/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  befehl.c						   */
/*        FUNKTIONEN  bef()						   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  06.06.1992					   */
/***************************************************************************/

#include <stdio.h>

#include "mbox.h"


/***************************************************************************/
/*      FUNKTION  bef()							   */
/*  BESCHREIBUNG  Sucht entweder die Befehlsnummer zu einem bekannten      */
/*		  Befehl, oder zeigt die Befehle als Uebersicht an.        */
/*		  Dabei wird das Userlevel beruecksichtigt.                */
/*     PARAMETER  befehl  =  Befehl  =  Befehl, der gesucht werden soll    */
/*			     '?'     =  Befehle anzeigen (levelabhaengig)  */
/*		  arg     =  '*'     =  ALLE Befehle anzeigen 	           */
/*     RUECKGABE  -1  =  Userlevel reicht nicht aus			   */
/*     		  -9  =  Befehl nicht gefunden				   */
/*		   n  =  Befehlsnummer (siehe Datei BEFEHLE und loop.c)	   */
/***************************************************************************/

int bef(befehl, arg)
char befehl[];
char arg[];
{
  char s[STRING];
  int b = 0, i = 0, l;

  l = USER.level;

  if (befehl[0] == '?') {

	if (arg[0] == '*') l = 9999;

	while (BEF[b].id != -1) {
		if ((BEF[b].prototyp == 1) && (BEF[b].in <= l)) {
			printf("%-14.14s ", BEF[b].befehl);
			i++;
			if (i == 5) {
				printf("\n");
				i = 0;
			}
		}
		b++;
	}
	printf("\n\n");
	return 0;
  }
  else {
	while (BEF[b].id != -1) {
		if (strcomp(befehl, BEF[b].befehl) == 0) {
			if (BEF[b].in <= USER.level){
				if(BEF[b].id == 1000){
					printf("\n\n");
					if(arg[0] == '\0')
						sprintf(s, "exec %s %s %d %d", RSH, BEF[b].pfad, OLDUID, OLDGID);
					else
						sprintf(s, "exec %s %s \"%s\" %d %d", RSH, BEF[b].pfad, arg, OLDUID, OLDGID);			
					system(s);
				}
				return BEF[b].id;
			}
			else{
				return -1;
			}
		}
		b++;
	}
	return -9;
  }
}
