/***************************************************************************/
/*	    PROGRAMM  ix/Mbox						   */
/*             DATEI  baudrate.c					   */
/*        FUNKTIONEN  baudrate()					   */
/*             AUTOR  vs (Volker Schuermann/MINIX-Version)		   */
/*  LETZTE AENDERUNG  16.03.1992					   */
/***************************************************************************/

#include <stdio.h>
#include <time.h>

#include "mbox.h"


#ifdef _SYS7	/* UNIX System 7  (MINIX, COHERENT, ...) */

#include  <sgtty.h>
static struct sgttyb told;

#else		/* UNIX System V  (UNIX, XENIX, ESIX, ...) */

#include  <sys/termio.h> 
static struct termio told;

#endif


#define BYTE	0377	/* Don't ask me, ask Andy !! */


int baudrate( try )
int try;
{
  int i, j = 0;
  int guess = -1;
  long ts, tn;


  if(BAUDRATE != 0) return BAUDRATE;

#ifdef _SYS7
  
  ioctl( 0, TIOCGETP, &told );
  guess = (int) (100 * (told.sg_ospeed & BYTE));

#else

  ioctl( 0, TCGETA, &told );

  if(told.c_cflag &=    B300) guess = (int)   300;
  if(told.c_cflag &=   B1200) guess = (int)  1200;
  if(told.c_cflag &=   B2400) guess = (int)  2400;
  if(told.c_cflag &=   B4800) guess = (int)  4800;
  if(told.c_cflag &=   B9600) guess = (int)  9600;
  /*
  if(told.c_cflag &=  B14400) guess = (int) 14400;
  */
  if(told.c_cflag &=  B19200) guess = (int) 19200;
  if(told.c_cflag &=  B38400) guess = (int) 38400;

#endif

#ifdef _BAUDRATE  	/* HST mit 'fixed baudrate 19.2k' */
	
  if((guess == MAX_BPS) || (guess == 0)){

	guess = 300;

	if(try >   300) guess =  1200;
	if(try >  1200) guess =  2400;
	if(try >  2400) guess =  9600;
	if(try >  9600) guess = 14400;
	if(try > 14400) guess = 19200;
  }

#endif

  return guess;

}
