/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.scilab.forge.jlatexmath.GlueSettingsParser;
import org.scilab.forge.jlatexmath.XMLResourceParseException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TeXFormulaSettingsParser {
    private Element a;

    public TeXFormulaSettingsParser() {
        this(GlueSettingsParser.class.getResourceAsStream("TeXFormulaSettings.xml"), "TeXFormulaSettings.xml");
    }

    public TeXFormulaSettingsParser(InputStream inputStream, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setIgnoringElementContentWhitespace(true);
            documentBuilderFactory.setIgnoringComments(true);
            this.a = documentBuilderFactory.newDocumentBuilder().parse(inputStream).getDocumentElement();
        }
        catch (Exception exception) {
            throw new XMLResourceParseException(string, exception);
        }
    }

    public void parseSymbolToFormulaMappings(String[] stringArray, String[] stringArray2) {
        Element element = (Element)this.a.getElementsByTagName("CharacterToFormulaMappings").item(0);
        if (element != null) {
            TeXFormulaSettingsParser.addFormulaToMap(element.getElementsByTagName("Map"), stringArray, stringArray2);
        }
    }

    public void parseSymbolMappings(String[] stringArray, String[] stringArray2) {
        Element element = (Element)this.a.getElementsByTagName("CharacterToSymbolMappings").item(0);
        if (element != null) {
            TeXFormulaSettingsParser.addToMap(element.getElementsByTagName("Map"), stringArray, stringArray2);
        }
    }

    private static void addToMap(NodeList nodeList, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("char");
            String string2 = element.getAttribute("symbol");
            String string3 = element.getAttribute("text");
            if (string.equals("")) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "char", null);
            }
            if (string2.equals("")) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "symbol", null);
            }
            if (string.length() != 1) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            stringArray[string.charAt((int)0)] = string2;
            if (stringArray2 == null || string3.equals("")) continue;
            stringArray2[string.charAt((int)0)] = string3;
        }
    }

    private static void addFormulaToMap(NodeList nodeList, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("char");
            String string2 = element.getAttribute("formula");
            String string3 = element.getAttribute("text");
            if (string.equals("")) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "char", null);
            }
            if (string2.equals("")) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "formula", null);
            }
            if (string.length() != 1) {
                throw new XMLResourceParseException("TeXFormulaSettings.xml", element.getTagName(), "char", "must have a value that contains exactly 1 character!");
            }
            stringArray[string.charAt((int)0)] = string2;
            if (stringArray2 == null || string3.equals("")) continue;
            stringArray2[string.charAt((int)0)] = string3;
        }
    }
}

