/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import org.jboss.threads.DelegatingRunnable;
import org.jboss.threads.JBossExecutors;

final class ThreadLocalResettingRunnable
extends DelegatingRunnable {
    ThreadLocalResettingRunnable(Runnable delegate) {
        super(delegate);
    }

    @Override
    public void run() {
        try {
            super.run();
        }
        finally {
            Resetter.run();
        }
    }

    @Override
    public String toString() {
        return "Thread-local resetting Runnable";
    }

    static final class Resetter {
        private static final long threadLocalMapOffs;
        private static final long inheritableThreadLocalMapOffs;

        Resetter() {
        }

        static void run() {
            Thread thread = Thread.currentThread();
            JBossExecutors.unsafe.putObject(thread, threadLocalMapOffs, null);
            JBossExecutors.unsafe.putObject(thread, inheritableThreadLocalMapOffs, null);
        }

        static {
            try {
                threadLocalMapOffs = JBossExecutors.unsafe.objectFieldOffset(Thread.class.getDeclaredField("threadLocals"));
                inheritableThreadLocalMapOffs = JBossExecutors.unsafe.objectFieldOffset(Thread.class.getDeclaredField("inheritableThreadLocals"));
            }
            catch (NoSuchFieldException e) {
                throw new NoSuchFieldError(e.getMessage());
            }
        }
    }
}

