/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.AuthenticationDigest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ChainedAuthentication
implements Authentication {
    private final Authentication[] authentications;

    public ChainedAuthentication(Authentication ... authentications) {
        this.authentications = authentications != null && authentications.length > 0 ? (Authentication[])authentications.clone() : new Authentication[0];
    }

    public ChainedAuthentication(Collection<? extends Authentication> authentications) {
        this.authentications = authentications != null && !authentications.isEmpty() ? authentications.toArray(new Authentication[authentications.size()]) : new Authentication[0];
    }

    @Override
    public void fill(AuthenticationContext context, String key, Map<String, String> data) {
        for (Authentication authentication : this.authentications) {
            authentication.fill(context, key, data);
        }
    }

    @Override
    public void digest(AuthenticationDigest digest) {
        for (Authentication authentication : this.authentications) {
            authentication.digest(digest);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ChainedAuthentication that = (ChainedAuthentication)obj;
        return Arrays.equals(this.authentications, that.authentications);
    }

    public int hashCode() {
        return Arrays.hashCode(this.authentications);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(256);
        for (Authentication authentication : this.authentications) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append(authentication);
        }
        return buffer.toString();
    }
}

