/*	$NetBSD: sm502reg.h,v 1.7 2013/03/13 21:31:01 macallan Exp $	*/

/*
 * Copyright (c) 2009 Michael Lorenz
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/* Silicon Motion SM502 / Voyager GX register definitions */

#ifndef SM502REG_H
#define SM502REG_H

/* System Control Registers */
#define SM502_SYSTEM_CTRL	0x00000000
#define 	SM502_SYSCTL_PANEL_3STATE	0x00000001
#define 	SM502_SYSCTL_MEM_3STATE		0x00000002
#define 	SM502_SYSCTL_CRT_3STATE		0x00000004
#define 	SM502_SYSCTL_BURST_32		0x00000000
#define 	SM502_SYSCTL_BURST_64		0x00000010
#define 	SM502_SYSCTL_BURST_128		0x00000020
#define 	SM502_SYSCTL_BURST_256		0x00000030
#define 	SM502_SYSCTL_PCI_CLOCK_RUN_E	0x00000040
#define 	SM502_SYSCTL_PCI_RETRY_E	0x00000080
#define 	SM502_SYSCTL_PCI_LOCK		0x00000800
/* stop drawing engine */
#define 	SM502_SYSCTL_ENGINE_ABORT	0x00003000
#define 	SM502_SYSCTL_BURST_READ_E	0x00008000
#define 	SM502_SYSCTL_ZV_VSYNC_DET	0x00010000
#define 	SM502_SYSCTL_CRT_FLIP_PENDING	0x00020000
#define 	SM502_SYSCTL_ENGINE_BUSY	0x00080000
#define 	SM502_SYSCTL_FIFO_EMPTY		0x00100000
#define 	SM502_SYSCTL_VIDEO_FLIP_PENDING	0x00400000
#define 	SM502_SYSCTL_PANEL_FLIP_PENDING	0x00800000
#define 	SM502_SYSCTL_PCI_LT_E		0x01000000
#define 	SM502_SYSCTL_PCI_BM_E		0x02000000
#define 	SM502_SYSCTL_CSC_BUSY		0x10000000
#define 	SM502_SYSCTL_PCI_BURST_E	0x20000000
#define 	SM502_SYSCTL_DISABLE_HSYNC	0x40000000
#define 	SM502_SYSCTL_DISABLE_VSYNC	0x80000000

#define SM502_MISC_CONTROL		0x00000004
#define 	SM502_DAC_POWER_DOWN		0x00001000
/* each bit: 0 - GPIO, 1 - other stuff */
#define SM502_GPIO0_CONTROL		0x00000008
#define SM502_GPIO1_CONTROL		0x0000000c
#define SM502_DRAM_CONTROL		0x00000010
	#define SM502_MEM_4M		0x00000000
	#define SM502_MEM_8M		0x00002000
	#define SM502_MEM_16M		0x00004000
	#define SM502_MEM_32M		0x00006000
	#define SM502_MEM_64M		0x00008000
	#define SM502_MEM_2M		0x0000a000

#define SM502_ARB_CONTROL		0x00000014
#define SM502_COMMANDLIST_STATUS	0x00000024
#define SM502_INTR_STATUS_R		0x00000028	/* on read */
#define SM502_INTR_CLEAR_R		0x00000028	/* on write */
	#define SM502_RINTR_ZV1		0x00000040	/* zoomed video 1 */
	#define SM502_RINTR_UP		0x00000020	/* USB slave plug */
	#define SM502_RINTR_ZV0		0x00000010	/* zoomed video 0 */
	#define SM502_RINTR_CV		0x00000008	/* CRT vsync */
	#define SM502_RINTR_US		0x00000004	/* USB slave */
	#define SM502_RINTR_PV		0x00000002	/* panel vsync */
	#define SM502_RINTR_CI		0x00000001	/* command interpreter */
	
#define SM502_INTR_STATUS		0x0000002c
#define SM502_INTR_MASK			0x00000030
	#define SM502_INTR_UP		0x80000000	/* USB slave plug */
	#define SM502_INTR_GPIO54	0x40000000
	#define SM502_INTR_GPIO53	0x20000000
	#define SM502_INTR_GPIO52	0x10000000
	#define SM502_INTR_GPIO51	0x08000000
	#define SM502_INTR_GPIO50	0x04000000
	#define SM502_INTR_GPIO49	0x02000000
	#define SM502_INTR_GPIO48	0x01000000
	#define SM502_INTR_I2C		0x00800000
	#define SM502_INTR_PWM		0x00400000
	#define SM502_INTR_RES		0x00200000	/* reserved */
	#define SM502_INTR_DMA		0x00100000
	#define SM502_INTR_PCI		0x00080000
	#define SM502_INTR_I2S		0x00040000
	#define SM502_INTR_AC97		0x00020000
	#define SM502_INTR_US		0x00010000
	#define SM502_INTR_RES2		0x0000c000	/* reserved */
	#define SM502_INTR_UART1	0x00002000
	#define SM502_INTR_UART0	0x00001000
	#define SM502_INTR_CV		0x00000800	/* CRT vsync */
	#define SM502_INTR_MC		0x00000400	/* microcontroller */
	#define SM502_INTR_SSP1		0x00000200
	#define SM502_INTR_SSP0		0x00000100
	#define SM502_INTR_RES3		0x00000080	/* reserved */
	#define SM502_INTR_UH		0x00000040	/* USB host */
	#define SM502_INTR_RES4		0x00000020	/* reserved */
	#define SM502_INTR_ZV1		0x00000010	/* zoomed video 1 */
	#define SM502_INTR_2D		0x00000008	/* 2D engine */
	#define SM502_INTR_ZV0		0x00000004	/* zoomed video 0 */
	#define SM502_INTR_PV		0x00000002	/* panel vsync */
	#define SM502_INTR_CI		0x00000001	/* command interpreter */

#define SM502_DEBUG_CONTROL		0x00000034

#define SM502_CURRENT_GATE		0x00000038
#define		SM502_GATE_AUDIO_ENABLE		0x00040000
#define		SM502_GATE_8051_ENABLE		0x00020000
#define		SM502_GATE_USB_SLAVE_ENABLE	0x00001000
#define		SM502_GATE_USB_HOST_ENABLE	0x00000800
#define		SM502_GATE_SSP_ENABLE		0x00000400
#define		SM502_GATE_UART1_ENABLE		0x00000100
#define		SM502_GATE_UART0_ENABLE		0x00000080
#define		SM502_GATE_GPIO_ENABLE		0x00000040
#define		SM502_GATE_ZV_ENABLE		0x00000020
#define		SM502_GATE_CSC_ENABLE		0x00000010
#define		SM502_GATE_2D_ENGINE_ENABLE	0x00000008
#define		SM502_GATE_DISPLAY_ENABLE	0x00000004
#define		SM502_GATE_MEMORY_ENABLE	0x00000002
#define		SM502_GATE_HOST_ENABLE		0x00000001
#define SM502_CURRENT_CLOCK		0x0000003c
#define SM502_POWER_MODE0_GATE		0x00000040
#define SM502_POWER_MODE0_CLOCK		0x00000044
#define SM502_POWER_MODE1_GATE		0x00000048
#define SM502_POWER_MODE1_CLOCK		0x0000004c
#define SM502_SLEEP_MODE_GATE		0x00000050
#define SM502_POWER_MODE_CONTROL	0x00000054

/* GPIO */
#define SM502_GPIO_DATA0		0x00010000
#define SM502_GPIO_DATA1		0x00010004
#define SM502_GPIO_DIR0			0x00010008	/* 1 is output */
#define SM502_GPIO_DIR1			0x0001000c
#define SM502_GPIO_INTR_SETUP		0x00010010
#define SM502_GPIO_INTR_STATUS		0x00010014	/* read */
#define SM502_GPIO_INTR_CLEAR		0x00010014	/* write */

/* PWM - Pulse Width Modulation */
#define SM502_PWM0			0x00010020
#define SM502_PWM1			0x00010024
#define SM502_PWM2			0x00010028
#define		SM502_PWM_ENABLE		0x00000001
#define		SM502_PWM_ENABLE_INTR		0x00000004
#define		SM502_PWM_INTR_PENDING		0x00000008 /* write 1 to clear */
/* 96MHz divided by 1 << n */
#define		SM502_PWM_CLOCK_DIV_MASK	0x000000f0
#define		SM502_PWM_CLOCK_DIV_SHIFT	4
/* output remains low for n+1 cycles */
#define		SM502_PWM_CLOCK_LOW_MASK	0x000fff00
#define		SM502_PWM_CLOCK_LOW_SHIFT	8
/* output remains high for n+1 cycles */
#define		SM502_PWM_CLOCK_HIGH_MASK	0xfff00000
#define		SM502_PWM_CLOCK_HIGH_SHIFT	20

/* Video Controller Registers */
#define SM502_PANEL_DISP_CTRL			0x080000
#define		SM502_PDC_8BIT			0x00000000
#define		SM502_PDC_16BIT			0x00000001
#define		SM502_PDC_32BIT			0x00000002
#define		SM502_PDC_DEPTH_MASK		0x00000003
#define		SM502_PDC_PANEL_ENABLE		0x00000004
#define		SM502_PDC_GAMMA_ENABLE		0x00000008
#define		SM502_PDC_HPAN_AUTO		0x00000010
#define		SM502_PDC_HPAN_DIR_LEFT		0x00000000
#define		SM502_PDC_HPAN_DIR_RIGHT	0x00000020
#define		SM502_PDC_VPAN_AUTO		0x00000040
#define		SM502_PDC_VPAN_DIR_UP		0x00000080
#define		SM502_PDC_VPAN_DIR_DOWN		0x00000000
#define		SM502_PDC_TIMING_ENABLE		0x00000100
#define		SM502_PDC_COLORKEY_ENABLE	0x00000200
#define		SM502_PDC_CAPTURE_ZV_0		0x00000400
#define		SM502_PDC_HSYNC_PHASE_LOW	0x00001000
#define		SM502_PDC_HSYNC_PHASE_HIGH	0x00000000
#define		SM502_PDC_VSYNC_PHASE_LOW	0x00002000
#define		SM502_PDC_VSYNC_PHASE_HIGH	0x00000000
#define		SM502_PDC_CLOCK_ACT_LOW		0x00004000
#define		SM502_PDC_CLOCK_ACTIVE_HIGH	0x00000000
#define		SM502_PDC_8BIT_TV_ENABLE	0x00008000
#define		SM502_PDC_FIFO_HWATER_1		0x00000000
#define		SM502_PDC_FIFO_HWATER_3		0x00010000
#define		SM502_PDC_FIFO_HWATER_7		0x00020000
#define		SM502_PDC_FIFO_HWATER_11	0x00030000
#define		SM502_PDC_FIFO_HWATE_MASK	0x00030000
#define		SM502_PDC_TYPE_TFT		0x00000000
#define		SM502_PDC_TYPE_8BIT_STN		0x00040000
#define		SM502_PDC_TYPE_12BIT_STN	0x00080000
#define		SM502_PDC_TYPE_MASK		0x000c0000
#define		SM502_PDC_DITHERING_ENABLE	0x00100000
#define		SM502_PDC_TFT_RGB888		0x00000000
#define		SM502_PDC_TFT_RGB333		0x00200000
#define		SM502_PDC_TFT_RGB444		0x00400000
#define		SM502_PDC_TFT_RGB_MASK		0x00600000
#define		SM502_PDC_DITHER_8_GREY		0x00800000
#define		SM502_PDC_FPVDDEN_HIGH		0x01000000
#define		SM502_PDC_FPVDDEN_LOW		0x00000000
#define		SM502_PDC_PANEL_SIGNALS_ENABLE	0x02000000
#define		SM502_PDC_VBIASEN_HIGH		0x04000000
#define		SM502_PDC_VBIASEN_LOW		0x00000000
#define		SM502_PDC_GPEN_ENABLE		0x08000000

#define SM502_PANEL_PAN_CTRL	0x080004
#define SM502_PANEL_COLOR_KEY	0x080008
#define SM502_PANEL_FB_ADDRESS	0x08000C
#define		SM502_FBA_MASK			0x03fffff0 /* 128bit align */
#define		SM502_FBA_CS1			0x04000000
#define		SM502_FBA_CS0			0x00000000
#define		SM502_FBA_SYSTEM_MEM		0x08000000
#define		SM502_FBA_LOCAL_MEM		0x00000000
#define		SM502_FBA_FLIP_PENDING		0x80000000

#define SM502_PANEL_FB_OFFSET	0x080010
#define		SM502_FBO_FB_STRIDE_MASK	0x00003ff0 /* 128bit align */
#define		SM502_FBA_WIN_STRIDE_MASK	0x3ff00000 /* 128bit align */

#define SM502_PANEL_FB_WIDTH	0x080014
#define		SM502_FBW_WIN_X_MASK		0x00003fff
#define		SM502_FBW_WIN_WIDTH_MASK	0x3fff0000

#define SM502_PANEL_FB_HEIGHT	0x080018
#define		SM502_FBH_WIN_Y_MASK		0x00003fff
#define		SM502_FBH_WIN_HEIGHT_MASK	0x3fff0000
#define SM502_PANEL_TL		0x08001C
#define		SM502_TL_LEFT_MASK		0x000007ff
#define		SM502_TL_TOP_MASK		0x07ff0000

#define SM502_PANEL_BR		0x080020
#define		SM502_BR_RIGHT_MASK		0x000007ff
#define		SM502_BR_BOTTOM_MASK		0x07ff0000

#define SM502_PANEL_HTOTAL	0x080024
#define 	SM502_HT_HDISPE_MASK		0x00000fff
#define 	SM502_HT_HTOTAL_MASK		0x0fff0000
#define SM502_PANEL_HSYNC	0x080028
#define SM502_PANEL_VTOTAL	0x08002C
#define 	SM502_VT_VDISPE_MASK		0x00000fff
#define 	SM502_VT_VTOTAL_MASK		0x0fff0000
#define SM502_PANEL_VSYNC	0x080030
#define SM502_PANEL_CRSR_ADDR	0x0800f0
#define		SM502_CRSR_ENABLE	0x80000000
#define		SM502_CRSR_SYSTEM_MEM	0x08000000
#define		SM502_CRSR_SYSMEM_CS1	0x04000000
#define		SM502_CRSR_ADDRESS_M	0x03fffff0
#define SM502_PANEL_CRSR_XY	0x0800f4
#define		SM502_CRSR_X_MASK	0x00000fff
#define		SM502_CRSR_Y_MASK	0x0fff0000
#define SM502_PANEL_CRSR_COL12	0x0800f8
#define		SM502_CRSR_COLOR_1_MASK	0x0000ffff
#define		SM502_CRSR_COLOR_2_MASK	0xffff0000
#define SM502_PANEL_CRSR_COL3	0x0800fc
#define		SM502_CRSR_COLOR_3_MASK	0x0000ffff


#define SM502_PALETTE_PANEL	0x080400
#define SM502_PALETTE_VIDEO	0x080800
#define SM502_PALETTE_CRT	0x080c00

/* drawing engine */
#define SM502_SRC		0x100000
#define		SM502_SRC_WRAP_ENABLE	0x80000000
#define		SM502_SRC_X_MASK	0x3fff0000
#define		SM502_SRC_Y_MASK	0x0000ffff

#define SM502_DST		0x100004
#define		SM502_DST_WRAP_ENABLE	0x80000000
#define		SM502_DST_X_MASK	0x3fff0000
#define		SM502_DST_Y_MASK	0x0000ffff

#define SM502_DIMENSION		0x100008
#define		SM502_DIM_X_MASK	0x3fff0000
#define		SM502_DIM_Y_MASK	0x0000ffff

#define SM502_CONTROL		0x10000c
#define ROP_COPY 	0x0c
#define ROP_INVERT	0x03
#define		SM502_CTRL_ROP_MASK	0x000000ff
#define		SM502_CTRL_TRANSP_EN	0x00000100
#define		SM502_CTRL_TRANSP_DST	0x00000200
#define		SM502_CTRL_TRANSP_SRC	0x00000000
#define		SM502_CTRL_TRANSP_MATCH	0x00000400
#define		SM502_CTRL_OPAQUE_MATCH	0x00000000
#define		SM502_CTRL_REPEAT_ROT	0x00000800
#define		SM502_CTRL_MONO_PACK_MASK	0x00003000
#define		SM502_CTRL_MONO_PACK_8BIT	0x00001000
#define		SM502_CTRL_MONO_PACK_16BIT	0x00002000
#define		SM502_CTRL_MONO_PACK_32BIT	0x00003000
#define		SM502_CTRL_ROP2_SRC_PAT	0x00004000 /* otherwise src is bmp */
#define		SM502_CTRL_USE_ROP2	0x00008000 /* X-style ROPs vs. Win */
#define		SM502_CTRL_COMMAND_MASK	0x001f0000
#define		SM502_CTRL_CMD_BITBLT	0x00000000
#define		SM502_CTRL_CMD_RECTFILL	0x00010000
#define		SM502_CTRL_CMD_DETILE	0x00020000
#define		SM502_CTRL_CMD_TRAPFILL	0x00030000
#define		SM502_CTRL_CMD_ALPHA	0x00040000
#define		SM502_CTRL_CMD_RLESTRIP	0x00050000
#define		SM502_CTRL_CMD_SHRTSTRK	0x00060000
#define		SM502_CTRL_CMD_LINE	0x00070000
#define		SM502_CTRL_CMD_HOSTWRT	0x00080000
#define		SM502_CTRL_CMD_HOSTREAD	0x00090000
#define		SM502_CTRL_CMD_WRT_BT	0x000a0000
#define		SM502_CTRL_CMD_ROTATE	0x000b0000
#define		SM502_CTRL_CMD_FONT	0x000c0000
#define		SM502_CTRL_CMD_TEXLOAD	0x000f0000
#define		SM502_CTRL_DRAWLAST	0x00200000 /* last pixel in line */
#define		SM502_CTRL_HOSTBLT_MONO	0x00400000 /* colour otherwise */
#define		SM502_CTRL_YSTRETCH_E	0x00800000
#define		SM502_CTRL_Y_STEP_NEG	0x01000000 /* line, otherwise pos */
#define		SM502_CTRL_X_STEP_NEG	0x02000000 /* line, otherwise pos */
#define		SM502_CTRL_LINE_AX_Y	0x04000000 /* otherwise X */
#define		SM502_CTRL_R_TO_L	0x08000000 /* otherwise L to R */
/* run command when writing SM502_DIMENSION */
#define		SM502_CTRL_QUICKSTART_E	0x10000000
#define		SM502_CTRL_UPD_DESTX	0x20000000
#define		SM502_CTRL_PAT_COLOR	0x40000000 /* otherwise mono */
#define		SM502_CTRL_ENGINE_START	0x80000000

#define SM502_PITCH		0x100010
#define		SM502_PITCH_SRC_MASK	0x00003fff
#define		SM502_PITCH_DST_MASK	0x3fff0000

#define SM502_FOREGROUND	0x100014
#define SM502_BACKGROUND	0x100018
#define SM502_STRETCH		0x10001c
#define		SM502_STRETCH_HEIGHT_MASK	0x00000fff /* source */
#define		SM502_STRETCH_ADDR_LINEAR	0x000f0000 /* XY otherwise */
#define		SM502_STRETCH_PIXEL_FORMAT_MASK	0x00300000
#define		SM502_STRETCH_8BIT		0x00000000
#define		SM502_STRETCH_16BIT		0x00100000
#define		SM502_STRETCH_32BIT		0x00200000
#define		SM502_STRETCH_PAT_X_ORIGIN_MASK	0x03800000
#define		SM502_STRETCH_PAT_Y_ORIGIN_MASK 0x38000000
#define		SM502_STRETCH_PAT_XY_ENABLE	0x40000000

#define SM502_COLOR_COMPARE	0x100020
#define SM502_COLOR_COMP_MASK	0x100024
#define SM502_PLANEMASK		0x100028
#define SM502_CLIP_TOP_LEFT	0x10002c
#define		SM501_CLIP_TOP_MASK	0xffff0000
#define		SM501_CLIP_LEFT_MASK	0x00000fff
#define		SM501_CLIP_BLOCK_INSIDE	0x00001000 /* otherwise block outside */
#define		SM501_CLIP_ENABLE	0x00002000

#define SM502_CLIP_BOTTOM_RIGHT	0x100030
#define		SM501_CLIP_BOTTOM_MASK	0xffff0000
#define		SM501_CLIP_RIGHT_MASK	0x00001fff

#define SM502_MONO_PATTERN_0	0x100034
#define SM502_MONO_PATTERN_1	0x100038
#define SM502_WINDOW_WIDTH	0x10003c
#define		SM502_WIN_SRC_MASK	0x00001fff
#define		SM502_WIN_DST_MASK	0x1fff0000

#define SM502_SRC_BASE		0x100040
#define		SM502_SRC_BASE_ADDR_MASK	0x03fffff0 /* 128bit align */
#define		SM502_SRC_BASE_SYSMEM_CS1	0x04000000 /* SC0 otherw. */
#define		SM502_SRC_BASE_SYSMEM		0x08000000 /* local otherw. */

#define SM502_DST_BASE		0x100044
#define		SM502_DST_BASE_ADDR_MASK	0x03fffff0 /* 128bit align */
#define		SM502_DST_BASE_SYSMEM_CS1	0x04000000 /* SC0 otherw. */
#define		SM502_DST_BASE_SYSMEM		0x08000000 /* local otherw. */

#define SM502_ALPHA		0x100048
#define SM502_WRAP		0x10004c
#define		SM502_WRAP_HEIGHT_MASK	0x0000ffff
#define		SM502_WRAP_WIDTH_MASK	0xffff0000

#define SM502_STATUS		0x100050
#define		SM502_CMD_DONE		0x00000001
#define		SM502_CSC_DONE		0x00000002

#define	SM502_DATAPORT		0x110000

/* AC97 Link */
#define SM502_AC97_TX_TAG	0x0A0100
#define		SM502_AC97_FRAME_VALID	0x8000
#define		SM502_AC97_S1_VALID	0x4000
#define		SM502_AC97_S2_VALID	0x2000
#define		SM502_AC97_S3_VALID	0x1000
#define		SM502_AC97_S4_VALID	0x0800
#define SM502_AC97_TX_ADDR	0x0A0104
#define		SM502_AC97_READ		0x00100000	/* write otherwise */
#define		SM502_AC97_ADDR_MASK	0x000fe000
#define SM502_AC97_TX_DATA	0x0A0108
#define		SM502_AC97_DATA_MASK	0x000ffff0
#define SM502_AC97_TX_LEFT	0x0A010C
#define SM502_AC97_TX_RIGHT	0x0A0110
#define SM502_AC97_RX_TAG	0x0A0140
#define SM502_AC97_RX_ADDR	0x0A0144
#define SM502_AC97_RX_DATA	0x0A0148
#define SM502_AC97_RX_LEFT	0x0A014C
#define SM502_AC97_RX_RIGHT	0x0A0150
#define SM502_AC97_CONTROL	0x0A0180
#define		SM502_AC97_DROP_COUNT	0x0000fc00
#define		SM502_AC97_STOP_SYNC	0x00000200
#define		SM502_AC97_BCLK_RUNNING	0x00000100
#define		SM502_AC97_WAKEUP_REQ	0x00000080
#define		SM502_AC97_STATUS_MASK	0x00000030
#define		SM502_AC97_STATUS_OFF	0x00000000
#define		SM502_AC97_STATUS_RESET	0x00000010
#define		SM502_AC97_STATUS_WAIT	0x00000020
#define		SM502_AC97_STATUS_ON	0x00000030
#define		SM502_AC97_WI_ENABLE	0x00000008	/* wakeup interrupt */
#define		SM502_AC97_WARM_RESET	0x00000004	/* 1uS at least */
#define		SM502_AC97_COLD_RESET	0x00000002	/* 1uS at least */
#define		SM502_AC97_ENABLE	0x00000001

#define SM502_AUDIO_GPIO_MASK	0x1f000000	/* pins used */

/* 8051 Microcontroller */
#define SM502_uC_RESET		0x000b0000
#define 	SM502_uC_ENABLE		0x00000001	/* reset otherwise */
#define SM502_uC_MODE_SELECT	0x000b0004
#define 	SM502_uC_CLOCK_MASK	0x00000003
#define 	SM502_uC_CLOCK_DIV2	0x00000000
#define 	SM502_uC_CLOCK_DIV3	0x00000001
#define 	SM502_uC_CLOCK_DIV4	0x00000002
#define 	SM502_uC_CLOCK_DIV5	0x00000003
#define 	SM502_uC_CODEC_I2S	0x00000004	/* AC97 otherwise */
#define 	SM502_uC_AUDIO_TEST	0x00000008	/* test mode */
#define 	SM502_uC_IO_8BIT	0x00000010	/* 12 bit otherwise */
#define 	SM502_uC_SRAM_DISABLE	0x00000020
#define 	SM502_uC_USB_WAIT_MASK	0x000000c0
#define 	SM502_uC_USB_NO_WAIT	0x00000000
#define 	SM502_uC_USB_1_WAIT	0x00000040
#define 	SM502_uC_USB_2_WAIT	0x00000080
#define SM502_uC_8051_INTR	0x000b0008
#define SM502_uC_CPU_INTR	0x000b000c

#define SM502_uC_SRAM_PROG	0x00dc0000	/* only readable in RESET */
#define SM502_uC_SRAM_DATA	0x00dc3000

#endif /* SM502REG_H */
