
/***********************************************************
*                      K O U L E S                         *
*----------------------------------------------------------*
*  C1995 JAHUSOFT                                          *
*        Jan Hubicka                                       *
*        Dukelskych Bojovniku 1944                         *
*        390 03 Tabor                                      *
*        Czech Republic                                    *
*        Telefon: (048-I think) (0361) 32613               *
*        eMail: hubicka@limax.paru.cas.cz                  *
*----------------------------------------------------------*
* Copyright(c)1995 by Jan Hubicka.See README for license   *
*                          details.                        *
*----------------------------------------------------------*
*  menu.c                                                  *
*   GUI menuing system					   *
***********************************************************/

#include "koules.h"
int             selected = 0;
float           mx1, my1, mx1p, my1p;
float           mx2, my2, mx2p, my2p;
int             time;
int             ssound = 1;
char           *playertext = "1 PLAYER";
#define YPOSITION(i) (MAPHEIGHT/2+20-5*nmenu+10*i)
#define XPOSITION(i) (MAPWIDTH/2-4*strlen(menu[i].text))
#define XPOSITION1(i) (MAPWIDTH/2+4*strlen(menu[i].text))
int             player, keynum, lastplayer;
#ifdef JOYSTICK
int             joystick, joypos;
struct JS_DATA_TYPE js_data;
#endif

void            main_menu ();
void            change_menu ();
#ifdef JOYSTICK
void
calibrate_init ()
{
  int             status;
  long            tmpl;
  tmpl = 1;
  status = ioctl (joystickdevice[joystick], JS_SET_TIMELIMIT, &tmpl);
  if (status == -1)
    {
      {
	perror ("Joystick");
	joystickplayer[joystick] = -2;
	gamemode = MENU;
	change_menu ();
	return;
      }
    }
}
#endif

/*static void
   allplayers ()
   {
   player = 0;
   lastplayer = nrockets - 1;
   keynum = 0;
   gamemode = KEYS;
   } */

static void
player_change ()
{
  player = (selected - 2) / 2;
  lastplayer = (selected - 2) / 2;
  if (player == mouseplayer)
    return;
#ifdef JOYSTICK
  if (player == joystickplayer[0])
    {
      joystick = 0;
      joypos = 0;
      gamemode = JOY;
      calibrate_init ();
      return;
    }
  if (player == joystickplayer[1])
    {
      joystick = 1;
      joypos = 0;
      gamemode = JOY;
      calibrate_init ();
      return;
    }
#endif
  keynum = 0;
  gamemode = KEYS;
}


static void
control_change ()
{
  int             player;
  player = (selected - 1) / 2;
  if (player == mouseplayer)
    {
      mouseplayer = -1;
#ifdef JOYSTICK
      if (joystickplayer[0] == -1)
	joystickplayer[0] = player;
      else if (joystickplayer[1] == -1)
	joystickplayer[1] = player;
    }
  else if (player == joystickplayer[0])
    {
      joystickplayer[0] = -1;
      if (joystickplayer[1] == -1)
	joystickplayer[1] = player;
    }
  else if (player == joystickplayer[1])
    {
      joystickplayer[1] = -1;
#endif
    }
  else
    {
      if (!rotation[player])
	{
	  rotation[player] = 1;
	}
      else
	{
	  rotation[player] = 0;
	  if (mouseplayer == -1)
	    mouseplayer = player;
#ifdef JOYSTICK
	  else if (joystickplayer[0] == -1)
	    joystickplayer[0] = player;
	  else if (joystickplayer[1] == -1)
	    joystickplayer[1] = player;
#endif
	}
    }
  change_menu ();
}

static void
start ()
{
  int             i;
  for (i = 0; i < nrockets; i++)
    {
      object[i].score = 0;
    }
  sound = ssound;
  gamemode = GAME;
  gameplan_init ();
  init_objects ();
}


static void
playerchange ()
{
  nrockets++;
  if (nrockets > 5)
    nrockets = 1;
  playertext[0] = nrockets + '0';
}


static void
quit ()
{
  uninitialize ();
  exit (0);
}

static void
fit_selector ()
{
  time = MENUTIME;
  mx1p = (XPOSITION (selected) - 2 - mx1) / time;
  mx2p = (XPOSITION1 (selected) + 1 - mx2) / time;
  my1p = (YPOSITION (selected) - 2 - my1) / time;
  my2p = (YPOSITION (selected) + 8 + 0 - my2) / time;
}

void
to_main_menu ()
{
#ifdef JOYSTICK
  if (joystickplayer[0] >= 0 && !calibrated[0])
    {
      joystick = 0;
      joypos = 0;
      gamemode = JOY;
      calibrate_init ();
      return;
    }
  if (joystickplayer[1] >= 1 && !calibrated[0])
    {
      joystick = 1;
      joypos = 0;
      gamemode = JOY;
      calibrate_init ();
      return;
    }
#endif
  main_menu ();
}

void
change_menu ()
{
  static char     s[2][5][40], *s1;
  int             i;
  menu[0].text = "BACK TO MAIN MENU";
  menu[0].func = to_main_menu;
  for (i = 0; i < nrockets; i++)
    {
      if (i == mouseplayer)
	s1 = "MOUSE";
      else
#ifdef JOYSTICK
      if (i == joystickplayer[0])
	s1 = "JOYSTICK A";
      else if (i == joystickplayer[1])
	s1 = "JOYSTICK B";
      else
#endif
      if (rotation[i])
	s1 = "ROTATION KEYBOARD";
      else
	s1 = "KEYBOARD";
      sprintf (s[0][i], "PLAYER %i:%s", i + 1, s1);
#ifdef JOYSTICK
      if (i == joystickplayer[0])
	sprintf (s[1][i], "CALIBRATE");
      else if (i == joystickplayer[1])
	sprintf (s[1][i], "CALIBRATE");
      else
#endif
      if (i == mouseplayer)
	sprintf (s[1][i], " ");
      else
	sprintf (s[1][i], "CHANGE KEYS");
      menu[i * 2 + 1].text = s[0][i];
      menu[i * 2 + 2].text = s[1][i];
      menu[i * 2 + 1].func = control_change;
      menu[i * 2 + 2].func = player_change;
    }
  nmenu = nrockets * 2 + 1;
  if (selected >= nmenu)
    selected = 0;
  fit_selector ();
}
void
deathmatch ()
{
  gameplan = DEATHMATCH;
  main_menu ();
}

void
cooperative ()
{
  gameplan = COOPERATIVE;
  main_menu ();
}

void
setsound ()
{
  ssound = !ssound;
  main_menu ();
}

void
veryhard ()
{
  ROCKET_SPEED = 0.8;
  BALL_SPEED = 1.2;
  BBALL_SPEED = 1.2;
  SLOWDOWN = 0.9;
  GUMM = 20;


  BALLM = 3;
  LBALLM = 3;
  BBALLM = 8;
  APPLEM = 40;
  ROCKETM = 2;

  main_menu ();
}

void
hard ()
{
  ROCKET_SPEED = 1.0;
  BALL_SPEED = 1.2;
  BBALL_SPEED = 1.2;
  SLOWDOWN = 0.9;
  GUMM = 20;


  BALLM = 3;
  LBALLM = 3;
  BBALLM = 8;
  APPLEM = 40;
  ROCKETM = 3;

  main_menu ();
}

void
medium ()
{
  ROCKET_SPEED = 1.2;
  BALL_SPEED = 1.2;
  BBALL_SPEED = 1.2;
  SLOWDOWN = 0.8;
  GUMM = 20;


  APPLEM = 34;
  BALLM = 3;
  LBALLM = 3;
  BBALLM = 8;
  ROCKETM = 4;

  main_menu ();
}

void
easy ()
{
  ROCKET_SPEED = 2.0;
  BALL_SPEED = 1.2;
  BBALL_SPEED = 1.2;
  SLOWDOWN = 0.8;
  GUMM = 20;


  BALLM = 3;
  LBALLM = 3;
  APPLEM = 24;
  BBALLM = 8;
  ROCKETM = 5;
  main_menu ();
}

void
veryeasy ()
{
  ROCKET_SPEED = 2.0;
  BALL_SPEED = 1.2;
  BBALL_SPEED = 1.2;
  SLOWDOWN = 0.8;
  GUMM = 15;


  BALLM = 3;
  LBALLM = 3;
  APPLEM = 24;
  BBALLM = 8;
  ROCKETM = 7;
  main_menu ();
}




void
change_mode ()
{
  menu[0].text = "DEATH MATCH(DOOM)";
  menu[0].func = deathmatch;
  menu[1].text = "COOPERATIVE";
  menu[1].func = cooperative;
  nmenu = 2;
  selected = 1;
  fit_selector ();
}

void
change_obtiznost ()
{
  menu[0].text = "NIGHTMARE";
  menu[0].func = veryhard;
  menu[1].text = "HARD";
  menu[1].func = hard;
  menu[2].text = "MEDIUM";
  menu[2].func = medium;
  menu[3].text = "EASY";
  menu[3].func = easy;
  menu[4].text = "VERY EASY";
  menu[4].func = veryeasy;
  nmenu = 5;
  selected = 2;
  fit_selector ();
}

void
main_menu ()
{
  menu[0].text = "START GAME";
  menu[0].func = start;
  menu[1].text = playertext;
  menu[1].func = playerchange;
  menu[2].text = "CONTROL";
  menu[2].func = change_menu;
  menu[3].text = "GAME MODE";
  menu[3].func = change_mode;
  menu[4].text = "DIFICULTY";
  menu[4].func = change_obtiznost;
  menu[5].text = ssound ? "SOUND ON" : "SOUND OFF";
  menu[5].func = setsound;
  menu[6].text = "QUIT";
  menu[6].func = quit;
  nmenu = 7;
  selected = 0;
  fit_selector ();
}


void
init_menu ()
{
  mx1 = 10;
  mx2 = MAPWIDTH - 10;
  my2 = 10;
  my2 = MAPHEIGHT - 10;
  main_menu ();
}

void
draw_menu (int draw)
{
  int             i;
  if (draw)
    {
      gl_line ((int) mx1, (int) my1, (int) mx1, (int) my2, ball (2));
      gl_line ((int) mx1, (int) my2, (int) mx2, (int) my2, ball (2));
      gl_line ((int) mx2, (int) my2, (int) mx2, (int) my1, ball (2));
      gl_line ((int) mx2, (int) my1, (int) mx1, (int) my1, ball (2));
      gl_line ((int) mx1 + 1, (int) my1 + 1, (int) mx1 + 1, (int) my2 + 1, ball (20));
      gl_line ((int) mx1 + 1, (int) my2 + 1, (int) mx2 + 1, (int) my2 + 1, ball (20));
      gl_line ((int) mx2 + 1, (int) my2 + 1, (int) mx2 + 1, (int) my1 + 1, ball (20));
      gl_line ((int) mx2 + 1, (int) my1 + 1, (int) mx1 + 1, (int) my1 + 1, ball (20));
      gl_setwritemode (WRITEMODE_MASKED);
      gl_setfont (8, 8, fontblack);
      gl_write (MAPWIDTH / 2 - 8 * 4 + 1, 1, "THE GAME");
      gl_write (MAPWIDTH / 2 - 10 * 4 + 1, 11, "K O U L E S");
      gl_write (MAPWIDTH / 2 - 2 * 4 + 1, 21, "BY");
      gl_write (MAPWIDTH / 2 - 8 * 4 + 1, 31, "JAHUSOFT");
      gl_setfont (8, 8, fontwhite);
      gl_write (MAPWIDTH / 2 - 8 * 4, 0, "THE GAME");
      gl_write (MAPWIDTH / 2 - 10 * 4, 10, "K O U L E S");
      gl_write (MAPWIDTH / 2 - 2 * 4, 20, "BY");
      gl_write (MAPWIDTH / 2 - 8 * 4, 30, "JAHUSOFT");
      for (i = 0; i < nmenu; i++)
	{
	  gl_setfont (8, 8, fontblack);
	  gl_write ((int) XPOSITION (i) + 1, (int) YPOSITION (i) + 1, menu[i].text);
	  gl_setfont (8, 8, fontwhite);
	  gl_write ((int) XPOSITION (i), (int) YPOSITION (i), menu[i].text);
	}
      gl_setfont (8, 8, fontblack);
    }
  if (time)
    {
      time--;
      my1 += my1p;
      mx1 += mx1p;
      my2 += my2p;
      mx2 += mx2p;
    }
}

void
menu_keys ()
{
  static int      enter;
  int             ent = 0;
  sound = 0;
  if (mouse_getbutton () && !time)
    {
      int             i;
      i = (mouse_gety () - MAPHEIGHT / 2 - 20 + 5 * nmenu) / 10;
      if (i >= 0 && i < nmenu)
	{
	  selected = i;
	  if (ssound)
	    Snd_effect (S_CREATOR2, next);
	  menu[selected].func ();
	  return;
	}
    }
  if (keyboard_keypressed (SCANCODE_ESCAPE))
    quit ();
  if ((keyboard_keypressed (SCANCODE_CURSORUP) ||
     keyboard_keypressed (SCANCODE_CURSORBLOCKUP)) && !time && selected > 0)
    selected--, fit_selector ();
  if ((keyboard_keypressed (SCANCODE_CURSORDOWN) ||
       keyboard_keypressed (SCANCODE_CURSORBLOCKDOWN)) && !time && selected < nmenu - 1)
    selected++, fit_selector ();
  if (keyboard_keypressed (SCANCODE_ENTER) && !time)
    ent = 1;
  if (!ent && enter)
    {
      if (ssound)
	Snd_effect (S_CREATOR2, next);
      menu[selected].func ();
    }
  enter = ent;

}

void
keys_keys ()
{
  static int      lscan_code;
  int             i, scan_code;
  scan_code = 0;
  for (i = 0; i < 128; i++)
    if (keyboard_keypressed (i))
      {
	if (scan_code)
	  {
	    scan_code = 0;
	    break;
	  }
	else
	  scan_code = i;
      }
  if (!scan_code && lscan_code)
    {
      keys[player][keynum] = lscan_code;
      keynum++;
      if (ssound)
	Snd_effect (S_CREATOR2, next);
      if (keynum > (rotation[player] ? 2 : 3))
	{
	  player++;
	  keynum = 0;
	  if (player > lastplayer)
	    {
	      change_menu ();
	      gamemode = MENU;
	    }
	}
    }
  lscan_code = scan_code;
}


void
draw_keys (int draw)
{
  char            s[20];
  static char    *key[4] =
  {"UP", "DOWN", "LEFT", "RIGHT"};
  static char    *rkey[3] =
  {"ACCELERATION", "ROTATE LEFT", "ROTATE RIGHT"};
  if (!draw)
    return;
  gl_setfont (8, 8, fontwhite);
  gl_setwritemode (WRITEMODE_MASKED);
  nmenu = 2;
  sprintf (s, "PLAYER:%i", player + 1);
  gl_write ((int) (MAPWIDTH / 2 - 4 * strlen (s)), (int) YPOSITION (0), s);
  if (rotation[player])
    sprintf (s, "KEY:%s", rkey[keynum]);
  else
    sprintf (s, "KEY:%s", key[keynum]);
  gl_write ((int) (MAPWIDTH / 2 - 4 * strlen (s)), (int) YPOSITION (1), s);

}

#ifdef JOYSTICK
void
joy_keys ()
{
  int             status, tmp;
  static int      lastbutton, button;
  if (read (joystickdevice[joystick], &js_data, JS_RETURN) <= 0)
    {
      perror ("Joystick");
      joystickplayer[joystick] = -2;
      gamemode = MENU;
      change_menu ();
      return;
    }
  button = lastbutton;
  lastbutton = js_data.buttons + keyboard_keypressed (SCANCODE_SPACE);
  if (joypos == 0)
    {
      if ((button == 0x00 || lastbutton != 0x00))
	return;
      joypos++;

      for (tmp = 0; js_data.x > 0xff; tmp++, js_data.x = js_data.x >> 1);
      js_data.x = tmp;
      for (tmp = 0; js_data.y > 0xff; tmp++, js_data.y = js_data.y >> 1);
      js_data.y = tmp;


      status = ioctl (joystickdevice[joystick], JS_SET_CAL, &js_data);
      if (status == -1)
	{
	  perror ("Joystick");
	}
      return;
    }
  if ((button == 0x00 || lastbutton != 0x00))
    return;

  calibrated[joystick] = 1;
  center[joystick][0] = js_data.x;
  center[joystick][1] = js_data.y;
  gamemode = MENU;
  change_menu ();
}


void
draw_joy (int draw)
{
  char            s[20];
  static char    *mess[2] =
  {"Move joystick to lower right corner", "Center joystick"};
  if (!draw)
    return;
  gl_setfont (8, 8, fontwhite);
  gl_setwritemode (WRITEMODE_MASKED);
  nmenu = 4;
  sprintf (s, "JOYSTICK:%i", joystick + 1);
  gl_write ((int) (MAPWIDTH / 2 - 4 * strlen (s)), (int) YPOSITION (0), s);
  gl_write ((int) (MAPWIDTH / 2 - 4 * strlen (mess[joypos])), (int) YPOSITION (1), mess[joypos]);
  gl_write ((int) (MAPWIDTH / 2 - 4 * 33), (int) YPOSITION (2), "and press either button or space");
  sprintf (s, "x:%i y:%i", js_data.x, js_data.y);
  gl_write ((int) (MAPWIDTH / 2 - 4 * strlen (s)), (int) YPOSITION (3), s);

}

#endif
