// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#include "FastMath.h"

double FastMath::Vcos[360];
double FastMath::Vsin[360];
unsigned char FastMath::VintSqrt[SQRTSIZE];

void FastMath::init()
	{
	double radian;
	int i;
	
	for(i=0; i<360; i++)
		{
		radian = (M_PI/180.0) * (double)i;
		Vcos[i] = ::cos( radian );
		Vsin[i] = ::sin( radian );
		}

	for(i=0; i<SQRTSIZE; i++)
		{
		VintSqrt[i] = (unsigned char)sqrt(i);
		}

	}

