/* timer.c */
/* $Id: timer.c,v 1.6 1993/03/04 03:11:28 nils Exp $ */

/* Subroutines for timed events */
#include "copyright.h"

#include <stdio.h>
#include <ctype.h>
#include <fcntl.h>
#ifdef XENIX
#include <sys/signal.h>
#else
#include <signal.h>
#endif /* xenix */

#include "db.h"
#include "config.h"
#include "interface.h"
#include "match.h"
#include "externs.h"
static int alarm_triggered=0;
extern char ccom[1024];
#ifdef USE_RWHO
extern int rwho_on;
#endif

signal_type alarm_handler(i)
     int i;
{
  alarm_triggered=1;
  /* note was an ifdef xenix here!!! */
  signal(SIGALRM,alarm_handler);
#if signal_type == void
  return;
#else
  return 0;
#endif
}

void init_timer()
{
  signal(SIGALRM,alarm_handler);
  signal(SIGHUP,alarm_handler);
  alarm(1);
}

void dispatch()
{         
    extern FILE *command_log;
  /* this routine can be used to poll from interface.c */
  if (!alarm_triggered)
    return;
  alarm_triggered=0;
  do_second();
  /* Free list re ruction */
  {
    static int ticks=FIXUP_INTERVAL;

    if (!ticks--)
      {
	if (command_log) {
	  fprintf(command_log,"Dbcking...");
	  fflush(command_log);
	}

	ticks=FIXUP_INTERVAL;
	strcpy(ccom,"dbck");
	do_dbck(1);
	if(command_log) {
	  fprintf(command_log,"...Done.\n");
	  fflush(command_log);
	}
      }
  }
  /* Database dump routines */
  {
    static int ticks=DUMP_INTERVAL;
    if (!ticks--)
      {
	if(command_log) {
	  fprintf(command_log,"Dumping.\n");
	  fflush(command_log);
	}
	ticks=DUMP_INTERVAL;    
	strcpy(ccom,"dump");
	fork_and_dump();
      }
  }
#ifdef USE_RWHO
  if (rwho_on == 1)
  {
    static int ticks=RWHO_INTERVAL;
    if(!ticks--) {
      ticks=RWHO_INTERVAL;
      strcpy(ccom,"rwho");
      rwho_update();
    }
  }
#endif

#ifdef USE_SPACE /* Call installed by Michael Majere */
  space_count++;
  if((space_count >= (SPACE_INTERVAL + 1)) && (halt_space == 1))
    space_count = 1;
  if(halt_space == 1)
  {
    static int ticks=SPACE_INTERVAL;
    if(!ticks--) {
      ticks=SPACE_INTERVAL;
      strcpy(ccom,"space");
      update_space();
    }
  }
#endif

  strcpy(ccom,"garbage");
  do_incremental(); /* handle incremental garbage collection */
  /* reset alarm */
  alarm(1);
}

/* build new database ordering list from old num1 */
#ifdef DO_AGE
void do_age() 
{
  int a,b,c;
  struct object *o=db;
  /* put all accessed things into list */
  for(a=c=0;a<db_top;a++)
    if (db[b=db[a].num1].flags & ACCESSED)
      db[c++].num2=b;
  for(a=0;a<db_top;a++)
    if (!(db[b=db[a].num1].flags & ACCESSED))
      db[c++].num2=b;
    else
      db[b].flags&=~ACCESSED;
  /* move num2 back to num1 */
  for(a=0;a<db_top;a++,o++)
    o->num1=o->num2;
  /*  for(a=0;a<10;a++)
      fprintf(stderr,"%d\n",db[a].num1);*/
}
#endif
