/* powerlist.c */
/* $Id: powerlist.c,v 1.11 1993/03/21 08:08:30 nils Exp $ */

#include "db.h"
#include "powers.h"
#include "externs.h"

#define NO PW_NO
#define YES PW_YES
#define YESLT PW_YESLT
#define YESEQ PW_YESEQ
  
  
/* Drctr  Admin Cnstctr Offcil Citzen Vistr  Guest  Jroff Corp  Robot */
struct pow_list powers[]={
  {
    "Allquota", POW_ALLQUOTA, "Ability to alter everyone's quota at once",
    {NO,     NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Announce", POW_ANNOUNCE, "Ability to @announce for dfree",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    YES,  YES,  NO }},
  {
    "Boot", POW_BOOT, "Ability to @boot players off the game",
    {YES,    YESLT, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YESLT, YESLT, YESLT, NO,    NO,    NO,    NO,   YESLT,NO }},
  {
    "Broadcast", POW_BROADCAST, "Ability to @broadcast a message",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Chown", POW_CHOWN, "Ability to change ownership of an object",
    {YESEQ,  YESEQ, YESEQ, NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESEQ,  YESEQ, YESEQ, YESLT, NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Class", POW_CLASS, "Ability to re@classify somebody",
    {YESLT,  NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESLT,  NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Database", POW_DB, "Ability to use @dbck and other database utilities",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Examine", POW_EXAMINE, "Ability to see people's homes and locations",
    {YES,    YESEQ, YESEQ, YESEQ, NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YESEQ, YESEQ, YESEQ, NO,    NO,    NO,    YESLT,YES,  YES}},
  {
    "Free", POW_FREE, "Ability to build, etc. for dfree (currently unused)",
    {YES,    YES,   YES,   NO,    NO,    NO,    YES,   NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    YES,   NO,   YES,  NO }},
  {
    "Who", POW_WHO, "Ability to see classes and hidden players on the WHO list",
    {YES,    YES,   YESLT, NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Hostnames", POW_HOST, "Ability to see hostnames on the WHO list",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    YES,   NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Join", POW_JOIN, "Ability to 'join' players",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    YES,  YES,  YES}},
  {
    "Member", POW_MEMBER, "Ability to change your name and password",
    {YES,    YES,   YES,   YES,   YES,   NO,    NO,    YES,  YES,  YES},
    {YES,    YES,   YES,   YES,   YES,   NO,    NO,    YES,  YES,  YES}},
  {
    "Modify", POW_MODIFY, "Ability to modify other people's objects",
    {YESEQ,  YESEQ, YESEQ, NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESEQ,  YESEQ, YESEQ, YESEQ, NO,    NO,    NO,    NO,   YESEQ,NO }},
  {
    "Money", POW_MONEY, "Power to have INFINITE money",
    {YES,    YES,  NO,     NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,  YES,    NO,    NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Newpassword", POW_NEWPASS, "Ability to use the @newpassword command",
    {YESLT,  YESLT, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESLT,  YESLT, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Noslay", POW_NOSLAY, "Power to not be killed (currently unused)",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Noquota", POW_NOQUOTA, "Power to have INFINITE quota",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Nuke", POW_NUKE, "Power to @nuke other characters",
    {YESLT,  NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESLT,  YESLT, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Pcreate", POW_PCREATE, "Power to create new characters",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Poor", POW_POOR, "Power to use the @poor command",
    {NO,     NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Queue", POW_QUEUE, "Power to see everyone's commands in the queue",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    NO,   YES,  YES}},
  {
#ifdef EXEC
    "Exec", POW_EXEC, "Power to execute external programs",
#else
    "Exec", POW_EXEC, "<not available>",
#endif
    {NO,     NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Seeatr", POW_SEEATR, "Ability to see attributes on other people's things",
    {YESEQ,  YESEQ, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESEQ,  YESEQ, YESEQ, YESEQ, NO,    NO,    NO,    YESEQ,YES,  YES}},
  {
    "Setpow", POW_SETPOW, "Ability to alter people's powers",
    {YESLT,  NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESLT,  NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Slay", POW_SLAY, "Ability to use the 'slay' command",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Shutdown", POW_SHUTDOWN, "Ability to @shutdown the game",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Summon", POW_SUMMON, "Ability to 'summon' other players",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YESEQ, NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Slave", POW_SLAVE, "Ability to set the SLAVE flag.",
    {YESLT,  YESLT, NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YESLT,  YESLT, YESLT, YESLT, NO,    NO,    NO,    YESLT,YESLT,NO }},
  {
    "Spoof", POW_SPOOF, "Ability to do unlimited @emit etc",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Stats", POW_STATS, "Ability to @stat other ppl",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Steal", POW_STEAL, "Ability to give negative amounts of credits",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Teleport", POW_TELEPORT, "Ability to use unlimited @tel",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "WizAttributes", POW_WATTR, "Ability to set Last, Queue, etc",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "WizFlags", POW_WFLAGS, "Ability to set Temple, etc",
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Remote", POW_REMOTE, "Ability to do remote whisper, @pemit, etc.",
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    YES,  YES,  YES}},
  {
    "Security", POW_SECURITY, "Ability to do various security-related things",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
    "Backstage", POW_BACKSTAGE, "Ability to see numbers on all objects",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    YES,  YES,  YES}},
  {
    "Functions", POW_FUNCTIONS, "Ability to get correct results from all functions",
    {YES,    YES,   YES,   NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   YES,   YES,   NO,    NO,    NO,    NO,   YES,  YES}},
  {
    "Dbtop", POW_DBTOP, "Abililty to do a @dbtop",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    YES,   NO,    YES,   NO,    NO,    NO,    NO,   YES,  NO }},
  {
    "Setquota", POW_SETQUOTA, "Ability to change people's quotas",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES, YESLT,    YESLT, NO,    NO,    NO,    NO,    NO,   NO,   NO }},
  {
#ifdef USE_SPACE /* Power added by Michael Majere */
    "Space", POW_SPACE, "Overlord of time and space!",
#else
    "Space", POW_SPACE, "<not available>",
#endif
    {NO,     NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   YES,  NO }},
  {
#ifdef USE_RWHO
    "Rwho", POW_RWHO, "Ability to start/stop and do dfree rwho",
    {YES,    NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
#else
    "Rwho", POW_RWHO, "<not available>",
    {NO,     NO,    NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO },
#endif
    {YES,    YES,   NO,    NO,    NO,    NO,    NO,    NO,   NO,   NO }},
};

char *classnames[] ={
  " ?",
  "Guest", "Visitor", "Robot", "Citizen",
  "pCitizen", "Guide", "Official", "Constructor",
  "Administrator", "Director",
  NULL
  };
char *public_classnames[]={
  " ?",
  "Visitor", "Visitor", "Robot", "Citizen",
  "pCitizen", "Guide", "Official", "Constructor",
  "Administrator", "Director",
  NULL
  };
char *short_classnames[]={
  " ?",
  "Guest", "Vstor", "Robot", "Ctzen", "pCtzn",
  "Guide", "Offcl", "Cnstr", "Admin", "Drctr",
  NULL
  };
char *short_public_classnames[]={
  " ?",
  "Vstor", "Vstor", "Robot", "Ctzen", "pCtzn",
  "Guide", "Offcl", "Cnstr", "Admin", "Drctr",
  NULL
  };
char *typenames[] ={
  "Room", "Thing", "Exit", " 0x3", " 0x4", " 0x5", " 0x6", " 0x7", "Player"
  };
char hierarchy[] ={		/* class hierarchy.. the sooner it comes the further down, less powerful. */
  CLASS_DIR, CLASS_ADMIN, 
  CLASS_BUILDER, CLASS_OFFICIAL, CLASS_JUNOFF, CLASS_CORP,
  CLASS_CITIZEN, CLASS_ROBOT,
  CLASS_VISITOR, CLASS_GUEST,
  0
  };

 char *class_to_name(class)
     int class;
{
  if(class >= NUM_CLASSES || class <=0) return NULL;
  return classnames[class];
}
char *public_class_to_name(class)
     int class;
{
  return public_classnames[class];
}
char *short_class_to_name(class)
     int class;
{
  return short_classnames[class];
}
char *short_public_class_to_name(class)
     int class;
{
  return short_public_classnames[class];
}
int name_to_class(name)
 char *name;
{
  int k;
  for(k=0;classnames[k];k++)
    if(!string_compare(name,classnames[k]))
      return k;
  return 0;
}
char *type_to_name(type)
     int type;
{
  if(type>=0 && type<9)
    return typenames[type];
  else
    return NULL;
}

int class_to_list_pos(type)
     int type;
{
  switch(type) {
  case CLASS_DIR:
    return 0;
  case CLASS_ADMIN:
    return 1;
  case CLASS_BUILDER:
    return 2;
  case CLASS_OFFICIAL:
    return 3;
  case CLASS_CITIZEN:
    return 4;
  case CLASS_VISITOR:
    return 5;
  case CLASS_GUEST:
    return 6;
  case CLASS_JUNOFF:
    return 7;
  case CLASS_CORP:
    return 8;
  case CLASS_ROBOT:
    return 9;
  default: return 5;
  }
}
