/* $Id: log.h,v 1.3 1993/03/18 22:26:16 nils Exp $ */
/* log.h - extern definitions for logging things */


#ifndef __LOG_H
#define __LOG_H

#include <stdio.h>

struct log {
  FILE *fptr;
  int counter;
  char *filename;
  char *com_channel;
};

extern struct log important_log, sensitive_log, error_log, ioerr_log,
  io_log, gripe_log
#ifdef LOG_FAILED_COMMANDS
  , huh_log
#endif
  ;

#define log_important(str) muse_log(&important_log, (str))
#define log_sensitive(str) muse_log(&sensitive_log, (str))
#define log_error(str) muse_log(&error_log, (str))
#define log_ioerr(str) muse_log(&ioerr_log, (str))
#define log_io(str) muse_log(&io_log, (str))
#define log_gripe(str) muse_log(&gripe_log, (str))
#ifdef LOG_FAILED_COMMANDS
#define log_huh(str) muse_log(&huh_log, (str))
#endif

extern void muse_log P((struct log *, char *));

#endif /* __LOG_H */
