------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS                --
--                                                                          --
--             S Y S T E M . M A C H I N E _ S P E C I F I C S              --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                    (corresponds to FSU revision 1.16)                    --
--                                                                          --
--           Copyright (c) 1992,1993,1994 FSU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System;
with System.POSIX_RTE;
with System.Pthreads;

package System.Machine_Specifics is

   type Init_State is access procedure (Arg : System.Address);

   type Pre_Call_State is new POSIX_RTE.sigcontext_ptr;

   type Task_Storage_Size is new Pthreads.size_t;

   type Machine_Exceptions is new POSIX_RTE.Signal_Number;

   type Interrupt_ID is new POSIX_RTE.Signal_Number;

   type Interrupt_Info is new POSIX_RTE.siginfo_ptr;

   type Error_Information is new POSIX_RTE.siginfo_ptr;

end System.Machine_Specifics;
