------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--              A D A . T A S K _ I D E N T I F I C A T I O N               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with System;
with System.Abortion;
with System.Address_Image;
with System.Rendezvous;
with System.Task_IDs;
with System.Task_Stages;

with Unchecked_Conversion;

package body Ada.Task_IDentification is

   ---------
   -- "=" --
   ---------

   function  "=" (Left, Right : Task_Id) return Boolean is
   begin
      return System.Task_IDs.Same_Task (Left.Id, Right.Id);
   end "=";

   -----------------
   -- Abort_Task --
   ----------------

   procedure Abort_Task (T : in out Task_Id) is
   begin
      System.Abortion.Abort_Tasks (System.Abortion.Task_List'(1 => T.Id));
   end Abort_Task;

   ------------------
   -- Current_Task --
   ------------------

   function Current_Task return Task_Id is
   begin
      return (Id => System.Task_IDs.Self);
   end Current_Task;

   -----------
   -- Image --
   -----------

   function Image (T : Task_Id) return String is
   --   function To_Address is
   --     new Unchecked_Conversion (Task_ID, Address);
   begin
   --   return Address_Image (To_Address (T));
      return "???";
   end Image;

   -----------------
   -- Is_Callable --
   -----------------

   function Is_Callable (T : Task_Id) return Boolean is
   begin
      return System.Rendezvous.Callable (T.Id);
   end Is_Callable;

   -------------------
   -- Is_Terminated --
   -------------------

   function Is_Terminated (T : Task_Id) return Boolean is
   begin
      return
        System.Task_Stages.Terminated (T.Id);
   end Is_Terminated;

end Ada.Task_IDentification;
