#include <string.h>
#include <stdlib.h>

#include "match.h"
#include "players.h"
#include "gospel.h"
#include "xgospel.h"

void AutoMatchRequest(const NameList *Lines)
{
    const NameList *Line;
    const char *From, *To;

    Line = Lines->Next;
    From = Line->Name;
    To = strchr(From, ' ');
    if (To) Outputf("%.*s wants a match\n", To-From, From);
    for (Line = Lines->Next; Line != Lines; Line = Line->Next)
        Outputf("%s\n", Line->Name);
}

void AutoMatchDispute(const char *FirstLine, const NameList *Lines)
{
    const NameList *Line;

    Outputf("%s\n", FirstLine);
    for (Line = Lines->Next; Line != Lines; Line = Line->Next)
        Outputf("%s\n", Line->Name);
}

void MatchRequest(int Rules, const NameList *names)
{
    const char *Name, *Prefix;
    int         Color, Size, Tim, ByoYomi;

    names   = names->Next;
    Name    = names->Name;
    names   = names->Next;
    Color   = names->Name[0] == 'B' ? Black : White;
    names   = names->Next;
    Size    = atoi(names->Name);
    names   = names->Next;
    Tim     = atoi(names->Name); 
    names   = names->Next;
    ByoYomi = atoi(names->Name); 
    Outputf("%s%sMatch[%dx%d] in %d minutes requested with %s as %s.\n",
            Rules == 'i' || Rules == 'g' ? "Tournament " : "",
            Rules == 'G' || Rules == 'g' ? "GOE " : "",
            Size, Size, Tim, Name, Color == Black ? "white" : "black");
    switch(Rules) {
      case 'I': Prefix = "";    break;
      case 'i': Prefix = "t";   break;
      case 'G': Prefix = "goe"; break;
      case 'g': Prefix = "tg";  break;
      default:
        Prefix = "unknown";
        Raise1(AssertException, "Impossible match type");
        break;
    }
    Outputf("Use <%smatch %s %c %d %d %d> or <decline %s> to respond\n",
            Prefix, Name, Color == Black ? 'B':'W', Size, Tim, ByoYomi, Name);
}

void Dispute(const NameList *Lines)
{
    const NameList *Line;

    Output("There is a dispute regarding your match:\n");
    for (Line = Lines->Next; Line != Lines; Line = Line->Next)
        Outputf("%s\n", Line->Name+2);
}

void Decline(const char *Name)
{
    Outputf("%s declined your request for a match\n",
            PlayerNameToString(Name));
}
