/*
   This file is part of TALER
   Copyright (C) 2025 Taler Systems SA

   TALER is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 3, or (at your option) any later version.

   TALER is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
   A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along with
   TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */
/**
 * @file backenddb/pg_check_donau_instance.c
 * @brief Implementation of the check_donau_instance function for Postgres
 * @author Christian Grothoff
 */
#include "platform.h"
#include <taler/taler_error_codes.h>
#include <taler/taler_dbevents.h>
#include <taler/taler_pq_lib.h>
#include "pg_check_donau_instance.h"
#include "pg_helper.h"


enum GNUNET_DB_QueryStatus
TMH_PG_check_donau_instance (
  void *cls,
  const struct TALER_MerchantPublicKeyP *merchant_pub,
  const char *donau_url,
  uint64_t charity_id
  )
{
  struct PostgresClosure *pg = cls;
  struct GNUNET_PQ_QueryParam params[] = {
    GNUNET_PQ_query_param_string (donau_url),
    GNUNET_PQ_query_param_uint64 (&charity_id),
    GNUNET_PQ_query_param_auto_from_type (merchant_pub),
    GNUNET_PQ_query_param_end
  };
  struct GNUNET_PQ_ResultSpec rs[] = {
    GNUNET_PQ_result_spec_end
  };

  check_connection (pg);
  PREPARE (pg,
           "check_donau_instance",
           "SELECT 1"
           " FROM merchant_donau_instances"
           " WHERE donau_url=$1"
           "   AND charity_id=$2 "
           "   AND merchant_instance_serial ="
           "   (SELECT merchant_serial"
           "      FROM merchant_instances mi"
           "     WHERE mi.merchant_pub = $3)");
  return GNUNET_PQ_eval_prepared_singleton_select (pg->conn,
                                                   "check_donau_instance",
                                                   params,
                                                   rs);

}
