/*------------------------->  ANSI C - sourcefile  <-------------------------*/
/* Copyright (C) 2000 by K Hopper, University of Waikato, New Zealand        */
/* This file is part of the GNU Sather library. It is free software; you may */
/* redistribute  and/or modify it under the terms of the GNU Library General */
/* Public  License (LGPL)  as published  by the  Free  Software  Foundation; */
/* either version 2 of the license, or (at your option) any later version.   */
/* This  library  is distributed  in the  hope that it will  be  useful, but */
/* WITHOUT ANY WARRANTY without even the implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE. See Doc/LGPL for more details.       */
/* The license text is also available from:  Free Software Foundation, Inc., */
/* 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA                     */
/*------------>  Please email comments to <bug-sather@gnu.org>  <------------*/

/* - - - - -- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          This file contains references to all of the clock and timer services
     offered by the operating system which conflict with the Sather interface
     but which it is necessary to use in the required Sather library.
     
          Version 2.1 Oct 99.  Copyright K Hopper, U of Waikato
          
                          Development History
                          -------------------

        Date           Who By         Detail
        ----           ------         ------

        15 Oct 98        kh       Original from Sather 1.2 distribution.
        30 Oct 99        kh       Modified for Win32 clock interface.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */
 
#include <unistd.h>

#include <utime.h>
#include <sys/time.h>
#include <sys/times.h>
#include <time.h>
#include "sather.h"


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The following routine returns zero if successful and the entity
     pointed to by thge argument has had its components filled with the
     process time details.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


CARD p_times(REFERENCE arg) {
     return (CARD) times((struct tms *)arg) ;
     }


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The following routine returns the count of seconds since the operating
     system defined base date.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


INT os_clock(void) {
     return (INT) clock() ;
     }


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The following routine returns zero if it has successfully set the
     argument to the count of seconds since the operating system defined base
     date.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


INT os_time(REFERENCE arg) {
     return (INT) time((void *)arg) ;
     }


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The following routine returns zero if it has successfully obtained
	OS time of day clock value.
 *
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


INT get_timeofday(REFERENCE clock, REFERENCE tzinfo) {
     return (INT) gettimeofday((struct timeval *) clock, (struct timezone *) tzinfo) ;
     }


/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

          The following routine returns zero if it has successfully set the
	OS time of day clock.
 *
 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */


INT set_timeofday(REFERENCE clock, REFERENCE tzinfo) {
     return (INT) settimeofday((struct timeval *) clock,
                                    (struct timezone *) tzinfo) ;
     }


CARD sa_pause(
              CARD seconds
              ) {

     return (CARD) sleep((unsigned int) seconds) ;
     }

