/* LocaleInformation_km.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_km extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "KHR";

  private static final String currenciesDisplayNameValues = "Riel";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "KHR";

  private static final String currenciesSymbolValues = "\u17db";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "\u17e1",
    "\u17e2",
    "\u17e3",
    "\u17e4",
    "\u17e5",
    "\u17e6",
    "\u17e7",
    "\u17e8",
    "\u17e9",
    "\u17e1\u17e0",
    "\u17e1\u17e1",
    "\u17e1\u17e2",
    null,
  };

  private static final String[] months = {
    "\u1798\u1780\u179a\u17b6",
    "\u1780\u17bb\u1798\u17d2\u1797\u17c8",
    "\u1798\u17b7\u1793\u17b6",
    "\u1798\u17c1\u179f\u17b6",
    "\u17a7\u179f\u1797\u17b6",
    "\u1798\u17b7\u1790\u17bb\u1793\u17b6",
    "\u1780\u1780\u17d2\u1780\u178a\u17b6",
    "\u179f\u17b8\u17a0\u17b6",
    "\u1780\u1789\u17d2\u1789\u17b6",
    "\u178f\u17bb\u179b\u17b6",
    "\u179c\u17b7\u1785\u17d2\u1786\u17b7\u1780\u17b6",
    "\u1792\u17d2\u1793\u17bc",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "\u17a2\u17b6",
    "\u1785",
    "\u17a2",
    "\u1796\u17bb",
    "\u1796\u17d2\u179a",
    "\u179f\u17bb",
    "\u179f",
  };

  private static final String[] weekdays = {
    null,
    "\u1790\u17d2\u1784\u17c3\u200b\u17a2\u17b6\u1791\u17b7\u178f\u17d2\u1799",
    "\u1790\u17d2\u1784\u17c3\u200b\u1785\u17d0\u1793\u17d2\u1791",
    "\u1790\u17d2\u1784\u17c3\u200b\u17a2\u1784\u17d2\u1782\u17b6\u179a",
    "\u1790\u17d2\u1784\u17c3\u200b\u1796\u17bb\u1792",
    "\u1790\u17d2\u1784\u17c3\u200b\u1796\u17d2\u179a\u17a0\u179f\u17d2\u1794\u178f\u17b7\u17cd",
    "\u1790\u17d2\u1784\u17c3\u200b\u179f\u17bb\u1780\u17d2\u179a",
    "\u1790\u17d2\u1784\u17c3\u200b\u179f\u17c5\u179a\u17cd",
  };

  private static final String[] ampms = {
    "\u1796\u17d2\u179a\u17b9\u1780",
    "\u179b\u17d2\u1784\u17b6\u1785",
  };

  private static final String territoriesKeys = "TL|TJ|TH|TG|GY|TD|GW|GT|GR|GQ|SZ|SY|GN|GM|SV|GH|SR|GE|SO|SN|SL|GA|SK|SI|SG|SE|SD|SC|SA|FR|FM|RW|RU|FJ|FI|RO|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|DK|DJ|PT|PS|PR|DE|PL|PK|PH|PG|CZ|PE|CY|CV|PA|CU|CR|CO|CN|CM|CL|CI|CH|CG|CF|OM|CA|BZ|BY|BW|BT|BS|BR|NZ|BO|BN|BJ|BI|BH|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|AZ|NE|ZM|AU|NA|AT|AR|MZ|AO|MY|MX|AM|AL|ZA|MU|MT|MR|AF|AE|AD|MN|MM|ML|MK|YU|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LB|LA|KZ|KW|KR|KP|KM|KI|WS|KH|KG|KE|JP|JO|JM|VN|VE|VA|IT|IS|IR|IQ|UZ|UY|IN|IL|US|IE|ID|UG|UA|HU|HT|HR|TZ|HN|TW|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "\u1791\u17b8\u1798\u17d0\u179a\u1781\u17b6\u1784\u1780\u17be\u178f|\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1790\u17c3|\u178f\u17bc\u17a0\u17d2\u1782\u17bc|\u17a0\u17d2\u1782\u17b8\u1799\u17c9\u17b6\u178e\u17b6|\u1786\u17b6\u178a|\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u1794\u17ca\u17b8\u179f\u17bc|\u17a0\u17d2\u1782\u17b6\u178f\u17c1\u1798\u17c9\u17b6\u17a1\u17b6|\u1780\u17d2\u179a\u17b7\u1785|\u17a0\u17d2\u1782\u17b8\u178e\u17c1\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u1791\u17d0\u179a|\u179f\u17bc\u17a0\u17d2\u179f\u17c9\u17b8\u17a1\u1784\u17cb|\u179f\u17ca\u17b8\u179a\u17b8|\u17a0\u17d2\u1782\u17b8\u178e\u17c1|\u17a0\u17d2\u1782\u17b6\u17c6\u1794\u17ca\u17b8|\u17a2\u17c2\u179b\u179f\u17b6\u179b\u17cb\u179c\u17c9\u17b6\u178c\u17d0\u179a|\u17a0\u17d2\u1780\u17b6\u178e\u17b6|\u179f\u17bc\u179a\u17b8\u178e\u17b6\u1798|\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8|\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8|\u179f\u17c1\u1793\u17c1\u17a0\u17d2\u1780\u17b6\u179b\u17cb|\u179f\u17c1\u179a\u17c9\u17b6\u17a1\u17c1\u17a2\u17bc\u1793|\u17a0\u17d2\u1782\u17b6\u1794\u17bb\u1784|\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8|\u179f\u17d2\u179b\u17bc\u179c\u17c1\u1793\u17b8|\u179f\u17b7\u1784\u17d2\u17a0\u1794\u17bb\u179a\u17b8|\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a|\u179f\u17ca\u17bc\u178a\u1784\u17cb|\u179f\u17b8\u179f\u17c2\u179b|\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17ca\u17b8\u179f\u17b6\u17a2\u17ca\u17bc\u178c\u17b8\u178f|\u1794\u17b6\u179a\u17b6\u17c6\u1784|\u1798\u17b7\u1780\u17d2\u179a\u17bc\u1793\u17c1\u179f\u17ca\u17b8|\u179a\u179c\u17c9\u17b6\u1793\u17cb\u178a\u17b6|\u179a\u17bc\u179f\u17d2\u179f\u17ca\u17b8|\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8|\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb|\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8|\u17a2\u17c1\u178f\u17d2\u1799\u17bc\u1796\u17b8|\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789|\u17a2\u17c1\u179a\u17b8\u1791\u17d2\u179a\u17b6|\u179f\u17b6\u17a0\u17b6\u179a\u17c9\u17b6\u1781\u17b6\u1784\u179b\u17b7\u1785|\u17a2\u17c1\u17a0\u17d2\u179f\u17c9\u17b8\u1794|\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8|\u17a2\u17c1\u1780\u17d2\u179c\u17b6\u178c\u17d0\u179a|\u17a2\u17b6\u179b\u17cb\u17a0\u17d2\u179f\u17c1\u179a\u17b8|\u1780\u17b6\u178f\u17b6\u179a|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17c2\u1793|\u1794\u17c9\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17b6\u1799|\u178a\u17bc\u1798\u17b8\u1793\u17b8\u1780\u17b6|\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780|\u17a0\u17d2\u179f\u17c9\u17b8\u1794\u17bc\u1791\u17b8|\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb|\u1794\u17c9\u17b6\u179b\u17c1\u179f\u17d2\u1791\u17b8\u1793|\u1796\u17d0\u179a\u178f\u17bc\u179a\u17b8\u1780\u17bc|\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb|\u1794\u17c9\u17bc\u179b\u17bc\u1789|\u1794\u17c9\u17b6\u1782\u17b8\u179f\u17d2\u1790\u17b6\u1793|\u17a0\u17d2\u179c\u17c9\u17b8\u179b\u17b8\u1796\u17b8\u1793|\u1794\u17c9\u17b6\u1796\u17bc\u17a2\u17b6\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u1782\u17b8\u178e\u17c1|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1786\u17c1\u1780|\u1794\u17c9\u17c1\u179a\u17bc|\u179f\u17c9\u17b8\u1796\u179a\u17cd|\u1780\u17b6\u1794\u179c\u17c2\u179a|\u1794\u17c9\u17b6\u178e\u17b6\u1798\u17c9\u17b6|\u1782\u17bb\u1799\u1794\u17b6|\u1780\u17bc\u179f\u17d2\u178f\u17b6\u179a\u17b8\u1780\u17b6|\u1780\u17bc\u17a1\u17bb\u17c6\u1794\u17ca\u17b8|\u1785\u17b7\u1793|\u1780\u17b6\u1798\u17c1\u179a\u17bc\u1793|\u1788\u17b8\u179b\u17b8|\u1780\u17bc\u178a\u178c\u17b8\u179c\u17d0\u179a|\u179f\u17d2\u179c\u17b8\u179f|\u1780\u17bb\u1784\u17a0\u17d2\u1782\u17c4|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1780\u178e\u17d2\u178a\u17b6\u179b|\u17a2\u17bc\u1798\u17c9\u1784\u17cb|\u1780\u17b6\u178e\u17b6\u178a\u17b6|\u1794\u17c1\u179b\u17b8\u17a0\u17d2\u179f|\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f|\u1794\u17bb\u178f\u179f\u17d2\u179c\u17b6\u178e\u17b6|\u1794\u17ca\u17bc\u178f\u17b6\u1793|\u1794\u17b6\u17a0\u17b6\u1798\u17c9\u17b6|\u1794\u17d2\u179a\u17c1\u179f\u17ca\u17b8\u179b|\u1793\u17bc\u179c\u17c2\u179b\u17a0\u17d2\u179f\u17c1\u17a1\u1784\u17cb|\u1794\u17bc\u179b\u17b8\u179c\u17b8|\u1794\u17ca\u17d2\u179a\u17bb\u1799\u178e\u17c1|\u1794\u17c1\u178e\u17b6\u17c6\u1784|\u1794\u17ca\u17bc\u179a\u17bb\u1793\u178c\u17b8|\u1794\u17b6\u179a\u17c9\u17c2\u1793|\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1782\u17b6\u179a\u17b8|\u1794\u17ca\u17bc\u179a\u1782\u17b8\u178e\u17b6\u17a0\u17d2\u179c\u17b6\u179f\u17bc|\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb|\u1794\u17c2\u179b\u17a0\u17d2\u179f\u17c9\u17b7\u1780|\u1793\u17d0\u179a\u179c\u17c2\u179f|\u1794\u1784\u17cb\u1780\u17d2\u179b\u17b6\u178a\u17c1\u179f\u17d2\u17a0|\u1794\u17b6\u179a\u1794\u17b6\u178a\u17bc\u179f|\u17a0\u17d2\u179f\u17ca\u17b8\u1798\u1794\u17b6\u1794\u179c\u17c9\u17c1|\u17a0\u17bc\u179b\u17d2\u179b\u1784\u17cb|\u1794\u17bc\u179f\u17d2\u1793\u17c9\u17b8|\u1793\u17b8\u1780\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17d0\u179a|\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a\u17b8\u1799\u17c9\u17b6|\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb|\u1793\u17b8\u17a0\u17d2\u179f\u17c1\u179a|\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b8|\u17a2\u17bc\u179f\u17d2\u178f\u17d2\u179a\u17b6\u179b\u17b8|\u178e\u17b6\u1798\u17b8\u1794\u17ca\u17b8|\u17a2\u17bc\u1791\u17d2\u179a\u17b8\u179f|\u17a2\u17b6\u17a0\u17d2\u179f\u1784\u17cb\u1791\u17b8\u1793|\u1798\u17c9\u17bc\u17a0\u17d2\u179f\u17b6\u17c6\u1794\u17ca\u17b7\u1780|\u17a2\u1784\u17cb\u17a0\u17d2\u1782\u17c4\u17a1\u17b6|\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8|\u1798\u17c9\u17b7\u1785\u179f\u17b7\u1780|\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8|\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8|\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b7\u1780\u1781\u17b6\u1784\u178f\u17d2\u1794\u17bc\u1784|\u1798\u17c9\u17bc\u179a\u17b8\u1791\u17bb\u179f|\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6|\u1798\u17c9\u17bc\u179a\u17b8\u178f\u17b6\u1793\u17b8|\u17a2\u17b6\u17a0\u17d2\u179c\u17a0\u17d2\u1782\u17b6\u1793\u17b8\u179f\u17d2\u1790\u17b6\u1793|\u17a2\u17c1\u1798\u17b8\u179a\u17c9\u17c2\u1791\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb\u179a\u17bd\u1798|\u17a2\u17b6\u1793\u178a\u17bc\u179a\u17c9\u17b6|\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8|\u1798\u17b8\u1799\u17c9\u17b6\u1793\u17cb\u1798\u17c9\u17b6|\u1798\u17c9\u17b6\u179b\u17b8|\u1798\u17c9\u17b6\u179f\u17c1\u178a\u1793|\u1799\u17bc\u17a0\u17d2\u1782\u17c4\u179f\u17d2\u179b\u17b6\u179c\u17b8|\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u17d2\u1780\u17b6\u179a|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8|\u1798\u17c9\u17bc\u178e\u17b6\u1780\u17bc|\u1798\u17c9\u17b6\u179a\u17c9\u17bb\u1780|\u1799\u17c1\u1798\u17c2\u1793|\u179b\u17b8\u1794\u17ca\u17b8|\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6|\u179b\u17bb\u1785\u17a0\u17d2\u179f\u17c6\u1794\u17bd\u179a|\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8|\u179b\u17be\u179f\u17bc\u178f\u17bc|\u179b\u17b8\u1794\u17c1\u179a\u17b8\u1799\u17c9\u17b6|\u179f\u17d2\u179a\u17b8\u179b\u1784\u17d2\u1780\u17b6|\u179b\u17b7\u1785\u1791\u17c1\u1793\u179f\u17d2\u178f\u17c2\u1793|\u179b\u17b8\u1794\u1784\u17cb|\u17a1\u17b6\u179c|\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u17b6\u1784\u17cb\u17cb|\u1782\u17bb\u1799\u179c\u17c9\u17c2\u178f|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1780\u17bc\u179a\u17c9\u17c1|\u179f\u17b6\u1792\u17b6\u179a\u178e\u179a\u178a\u17d2\u178b\u1794\u17d2\u179a\u1787\u17b6\u1792\u17b7\u1794\u178f\u17c1\u1799\u17d2\u1799\u1794\u17d2\u179a\u1787\u17b6\u1798\u17b6\u1793\u17b7\u178f\u1780\u17bc\u179a\u17c9\u17c1|\u1780\u17bb\u17c6\u1798\u17c9\u17bc\u179a\u17c9\u17bc\u179f|\u1782\u17b7\u179a\u17b7\u1794\u17b6\u1791\u17b8|\u179f\u17b6\u1798\u17bc\u17a2\u17b6|\u1780\u1798\u17d2\u1796\u17bb\u1787\u17b6|\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1780\u17c1\u1793\u1799\u17c9\u17b6|\u1787\u1794\u17c9\u17bb\u1793|\u17a0\u17ca\u17d2\u179f\u1780\u178a\u17b6\u1793\u17b8|\u17a0\u17d2\u179f\u17b6\u1798\u17c9\u17b6\u17a2\u17c9\u17b7\u1782|\u179c\u17c0\u178f\u178e\u17b6\u1798|\u179c\u17c1\u1793\u17c1\u17a0\u17d2\u179f\u17ca\u17bb\u1799\u17a1\u17b6|\u179c\u17c9\u17b6\u1791\u17b8\u1780\u1784\u17cb|\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8|\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb|\u17a2\u17ca\u17b8\u179a\u17c9\u1784\u17cb|\u17a2\u17ca\u17b8\u179a\u17c9\u17b6\u1780\u17cb|\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u17a2\u17ca\u17bb\u1799\u179a\u17bb\u1799\u17a0\u17d2\u1782\u17b6\u1799|\u17a5\u178e\u17d2\u178c\u17b6|\u17a2\u17ca\u17b8\u179f\u17d2\u179a\u17b6\u17a2\u17c2\u179b|\u179f\u17a0\u179a\u178a\u17d2\u178b\u17a2\u17b6\u1798\u17c1\u179a\u17b7\u1780|\u17a2\u17c0\u179a\u17a1\u1784\u17cb|\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8|\u17a2\u17ca\u17bc\u17a0\u17d2\u1780\u1784\u17cb\u178a\u17b6|\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793|\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8|\u17a0\u17c3\u1791\u17b8|\u1780\u17d2\u179a\u17bc\u17a2\u17b6\u179f\u17ca\u17b8|\u178f\u1784\u17cb\u17a0\u17d2\u179f\u17b6\u1793\u17b8|\u17a0\u17bb\u1784\u178c\u17bd\u179a\u17c9\u17b6\u179f\u17cb|\u178f\u17c3\u179c\u17c9\u17b6\u1793\u17cb|\u17a0\u17bb\u1784\u1780\u17bb\u1784|\u1791\u17d2\u179a\u17b8\u1793\u17b8\u178a\u17b6\u178a\u1793\u17b9\u1784\u178f\u17bc\u1794\u17b6\u17a0\u17d2\u1782\u17c4|\u1791\u17bd\u179a\u1782\u17b8|\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17b6|\u1791\u17bb\u1799\u1793\u17c1\u179f\u17ca\u17b8|\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "es|ku|eo|en|el|qu|ko|kn|km|kk|ka|dz|jv|pt|de|pl|da|ja|vi|pa|cs|it|is|uz|or|ur|ca|id|uk|hy|hu|bo|bn|bm|bh|bg|tt|no|be|hi|tr|nl|zu|to|he|tk|ne|az|ay|th|tg|te|zh|ar|ta|gu|an|za|mt|ms|gn|sw|mr|sv|gl|su|af|mo|ae|mn|sq|ml|mk|aa|so|mi|gd|sm|sl|mg|sk|ga|yo|yi|sd|sa|fr|lv|lt|ru|lo|fj|fi|ro|rn|la|xh|eu|ky|et";

  private static final String languagesValues = "\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1794\u17c9\u17b6\u1789|\u1797\u17b6\u179f\u17b6\u1783\u17ba\u178a|\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u1796\u17c1\u179a\u17c9\u17b6\u1793\u17d2\u1791\u17c4|\u1797\u17b6\u179f\u17b6\u17a2\u1784\u17cb\u1782\u17d2\u179b\u17c1\u179f|\u1797\u17b6\u179f\u17b6\u1780\u17d2\u179a\u17b7\u1785|\u1797\u17b6\u179f\u17b6\u1780\u17c1\u1791\u17d2\u1787\u17bc\u17a2\u17b6|\u1797\u17b6\u179f\u17b6\u1780\u17bc\u179a\u17c9\u17c1|\u1797\u17b6\u179f\u17b6\u1780\u17b7\u178e\u17b6\u178a\u17b6|\u1797\u17b6\u179f\u17b6\u1781\u17d2\u1798\u17c2\u179a|\u1797\u17b6\u179f\u17b6\u1780\u17b6\u17a0\u17d2\u179f\u17b6\u1780\u17cb\u179f\u17d2\u178f\u1784\u17cb\u17cb|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u1780\u17a0\u17d2\u179f\u17c9\u17b8|\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bc\u178f\u17b6\u1793|\u1797\u17b6\u179f\u17b6\u1799\u17c9\u17b6\u179c\u17b6|\u1797\u17b6\u179f\u17b6\u1796\u17d0\u179a\u1791\u17bb\u1799\u17a0\u17d2\u1780\u17b6\u179b\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17d2\u179b\u17ba\u1798\u17c9\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u1794\u17c9\u17bc\u17a1\u17bc\u1789|\u1797\u17b6\u179f\u17b6\u178a\u17b6\u178e\u17ba\u1798\u17c9\u17b6\u1780|\u1797\u17b6\u179f\u17b6\u1787\u1794\u17c9\u17bb\u1793|\u1797\u17b6\u179f\u17b6\u179c\u17c0\u178f\u178e\u17b6\u1798|\u1797\u17b6\u179f\u17b6\u1796\u17bc\u1793\u1799\u17c9\u17b6\u1794\u17ca\u17b8|\u1797\u17b6\u179f\u17b6\u1786\u17c1\u1780|\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17b8\u178f\u17b6\u179b\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17c9\u17b8\u179f\u17d2\u179b\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u17a0\u17d2\u179f\u1794\u17c1\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17bc\u179a\u17b8\u1799\u17c9\u17b6|\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bc\u179a\u17d2\u178c\u17bc|\u1797\u17b6\u179f\u17b6\u1780\u17b6\u178f\u17b6\u17a1\u17b6\u1793|\u1797\u17b6\u179f\u17b6\u17a5\u178e\u17d2\u178c\u17bc\u1793\u17c1\u179f\u17ca\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17ca\u17bb\u1799\u1780\u17d2\u179a\u17c2\u1793|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u1798\u17c1\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u1784\u1782\u17d2\u179a\u17b8|\u1797\u17b6\u179f\u17b6\u1791\u17b8\u1794\u17c1|\u1797\u17b6\u179f\u17b6\u1794\u17c1\u1793\u17d2\u1780\u17b6\u179b\u17b8|\u1797\u17b6\u179f\u17b6\u1794\u17b6\u1798\u17d2\u1794\u17b6\u179a\u17b6|\u1797\u17b6\u179f\u17b6\u1794\u17b7\u17a0\u17b6\u179a|\u1797\u17b6\u179f\u17b6\u1794\u17ca\u17bb\u179b\u17a0\u17d2\u1780\u17b6\u179a\u17b8|\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178f\u17b6\u179a|\u1797\u17b6\u179f\u17b6\u1793\u17d0\u179a\u179c\u17c2\u179f|\u1797\u17b6\u179f\u17b6\u1794\u17c1\u17a1\u17b6\u179a\u17bb\u179f\u17d2\u179f|\u1797\u17b6\u179f\u17b6\u17a0\u17c9\u17b7\u1793\u178c\u17b8|\u1797\u17b6\u179f\u17b6\u1791\u17bd\u179a\u1782\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17bb\u179b\u17d2\u179b\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179f\u17c9\u17bc\u179b\u17bc|\u1797\u17b6\u179f\u17b6\u178f\u17bb\u1784\u17a0\u17d2\u1782\u17c4|\u1797\u17b6\u179f\u17b6\u17a0\u17c1\u1794\u17d2\u179a\u17b7|\u1797\u17b6\u179f\u17b6\u1791\u17bd\u1782\u1798\u17c1\u1793\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u1793\u17c1\u1794\u17c9\u17b6\u179b\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17ca\u17d2\u179f\u17c2\u179a\u1794\u17c2\u17a0\u17d2\u179f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17b8\u1798\u17c9\u17b6\u179a\u17c9\u17b6|\u1797\u17b6\u179f\u17b6\u1790\u17c3|\u1797\u17b6\u179f\u17b6\u178f\u17b6\u178a\u17a0\u17d2\u179f\u17c9\u17b8\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u178f\u17c1\u179b\u17bc\u17a0\u17d2\u1782\u17bc|\u1797\u17b6\u179f\u17b6\u1785\u17b7\u1793|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u1794\u17cb|\u1797\u17b6\u179f\u17b6\u178f\u17b6\u1798\u17b8\u179b|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bb\u1799\u17c9\u17b6\u179a\u17b6\u1791\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179a\u17c9\u17b6\u17a0\u17d2\u1782\u17c4\u1793|\u1797\u17b6\u179f\u17b6\u1785\u17bd\u1784|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17cb\u178f\u17b6|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179b\u17c1\u179f\u17c9\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17bd\u179a\u17c9\u17b6\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179c\u17b6\u17a0\u17c9\u17b8\u179b\u17b8|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179a\u17b6\u1792\u17b8|\u1797\u17b6\u179f\u17b6\u179f\u17ca\u17bb\u1799\u17a2\u17c2\u178a|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17b6\u179b\u17b8\u179f\u17c9\u17b8|\u1797\u17b6\u17c6\u179f\u17b6\u179f\u17ca\u17bc\u178a\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17d2\u179a\u17b8\u1780\u17b6\u17a2\u17b6\u1793|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u179b\u178a\u17b6\u179c\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179c\u17c2\u179f\u17d2\u178f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17bb\u1784\u17a0\u17d2\u1782\u17c4\u179b\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u179b\u17cb\u1794\u17b6\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u17a1\u17b6\u17a1\u17b6\u1799\u17c9\u17b6\u1793|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u179f\u17c1\u178a\u17bc\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u17a2\u17b6\u17a0\u17d2\u179c\u17b6\u179a|\u1797\u17b6\u179f\u17b6\u179f\u17bc\u1798\u17c9\u17b6\u179b\u17b8|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17c4\u179a\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782|\u1797\u17b6\u179f\u17b6\u179f\u17b6\u1798\u17bc\u17a2\u17b6|\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u1798\u17c9\u17b6\u178a\u17b6\u17a0\u17d2\u1780\u17b6\u179f\u1780\u17b6\u179a|\u1797\u17b6\u179f\u17b6\u179f\u17d2\u179b\u17bc\u179c\u17c9\u17b6\u1782\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u1780\u17c2\u179b\u17b7\u1782|\u1797\u17b6\u179f\u17b6\u1799\u179a\u17bc\u1794\u17b6|\u1797\u17b6\u179f\u17b6\u1799\u17b8\u178c\u17b8\u17a0\u17d2\u179f|\u1797\u17b6\u179f\u17b6\u179f\u17c9\u17b8\u1793\u17d2\u178a\u17b8|\u1797\u17b6\u179f\u17b6\u179f\u17c6\u179f\u17d2\u1780\u17d2\u179a\u17b9\u178f|\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179a\u17b6\u17c6\u1784|\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u179c\u17b8\u1799\u17c9\u17b6|\u1797\u17b6\u179f\u17b6\u179b\u17b8\u1791\u17bb\u1799\u17a2\u17b6\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u0e23\u0e31\u179a\u17bc\u179f\u17d2\u179f\u17c9\u17b8|\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u179c|\u17a0\u17d2\u179c\u17c9\u17b8\u17a0\u17d2\u179f\u17c9\u17b8|\u1797\u17b6\u179f\u17b6\u17a0\u17d2\u179c\u17b6\u17c6\u1784\u17a1\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1798\u17c9\u17b6\u1793\u17b8|\u1797\u17b6\u179f\u17b6\u179a\u17bc\u1793\u17d2\u178c\u17b8|\u1797\u17b6\u179f\u17b6\u17a1\u17b6\u178f\u17c6\u17b6\u1784|\u1797\u17b6\u179f\u17b6\u1783\u179f\u17b6|\u1797\u17b6\u179f\u17b6\u1794\u17b6\u179f\u17d2\u1780\u17c1|\u1797\u17b6\u179f\u17b6\u1782\u17c0\u179a\u17a0\u17d2\u1782\u17b8\u179f\u17d2\u178f\u1784\u17cb|\u1797\u17b6\u179f\u17b6\u17a2\u17c1\u179f\u17d2\u178f\u17bc\u1793\u17b8";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GyMdkHmsSEDFwWahKzYeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "ampms", ampms },
    { "shortDateFormat", "d/M/yyyy" },
    { "mediumDateFormat", "d MMMM yyyy" },
    { "longDateFormat", "EEEE' \u1790\u17d2\u1784\u17c3 'd' \u1781\u17c2 'MMMM' \u1786\u17d2\u1793\u17b6\u17c6 ' yyyy" },
    { "fullDateFormat", "EEEE' \u1790\u17d2\u1784\u17c3 'd' \u1781\u17c2 'MMMM' \u1786\u17d2\u1793\u17b6\u17c6 ' yyyy" },
    { "shortTimeFormat", "H:mm" },
    { "mediumTimeFormat", "H:mm:ss" },
    { "longTimeFormat", "H' \u1798\u17c9\u17c4\u1784 'm' \u1793\u17b6\u1791\u17b8 'ss' \u179c\u17b7\u1793\u17b6\u1791\u17b8\u200b'" },
    { "fullTimeFormat", "H' \u1798\u17c9\u17c4\u1784 'm' \u1793\u17b6\u1791\u17b8 'ss' \u179c\u17b7\u1793\u17b6\u1791\u17b8\u200b' z" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
