/* LocaleInformation_hr.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_hr extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "YDD|KES|TWD|LKR|TJS|ERN|SDP|GRD|IEP|ARS|MQF|ARP|SDD|GEL|GEK|CRC|MDR|FKP|GQP|EEK|MDL|HKD|IQD|SCR|GQF|DKK|IDR|GQE|MDC|SOS|LVR|LVL|RUR|FJP|MCG|MCF|MOP|GPF|FJD|RUB|DJF|LIF|SBD|ECV|TTO|ECS|PHP|LUF|FIN|FIM|TTD|SZL|MNT|UAH|HUF|COP|LTT|PTE|PTC|GBP|ZRZ|INR|LTL|UYP|MZM|KZT|KZR|AOK|GNS|SYP|OMR|NGP|MZE|ZRN|NGN|PSP|AOA|GNI|MAF|GNF|MAD|HTG|CNP|MMK|MYR|LSL|TRL|KMF|CZK|GMP|AZM|KYD|GMD|CAD|VEB|MLF|MXP|ILS|PES|MXN|GYD|ILP|CYP|SKK|PEN|ILL|LRD|PEI|AMD|GLK|HRK|MKN|HRD|CLP|ALV|FRG|FRF|MWP|MKD|TPP|PDR|CLF|ALL|MWK|ALK|PDK|TPE|DES|DEM|YUR|KWD|NPR|GWP|YUO|YUN|YUM|GWM|SIT|JPY|YUG|YUF|BEF|YUD|GWE|RON|ROL|CWG|SIB|BDT|DDM|XBB|XBA|NOK|MUR|ZAR|ZAP|XAU|ZAL|VND|KID|TZS|GIP|ZMP|TND|CVE|UGX|ZMK|JOD|UGS|FOK|KHR|DOP|EUR|LNR|KHO|GUF|MTP|USS|MHD|NZP|CUP|MTL|TMM|USN|SSP|SGD|NZD|USD|HNL|ITL|PAB|GTQ|AUD|LAK|NAD|KGS|BBD|CHF|PYG|JMP|PLZ|YER|ATS|ETD|LYP|ETB|BND|DZG|DZF|YEI|EGP|JMD|PLN|DZD|ISK|SRG|LYD|BAM|ESP|NLG|MRO|BMP|ZWD|SEK|CSK|IRR|PKR|BMD|CSC";

  private static final String currenciesDisplayNameValues = "jemenski dinar|Kenijski \u0161iling|Novotajvanski dolar|Sri Lanka Rupee|Tad\u017eikistanski somoni|Eritrean Nakfa|Sudanska funta|Gr\u010dka drahma|Irska funta|Argentinski pezo|Martinique Franc|Argentinski pezo (1983-1985)|Sudanski dinar|Gruzijski lari|Georgian Kupon Larit|Kostarikanski kolon|Moldovan Ruble Cupon|Falklandska funta|Equatorial Guinea Peseta Guineana|Estonian Kroon|Moldovski lej|Honkon\u0161ki dolar|Ira\u010dki dinar|Sej\u0161elska rupija|Equatorial Guinea Franco|Danska kruna|Indonezijska rupija|Equatorial Guinea Ekwele Guineana|Moldovan Leu Cupon|Somalijski \u0161iling|Latvian Ruble|Latvian Lats|Ruska rublja (1991-1998)|Fid\u017eijska funta|Monaco Franc Germinal|Monaco Franc Nouveau|Macao Pataca|Guadeloupe Franc|Fid\u017eijski dolar|Ruska rublja|Djibouti Franc|Lihten\u0161tajnski franak|Solomonskooto\u010dni dolar|Ecuador Unidad de Valor Constante (UVC)|Trinidadtoba\u0161ki stari dolar|Ecuador Sucre|Filipinski pezo|Luksembur\u0161ki franak|Finska marka (1860-1962)|Finska marka|Trinidadtoba\u0161ki dolar|Lilangeni|Mongolski tugrik|Ukrajinska hrivnja|Ma\u0111arska forinta|Kolumbijski pezo|Lithuanian Talonas|Portugalski eskudo|Portugalski konto|Britanska funta|Zairski zair|Indijska rupija|Lithuanian Lita|Urugvajski pezo (1975-1993)|Mozambique Metical|Kazakhstan Tenge|Kazakhstan Ruble|Angolska kvanza (1977-1990)|Guinea Syli|Sirijska funta|Omanski rijal|Nigerijska funta|Mozambique Escudo|Zairski novi zair|Nigerijska naira|Palestinska funta|Angolska kvanza|Gvinejski franak (1960-1972)|Morokanski franak|Gvinejski franak|Morokanski dirham|Haitian Gourde|Chinese Jen Min Piao Yuan|Myanmar Kyat|Malaysian Ringgit|Lesotho Loti|Turska lira|Comoro Franc|\u010ce\u0161ka kruna|Gambijska funta|Azerbejd\u017eanski manat|Kajmanski dolar|Gambia Dalasi|Kanadski dolar|Venezuelski bolivar|Mali Franc|Meksi\u010dki srebrni pezo (1861-1992)|Novi izraelski \u0161ekel|Peruanski sol|Meksi\u010dki pezo|Guyana Dollar|Israelska funta|Ciparska funta|Slova\u010dka kruna|Peruanski novi sol|Israelski \u0161ekel|Liberijski dolar|Peruanski inti|Armenian Dram|Grenlandska kruna|Kuna|Makedonski denar (1992-1993)|Hrvatski dinar|\u010cileanski pezo|Albanian Lek Valute|French Franc Germinal/Franc Poincare|Francuski franak|Malawi Pound|Makedonski denar|Timor Pataca|Transdniestria Ruble|Chilean Unidades de Fomento|Albanski lek|Malawi Kwacha|Albanski lek (1946-1961)|Transdniestria Ruble Kupon|Timorski eskudo|German Sperrmark|Njema\u010dka marka|Jugoslavenski reformirani dinar|Kuvajtski dinar|Nepalska rupija|Gvinejskobisauski pezo|Jugoslavenski oktobarski dinar|Jugoslavenski konvertibilni dinar|Jugoslavenski novi dinar|Portuguese Guinea Mil Reis|Slovenski tolar|Japanski jen|Jugoslavenski dinar 1994|Jugoslavenski federalni dinar|Belgijski franak|Jugoslavenski \u010dvrsti dinar|Portuguese Guinea Escudo|Rumunjski novi lej|Rumunjski lej|Curacao Guilder|Slovenia Tolar Bons|Taka|East German Ostmark|Europska monetarna jedinica|Europska slo\u017eena jedinica|Norve\u0161ka kruna|Mauricijska rupija|Ju\u017enoafri\u010dki rand|Ju\u017enoafri\u010dka funta|Zlato|Ju\u017enoafri\u010dki rand (financijski)|Viejetnamski dong|Kiribati Dollar|Tanzanijski \u0161iling|Gibraltarska funta|Zambijska funta|Tuniski dinar|Zelenortski eskudo|Ugandski \u0161iling|Zambijska kva\u010da|Jordanski dinar|Ugandski \u0161iling (1966-1987)|Faeroe Islands Kronur|Cambodian Riel|Dominikanski pezo|Euro|Ceylon Rupee|Cambodian Old Riel|French Guyana Franc Guiana|Malte\u0161ka funta|Ameri\u010dki dolar (isti dan)|Marshall Islands Dollar|Novozelandska funta|Kubanski pezo|Malte\u0161ka lira|Turkmenistanski manat|Ameri\u010dki dolar (sljede\u0107i dan)|\u0160kotska funta|Singapurski dolar|Novozelandski dolar|Ameri\u010dki dolar|Hodura\u0161ka lempira|Talijanska lira|Panamska balboa|Kvecal|Australski dolar|Laotian Kip|Namibijski dolar|Kyrgystan Som|Barbadoski dolar|\u0160vicarski franak|Paragvajski gvarani|Jamai\u010danska funta|Poljska zlota (1950-1995)|Jemenski rial|Austrijski \u0161iling|Etiopski dolar|Libijska funta|Etiopski bir|Brunejski dolar|Algerian Franc Germinal|Algerian New Franc|Yemeni Imadi Riyal|Egipatska funta|Jamai\u010danski dolar|Poljska zlota|Al\u017eirski dinar|Islandska kruna|Surinamski gulden|Libijski dinar|Konvertibilna marka|\u0160panjolska pezeta|Nizozemski gulden|Mauritanska ouguja|Bermudska funta|Zimbabveanski dolar|\u0160vedska kruna|Czechoslovak Hard Koruna|Iranski rijal|Pakistanska rupija|Bermudski dolar|\u010ce\u0161ka kruna";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "YDD|KES|TWD|LKR|TJS|ERN|SDP|GRD|IEP|ARS|MQF|ARP|SDD|GEL|GEK|CRC|MDR|FKP|GQP|EEK|MDL|HKD|IQD|SCR|GQF|DKK|IDR|GQE|MDC|SOS|LVR|LVL|RUR|FJP|MCG|MCF|MOP|GPF|FJD|RUB|DJF|LIF|SBD|ECV|TTO|ECS|PHP|LUF|FIN|FIM|TTD|SZL|MNT|UAH|HUF|COP|LTT|PTE|PTC|ZRZ|INR|LTL|UYP|MZM|KZT|KZR|AOK|GNS|SYP|OMR|NGP|MZE|ZRN|NGN|PSP|AOA|GNI|MAF|GNF|MAD|HTG|CNP|MMK|MYR|LSL|TRL|KMF|CZK|GMP|AZM|KYD|GMD|CAD|VEB|MLF|MXP|ILS|PES|MXN|GYD|ILP|CYP|SKK|PEN|ILL|LRD|PEI|AMD|GLK|HRK|MKN|HRD|CLP|ALV|FRG|FRF|MWP|MKD|TPP|PDR|CLF|ALL|MWK|ALK|PDK|TPE|DES|DEM|YUR|KWD|NPR|GWP|YUO|YUN|YUM|GWM|SIT|YUG|YUF|YUD|GWE|BEF|RON|ROL|CWG|SIB|BDT|DDM|XBB|XBA|NOK|MUR|ZAR|ZAP|XAU|ZAL|VND|KID|TZS|GIP|ZMP|TND|CVE|UGX|ZMK|JOD|UGS|FOK|KHR|DOP|LNR|KHO|GUF|MTP|USS|MHD|NZP|CUP|MTL|TMM|USN|SSP|SGD|NZD|USD|HNL|PAB|GTQ|AUD|LAK|NAD|KGS|BBD|CHF|PYG|JMP|PLZ|YER|ATS|ETD|LYP|ETB|BND|DZG|DZF|YEI|EGP|JMD|PLN|DZD|ISK|SRG|LYD|BAM|ESP|NLG|MRO|BMP|ZWD|SEK|CSK|IRR|PKR|BMD|CSC";

  private static final String currenciesSymbolValues = "YDD|K Sh|NT$|SL Re|TJS|ERN|SDP|GRD|IR\u00a3|Arg$|MQF|ARP|SDD|lari|GEK|C|MDR|FKP|GQP|EEK|MDL|HK$|ID|SR|GQF|DKr|Rp|GQE|MDC|So. Sh.|LVR|LVL|RUR|FJP|MCG|MCF|MOP|GPF|F$|RUB|DF|LIF|SI$|ECV|TTO|ECS|PHP|LUF|FIN|FIM|TT$|E|Tug|UAH|Ft|Col$|LTT|PTE|PTC|ZRZ|INR|LTL|UYP|Mt|T|KZR|AOK|GNS|LS|RO|NGP|MZE|ZRN|NGN|PSP|AOA|GNI|MAF|GF|MAD|HTG|CNP|MMK|RM|M|TL|CF|CZK|GMP|AZM|KYD|GMD|Can$|Be|MLF|MXP|ILS|PES|MEX$|G$|ILP|\u00a3C|Sk|PEN|ILL|LRD|PEI|dram|GLK|HRK|MKN|HRD|Ch$|ALV|FRG|FRF|MWP|MDen|TPP|PDR|CLF|lek|MK|ALK|PDK|TPE|DES|DEM|YUR|KD|Nrs|GWP|YUO|YUN|YUM|GWM|SIT|YUG|YUF|YUD|GWE|BF|RON|leu|CWG|SIB|Tk|DDM|XBB|XBA|NKr|MUR|R|ZAP|XAU|ZAL|VND|KID|T Sh|GIP|ZMP|TND|CVEsc|U Sh|ZMK|JD|UGS|FOK|CR|RD$|LNR|KHO|GUF|MTP|USS|MHD|NZP|CUP|Lm|TMM|USN|SSP|S$|$NZ|US$|L|PAB|Q|$A|LAK|N$|som|BDS$|SwF|PYG|JMP|PLZ|YRl|ATS|ETD|LYP|Br|BND|DZG|DZF|YEI|EGP|J$|Zl|DA|ISK|Sf|LD|KM|ESP|NLG|UM|BMP|Z$|SKr|CSK|RI|Pra|Ber$|CSC";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "sij",
    "vel",
    "o\u017eu",
    "tra",
    "svi",
    "lip",
    "srp",
    "kol",
    "ruj",
    "lis",
    "stu",
    "pro",
    null,
  };

  private static final String[] months = {
    "sije\u010danj",
    "velja\u010da",
    "o\u017eujak",
    "travanj",
    "svibanj",
    "lipanj",
    "srpanj",
    "kolovoz",
    "rujan",
    "listopad",
    "studeni",
    "prosinac",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "ned",
    "pon",
    "uto",
    "sri",
    "\u010det",
    "pet",
    "sub",
  };

  private static final String[] weekdays = {
    null,
    "nedjelja",
    "ponedjeljak",
    "utorak",
    "srijeda",
    "\u010detvrtak",
    "petak",
    "subota",
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Isto\u010dni Timor|Tokelau|Tad\u017eikistan|Tajland|Togo|Francuske Ju\u017ene Teritorije|Gvajana|\u010cad|Turkski i Kaikos Otoci|Gvineja Bisau|Guam|Gvatemala|Ju\u017ena Gruzija i Ju\u017eni Sendvi\u010d Otoci|Gr\u010dka|Ekvatorska Gvineja|Guadeloupe|Svazi|Sirija|Gvineja|Gambija|Greenland|El Salvador|Sveti Toma i Prinsipe|Gibraltar|Gana|Surinam|Francuska Gvajana|Serbia|Gruzija|Somalija|Grenada|Senegal|San Marino|Ujedinjena Kraljevina|Sijera Leone|Gabon|Slova\u010dka|Svalbard i Jan Mayen|Slovenija|Sveta Helena|Singapur|\u0160vedska|Sudan|Sej\u0161eli|Salamunovi Otoci|Saudijska Arabija|Francuska|Farski Otoci|Mikronezija, Federalne Dr\u017eave|Ruanda|Falklandski Otoci|Ruska Federacija|Fid\u017ei|Finska|Rumunjska|Reunion|Etiopija|\u0160panjolska|Eritreja|Zapadna Sahara|Egipat|Estonija|Ekvador|Al\u017eir|Katar|Dominikanska Republika|Paragvaj|Dominika|Palau|Danska|D\u017eibuti|Portugal|Palestinska Teritoija|Portoriko|Njema\u010dka|Pitcairn|Sveti Petar i Miguel|Poljska|Pakistan|Filipini|Papua Nova Gvineja|Francuska Polinezija|\u010ce\u0161ka Republika|Peru|Cipar|Bo\u017ei\u0107ni Otoci|Zeleni Rt|Panama|Kuba|Kostarika|Kolumbija|Kina|Kamerun|\u010cile|Kukovi Otoci|Obala Bjelokosti|\u0160vicarska|Kongo|Srednjoafri\u010dka Republika|Kongo, Demokratska Republika|Kokos (Keeling) Otoci|Oman|Kanada|Belize|Bjelorusija|Bocvana|Otok Bouvet|Butan|Bahami|Brazil|Novi Zeland|Bolivija|Brunei Darussalam|Bermuda|Niue|Benin|Burundi|Bahrein|Nauru|Bugarska|Burkina Faso|Nepal|Belgija|Norve\u0161ka|Banglade\u0161|Barbados|Zimbabve|Nizozemska|Bosna i Hercegovina|Nikaragva|Nigerija|Norfol\u0161ki Otoci|Azerbajd\u017ean|Niger|Nova Kaledonija|Aruba|Zambija|Namibija|Australija|Austrija|Ameri\u010dka Samoa|Argentina|Antarktik|Mozambik|Angola|Malezija|Nizozemski Antili|Meksiko|Armenija|Malavi|Albanija|Maldivi|Ju\u017ena Afrika|Mauricijus|Malta|Anguila|Montserat|Mauritanija|Antigua i Barbuda|Martinik|Afganistan|Sjeverni Marianski Otoci|Ujedinjeni Arapski Emirati|Makao S.A.R. Kine|Andora|Mongolija|Mijanma|Mali|Makedonija, Republika|Jugoslavija|Majote|Mar\u0161alovi Otoci|Madagaskar|Moldavija, Republika|Monako|Maroko|Jemen|Libijska Arapska D\u017eamahirija|Latvija|Luksemburg|Litva|Lesoto|Liberija|\u0160ri Lanka|Lihten\u0161tajn|Sveta Lucija|Libanon|Laoska Narodna Demokratska Republika|Kazakstan|Kajmanski Otoci|Kuvajt|Koreja, Ju\u017ena|Koreja, Sjeverna|Sveti Kristofor i Nevis|Komori|Kiribati|Samoa|Kambod\u017ea|Kirgistan|Kenija|Wallis i Futuna|Japan|Jordan|Jamajka|Vanuatu|Vijetnam|U.S. Djevi\u010danski Otoci|Britanski Djevi\u010danski Otoci|Venezuela|Sveti Vincent i Grenadini|Sveta Stolica (Dr\u017eava Vatikanskog Grada)|Italija|Island|Iran, Islamska Republika|Irak|Uzbekistan|Britanski Teritorij Indijskog Oceana|Urugvaj|Indija|Izrael|Sjedinjene Dr\u017eave|Irska|Indonezija|Sjedinjene Dr\u017eave Manji Vanjski Otoci|Uganda|Ukrajina|Ma\u0111arska|Haiti|Hrvatska|Tanzanija|Honduras|Heard Otok i McDonald Otoci|Tajvan|Tuvalu|Hong Kong S.A.R. Kine|Trinidad i Tobago|Turska|Tonga|Tunis|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "ne|haw|zh|dum|av|ar|apa|mt|sv|pt|enm|sr|mn|sq|mk|de|pl|sl|sk|da|art|ga|vi|ja|gmh|sla|cy|egy|fy|cel|cu|cs|lv|it|fr|is|lt|roa|ru|fi|ira|ro|uk|fa|la|mga|goh|bat|hy|ang|fro|et|hu|grc|es|frm|hr|eo|ine|en|inc|el|ko|no|km|bg|tr|be|nl|gem|he";

  private static final String languagesValues = "nepalski|havajski|kineski|nizozemski, srednji (ca. 1050-1350)|avarski|arapski|apa\u0161ki|malte\u0161ki|\u0161vedski|portugalski|engleski, srednji (1100-1500)|srpski|mongolski|albanski|makedonski|njema\u010dki|poljski|slovenski|slova\u010dki|danski|umjetni (ostali)|irski|vijetnamski|japanski|njema\u010dki, srednji visoki (ca.1050-1500)|slavenski (drugi)|vel\u0161ki|egipatski (anti\u010dki)|frizijski|keltski (ostali)|crkvenoslavenski|\u010de\u0161ki|latvijski|talijanski|francuski|islandski|litvanski|romanski (ostali)|ruski|finski|iranski|rumunjski|ukrajinski|perzijski|latinski|irski, srednji (900-1200)|njema\u010dki, stari visoki (ca.750-1050)|balti\u010dki (ostali)|armenski|engleski, stari (ca.450-1100)|francuski, stari (842-ca.1400)|estonijski|ma\u0111arski|gr\u010dki, anti\u010dki (do 1453)|\u0161panjolski|francuski, srednji (ca.1400-1600)|hrvatski|esperanto|indoevropski (drugi)|engleski|indijski (drugi)|gr\u010dki|korejski|norve\u0161ki|kmerski|bugarski|turski|bjeloruski|nizozemski|germanski (ostali)|hebrejski";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "." },
    { "localPatternChars", "GanjkHmsSEDFwWxhKzAeugXZ" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "shortDateFormat", "yyyy.MM.dd" },
    { "mediumDateFormat", "yyyy.MM.dd" },
    { "longDateFormat", "yyyy. MMMM dd" },
    { "fullDateFormat", "yyyy. MMMM dd" },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
