/* LocaleInformation_fi.java --
   Copyright (C) 2004  Free Software Foundation, Inc.

This file is part of GNU Classpath.

GNU Classpath is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU Classpath is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Classpath; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
02111-1307 USA.

Linking this library statically or dynamically with other modules is
making a combined work based on this library.  Thus, the terms and
conditions of the GNU General Public License cover the whole
combination.

As a special exception, the copyright holders of this library give you
permission to link this library with independent modules to produce an
executable, regardless of the license terms of these independent
modules, and to copy and distribute the resulting executable under
terms of your choice, provided that you also meet, for each linked
independent module, the terms and conditions of the license of that
module.  An independent module is a module which is not derived from
or based on this library.  If you modify this library, you may extend
this exception to your version of the library, but you are not
obligated to do so.  If you do not wish to do so, delete this
exception statement from your version. */


// This file was automatically generated by gnu.localegen from LDML

package gnu.java.locale;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.ListResourceBundle;

public class LocaleInformation_fi extends ListResourceBundle
{
  private static final String currenciesDisplayNameKeys = "JOD|BOV|XAU|FOK|LBP|EUR|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|ITL|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|GBP|SAS|SAR|LTT|INR|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|JPY|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesDisplayNameValues = "Jordanian dinaari|Bolivian mvdol|Kulta|F\u00e4rsaarten kruunu|Libanonin punta|euro|Vietnamin dong|Tansanian shillinki|Bolivian peso|Kambod\u017ean riel|Aasian rahayksikk\u00f6 (AMU)|Boliviano (1863-1962)|Kambod\u017ean vanha riel|Zambian punta|Australian punta|CFA-frangi BEAC|Maltan punta|Ghanan revalvoitu cedi|Zambian kwacha|Aasian dinaarin UA|Ghanan punta|Boliviano|Ghanan vanha cedi|Maltan liira|Australian dollari|Yhdysvaltain dollari (Sama p\u00e4iv\u00e4)|Italian liira|Yhdysvaltain dollari (Seuraava p\u00e4iv\u00e4)|Ghanan cedi|Singaporen dollari|Panaman balboa|Laosin kip|Kirgistanin som|Sveitsin frangi|It\u00e4vallan shillinki|Yhdysvaltain dollari|Etiopian dollari|Brunein dollari|Jamaikan punta|Etiopian birr|Algerian franc germinal|Algerian uusi frangi|Algerian dinaari|Paraguayn guarani|Libyan punta|Jamaikan dollari|Islannin kruunu|Espanjan peseta|Bermudan punta|Libyan dinaari|Libyan sotilasvallan liira|Bermudan dollari|Alankomaiden guldeni|Mauritanian ouguiya|Iranin rial|Ruotsin kruunu|Eritrean nakfa|Kenian shillinki|Keski-Afrikan tasavallan CFA-frangi|Argentiinan peso|Argentiinan peso (1983-1985)|Argentiinan peso moneda nacional|Taiwanin uusi dollari|Sudanin punta|Georgian lari|Georgian kuponkilari|Martiniquen frangi|Falklandinsaarten punta|Argentiinan austral|Sudanin dinaari|Irakin dinaari|Tuvalun dollari|Seychellien rupia|Latvian rupla|Fid\u017ein punta|Latvian lati|Kongon zaire|Kongon tasavallan frangi|Kongon kongolainen frangi|Fid\u017ein dollari|Nicaraguan cordoba oro|Macaon pataca|Nicaraguan kultacordoba|Nicaraguan cordoba|COMECONin siirrett\u00e4v\u00e4 rupla|Suomen markka (1860-1962)|Suomen markka|Salomonsaarten dollari|Luxemburgin frangi|Trinidadin ja Tobagon vanha dollari|Angolan escudo|Angolan kwanza reajustado (1995-1999)|Mongolian tugrik|Unkarin forintti|Burundin frangi|Angolan uusi kwanza (1990-2000)|Angolan kwanza (1977-1990)|Trinidadin ja Tobagon dollari|Swazimaan lilangeni|Uusien-Hebridien CFP-frangi|Iso-Britannian sterling-punta|Saudi-Arabian itsen\u00e4inen rial|Saudi-Arabian rial|Liettuan talonas|Intian rupia|Portugalin escudo|Angolan kwanza|Portugalin conto|Liettuan liti|Kazakhstanin tenge|Kazakhstanin rupla|Brittil\u00e4isten Neitsytsaarten dollari|Nigerian punta|Myanmarin dollarin FEC|Nigerian naira|Haitin gourde|Syyrian punta|Palestiinan punta|Bahrainin dinaari|Myanmarin kyat|Alankomaiden Antillien guldeni|T\u0161ekin koruna|Mansaaren sterling-punta|Bulgarian lev FEC|Lesothon loti|Gabonin CFA-frangi|Bulgarian lev (1879-1952)|Bulgarian uusi lev|Bulgarian sosialistinen lev|Kanadan dollari|Bulgarian kova leva|Turkin liira|Caymansaarten dollari|Kyproksen punta|Israelin uusi sekeli|Guyanan dollari|Armenian dram|Israelin punta|Malin frangi|Israelin sekeli|Venezuelan bolivar|Albanian dollarin FEC|Liberian dollari|Albanian lek valute|Kroatian kuna|Reunionin frangi|Kroatian dinaari|Albanian lek|Jerseyn sterling-punta|Albanian lek (1946-1961)|Makedonian dinaari (1992-1993)|Pohjois-Vietnamin viet minh piastre dong viet|Pohjois-Vietnamin uusi dong|Makedonian dinaari|Pohjois-Vietnamin piastre dong viet|Timorin pataca|CFP-frangi|Belgian frangi (rahoitus)|Guinea-Bissaun peso|Kuwaitin dinaari|Portugalin Guinean mil reis|Belgian frangi|Timorin escudo|Belgian frangi (vaihdettava)|Portugalin Guinean escudo|El Salvadorin colon|Curacaon guldeni|Bangladeshin taka|Tongan sterling-punta|Tongan pa\u02bbanga|CFA-frangi BCEAO|Neuvostoliiton rupla|Neuvostoliiton uusi rupla|Uuden-Kaledonian franc germinal|Kap Verden escudo|Ranskan Antillien CFA-frangi|Etel\u00e4-Afrikan randi|Dominikaanisen tasavallan peso|Kuuban FEC|Etel\u00e4-Afrikan punta|Etel\u00e4-Afrikan randi (rahoitus)|Tunisian dinaari|Kuuban peso|Ranskan Guyanan franc guiana|Ugandan shillinki|Ceylonin rupia|Affarsin ja Issasin frangi|Vatikaanin kaupungin liira|S\u00e3o Tom\u00e9n ja Princip\u00e9n escudo|Ugandan shillinki (1966-1987)|S\u00e3o Tom\u00e9n ja Princip\u00e9n dobra|Marshallinsaarten dollari|Uuden-Seelannin punta|L\u00e4nsi-Samoan tala|L\u00e4nsi-Samoan punta|Hondurasin lempira|Ranskan em\u00e4maan uusi frangi|Turkmenistanin manat|Guatemalan quetzal|Uuden-Seelannin dollari|Skotlannin punta|Barbadosin dollari|Namibian dollari|Madagaskarin frangi|Madagaskarin ariary|Egyptin punta|Brittil\u00e4isen Hondurasin dollari|Puolan zloty (1950-1995)|Bosnia-Hertsegovinan uusi dinaari|Puolan US-dollarin FEC|Bosnia-Hertsegovinan vaihdettava markka|Belizen dollari|Bosnia-Hertsegovinan dinaari|Puolan zloty|Jemenin rial|Surinamin guldeni|T\u0161ekkoslovakian kova koruna|Etel\u00e4-Korean won|Valko-Ven\u00e4j\u00e4n rupla|Jemenin imadi rial|Valko-Ven\u00e4j\u00e4n rupla (1992-1994)|T\u0161ekkoslovakian koruna|Etel\u00e4-Korean vanha won|Etel\u00e4-Korean hwan|Valko-Ven\u00e4j\u00e4n uusi rupla (1994-1999)|Somalimaan shillinki|Kreikan uusi drakhma|Pakistanin rupia|Afgaani|Zimbabwen dollari|Sri Lankan rupia|Kreikan drakhma|Irlannin punta|Afgaani (1927-2002)|Jemenin dinaari|Ruandan frangi|Costa Rican colon|Tad\u017eikistanin somoni|Tad\u017eikistanin rupla|Viron kruunu|P\u00e4iv\u00e4ntasaajan Guinean peseta guineana|Moldovan kuponkirupla|Hong Kongin dollari|Tanskan kruunu|Moldovan leu|P\u00e4iv\u00e4ntasaajan Guinean frangi|P\u00e4iv\u00e4ntasaajan Guinean ekwele guineana|Indonesian rupia|Arabiemiirikuntien dirhami|Pohjois-Korean won|Indonesian uusi rupia|Botswanan pula|Moldovan kuponkileu|Indonesian java rupia|Pohjois-Korean kansan won|Indonesian nica guldeni|Vanuatun vatu|Islamin dinaari|Somalin shillinki|Andorran peseta|Ven\u00e4j\u00e4n rupla (1991-1998)|Guadeloupen frangi|Djiboutin frangi|Andorran dinaari|Monacon franc germinal|Monacon uusi frangi|Ecuadorin UVC|Ecuadorin sucre|Liechtensteinin frangi|Ven\u00e4j\u00e4n rupla|Filippiinien peso|Uzbekistanin som|Kolumbian peso|Thaimaan baht|Pohjois-Irlannin punta|Burman rupia|Kongon CFA-frangi|Burman kyat|Kolumbian paperipeso|Uzbekistanin kuponkisom|Ukrainan karbovanetz|Qatarin rial|Ukrainan hryvnia|Guinean syli|Kiinan yuan renminbi|Mosambikin metical|Kiinan US-dollarin FEC|Uruguayn peso uruguayo|Guinean frangi (1960-1972)|San Marinon liira|Kiinan jen min piao yuan|Mosambikin escudo|Guinean frangi|Omanin rial saidi|Papua-Uuden-Guinean kina|Omanin rial|Uruguayn peso (1975-1993)|Ranskan UIC-frangi|Bhutanin rupia|Zairen zaire|Marokon frangi|Marokon dirhami|Bhutanin ngultrum|Ranskan kulta frangi|Uruguayn peso fuerte|Malesian ringgit|Zairen uusi zaire|Azerbaid\u017eanin manat|Gambian punta|Komorien frangi|Sierra Leonen leone|Gambian dalasi|Euroopan valuuttayksikk\u00f6|Bahaman punta|Kamerunin CFA-frangi|Meksikon UDI|CFA-frangi BCEAEC|Bahaman dollari|Meksikon hopeapeso (1861-1992)|Meksikon peso|Perun sol|Gr\u00f6nlannin kruunu|Brazilian cruzeiro (1942-1967)|Perun uusi sol|Chilen peso|Slovakin koruna|Perun inti|Brasilian cruzeiro|Erityiset nosto-oikeudet|Ranskan franc germinal/franc poincare|Ranskan frangi|Brasilian uusi cruzado|Chilen unidades de fomento|Chilen escudo|Brasilian real|Chilen condor|Brasilian cruzeiro (1990-1993)|Saksan sperrmark|Malawin punta|Brasilian cruzado|Brasilian uusi cruzeiro (1967-1986)|Malawin kwacha|Transdniestrian rupla|Saksan markka|T\u0161adin CFA-frangi|Transdniestrian uusi rupla|Transdniestrian kuponkirupla|Nepalin rupia|Cookinsaarten dollari|Japanin jeni|Malediivien rufiyaa|CFA uusi frangi|Malediivien rupia|It\u00e4-Karibian dollari|Slovenian tolar|Jugoslavian uudistettu dinaari|Aruban guldeni|Jugoslavian lokakuun dinaari|It\u00e4-Saksan ostmark|Jugoslavian vaihdettava dinaari|Jugoslavian uusi dinaari|Turks- ja Caicossaarten crown|Jugoslavian 1994 dinaari|Jugoslavian liittovaltion dinaari|Romanian uusi lei|Jugoslavian kova dinaari|Romanian lei|Slovenian tolar bons|Norjan kruunu|Mauritiuksen rupia|EUA (XBD)|Gibraltarin punta|Vietnamin kansallinen dong|EUA (XBC)|Vietnamin tasavallan dong|Euroopan rahayksikk\u00f6 (EMU)|EURCO|Kiribatin dollari|Saint Helenan punta|Vietnamin uusi dong";

  private static final Hashtable currenciesDisplayName;
  static
  {
    currenciesDisplayName = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesDisplayNameKeys, "|");
    Enumeration values = new StringTokenizer(currenciesDisplayNameValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesDisplayName.put(key, value);
      }
  }

  private static final String currenciesSymbolKeys = "JOD|BOV|XAU|FOK|LBP|VND|TZS|BOP|KHR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|BOB|GHO|MTL|AUD|USS|USN|GHC|SGD|PAB|LAK|KGS|CHF|ATS|USD|ETD|BND|JMP|ETB|DZG|DZF|DZD|PYG|LYP|JMD|ISK|ESP|BMP|LYD|LYB|BMD|NLG|MRO|IRR|SEK|ERN|KES|CFF|ARS|ARP|ARM|TWD|SDP|GEL|GEK|MQF|FKP|ARA|SDD|IQD|TVD|SCR|LVR|FJP|LVL|CDL|CDG|CDF|FJD|NIO|MOP|NIG|NIC|XTR|FIN|FIM|SBD|LUF|TTO|AOS|AOR|MNT|HUF|BIF|AON|AOK|TTD|SZL|NHF|SAS|SAR|LTT|PTE|AOA|PTC|LTL|KZT|KZR|VGD|NGP|MMX|NGN|HTG|SYP|PSP|BHD|MMK|ANG|CZK|IMP|BGX|LSL|GAF|BGO|BGN|BGM|CAD|BGL|TRL|KYD|CYP|ILS|GYD|AMD|ILP|MLF|ILL|VEB|ALX|LRD|ALV|HRK|REF|HRD|ALL|JEP|ALK|MKN|VDP|VDN|MKD|VDD|TPP|XPF|BEL|GWP|KWD|GWM|BEF|TPE|BEC|GWE|SVC|CWG|BDT|TOS|TOP|XOF|SUR|SUN|NCF|CVE|XNF|ZAR|DOP|CUX|ZAP|ZAL|TND|CUP|GUF|UGX|LNR|AIF|VAL|STE|UGS|STD|MHD|NZP|WST|WSP|HNL|XMF|TMM|GTQ|NZD|SSP|BBD|NAD|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|BAM|BZD|BAD|PLN|YER|SRG|CSK|KRW|BYR|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|PKR|AFN|ZWD|LKR|GRD|IEP|AFA|YDD|RWF|CRC|TJS|TJR|EEK|GQP|MDR|HKD|DKK|MDL|GQF|GQE|IDR|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VUV|XID|SOS|ADP|RUR|GPF|DJF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|COP|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QAR|UAH|GNS|CNY|MZM|CNX|UYU|GNI|SML|CNP|MZE|GNF|OMS|PGK|OMR|UYP|XFU|BTR|ZRZ|MAF|MAD|BTN|XFO|UYF|MYR|ZRN|AZM|GMP|KMF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MXN|PES|GLK|BRZ|PEN|CLP|SKK|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|BRL|CLC|BRE|DES|MWP|BRC|BRB|MWK|PDR|DEM|TDF|PDN|PDK|NPR|CKD|MVR|XCF|MVP|XCD|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|ROL|SIB|NOK|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final String currenciesSymbolValues = "JD|BOV|XAU|FOK|LL|VND|T Sh|BOP|CR|XAM|BOL|KHO|ZMP|AUP|XAF|MTP|GHR|ZMK|XAD|GHP|Bs|GHO|Lm|$A|USS|USN|GHC|S$|PAB|LAK|som|SwF|ATS|US$|ETD|BND|JMP|Br|DZG|DZF|DA|PYG|LYP|J$|ISK|ESP|BMP|LD|LYB|Ber$|NLG|UM|RI|SKr|ERN|K Sh|CFF|Arg$|ARP|ARM|NT$|SDP|lari|GEK|MQF|FKP|ARA|SDD|ID|TVD|SR|LVR|FJP|LVL|CDL|CDG|CDF|F$|NIO|MOP|NIG|NIC|XTR|FIN|mk|SI$|LUF|TTO|AOS|AOR|Tug|Ft|Fbu|AON|AOK|TT$|E|NHF|SAS|SRl|LTT|PTE|AOA|PTC|LTL|T|KZR|VGD|NGP|MMX|NGN|HTG|LS|PSP|BD|MMK|NA f.|CZK|IMP|BGX|M|GAF|BGO|BGN|BGM|Can$|lev|TL|KYD|\u00a3C|ILS|G$|dram|ILP|MLF|ILL|Be|ALX|LRD|ALV|HRK|REF|HRD|lek|JEP|ALK|MKN|VDP|VDN|MDen|VDD|TPP|CFPF|BEL|GWP|KD|GWM|BF|TPE|BEC|GWE|SVC|CWG|Tk|TOS|T$|XOF|SUR|SUN|NCF|CVEsc|XNF|R|RD$|CUX|ZAP|ZAL|TND|CUP|GUF|U Sh|LNR|AIF|VAL|STE|UGS|Db|MHD|NZP|WST|WSP|L|XMF|TMM|Q|$NZ|SSP|BDS$|N$|MGF|MGA|EGP|BZH|PLZ|BAN|PLX|KM|BZ$|BAD|Zl|YRl|Sf|CSK|KRW|Rbl|YEI|BYL|CSC|KRO|KRH|BYB|SQS|GRN|Pra|Af|Z$|SL Re|GRD|IR\u00a3|AFA|YDD|RWF|C|TJS|TJR|EEK|GQP|MDR|HK$|DKr|MDL|GQF|GQE|Rp|AED|KPW|IDN|BWP|MDC|IDJ|KPP|IDG|VT|XID|So. Sh.|ADP|RUR|GPF|DF|ADD|MCG|MCF|ECV|ECS|LIF|RUB|PHP|UZS|Col$|THB|IBP|BUR|COF|BUK|COB|UZC|UAK|QR|UAH|GNS|Y|Mt|CNX|Ur$|GNI|SML|CNP|MZE|GF|OMS|PGK|RO|UYP|XFU|BTR|ZRZ|MAF|MAD|Nu|XFO|UYF|RM|ZRN|AZM|GMP|CF|SLL|GMD|XEU|BSP|CMF|MXV|XEF|BSD|MXP|MEX$|PES|GLK|BRZ|PEN|Ch$|Sk|PEI|BRR|XDR|FRG|FRF|BRN|CLF|CLE|R$|CLC|BRE|DES|MWP|BRC|BRB|MK|PDR|DEM|TDF|PDN|PDK|Nrs|CKD|MVR|XCF|MVP|EC$|SIT|YUR|AWG|YUO|DDM|YUN|YUM|TCC|YUG|YUF|RON|YUD|leu|SIB|NKr|MUR|XBD|GIP|VNS|XBC|VNR|XBB|XBA|KID|SHP|VNN";

  private static final Hashtable currenciesSymbol;
  static
  {
    currenciesSymbol = new Hashtable();
    Enumeration keys = new StringTokenizer(currenciesSymbolKeys, "|");
    Enumeration values = new StringTokenizer(currenciesSymbolValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         currenciesSymbol.put(key, value);
      }
  }

  private static final String[] shortMonths = {
    "tammi",
    "helmi",
    "maalis",
    "huhti",
    "touko",
    "kes\u00e4",
    "hein\u00e4",
    "elo",
    "syys",
    "loka",
    "marras",
    "joulu",
    null,
  };

  private static final String[] months = {
    "tammikuu",
    "helmikuu",
    "maaliskuu",
    "huhtikuu",
    "toukokuu",
    "kes\u00e4kuu",
    "hein\u00e4kuu",
    "elokuu",
    "syyskuu",
    "lokakuu",
    "marraskuu",
    "joulukuu",
    null,
  };

  private static final String[] shortWeekdays = {
    null,
    "su",
    "ma",
    "ti",
    "ke",
    "to",
    "pe",
    "la",
  };

  private static final String[] weekdays = {
    null,
    "sunnuntai",
    "maanantai",
    "tiistai",
    "keskiviikko",
    "torstai",
    "perjantai",
    "lauantai",
  };

  private static final String[] eras = {
    "eaa.",
    "jaa.",
  };

  private static final String[] ampms = {
    "ap.",
    "ip.",
  };

  private static final String[][] zoneStrings =
  {
    { "PST", "Tyynenmeren normaaliaika", "PDT", "Tyynenmeren kes\u00e4aika",  "America/Los_Angeles" },
    { "GMT", "Greenwichin aika", "GMT", "Greenwichin aika",  "Africa/Casablanca" },
    { "EST", "It\u00e4inen normaaliaika", "EDT", "It\u00e4inen kes\u00e4aika",  "America/New_York" },
    { "AST", "Alaskan normaaliaika", "ADT", "Alaskan kes\u00e4aika",  "America/Anchorage" },
    { "GMT", "Greenwichin aika", "GMT", "Greenwichin aika",  "Etc/GMT" },
    { "CTT", "Kiinan normaaliaika", "CDT", "Kiinan normaaliaika",  "Asia/Shanghai" },
    { "AST", "Atlantin normaaliaika", "ADT", "Atlantin kes\u00e4aika",  "America/Halifax" },
    { "CET", "Keski-Euroopan normaaliaika", "CEST", "Keski-Euroopan kes\u00e4aika",  "Europe/Paris" },
    { "MST", "Kalliovuorten normaaliaika", "MDT", "Kalliovuorten kes\u00e4aika",  "America/Denver" },
    { "IST", "Israelin normaaliaika", "IDT", "Israelin kes\u00e4aika",  "Asia/Jerusalem" },
    { "HST", "Havaijin normaaliaika", "HST", "Havaijin normaaliaika",  "Pacific/Honolulu" },
    { "CNT", "Newfoundlandin normaaliaika", "CDT", "Newfoundlandin kes\u00e4aika",  "America/St_Johns" },
    { "EST", "It\u00e4inen normaaliaika", "EST", "It\u00e4inen normaaliaika",  "America/Indianapolis" },
    { "CST", "Keskinen normaaliaika", "CDT", "Keskinen kes\u00e4aika",  "America/Chicago" },
    { "EET", "It\u00e4-Euroopan normaaliaika", "EEST", "It\u00e4-Euroopan kes\u00e4aika",  "Europe/Bucharest" },
    { "JST", "Japanin normaaliaika", "JST", "Japanin normaaliaika",  "Asia/Tokyo" },
    { "MST", "Kalliovuorten normaaliaika", "MST", "Kalliovuorten normaaliaika",  "America/Phoenix" },
  };

  private static final String territoriesKeys = "TL|TK|TJ|TH|TG|TF|GY|TD|TC|GW|GU|GT|GS|GR|GQ|GP|SZ|SY|GN|GM|GL|SV|ST|GI|GH|SR|GF|SP|GE|SO|GD|SN|SM|GB|SL|GA|SK|SJ|SI|SH|SG|SE|SD|SC|SB|SA|FR|FO|FM|RW|FK|RU|FJ|FI|RO|RE|ET|ES|ER|EH|EG|EE|EC|DZ|QA|DO|PY|DM|PW|DK|DJ|PT|PS|PR|DE|PN|PM|PL|PK|PH|PG|PF|CZ|PE|CY|CX|CV|PA|CU|CR|CO|CN|CM|CL|CK|CI|CH|CG|CF|CD|CC|OM|CA|BZ|BY|BW|BV|BT|BS|BR|NZ|BO|BN|BM|NU|BJ|BI|BH|NR|BG|BF|NP|BE|NO|BD|BB|ZW|NL|BA|NI|NG|NF|AZ|NE|NC|AW|ZM|NA|AU|AT|AS|AR|AQ|MZ|AO|MY|AN|MX|AM|MW|AL|MV|ZA|MU|MT|AI|MS|MR|AG|MQ|AF|MP|AE|MO|AD|MN|MM|ML|MK|YU|YT|MH|MG|MD|MC|MA|YE|LY|LV|LU|LT|LS|LR|LK|LI|LC|LB|LA|KZ|KY|KW|KR|KP|KN|KM|KI|WS|KH|KG|KE|WF|JP|JO|JM|VU|VN|VI|VG|VE|VC|VA|IT|IS|IR|IQ|UZ|IO|UY|IN|IL|US|IE|ID|UM|UG|UA|HU|HT|HR|TZ|HN|HM|TW|TV|HK|TT|TR|TO|TN|TM";

  private static final String territoriesValues = "Timor-Leste|Tokelau|Tad\u017eikistan|Thaimaa|Togo|Ranskan etel\u00e4iset alueet|Guyana|T\u0161ad|Turks- ja Caicossaaret|Guinea-Bissau|Guam|Guatemala|Etel\u00e4-Georgia ja Etel\u00e4iset Sandwichsaaret|Kreikka|P\u00e4iv\u00e4ntasaajan Guinea|Guadeloupe|Swazimaa|Syyria|Guinea|Gambia|Gr\u00f6nlanti|El Salvador|S\u00e3o Tom\u00e9 ja Pr\u00edncipe|Gibraltar|Ghana|Suriname|Ranskan Guayana|Serbia|Georgia|Somalia|Grenada|Senegal|San Marino|Iso-Britannia|Sierra Leone|Gabon|Slovakia|Huippuvuoret ja Jan Mayen|Slovenia|Saint Helena|Singapore|Ruotsi|Sudan|Seychellit|Salomonsaaret|Saudi-Arabia|Ranska|F\u00e4rsaaret|Mikronesia|Ruanda|Falklandinsaaret|Ven\u00e4j\u00e4|Fid\u017ei|Suomi|Romania|R\u00e9union|Etiopia|Espanja|Eritrea|L\u00e4nsi-Sahara|Egypti|Viro|Ecuador|Algeria|Qatar|Dominikaaninen tasavalta|Paraguay|Dominica|Palau|Tanska|Djibouti|Portugali|Palestiina|Puerto Rico|Saksa|Pitcairn|Saint-Pierre ja Miquelon|Puola|Pakistan|Filippiinit|Papua-Uusi-Guinea|Ranskan Polynesia|T\u0161ekki|Peru|Kypros|Joulusaari|Kap Verde|Panama|Kuuba|Costa Rica|Kolumbia|Kiina|Kamerun|Chile|Cookinsaaret|Norsunluurannikko|Sveitsi|Kongo|Keski-Afrikan tasavalta|Kongon demokraattinen tasavalta|Kookossaaret|Oman|Kanada|Belize|Valko-Ven\u00e4j\u00e4|Botswana|Bouvet\u2019nsaari|Bhutan|Bahama|Brasilia|Uusi-Seelanti|Bolivia|Brunei|Bermuda|Niue|Benin|Burundi|Bahrain|Nauru|Bulgaria|Burkina Faso|Nepal|Belgia|Norja|Bangladesh|Barbados|Zimbabwe|Alankomaat|Bosnia ja Hertsegovina|Nicaragua|Nigeria|Norfolkinsaari|Azerbaid\u017ean|Niger|Uusi-Kaledonia|Aruba|Sambia|Namibia|Australia|It\u00e4valta|Amerikan Samoa|Argentiina|Antarktis|Mosambik|Angola|Malesia|Alankomaiden Antillit|Meksiko|Armenia|Malawi|Albania|Malediivit|Etel\u00e4-Afrikka|Mauritius|Malta|Anguilla|Montserrat|Mauritania|Antigua ja Barbuda|Martinique|Afganistan|Pohjois-Mariaanit|Arabiemiirikunnat|Macaon erityishallintoalue|Andorra|Mongolia|Myanmar|Mali|Makedonia|Jugoslavia|Mayotte|Marshallinsaaret|Madagaskar|Moldova|Monaco|Marokko|Jemen|Libya|Latvia|Luxemburg|Liettua|Lesotho|Liberia|Sri Lanka|Liechtenstein|Saint Lucia|Libanon|Laos|Kazakstan|Caymansaaret|Kuwait|Korean tasavalta|Pohjois-Korea|Saint Kitts ja Nevis|Komorit|Kiribati|Samoa|Kambod\u017ea|Kirgisia|Kenia|Wallis ja Futuna|Japani|Jordania|Jamaika|Vanuatu|Vietnam|Yhdysvaltain Neitsytsaaret|Brittil\u00e4iset Neitsytsaaret|Venezuela|Saint Vincent ja Grenadiinit|Vatikaani|Italia|Islanti|Iran|Irak|Uzbekistan|Brittil\u00e4inen Intian valtameren alue|Uruguay|Intia|Israel|Yhdysvallat|Irlanti|Indonesia|Yhdysvaltain pienet erillissaaret|Uganda|Ukraina|Unkari|Haiti|Kroatia|Tansania|Honduras|Heard ja McDonaldinsaaret|Taiwan|Tuvalu|Hongkongin erityishallintoalue|Trinidad ja Tobago|Turkki|Tonga|Tunisia|Turkmenistan";

  private static final Hashtable territories;
  static
  {
    territories = new Hashtable();
    Enumeration keys = new StringTokenizer(territoriesKeys, "|");
    Enumeration values = new StringTokenizer(territoriesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         territories.put(key, value);
      }
  }

  private static final String languagesKeys = "gwi|akk|eka|xh|sux|sus|mis|loz|tog|pon|min|suk|wo|lol|kut|mic|wa|kum|zap|cus|jbo|doi|vo|oto|vi|rar|ve|rap|raj|ota|nzi|nap|uz|uga|tmh|nai|nah|ur|fat|uk|egy|ug|fan|ssa|mga|bat|nyo|bas|nyn|nym|hmn|ban|osa|bal|ty|bai|tw|srr|tli|tt|ts|bad|tr|to|tn|tl|tk|ti|th|kru|tg|byn|te|kro|csb|ta|tkl|efi|sw|sv|su|krc|st|ss|sr|sq|men|crp|so|afh|sn|sm|sl|grc|sk|grb|si|sh|crh|afa|sg|se|sd|udm|sc|sa|rw|ru|mdr|ro|rn|rm|mdf|ady|zun|kpe|qu|tig|son|cpp|sog|ada|kos|hit|cpf|cpe|him|kok|hil|got|gor|gon|din|nub|pt|ps|fur|phn|goh|snk|cop|yap|yao|phi|pl|ace|pi|pa|bug|iba|sms|bua|mas|smn|os|map|or|man|smj|smi|mak|om|mai|oj|mag|mad|sma|oc|nso|btk|myv|dgr|ny|myn|nv|kmb|nr|gmh|no|nn|nl|ng|sla|ne|nd|cmc|tet|nb|na|ter|tem|my|lez|mt|peo|ms|mr|fro|mo|frm|mn|jrb|ml|mk|mi|mh|mg|mwr|bra|den|lv|lu|del|lt|lo|ln|li|ewo|lg|lb|la|jpr|vot|sit|ky|kw|kv|ku|sio|ks|kr|awa|ko|kn|km|kl|kk|rom|kj|sid|ki|kg|non|ka|mus|roa|nog|mun|mul|jv|gil|znd|shn|fon|xal|aus|kho|ja|khi|pau|chy|tai|iu|pap|it|sgn|is|kha|chr|pam|pal|chp|io|cho|chn|chm|tyv|bnt|pag|ik|chk|ii|haw|lam|ig|chg|sga|paa|ie|id|lah|day|chb|ia|lad|hz|hai|dar|hy|ath|hu|ht|dak|hr|ho|hi|dyu|he|ast|ha|wen|gv|gu|sem|sel|iro|gn|gl|arw|gez|art|gd|ira|ga|arp|arn|fy|bla|gem|ypk|arc|fr|fo|cel|fj|fi|ff|tvl|ceb|fa|eu|sco|et|es|eo|en|el|tut|niu|tup|ee|tum|mos|dz|nic|lus|fiu|dv|nia|moh|lun|apa|lui|hup|bin|de|lua|bik|was|und|war|da|dum|wal|mno|wak|sat|cy|sas|kbd|cv|cu|mni|cs|sam|cr|sal|dua|co|sai|mnc|sah|kaw|inh|gba|sad|ch|ine|bho|enm|kar|inc|ce|gay|ca|umb|syr|kam|tsi|ang|kac|cau|kab|kaa|bs|car|br|bo|bn|bm|gaa|cai|bi|bh|bg|be|cad|ba|zu|zen|pro|hsb|az|ay|av|as|dsb|ar|ilo|elx|zh|an|pra|am|new|ak|za|af|ae|ab|aa|yo|alg|ale|mkh|yi|dra|ber|nds|bem|bej|tpi";

  private static final String languagesValues = "gwit\u015fin|akkadi|ekajuk|kafferi|sumeri|susu|sekalaiset kielet|lozi|tonga|pohnpei|minangkabau|sukuma|wolof|mongo|kutenai|micmac|valloni|kumukki|zapoteekki|muut kuusilaiset kielet|lojba|dogri|volap\u00fck|otomangelaiset kielet|vietnam|rarotonga|venda|rapanui|rajasthani|osmani|nzima|napolin italia|uzbekki|ugarit|tama\u0161ek|muut Pohjois-Amerikan intiaanikielet|nahuatl|urdu|fanti|ukraina|muinaisegypti|uiguuri|fang|muut nilosaharalaiset kielet|keski-iiri|muut balttilaiset kielet|nyoro|basa|nyankole|nyamwezi|hmong|bali|osage|balut\u0161i|tahiti|bamileke|twi|serer|tlingit|tataari|tsonga|banda|turkki|Tonga-saarten tonga|tswana|tagalog|turkmeeni|tigrinja|thai|kurukh|tad\u017eikki|blin|telugu|kru-kielet|kashubi|tamili|tokelau|efik|suahili|ruotsi|sunda|karachay-balkar|etel\u00e4sotho|swazi|serbia|albania|mende|muut kreolit ja pidginit|somali|afrihili|shona|samoa|sloveeni|muinaiskreikka|slovakki|grebo|singaleesi|serbokroatia|krimin turkki; krimin tataari|muut afroaasialaiset kielet|sango|pohjoissaame|sindhi|udmurtti|sardi|sanskriitti|ruanda|ven\u00e4j\u00e4|mandar|romania|rundi|retoromaani|mok\u0161a|adyghe|zuni|kpelle|ket\u0161ua|tigre|songhai|muut portugaliin perustuvat kreolit ja pidginit|sogdi|adangme|kosrae|heetti|muut ranskaan perustuvat kreolit ja pidginit|pidginenglanti|himachali|konkani|ilongo|gootti|gorontalo|gondi|dinka|nuubialaiset kielet|portugali|pa\u0161to|friuli|foinikia|muinaisyl\u00e4saksa|soninke|kopti|jap|jao|muut filippiinil\u00e4iskielet|puola|aceh|pali|punjabi|bugi|iban|koltansaame|burjaatti|maasai|inarinsaame|osseetti|austronesia|orija|mandingo|luulajan saame|muut saamen kielet|makassar|oromo|maithili|ojibwa|magahi|madura|etel\u00e4saame|oksitaani, provensaali|pedi|batakki|ers\u00e4|dogrib|njand\u017ea, t\u0161ewa|maya|navaho|kimbundu|etel\u00e4ndebele|keskiyl\u00e4saksa|norja|uusnorja|hollanti|ndonga|muut slaavilaiset kielet|nepali|pohjoisndebele|t\u0161am|tetum|kirjanorja|nauru|tereno|temne|burma|lezgi|malta|muinaispersia|malaiji|marathi|muinaisranska|moldova|keskiranska|mongoli|juutalaisarabia|malajalam|makedonia|maori|marshalli|malagasi|marwari|brad\u017e|slaavi|latvia|katangan luba|delaware|liettua|lao|lingala|limburgi|ewondo|ganda|luxemburg|latina|juutalaispersia|vatja|muut sinotiibetil\u00e4iset kielet|kirgiisi|korni|komi|kurdi|siouxilaiset kielet|ka\u0161miri|kanuri|awadhi|korea|kannada|khmer|gr\u00f6nlanti|kazakki|romani|kuanjama|sidamo|kikuju|kongo|muinaisskandinaavi|georgia|muskogi|muut romaaniset kielet|nogai|mundakielet|monikielinen|jaava|kiribati|zande|\u0161an|fong|kalmukki|australialaiset kielet|khotani|japani|muut khoisankielet|palau|cheyenne|muut thaikielet|eskimo|papiamentu|italia|viittomakielet|islanti|khasi|cherokee|pampanga|pahlavi|chipewya|ido|choctaw|chinook|mari|tuviini|bantu|pangasinan|inupiak|truk|pohjois-ji|havaiji|lamba|igbo|t\u0161agatai|muinaisiiri|muut papualaiskielet|interlingue|indonesia|lahnda|dajakki|chibcha|interlingua|juutalaisespanja|herero|haida|dargva|armenia|athabasca-kielet|unkari|haiti|sioux|kroatia|hiri-motu|hindi|djula|heprea|astuuri|hausa|sorbi|manx|gud\u017earati|muut seemil\u00e4iset kielet|selkuppi|irokeesi|guarani|galicia|arawak|etiopia|muut tekokielet|gaeli|iran|iiri|arapaho|araukaani|friisi|mustajalka|muut germaaniset kielet|juppik-kielet|aramea|ranska|f\u00e4\u00e4ri|muut kelttil\u00e4iset kielet|fid\u017ei|suomi|fulani|tuvalu|sebuano|persia|baski|skotti|eesti|espanja|esperanto|englanti|kreikka|muut altailaiset kielet|niue|tupilaiset kielet|ewe|tumbuka|mosi|bhutani|muut nigeril\u00e4is-kongolaiset kielet|lushai|muut suomalais-ugrilaiset kielet|malediivi|nias|mohawk|lunda|apassi|luiseno|hupa|bini|saksa|luba|bicol|washo|m\u00e4\u00e4rittelem\u00e4t\u00f6n|waray|tanska|keskihollanti|walamo|manobo-kielet|wakasilaiset kielet|santali|kymri|sasak|kabardi|t\u0161uvassi|kirkkoslaavi|manipuri|tsekki|l\u00e4nsiaramea|cree|sali\u0161|duala|korsika|muut Etel\u00e4-Amerikan intiaanikielet|mant\u0161u|jakuutti|kavi|inguu\u0161i|gbaja|sandawe|chamorro|muut indoeurooppalaiset kielet|bhod\u017epuri|keskienglanti|karen|muut intialaiset kielet|t\u0161et\u0161eeni|gayo|katalaani|umbundu|syyria|kamba|tsimshian|muinaisenglanti|d\u017eingpho|muut kaukasialaiset kielet|kabyyli|karakalpakki|bosnia|karib|bretoni|tiibet|bengali|bambara|ga|muut Keski-Amerikan intiaanikielet|bislama|bihari|bulgaria|valkoven\u00e4j\u00e4|caddo|baski|zulu|zenaga|muinaisprovensaali|yl\u00e4-sorbi|azeri|aimara|avaari|assami|ala-sorbi|arabia|iloko|elami|kiina|aragonia|prakriitit|amhara|newari|akan|zhuang|afrikaans|avesta|abhaasi|afar|joruba|algonkin-kielet|aleutti|muut mon-khmer-kielet|jiddi|muut dravidakielet|berberi|alasaksa|bemba|bedauje|tok-pisin";

  private static final Hashtable languages;
  static
  {
    languages = new Hashtable();
    Enumeration keys = new StringTokenizer(languagesKeys, "|");
    Enumeration values = new StringTokenizer(languagesValues, "|");
    while (keys.hasMoreElements())
      {
         String key = (String) keys.nextElement();
         String value = (String) values.nextElement();
         languages.put(key, value);
      }
  }

  private static final Object[][] contents =
  {
    { "decimalSeparator", "," },
    { "groupingSeparator", "\u00a0" },
    { "currenciesDisplayName", currenciesDisplayName },
    { "currenciesSymbol", currenciesSymbol },
    { "shortMonths", shortMonths },
    { "months", months },
    { "shortWeekdays", shortWeekdays },
    { "weekdays", weekdays },
    { "eras", eras },
    { "ampms", ampms },
    { "shortDateFormat", "d.M.yyyy" },
    { "mediumDateFormat", "d.M.yyyy" },
    { "longDateFormat", "d. MMMM'ta 'yyyy" },
    { "fullDateFormat", "d. MMMM'ta 'yyyy" },
    { "shortTimeFormat", "H.mm" },
    { "mediumTimeFormat", "H.mm.ss" },
    { "longTimeFormat", "H.mm.ss z" },
    { "fullTimeFormat", "H.mm.ss z" },
    { "zoneStrings", zoneStrings },
    { "territories", territories },
    { "languages", languages },
  };

  public Object[][] getContents() { return contents; }
}
