#!/bin/sh

if [ -z "$1" ] || [ "$1" = "--help" ] || [ "$1" = "-help" ] || [ "$1" = "-h" ]; then
    echo "USAGE: ${0##*/} HOST[(:DISPLAY#|::PORT#)]"
    exit 0
fi

PT=$(echo "$1" | grep "::")
if [ -n "$PT" ] ; then
    HOST=$(echo "$PT" | sed -e "s/::.*//;")
    PORT=$(echo "$PT" | sed -e "s/.*:://;")
else
    PT=$(echo "$1" | grep ":")
    if [ -n "$PT" ] ; then 
        HOST=$(echo "$PT" | sed -e "s/:.*//;")
        P=$(echo "$PT" | sed -e "s/.*://;")
		PORT=$((5900+$P))
    else
        HOST="$1"
        PORT=5900
    fi
fi

echo $HOST $PORT

export CLASSPATH=/usr/share/java/tightvncviewer.jar

java tightvncviewer.VncViewer HOST $HOST PORT $PORT
