/* enchant.c generated by valac 0.56.18, the Vala compiler
 * generated from enchant.vala, do not modify */

/* enchant: An ispell-compatible command-line front-end for libenchant.
 *
 * Copyright (C) 2003 Dom Lachowicz
 *               2007 Hannu Väisänen
 *               2016-2024 Reuben Thomas
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along along with this program; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders
 * give permission to link the code of this program with
 * the non-LGPL Spelling Provider libraries (eg: a MSFT Office
 * spell checker backend) and distribute linked combinations including
 * the two.  You must obey the GNU Lesser General Public License in all
 * respects for all of the code used other than said providers. If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so. If you do not wish to
 * do so, delete this exception statement from your version.
 */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <stdio.h>
#include <config.h>
#include <enchant.h>
#include <gobject/gvaluecollector.h>
#include <util.h>
#include <locale.h>
#include <glib/gstdio.h>

#define MIN_WORD_LENGTH ((guint) 1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	MODE_NONE,
	MODE_A,
	MODE_L
} Mode;

#define TYPE_MODE (mode_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TOKEN (token_get_type ())
#define TOKEN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOKEN, Token))
#define TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOKEN, TokenClass))
#define IS_TOKEN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOKEN))
#define IS_TOKEN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOKEN))
#define TOKEN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOKEN, TokenClass))

typedef struct _Token Token;
typedef struct _TokenClass TokenClass;
typedef struct _TokenPrivate TokenPrivate;
typedef struct _ParamSpecToken ParamSpecToken;

#define TYPE_SPELLING (spelling_get_type ())

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;
enum  {
	MAIN_0_PROPERTY,
	MAIN_NUM_PROPERTIES
};
static GParamSpec* main_properties[MAIN_NUM_PROPERTIES];
#define _enchant_broker_free0(var) ((var == NULL) ? NULL : (var = (enchant_broker_free (var), NULL)))
#define _token_unref0(var) ((var == NULL) ? NULL : (var = (token_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))

struct _Token {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TokenPrivate * priv;
	gchar* word;
	glong pos;
};

struct _TokenClass {
	GTypeClass parent_class;
	void (*finalize) (Token *self);
};

struct _ParamSpecToken {
	GParamSpec parent_instance;
};

typedef enum  {
	SPELLING_EMPTY_WORD,
	SPELLING_SYNTAX_ERROR
} Spelling;
#define SPELLING spelling_quark ()

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
};

struct _MainClass {
	GObjectClass parent_class;
};

VALA_EXTERN gchar* charset;
gchar* charset = NULL;
static gpointer token_parent_class = NULL;
static gpointer main_parent_class = NULL;
static gchar* main_dictionary;
static gchar* main_perslist;
static gboolean main_count_lines;
static gboolean main_version;
static gboolean main_ignored;
static gchar** main_files;
static Mode main_mode;
static Mode main_mode = MODE_NONE;
static gchar* main_dictionary = NULL;
static gchar* main_perslist = NULL;
static gchar** main_files = NULL;
static gboolean main_version = FALSE;
static gboolean main_count_lines = FALSE;
static gboolean main_ignored = FALSE;

VALA_EXTERN GType mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void print_version (FILE* to);
VALA_EXTERN gchar* get_line (FILE* fin);
VALA_EXTERN void print_utf (const gchar* str);
VALA_EXTERN gboolean check_word (EnchantDict* dict,
                     const gchar* word);
VALA_EXTERN void do_mode_a (EnchantDict* dict,
                const gchar* word,
                gsize start_pos,
                gsize line_count,
                gboolean terse_mode);
VALA_EXTERN void do_mode_l (EnchantDict* dict,
                const gchar* word,
                gsize line_count);
VALA_EXTERN gpointer token_ref (gpointer instance);
VALA_EXTERN void token_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_token (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags);
VALA_EXTERN void value_set_token (GValue* value,
                      gpointer v_object);
VALA_EXTERN void value_take_token (GValue* value,
                       gpointer v_object);
VALA_EXTERN gpointer value_get_token (const GValue* value);
VALA_EXTERN GType token_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Token, token_unref)
VALA_EXTERN Token* token_new (const gchar* word,
                  glong pos);
VALA_EXTERN Token* token_construct (GType object_type,
                        const gchar* word,
                        glong pos);
static void token_finalize (Token * obj);
static GType token_get_type_once (void);
VALA_EXTERN GSList* tokenize_line (EnchantDict* dict,
                       const gchar* line);
VALA_EXTERN GQuark spelling_quark (void);
VALA_EXTERN GType spelling_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void usage (GOptionContext* ctx);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
static gboolean main_set_mode (const gchar* option_name,
                        const gchar* val,
                        void* data);
static gboolean main_parse_file (FILE* fin);
static void _token_unref0_ (gpointer var);
static inline void _g_slist_free__token_unref0_ (GSList* self);
static gint main_main (gchar** args,
                gint args_length1);
VALA_EXTERN Main* main_new (void);
VALA_EXTERN Main* main_construct (GType object_type);
static void main_finalize (GObject * obj);
static GType main_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry MAIN_main_options[10] = {{"pipe", 'a', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) main_set_mode, "Talk to another program through a pipe, like Ispell", NULL}, {"errors-only", 'l', (gint) G_OPTION_FLAG_NO_ARG, G_OPTION_ARG_CALLBACK, (void*) main_set_mode, "List only the misspellings", NULL}, {"dictionary", 'd', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_STRING, &main_dictionary, "Use the given dictionary", "DICTIONARY"}, {"pwl", 'p', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_FILENAME, &main_perslist, "Use the given personal word list", "FILE"}, {"show-lines", 'L', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &main_count_lines, "Display line numbers", NULL}, {"version", 'v', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_NONE, &main_version, "Display version information and exit", NULL}, {" ", 'm', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &main_ignored, NULL, NULL}, {" ", 'B', (gint) G_OPTION_FLAG_HIDDEN, G_OPTION_ARG_NONE, &main_ignored, NULL, NULL}, {G_OPTION_REMAINING, '\0', (gint) G_OPTION_FLAG_NONE, G_OPTION_ARG_FILENAME_ARRAY, &main_files, NULL, "FILE..."}, {NULL}};

static GType
mode_get_type_once (void)
{
	static const GEnumValue values[] = {{MODE_NONE, "MODE_NONE", "none"}, {MODE_A, "MODE_A", "a"}, {MODE_L, "MODE_L", "l"}, {0, NULL, NULL}};
	GType mode_type_id;
	mode_type_id = g_enum_register_static ("Mode", values);
	return mode_type_id;
}

GType
mode_get_type (void)
{
	static volatile gsize mode_type_id__once = 0;
	if (g_once_init_enter (&mode_type_id__once)) {
		GType mode_type_id;
		mode_type_id = mode_get_type_once ();
		g_once_init_leave (&mode_type_id__once, mode_type_id);
	}
	return mode_type_id__once;
}

void
print_version (FILE* to)
{
#line 48 "enchant.vala"
	g_return_if_fail (to != NULL);
#line 49 "enchant.vala"
	fprintf (to, "@(#) International Ispell Version 3.1.20 (but really Enchant %s)\n", PACKAGE_VERSION);
#line 50 "enchant.vala"
	fflush (to);
#line 257 "enchant.c"
}

static gchar*
g_file_stream_read_line (FILE* self)
{
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp3_;
	gchar* result;
#line 4101 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 4103 "glib-2.0.vapi"
	ret = NULL;
#line 4104 "glib-2.0.vapi"
	while (TRUE) {
#line 273 "enchant.c"
		GString* _tmp0_;
		GString* _tmp2_;
#line 4104 "glib-2.0.vapi"
		c = fgetc (self);
#line 4104 "glib-2.0.vapi"
		if (!(c != EOF)) {
#line 4104 "glib-2.0.vapi"
			break;
#line 282 "enchant.c"
		}
#line 4105 "glib-2.0.vapi"
		_tmp0_ = ret;
#line 4105 "glib-2.0.vapi"
		if (_tmp0_ == NULL) {
#line 288 "enchant.c"
			GString* _tmp1_;
#line 4106 "glib-2.0.vapi"
			_tmp1_ = g_string_new ("");
#line 4106 "glib-2.0.vapi"
			_g_string_free0 (ret);
#line 4106 "glib-2.0.vapi"
			ret = _tmp1_;
#line 296 "enchant.c"
		}
#line 4108 "glib-2.0.vapi"
		if (c == ((gint) '\n')) {
#line 4109 "glib-2.0.vapi"
			break;
#line 302 "enchant.c"
		}
#line 4111 "glib-2.0.vapi"
		_tmp2_ = ret;
#line 4111 "glib-2.0.vapi"
		g_string_append_c ((GString*) _tmp2_, (gchar) c);
#line 308 "enchant.c"
	}
#line 4113 "glib-2.0.vapi"
	_tmp3_ = ret;
#line 4113 "glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 4114 "glib-2.0.vapi"
		result = NULL;
#line 4114 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4114 "glib-2.0.vapi"
		return result;
#line 320 "enchant.c"
	} else {
		GString* _tmp4_;
		gchar* _tmp5_;
#line 4116 "glib-2.0.vapi"
		_tmp4_ = ret;
#line 4116 "glib-2.0.vapi"
		_tmp5_ = ((GString*) _tmp4_)->str;
#line 4116 "glib-2.0.vapi"
		((GString*) _tmp4_)->str = NULL;
#line 4116 "glib-2.0.vapi"
		result = _tmp5_;
#line 4116 "glib-2.0.vapi"
		_g_string_free0 (ret);
#line 4116 "glib-2.0.vapi"
		return result;
#line 336 "enchant.c"
	}
}

gchar*
get_line (FILE* fin)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 53 "enchant.vala"
	g_return_val_if_fail (fin != NULL, NULL);
#line 54 "enchant.vala"
	_tmp0_ = g_file_stream_read_line (fin);
#line 54 "enchant.vala"
	str = _tmp0_;
#line 55 "enchant.vala"
	_tmp2_ = str;
#line 55 "enchant.vala"
	if (_tmp2_ != NULL) {
#line 359 "enchant.c"
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 55 "enchant.vala"
		_tmp3_ = str;
#line 55 "enchant.vala"
		_tmp4_ = strlen (_tmp3_);
#line 55 "enchant.vala"
		_tmp5_ = _tmp4_;
#line 55 "enchant.vala"
		_tmp1_ = _tmp5_ > 0;
#line 371 "enchant.c"
	} else {
#line 55 "enchant.vala"
		_tmp1_ = FALSE;
#line 375 "enchant.c"
	}
#line 55 "enchant.vala"
	if (_tmp1_) {
#line 379 "enchant.c"
		{
			gchar* _tmp6_ = NULL;
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
#line 57 "enchant.vala"
			_tmp7_ = str;
#line 57 "enchant.vala"
			_tmp8_ = str;
#line 57 "enchant.vala"
			_tmp9_ = strlen (_tmp8_);
#line 57 "enchant.vala"
			_tmp10_ = _tmp9_;
#line 57 "enchant.vala"
			_tmp11_ = charset;
#line 57 "enchant.vala"
			_tmp12_ = g_convert (_tmp7_, (gssize) _tmp10_, "UTF-8", _tmp11_, NULL, NULL, &_inner_error0_);
#line 57 "enchant.vala"
			_tmp6_ = _tmp12_;
#line 57 "enchant.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 57 "enchant.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 407 "enchant.c"
					goto __catch0_g_convert_error;
				}
#line 57 "enchant.vala"
				_g_free0 (str);
#line 57 "enchant.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 57 "enchant.vala"
				g_clear_error (&_inner_error0_);
#line 57 "enchant.vala"
				return NULL;
#line 418 "enchant.c"
			}
#line 57 "enchant.vala"
			_tmp13_ = _tmp6_;
#line 57 "enchant.vala"
			_tmp6_ = NULL;
#line 57 "enchant.vala"
			result = _tmp13_;
#line 57 "enchant.vala"
			_g_free0 (_tmp6_);
#line 57 "enchant.vala"
			_g_free0 (str);
#line 57 "enchant.vala"
			return result;
#line 432 "enchant.c"
		}
		goto __finally0;
		__catch0_g_convert_error:
		{
#line 56 "enchant.vala"
			g_clear_error (&_inner_error0_);
#line 439 "enchant.c"
		}
		__finally0:
#line 56 "enchant.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "enchant.vala"
			_g_free0 (str);
#line 56 "enchant.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 56 "enchant.vala"
			g_clear_error (&_inner_error0_);
#line 56 "enchant.vala"
			return NULL;
#line 452 "enchant.c"
		}
	}
#line 62 "enchant.vala"
	result = str;
#line 62 "enchant.vala"
	return result;
#line 459 "enchant.c"
}

void
print_utf (const gchar* str)
{
	gsize bytes_written = 0UL;
	GError* _inner_error0_ = NULL;
#line 65 "enchant.vala"
	g_return_if_fail (str != NULL);
#line 469 "enchant.c"
	{
		gchar* native = NULL;
		gint _tmp0_;
		gint _tmp1_;
		gsize _tmp2_ = 0UL;
		gchar* _tmp3_;
		guint8* buf = NULL;
		gint buf_length1;
		gint _buf_size_;
		FILE* _tmp4_;
		guint8* _tmp5_;
		gint _tmp5__length1;
#line 68 "enchant.vala"
		_tmp0_ = strlen (str);
#line 68 "enchant.vala"
		_tmp1_ = _tmp0_;
#line 68 "enchant.vala"
		_tmp3_ = g_locale_from_utf8 (str, (gssize) _tmp1_, NULL, &_tmp2_, &_inner_error0_);
#line 68 "enchant.vala"
		bytes_written = _tmp2_;
#line 68 "enchant.vala"
		native = _tmp3_;
#line 68 "enchant.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 68 "enchant.vala"
			if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 496 "enchant.c"
				goto __catch0_g_convert_error;
			}
#line 68 "enchant.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 68 "enchant.vala"
			g_clear_error (&_inner_error0_);
#line 68 "enchant.vala"
			return;
#line 505 "enchant.c"
		}
#line 70 "enchant.vala"
		buf = (guint8*) native;
#line 70 "enchant.vala"
		buf_length1 = -1;
#line 70 "enchant.vala"
		_buf_size_ = buf_length1;
#line 71 "enchant.vala"
		buf_length1 = (gint) bytes_written;
#line 72 "enchant.vala"
		_tmp4_ = stdout;
#line 72 "enchant.vala"
		_tmp5_ = buf;
#line 72 "enchant.vala"
		_tmp5__length1 = buf_length1;
#line 72 "enchant.vala"
		fwrite (_tmp5_, (gsize) 1, (gint) _tmp5__length1, _tmp4_);
#line 67 "enchant.vala"
		_g_free0 (native);
#line 525 "enchant.c"
	}
	goto __finally0;
	__catch0_g_convert_error:
	{
#line 67 "enchant.vala"
		g_clear_error (&_inner_error0_);
#line 75 "enchant.vala"
		g_print ("%s", str);
#line 534 "enchant.c"
	}
	__finally0:
#line 67 "enchant.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 67 "enchant.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 67 "enchant.vala"
		g_clear_error (&_inner_error0_);
#line 67 "enchant.vala"
		return;
#line 545 "enchant.c"
	}
}

gboolean
check_word (EnchantDict* dict,
            const gchar* word)
{
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gboolean result;
#line 79 "enchant.vala"
	g_return_val_if_fail (dict != NULL, FALSE);
#line 79 "enchant.vala"
	g_return_val_if_fail (word != NULL, FALSE);
#line 80 "enchant.vala"
	_tmp1_ = strlen (word);
#line 80 "enchant.vala"
	_tmp2_ = _tmp1_;
#line 80 "enchant.vala"
	if (((guint) _tmp2_) <= MIN_WORD_LENGTH) {
#line 80 "enchant.vala"
		_tmp0_ = TRUE;
#line 569 "enchant.c"
	} else {
		gint _tmp3_;
		gint _tmp4_;
#line 81 "enchant.vala"
		_tmp3_ = strlen (word);
#line 81 "enchant.vala"
		_tmp4_ = _tmp3_;
#line 81 "enchant.vala"
		_tmp0_ = enchant_dict_check (dict, word, (glong) _tmp4_) == 0;
#line 579 "enchant.c"
	}
#line 80 "enchant.vala"
	result = _tmp0_;
#line 80 "enchant.vala"
	return result;
#line 585 "enchant.c"
}

void
do_mode_a (EnchantDict* dict,
           const gchar* word,
           gsize start_pos,
           gsize line_count,
           gboolean terse_mode)
{
#line 84 "enchant.vala"
	g_return_if_fail (dict != NULL);
#line 84 "enchant.vala"
	g_return_if_fail (word != NULL);
#line 85 "enchant.vala"
	if (check_word (dict, word)) {
#line 86 "enchant.vala"
		if (!terse_mode) {
#line 87 "enchant.vala"
			if (line_count > ((gsize) 0)) {
#line 88 "enchant.vala"
				g_print ("* %zu\n", line_count);
#line 607 "enchant.c"
			} else {
#line 90 "enchant.vala"
				g_print ("*\n");
#line 611 "enchant.c"
			}
		}
	} else {
		gchar** suggs = NULL;
		gint _tmp0_;
		gint _tmp1_;
		size_t _tmp2_ = 0;
		gchar** _tmp3_;
		gint suggs_length1;
		gint _suggs_size_;
		gboolean _tmp4_ = FALSE;
		gchar** _tmp5_;
		gint _tmp5__length1;
#line 93 "enchant.vala"
		_tmp0_ = strlen (word);
#line 93 "enchant.vala"
		_tmp1_ = _tmp0_;
#line 93 "enchant.vala"
		_tmp3_ = enchant_dict_suggest (dict, word, (glong) _tmp1_, &_tmp2_);
#line 93 "enchant.vala"
		suggs = _tmp3_;
#line 93 "enchant.vala"
		suggs_length1 = _tmp2_;
#line 93 "enchant.vala"
		_suggs_size_ = suggs_length1;
#line 94 "enchant.vala"
		_tmp5_ = suggs;
#line 94 "enchant.vala"
		_tmp5__length1 = suggs_length1;
#line 94 "enchant.vala"
		if (_tmp5_ == NULL) {
#line 94 "enchant.vala"
			_tmp4_ = TRUE;
#line 645 "enchant.c"
		} else {
			gchar** _tmp6_;
			gint _tmp6__length1;
#line 94 "enchant.vala"
			_tmp6_ = suggs;
#line 94 "enchant.vala"
			_tmp6__length1 = suggs_length1;
#line 94 "enchant.vala"
			_tmp4_ = _tmp6__length1 == 0;
#line 655 "enchant.c"
		}
#line 94 "enchant.vala"
		if (_tmp4_) {
#line 95 "enchant.vala"
			g_print ("# ");
#line 96 "enchant.vala"
			if (line_count > ((gsize) 0)) {
#line 97 "enchant.vala"
				g_print ("%zu ", line_count);
#line 665 "enchant.c"
			}
#line 98 "enchant.vala"
			print_utf (word);
#line 99 "enchant.vala"
			g_print (" %zu\n", start_pos);
#line 671 "enchant.c"
		} else {
			gchar** _tmp7_;
			gint _tmp7__length1;
			FILE* _tmp16_;
#line 101 "enchant.vala"
			g_print ("& ");
#line 102 "enchant.vala"
			if (line_count > ((gsize) 0)) {
#line 103 "enchant.vala"
				g_print ("%zu ", line_count);
#line 682 "enchant.c"
			}
#line 104 "enchant.vala"
			print_utf (word);
#line 105 "enchant.vala"
			_tmp7_ = suggs;
#line 105 "enchant.vala"
			_tmp7__length1 = suggs_length1;
#line 105 "enchant.vala"
			g_print (" %zu %zu:", (gsize) _tmp7__length1, start_pos);
#line 692 "enchant.c"
			{
				gsize i = 0UL;
#line 107 "enchant.vala"
				i = (gsize) 0;
#line 697 "enchant.c"
				{
					gboolean _tmp8_ = FALSE;
#line 107 "enchant.vala"
					_tmp8_ = TRUE;
#line 107 "enchant.vala"
					while (TRUE) {
#line 704 "enchant.c"
						gchar** _tmp10_;
						gint _tmp10__length1;
						FILE* _tmp11_;
						gchar** _tmp12_;
						gint _tmp12__length1;
						const gchar* _tmp13_;
						gchar** _tmp14_;
						gint _tmp14__length1;
#line 107 "enchant.vala"
						if (!_tmp8_) {
#line 715 "enchant.c"
							gsize _tmp9_;
#line 107 "enchant.vala"
							_tmp9_ = i;
#line 107 "enchant.vala"
							i = _tmp9_ + 1;
#line 721 "enchant.c"
						}
#line 107 "enchant.vala"
						_tmp8_ = FALSE;
#line 107 "enchant.vala"
						_tmp10_ = suggs;
#line 107 "enchant.vala"
						_tmp10__length1 = suggs_length1;
#line 107 "enchant.vala"
						if (!(i < ((gsize) _tmp10__length1))) {
#line 107 "enchant.vala"
							break;
#line 733 "enchant.c"
						}
#line 108 "enchant.vala"
						_tmp11_ = stdout;
#line 108 "enchant.vala"
						fputc (' ', _tmp11_);
#line 109 "enchant.vala"
						_tmp12_ = suggs;
#line 109 "enchant.vala"
						_tmp12__length1 = suggs_length1;
#line 109 "enchant.vala"
						_tmp13_ = _tmp12_[i];
#line 109 "enchant.vala"
						print_utf (_tmp13_);
#line 111 "enchant.vala"
						_tmp14_ = suggs;
#line 111 "enchant.vala"
						_tmp14__length1 = suggs_length1;
#line 111 "enchant.vala"
						if (i != ((gsize) (_tmp14__length1 - 1))) {
#line 753 "enchant.c"
							FILE* _tmp15_;
#line 112 "enchant.vala"
							_tmp15_ = stdout;
#line 112 "enchant.vala"
							fputc (',', _tmp15_);
#line 759 "enchant.c"
						}
					}
				}
			}
#line 114 "enchant.vala"
			_tmp16_ = stdout;
#line 114 "enchant.vala"
			fputc ('\n', _tmp16_);
#line 768 "enchant.c"
		}
#line 85 "enchant.vala"
		suggs = (_vala_array_free (suggs, suggs_length1, (GDestroyNotify) g_free), NULL);
#line 772 "enchant.c"
	}
}

void
do_mode_l (EnchantDict* dict,
           const gchar* word,
           gsize line_count)
{
#line 119 "enchant.vala"
	g_return_if_fail (dict != NULL);
#line 119 "enchant.vala"
	g_return_if_fail (word != NULL);
#line 120 "enchant.vala"
	if (!check_word (dict, word)) {
#line 787 "enchant.c"
		FILE* _tmp0_;
#line 121 "enchant.vala"
		if (line_count > ((gsize) 0)) {
#line 122 "enchant.vala"
			g_print ("%zu ", line_count);
#line 793 "enchant.c"
		}
#line 123 "enchant.vala"
		print_utf (word);
#line 124 "enchant.vala"
		_tmp0_ = stdout;
#line 124 "enchant.vala"
		fputc ('\n', _tmp0_);
#line 801 "enchant.c"
	}
}

Token*
token_construct (GType object_type,
                 const gchar* word,
                 glong pos)
{
	Token* self = NULL;
	gchar* _tmp0_;
#line 134 "enchant.vala"
	g_return_val_if_fail (word != NULL, NULL);
#line 134 "enchant.vala"
	self = (Token*) g_type_create_instance (object_type);
#line 135 "enchant.vala"
	_tmp0_ = g_strdup (word);
#line 135 "enchant.vala"
	_g_free0 (self->word);
#line 135 "enchant.vala"
	self->word = _tmp0_;
#line 136 "enchant.vala"
	self->pos = pos;
#line 134 "enchant.vala"
	return self;
#line 826 "enchant.c"
}

Token*
token_new (const gchar* word,
           glong pos)
{
#line 134 "enchant.vala"
	return token_construct (TYPE_TOKEN, word, pos);
#line 835 "enchant.c"
}

static void
value_token_init (GValue* value)
{
#line 130 "enchant.vala"
	value->data[0].v_pointer = NULL;
#line 843 "enchant.c"
}

static void
value_token_free_value (GValue* value)
{
#line 130 "enchant.vala"
	if (value->data[0].v_pointer) {
#line 130 "enchant.vala"
		token_unref (value->data[0].v_pointer);
#line 853 "enchant.c"
	}
}

static void
value_token_copy_value (const GValue* src_value,
                        GValue* dest_value)
{
#line 130 "enchant.vala"
	if (src_value->data[0].v_pointer) {
#line 130 "enchant.vala"
		dest_value->data[0].v_pointer = token_ref (src_value->data[0].v_pointer);
#line 865 "enchant.c"
	} else {
#line 130 "enchant.vala"
		dest_value->data[0].v_pointer = NULL;
#line 869 "enchant.c"
	}
}

static gpointer
value_token_peek_pointer (const GValue* value)
{
#line 130 "enchant.vala"
	return value->data[0].v_pointer;
#line 878 "enchant.c"
}

static gchar*
value_token_collect_value (GValue* value,
                           guint n_collect_values,
                           GTypeCValue* collect_values,
                           guint collect_flags)
{
#line 130 "enchant.vala"
	if (collect_values[0].v_pointer) {
#line 889 "enchant.c"
		Token * object;
		object = collect_values[0].v_pointer;
#line 130 "enchant.vala"
		if (object->parent_instance.g_class == NULL) {
#line 130 "enchant.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 896 "enchant.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 130 "enchant.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 900 "enchant.c"
		}
#line 130 "enchant.vala"
		value->data[0].v_pointer = token_ref (object);
#line 904 "enchant.c"
	} else {
#line 130 "enchant.vala"
		value->data[0].v_pointer = NULL;
#line 908 "enchant.c"
	}
#line 130 "enchant.vala"
	return NULL;
#line 912 "enchant.c"
}

static gchar*
value_token_lcopy_value (const GValue* value,
                         guint n_collect_values,
                         GTypeCValue* collect_values,
                         guint collect_flags)
{
	Token ** object_p;
	object_p = collect_values[0].v_pointer;
#line 130 "enchant.vala"
	if (!object_p) {
#line 130 "enchant.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 927 "enchant.c"
	}
#line 130 "enchant.vala"
	if (!value->data[0].v_pointer) {
#line 130 "enchant.vala"
		*object_p = NULL;
#line 933 "enchant.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 130 "enchant.vala"
		*object_p = value->data[0].v_pointer;
#line 937 "enchant.c"
	} else {
#line 130 "enchant.vala"
		*object_p = token_ref (value->data[0].v_pointer);
#line 941 "enchant.c"
	}
#line 130 "enchant.vala"
	return NULL;
#line 945 "enchant.c"
}

GParamSpec*
param_spec_token (const gchar* name,
                  const gchar* nick,
                  const gchar* blurb,
                  GType object_type,
                  GParamFlags flags)
{
	ParamSpecToken* spec;
#line 130 "enchant.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TOKEN), NULL);
#line 130 "enchant.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 130 "enchant.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 130 "enchant.vala"
	return G_PARAM_SPEC (spec);
#line 964 "enchant.c"
}

gpointer
value_get_token (const GValue* value)
{
#line 130 "enchant.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOKEN), NULL);
#line 130 "enchant.vala"
	return value->data[0].v_pointer;
#line 974 "enchant.c"
}

void
value_set_token (GValue* value,
                 gpointer v_object)
{
	Token * old;
#line 130 "enchant.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOKEN));
#line 130 "enchant.vala"
	old = value->data[0].v_pointer;
#line 130 "enchant.vala"
	if (v_object) {
#line 130 "enchant.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOKEN));
#line 130 "enchant.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 130 "enchant.vala"
		value->data[0].v_pointer = v_object;
#line 130 "enchant.vala"
		token_ref (value->data[0].v_pointer);
#line 996 "enchant.c"
	} else {
#line 130 "enchant.vala"
		value->data[0].v_pointer = NULL;
#line 1000 "enchant.c"
	}
#line 130 "enchant.vala"
	if (old) {
#line 130 "enchant.vala"
		token_unref (old);
#line 1006 "enchant.c"
	}
}

void
value_take_token (GValue* value,
                  gpointer v_object)
{
	Token * old;
#line 130 "enchant.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TOKEN));
#line 130 "enchant.vala"
	old = value->data[0].v_pointer;
#line 130 "enchant.vala"
	if (v_object) {
#line 130 "enchant.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TOKEN));
#line 130 "enchant.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 130 "enchant.vala"
		value->data[0].v_pointer = v_object;
#line 1027 "enchant.c"
	} else {
#line 130 "enchant.vala"
		value->data[0].v_pointer = NULL;
#line 1031 "enchant.c"
	}
#line 130 "enchant.vala"
	if (old) {
#line 130 "enchant.vala"
		token_unref (old);
#line 1037 "enchant.c"
	}
}

static void
token_class_init (TokenClass * klass,
                  gpointer klass_data)
{
#line 130 "enchant.vala"
	token_parent_class = g_type_class_peek_parent (klass);
#line 130 "enchant.vala"
	((TokenClass *) klass)->finalize = token_finalize;
#line 1049 "enchant.c"
}

static void
token_instance_init (Token * self,
                     gpointer klass)
{
#line 130 "enchant.vala"
	self->ref_count = 1;
#line 1058 "enchant.c"
}

static void
token_finalize (Token * obj)
{
	Token * self;
#line 130 "enchant.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TOKEN, Token);
#line 130 "enchant.vala"
	g_signal_handlers_destroy (self);
#line 131 "enchant.vala"
	_g_free0 (self->word);
#line 1071 "enchant.c"
}

static GType
token_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_token_init, value_token_free_value, value_token_copy_value, value_token_peek_pointer, "p", value_token_collect_value, "p", value_token_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (TokenClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) token_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Token), 0, (GInstanceInitFunc) token_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType token_type_id;
	token_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Token", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return token_type_id;
}

GType
token_get_type (void)
{
	static volatile gsize token_type_id__once = 0;
	if (g_once_init_enter (&token_type_id__once)) {
		GType token_type_id;
		token_type_id = token_get_type_once ();
		g_once_init_leave (&token_type_id__once, token_type_id);
	}
	return token_type_id__once;
}

gpointer
token_ref (gpointer instance)
{
	Token * self;
	self = instance;
#line 130 "enchant.vala"
	g_atomic_int_inc (&self->ref_count);
#line 130 "enchant.vala"
	return instance;
#line 1106 "enchant.c"
}

void
token_unref (gpointer instance)
{
	Token * self;
	self = instance;
#line 130 "enchant.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 130 "enchant.vala"
		TOKEN_GET_CLASS (self)->finalize (self);
#line 130 "enchant.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1120 "enchant.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
#line 1283 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1284 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1284 "glib-2.0.vapi"
	result = _tmp0_;
#line 1284 "glib-2.0.vapi"
	return result;
#line 1138 "enchant.c"
}

static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result;
#line 1313 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0U);
#line 1314 "glib-2.0.vapi"
	result = g_utf8_get_char (((gchar*) self) + index);
#line 1314 "glib-2.0.vapi"
	return result;
#line 1152 "enchant.c"
}

GSList*
tokenize_line (EnchantDict* dict,
               const gchar* line)
{
	GSList* tokens = NULL;
	glong cur_unichar = 0L;
	GSList* result;
#line 140 "enchant.vala"
	g_return_val_if_fail (dict != NULL, NULL);
#line 140 "enchant.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 141 "enchant.vala"
	tokens = NULL;
#line 142 "enchant.vala"
	cur_unichar = (glong) 0;
#line 1170 "enchant.c"
	{
		const gchar* cur_byte = NULL;
#line 144 "enchant.vala"
		cur_byte = line;
#line 1175 "enchant.c"
		{
			gboolean _tmp0_ = FALSE;
#line 144 "enchant.vala"
			_tmp0_ = TRUE;
#line 144 "enchant.vala"
			while (TRUE) {
#line 1182 "enchant.c"
				const gchar* _tmp1_;
				GString* word = NULL;
				GString* _tmp2_;
				gunichar uc = 0U;
				const gchar* start_ptr = NULL;
				const gchar* _tmp9_;
				glong start_unichar = 0L;
				const gchar* last_char_ptr = NULL;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				GString* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				gboolean found_word_char = FALSE;
				GString* _tmp33_;
#line 144 "enchant.vala"
				if (!_tmp0_) {
#line 1201 "enchant.c"
				}
#line 144 "enchant.vala"
				_tmp0_ = FALSE;
#line 144 "enchant.vala"
				_tmp1_ = cur_byte;
#line 144 "enchant.vala"
				if (!(string_get (_tmp1_, (glong) 0) != '\0')) {
#line 144 "enchant.vala"
					break;
#line 1211 "enchant.c"
				}
#line 145 "enchant.vala"
				_tmp2_ = g_string_new ("");
#line 145 "enchant.vala"
				word = _tmp2_;
#line 1217 "enchant.c"
				{
					const gchar* _tmp3_;
					gboolean _tmp4_ = FALSE;
#line 149 "enchant.vala"
					_tmp3_ = cur_byte;
#line 149 "enchant.vala"
					uc = string_get_char (_tmp3_, (glong) 0);
#line 149 "enchant.vala"
					_tmp4_ = TRUE;
#line 149 "enchant.vala"
					while (TRUE) {
#line 1229 "enchant.c"
						gboolean _tmp6_ = FALSE;
						const gchar* _tmp7_;
						const gchar* _tmp8_;
#line 149 "enchant.vala"
						if (!_tmp4_) {
#line 1235 "enchant.c"
							const gchar* _tmp5_;
#line 151 "enchant.vala"
							_tmp5_ = cur_byte;
#line 151 "enchant.vala"
							uc = string_get_char (_tmp5_, (glong) 0);
#line 1241 "enchant.c"
						}
#line 149 "enchant.vala"
						_tmp4_ = FALSE;
#line 150 "enchant.vala"
						if (uc != ((gunichar) 0)) {
#line 150 "enchant.vala"
							_tmp6_ = !enchant_dict_is_word_character (dict, (guint32) uc, 0);
#line 1249 "enchant.c"
						} else {
#line 150 "enchant.vala"
							_tmp6_ = FALSE;
#line 1253 "enchant.c"
						}
#line 150 "enchant.vala"
						if (!_tmp6_) {
#line 150 "enchant.vala"
							break;
#line 1259 "enchant.c"
						}
#line 152 "enchant.vala"
						_tmp7_ = cur_byte;
#line 152 "enchant.vala"
						_tmp8_ = g_utf8_next_char (_tmp7_);
#line 152 "enchant.vala"
						cur_byte = _tmp8_;
#line 153 "enchant.vala"
						cur_unichar += (glong) 1;
#line 1269 "enchant.c"
					}
				}
#line 155 "enchant.vala"
				_tmp9_ = cur_byte;
#line 155 "enchant.vala"
				start_ptr = _tmp9_;
#line 156 "enchant.vala"
				start_unichar = cur_unichar;
#line 1278 "enchant.c"
				{
					gboolean _tmp10_ = FALSE;
#line 159 "enchant.vala"
					_tmp10_ = TRUE;
#line 159 "enchant.vala"
					while (TRUE) {
#line 1285 "enchant.c"
						gboolean _tmp12_ = FALSE;
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						GString* _tmp15_;
#line 159 "enchant.vala"
						if (!_tmp10_) {
#line 1292 "enchant.c"
							const gchar* _tmp11_;
#line 161 "enchant.vala"
							_tmp11_ = cur_byte;
#line 161 "enchant.vala"
							uc = string_get_char (_tmp11_, (glong) 0);
#line 1298 "enchant.c"
						}
#line 159 "enchant.vala"
						_tmp10_ = FALSE;
#line 160 "enchant.vala"
						if (uc != ((gunichar) 0)) {
#line 160 "enchant.vala"
							_tmp12_ = enchant_dict_is_word_character (dict, (guint32) uc, 1);
#line 1306 "enchant.c"
						} else {
#line 160 "enchant.vala"
							_tmp12_ = FALSE;
#line 1310 "enchant.c"
						}
#line 160 "enchant.vala"
						if (!_tmp12_) {
#line 160 "enchant.vala"
							break;
#line 1316 "enchant.c"
						}
#line 162 "enchant.vala"
						_tmp13_ = cur_byte;
#line 162 "enchant.vala"
						_tmp14_ = g_utf8_next_char (_tmp13_);
#line 162 "enchant.vala"
						cur_byte = _tmp14_;
#line 163 "enchant.vala"
						_tmp15_ = word;
#line 163 "enchant.vala"
						g_string_append_unichar (_tmp15_, uc);
#line 164 "enchant.vala"
						cur_unichar += (glong) 1;
#line 1330 "enchant.c"
					}
				}
#line 168 "enchant.vala"
				_tmp16_ = cur_byte;
#line 168 "enchant.vala"
				_tmp17_ = g_utf8_prev_char (_tmp16_);
#line 168 "enchant.vala"
				last_char_ptr = _tmp17_;
#line 1339 "enchant.c"
				{
					gboolean _tmp18_ = FALSE;
#line 169 "enchant.vala"
					_tmp18_ = TRUE;
#line 169 "enchant.vala"
					while (TRUE) {
#line 1346 "enchant.c"
						const gchar* _tmp21_;
#line 169 "enchant.vala"
						if (!_tmp18_) {
#line 1350 "enchant.c"
							const gchar* _tmp19_;
							const gchar* _tmp20_;
#line 171 "enchant.vala"
							_tmp19_ = last_char_ptr;
#line 171 "enchant.vala"
							_tmp20_ = g_utf8_prev_char (_tmp19_);
#line 171 "enchant.vala"
							last_char_ptr = _tmp20_;
#line 1359 "enchant.c"
						}
#line 169 "enchant.vala"
						_tmp18_ = FALSE;
#line 170 "enchant.vala"
						_tmp21_ = last_char_ptr;
#line 170 "enchant.vala"
						if (!(!enchant_dict_is_word_character (dict, (guint32) string_get_char (_tmp21_, (glong) 0), 2))) {
#line 170 "enchant.vala"
							break;
#line 1369 "enchant.c"
						}
					}
				}
#line 172 "enchant.vala"
				_tmp22_ = word;
#line 172 "enchant.vala"
				_tmp23_ = last_char_ptr;
#line 172 "enchant.vala"
				_tmp24_ = g_utf8_next_char (_tmp23_);
#line 172 "enchant.vala"
				_tmp25_ = start_ptr;
#line 172 "enchant.vala"
				g_string_truncate (_tmp22_, ((gchar*) _tmp24_) - ((gchar*) _tmp25_));
#line 175 "enchant.vala"
				found_word_char = FALSE;
#line 1385 "enchant.c"
				{
					const gchar* p = NULL;
					GString* _tmp26_;
					const gchar* _tmp27_;
#line 176 "enchant.vala"
					_tmp26_ = word;
#line 176 "enchant.vala"
					_tmp27_ = _tmp26_->str;
#line 176 "enchant.vala"
					p = _tmp27_;
#line 1396 "enchant.c"
					{
						gboolean _tmp28_ = FALSE;
#line 176 "enchant.vala"
						_tmp28_ = TRUE;
#line 176 "enchant.vala"
						while (TRUE) {
#line 1403 "enchant.c"
							const gchar* _tmp31_;
							const gchar* _tmp32_;
#line 176 "enchant.vala"
							if (!_tmp28_) {
#line 1408 "enchant.c"
								const gchar* _tmp29_;
								const gchar* _tmp30_;
#line 176 "enchant.vala"
								_tmp29_ = p;
#line 176 "enchant.vala"
								_tmp30_ = g_utf8_next_char (_tmp29_);
#line 176 "enchant.vala"
								p = _tmp30_;
#line 1417 "enchant.c"
							}
#line 176 "enchant.vala"
							_tmp28_ = FALSE;
#line 176 "enchant.vala"
							_tmp31_ = p;
#line 176 "enchant.vala"
							if (!(string_get (_tmp31_, (glong) 0) != '\0')) {
#line 176 "enchant.vala"
								break;
#line 1427 "enchant.c"
							}
#line 177 "enchant.vala"
							_tmp32_ = p;
#line 177 "enchant.vala"
							uc = string_get_char (_tmp32_, (glong) 0);
#line 178 "enchant.vala"
							switch (g_unichar_type (uc)) {
#line 178 "enchant.vala"
								case G_UNICODE_MODIFIER_LETTER:
#line 178 "enchant.vala"
								case G_UNICODE_LOWERCASE_LETTER:
#line 178 "enchant.vala"
								case G_UNICODE_TITLECASE_LETTER:
#line 178 "enchant.vala"
								case G_UNICODE_UPPERCASE_LETTER:
#line 178 "enchant.vala"
								case G_UNICODE_OTHER_LETTER:
#line 1445 "enchant.c"
								{
#line 184 "enchant.vala"
									found_word_char = TRUE;
#line 185 "enchant.vala"
									break;
#line 1451 "enchant.c"
								}
								default:
								{
#line 187 "enchant.vala"
									break;
#line 1457 "enchant.c"
								}
							}
						}
					}
				}
#line 190 "enchant.vala"
				if (!found_word_char) {
#line 191 "enchant.vala"
					_g_string_free0 (word);
#line 191 "enchant.vala"
					break;
#line 1469 "enchant.c"
				}
#line 195 "enchant.vala"
				_tmp33_ = word;
#line 195 "enchant.vala"
				if (_tmp33_->len > ((gssize) 0)) {
#line 1475 "enchant.c"
					GString* _tmp34_;
					const gchar* _tmp35_;
					Token* _tmp36_;
#line 196 "enchant.vala"
					_tmp34_ = word;
#line 196 "enchant.vala"
					_tmp35_ = _tmp34_->str;
#line 196 "enchant.vala"
					_tmp36_ = token_new (_tmp35_, start_unichar);
#line 196 "enchant.vala"
					tokens = g_slist_append (tokens, _tmp36_);
#line 1487 "enchant.c"
				}
#line 144 "enchant.vala"
				_g_string_free0 (word);
#line 1491 "enchant.c"
			}
		}
	}
#line 200 "enchant.vala"
	result = tokens;
#line 200 "enchant.vala"
	return result;
#line 1499 "enchant.c"
}

GQuark
spelling_quark (void)
{
	return g_quark_from_static_string ("spelling-quark");
}

static GType
spelling_get_type_once (void)
{
	static const GEnumValue values[] = {{SPELLING_EMPTY_WORD, "SPELLING_EMPTY_WORD", "empty-word"}, {SPELLING_SYNTAX_ERROR, "SPELLING_SYNTAX_ERROR", "syntax-error"}, {0, NULL, NULL}};
	GType spelling_type_id;
	spelling_type_id = g_enum_register_static ("Spelling", values);
	return spelling_type_id;
}

GType
spelling_get_type (void)
{
	static volatile gsize spelling_type_id__once = 0;
	if (g_once_init_enter (&spelling_type_id__once)) {
		GType spelling_type_id;
		spelling_type_id = spelling_get_type_once ();
		g_once_init_leave (&spelling_type_id__once, spelling_type_id);
	}
	return spelling_type_id__once;
}

void
usage (GOptionContext* ctx)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
#line 208 "enchant.vala"
	g_return_if_fail (ctx != NULL);
#line 209 "enchant.vala"
	_tmp0_ = g_option_context_get_help (ctx, FALSE, NULL);
#line 209 "enchant.vala"
	_tmp1_ = _tmp0_;
#line 209 "enchant.vala"
	g_print ("%s", _tmp1_);
#line 209 "enchant.vala"
	_g_free0 (_tmp1_);
#line 210 "enchant.vala"
	exit (1);
#line 1546 "enchant.c"
}

static gboolean
main_set_mode (const gchar* option_name,
               const gchar* val,
               void* data)
{
	gboolean result;
#line 240 "enchant.vala"
	g_return_val_if_fail (option_name != NULL, FALSE);
#line 242 "enchant.vala"
	if (main_mode == MODE_NONE) {
#line 1559 "enchant.c"
		gboolean _tmp0_ = FALSE;
#line 243 "enchant.vala"
		if (g_strcmp0 (option_name, "--pipe") == 0) {
#line 243 "enchant.vala"
			_tmp0_ = TRUE;
#line 1565 "enchant.c"
		} else {
#line 243 "enchant.vala"
			_tmp0_ = g_strcmp0 (option_name, "-a") == 0;
#line 1569 "enchant.c"
		}
#line 243 "enchant.vala"
		if (_tmp0_) {
#line 244 "enchant.vala"
			main_mode = MODE_A;
#line 1575 "enchant.c"
		} else {
			gboolean _tmp1_ = FALSE;
#line 245 "enchant.vala"
			if (g_strcmp0 (option_name, "--errors-only") == 0) {
#line 245 "enchant.vala"
				_tmp1_ = TRUE;
#line 1582 "enchant.c"
			} else {
#line 245 "enchant.vala"
				_tmp1_ = g_strcmp0 (option_name, "-l") == 0;
#line 1586 "enchant.c"
			}
#line 245 "enchant.vala"
			if (_tmp1_) {
#line 246 "enchant.vala"
				main_mode = MODE_L;
#line 1592 "enchant.c"
			}
		}
	}
#line 248 "enchant.vala"
	result = TRUE;
#line 248 "enchant.vala"
	return result;
#line 1600 "enchant.c"
}

static gchar*
g_unichar_to_string (gunichar self)
{
	gchar* str = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1122 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, 7);
#line 1122 "glib-2.0.vapi"
	str = (gchar*) _tmp0_;
#line 1123 "glib-2.0.vapi"
	g_unichar_to_utf8 (self, str);
#line 1124 "glib-2.0.vapi"
	result = str;
#line 1124 "glib-2.0.vapi"
	return result;
#line 1619 "enchant.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
#line 1503 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1503 "glib-2.0.vapi"
	end = _tmp0_;
#line 1504 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1504 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1505 "glib-2.0.vapi"
		result = maxlen;
#line 1505 "glib-2.0.vapi"
		return result;
#line 1642 "enchant.c"
	} else {
		gchar* _tmp2_;
#line 1507 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1507 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1507 "glib-2.0.vapi"
		return result;
#line 1651 "enchant.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
#line 1514 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1516 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 1670 "enchant.c"
	} else {
#line 1516 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 1674 "enchant.c"
	}
#line 1516 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1518 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 1680 "enchant.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1520 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1520 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1520 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 1690 "enchant.c"
	}
#line 1523 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1524 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1525 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 1698 "enchant.c"
	} else {
#line 1527 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 1702 "enchant.c"
	}
#line 1529 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1530 "glib-2.0.vapi"
		len = string_length - offset;
#line 1708 "enchant.c"
	}
#line 1532 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1533 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1533 "glib-2.0.vapi"
	result = _tmp3_;
#line 1533 "glib-2.0.vapi"
	return result;
#line 1718 "enchant.c"
}

static gpointer
_token_ref0 (gpointer self)
{
#line 374 "enchant.vala"
	return self ? token_ref (self) : NULL;
#line 1726 "enchant.c"
}

static void
_token_unref0_ (gpointer var)
{
#line 367 "enchant.vala"
	(var == NULL) ? NULL : (var = (token_unref (var), NULL));
#line 1734 "enchant.c"
}

static inline void
_g_slist_free__token_unref0_ (GSList* self)
{
#line 367 "enchant.vala"
	g_slist_free_full (self, (GDestroyNotify) _token_unref0_);
#line 1742 "enchant.c"
}

static gboolean
main_parse_file (FILE* fin)
{
	gboolean terse_mode = FALSE;
	gchar* lang = NULL;
	const gchar* _tmp1_;
	EnchantBroker* broker = NULL;
	EnchantBroker* _tmp8_;
	EnchantDict* dict = NULL;
	EnchantBroker* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	EnchantDict* _tmp12_;
	EnchantDict* _tmp13_;
	gboolean corrected_something = FALSE;
	gsize line_count = 0UL;
	gchar* str = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 251 "enchant.vala"
	g_return_val_if_fail (fin != NULL, FALSE);
#line 252 "enchant.vala"
	terse_mode = FALSE;
#line 254 "enchant.vala"
	if (main_mode == MODE_A) {
#line 1770 "enchant.c"
		FILE* _tmp0_;
#line 255 "enchant.vala"
		_tmp0_ = stdout;
#line 255 "enchant.vala"
		print_version (_tmp0_);
#line 1776 "enchant.c"
	}
#line 258 "enchant.vala"
	_tmp1_ = main_dictionary;
#line 258 "enchant.vala"
	if (_tmp1_ != NULL) {
#line 1782 "enchant.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 259 "enchant.vala"
		_tmp2_ = main_dictionary;
#line 259 "enchant.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 259 "enchant.vala"
		_g_free0 (lang);
#line 259 "enchant.vala"
		lang = _tmp3_;
#line 1793 "enchant.c"
	} else {
		gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
#line 261 "enchant.vala"
		_tmp4_ = enchant_get_user_language ();
#line 261 "enchant.vala"
		_g_free0 (lang);
#line 261 "enchant.vala"
		lang = _tmp4_;
#line 262 "enchant.vala"
		_tmp5_ = lang;
#line 262 "enchant.vala"
		if (_tmp5_ == NULL) {
#line 263 "enchant.vala"
			result = FALSE;
#line 263 "enchant.vala"
			_g_free0 (lang);
#line 263 "enchant.vala"
			return result;
#line 1814 "enchant.c"
		}
#line 264 "enchant.vala"
		_tmp6_ = lang;
#line 264 "enchant.vala"
		if (g_strcmp0 (_tmp6_, "C") == 0) {
#line 1820 "enchant.c"
			gchar* _tmp7_;
#line 265 "enchant.vala"
			_tmp7_ = g_strdup ("en");
#line 265 "enchant.vala"
			_g_free0 (lang);
#line 265 "enchant.vala"
			lang = _tmp7_;
#line 1828 "enchant.c"
		}
	}
#line 268 "enchant.vala"
	_tmp8_ = enchant_broker_init ();
#line 268 "enchant.vala"
	broker = _tmp8_;
#line 269 "enchant.vala"
	_tmp9_ = broker;
#line 269 "enchant.vala"
	_tmp10_ = lang;
#line 269 "enchant.vala"
	_tmp11_ = main_perslist;
#line 269 "enchant.vala"
	_tmp12_ = enchant_broker_request_dict_with_pwl (_tmp9_, _tmp10_, _tmp11_);
#line 269 "enchant.vala"
	dict = _tmp12_;
#line 271 "enchant.vala"
	_tmp13_ = dict;
#line 271 "enchant.vala"
	if (_tmp13_ == NULL) {
#line 1849 "enchant.c"
		FILE* _tmp14_;
		const gchar* _tmp15_;
		gchar* errmsg = NULL;
		EnchantBroker* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		FILE* _tmp22_;
#line 272 "enchant.vala"
		_tmp14_ = stderr;
#line 272 "enchant.vala"
		_tmp15_ = lang;
#line 272 "enchant.vala"
		fprintf (_tmp14_, "No dictionary available for '%s'", _tmp15_);
#line 273 "enchant.vala"
		_tmp16_ = broker;
#line 273 "enchant.vala"
		_tmp17_ = enchant_broker_get_error (_tmp16_);
#line 273 "enchant.vala"
		_tmp18_ = g_strdup (_tmp17_);
#line 273 "enchant.vala"
		errmsg = _tmp18_;
#line 274 "enchant.vala"
		_tmp19_ = errmsg;
#line 274 "enchant.vala"
		if (_tmp19_ != NULL) {
#line 1876 "enchant.c"
			FILE* _tmp20_;
			const gchar* _tmp21_;
#line 275 "enchant.vala"
			_tmp20_ = stderr;
#line 275 "enchant.vala"
			_tmp21_ = errmsg;
#line 275 "enchant.vala"
			fprintf (_tmp20_, ": %s", _tmp21_);
#line 1885 "enchant.c"
		}
#line 276 "enchant.vala"
		_tmp22_ = stderr;
#line 276 "enchant.vala"
		fputc ('\n', _tmp22_);
#line 278 "enchant.vala"
		result = FALSE;
#line 278 "enchant.vala"
		_g_free0 (errmsg);
#line 278 "enchant.vala"
		_enchant_broker_free0 (broker);
#line 278 "enchant.vala"
		_g_free0 (lang);
#line 278 "enchant.vala"
		return result;
#line 1901 "enchant.c"
	}
#line 281 "enchant.vala"
	corrected_something = FALSE;
#line 282 "enchant.vala"
	line_count = (gsize) 0;
#line 284 "enchant.vala"
	while (TRUE) {
#line 1909 "enchant.c"
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gboolean mode_A_no_command = FALSE;
		const gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gboolean _tmp112_ = FALSE;
		FILE* _tmp114_;
#line 284 "enchant.vala"
		_tmp23_ = get_line (fin);
#line 284 "enchant.vala"
		_g_free0 (str);
#line 284 "enchant.vala"
		str = _tmp23_;
#line 284 "enchant.vala"
		_tmp24_ = str;
#line 284 "enchant.vala"
		if (!(_tmp24_ != NULL)) {
#line 284 "enchant.vala"
			break;
#line 1930 "enchant.c"
		}
#line 285 "enchant.vala"
		mode_A_no_command = FALSE;
#line 287 "enchant.vala"
		if (main_count_lines) {
#line 1936 "enchant.c"
			gsize _tmp25_;
#line 288 "enchant.vala"
			_tmp25_ = line_count;
#line 288 "enchant.vala"
			line_count = _tmp25_ + 1;
#line 1942 "enchant.c"
		}
#line 290 "enchant.vala"
		_tmp26_ = str;
#line 290 "enchant.vala"
		_tmp27_ = strlen (_tmp26_);
#line 290 "enchant.vala"
		_tmp28_ = _tmp27_;
#line 290 "enchant.vala"
		if (_tmp28_ > 0) {
#line 1952 "enchant.c"
			gboolean _tmp90_ = FALSE;
#line 291 "enchant.vala"
			corrected_something = FALSE;
#line 293 "enchant.vala"
			if (main_mode == MODE_A) {
#line 1958 "enchant.c"
				{
					const gchar* _tmp29_;
#line 295 "enchant.vala"
					_tmp29_ = str;
#line 295 "enchant.vala"
					switch (string_get (_tmp29_, (glong) 0)) {
#line 295 "enchant.vala"
						case '&':
#line 1967 "enchant.c"
						{
							const gchar* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							const gchar* _tmp35_;
							gint _tmp36_;
							gint _tmp37_;
#line 297 "enchant.vala"
							_tmp30_ = str;
#line 297 "enchant.vala"
							_tmp31_ = strlen (_tmp30_);
#line 297 "enchant.vala"
							_tmp32_ = _tmp31_;
#line 297 "enchant.vala"
							if (_tmp32_ == 1) {
#line 1983 "enchant.c"
								GError* _tmp33_;
								gboolean _tmp34_ = FALSE;
#line 298 "enchant.vala"
								_tmp33_ = g_error_new_literal (SPELLING, SPELLING_EMPTY_WORD, "Word missing");
#line 298 "enchant.vala"
								_inner_error0_ = _tmp33_;
#line 298 "enchant.vala"
								if (_inner_error0_->domain == SPELLING) {
#line 1992 "enchant.c"
									goto __catch0_spelling;
								}
#line 298 "enchant.vala"
								_g_free0 (str);
#line 298 "enchant.vala"
								_enchant_broker_free0 (broker);
#line 298 "enchant.vala"
								_g_free0 (lang);
#line 298 "enchant.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 298 "enchant.vala"
								g_clear_error (&_inner_error0_);
#line 298 "enchant.vala"
								return _tmp34_;
#line 2007 "enchant.c"
							}
#line 299 "enchant.vala"
							_tmp35_ = str;
#line 299 "enchant.vala"
							_tmp36_ = strlen (_tmp35_);
#line 299 "enchant.vala"
							_tmp37_ = _tmp36_;
#line 299 "enchant.vala"
							if (_tmp37_ > 1) {
#line 2017 "enchant.c"
								const gchar* new_word = NULL;
								const gchar* _tmp38_;
								const gchar* _tmp39_;
								gunichar c = 0U;
								const gchar* _tmp40_;
#line 300 "enchant.vala"
								_tmp38_ = str;
#line 300 "enchant.vala"
								_tmp39_ = g_utf8_next_char (_tmp38_);
#line 300 "enchant.vala"
								new_word = _tmp39_;
#line 301 "enchant.vala"
								_tmp40_ = new_word;
#line 301 "enchant.vala"
								c = g_utf8_get_char_validated (_tmp40_, (gssize) -1);
#line 302 "enchant.vala"
								if (c > ((gunichar) 0)) {
#line 2035 "enchant.c"
									EnchantDict* _tmp41_;
									gchar* _tmp42_;
									gchar* _tmp43_;
									const gchar* _tmp44_;
									const gchar* _tmp45_;
									gchar* _tmp46_;
									gchar* _tmp47_;
#line 303 "enchant.vala"
									_tmp41_ = dict;
#line 303 "enchant.vala"
									_tmp42_ = g_unichar_to_string (g_unichar_tolower (c));
#line 303 "enchant.vala"
									_tmp43_ = _tmp42_;
#line 303 "enchant.vala"
									_tmp44_ = new_word;
#line 303 "enchant.vala"
									_tmp45_ = g_utf8_next_char (_tmp44_);
#line 303 "enchant.vala"
									_tmp46_ = g_strconcat (_tmp43_, _tmp45_, NULL);
#line 303 "enchant.vala"
									_tmp47_ = _tmp46_;
#line 303 "enchant.vala"
									enchant_dict_add (_tmp41_, _tmp47_, (glong) -1);
#line 303 "enchant.vala"
									_g_free0 (_tmp47_);
#line 303 "enchant.vala"
									_g_free0 (_tmp43_);
#line 2063 "enchant.c"
								} else {
									EnchantDict* _tmp48_;
									const gchar* _tmp49_;
#line 305 "enchant.vala"
									_tmp48_ = dict;
#line 305 "enchant.vala"
									_tmp49_ = new_word;
#line 305 "enchant.vala"
									enchant_dict_add (_tmp48_, _tmp49_, (glong) -1);
#line 2073 "enchant.c"
								}
							}
#line 307 "enchant.vala"
							break;
#line 2078 "enchant.c"
						}
#line 295 "enchant.vala"
						case '*':
#line 2082 "enchant.c"
						{
							const gchar* _tmp50_;
							gint _tmp51_;
							gint _tmp52_;
							EnchantDict* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
#line 309 "enchant.vala"
							_tmp50_ = str;
#line 309 "enchant.vala"
							_tmp51_ = strlen (_tmp50_);
#line 309 "enchant.vala"
							_tmp52_ = _tmp51_;
#line 309 "enchant.vala"
							if (_tmp52_ == 1) {
#line 2098 "enchant.c"
								GError* _tmp53_;
								gboolean _tmp54_ = FALSE;
#line 310 "enchant.vala"
								_tmp53_ = g_error_new_literal (SPELLING, SPELLING_EMPTY_WORD, "Word missing");
#line 310 "enchant.vala"
								_inner_error0_ = _tmp53_;
#line 310 "enchant.vala"
								if (_inner_error0_->domain == SPELLING) {
#line 2107 "enchant.c"
									goto __catch0_spelling;
								}
#line 310 "enchant.vala"
								_g_free0 (str);
#line 310 "enchant.vala"
								_enchant_broker_free0 (broker);
#line 310 "enchant.vala"
								_g_free0 (lang);
#line 310 "enchant.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 310 "enchant.vala"
								g_clear_error (&_inner_error0_);
#line 310 "enchant.vala"
								return _tmp54_;
#line 2122 "enchant.c"
							}
#line 311 "enchant.vala"
							_tmp55_ = dict;
#line 311 "enchant.vala"
							_tmp56_ = str;
#line 311 "enchant.vala"
							_tmp57_ = g_utf8_next_char (_tmp56_);
#line 311 "enchant.vala"
							enchant_dict_add (_tmp55_, _tmp57_, (glong) -1);
#line 312 "enchant.vala"
							break;
#line 2134 "enchant.c"
						}
#line 295 "enchant.vala"
						case '@':
#line 2138 "enchant.c"
						{
							const gchar* _tmp58_;
							gint _tmp59_;
							gint _tmp60_;
							EnchantDict* _tmp63_;
							const gchar* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
#line 314 "enchant.vala"
							_tmp58_ = str;
#line 314 "enchant.vala"
							_tmp59_ = strlen (_tmp58_);
#line 314 "enchant.vala"
							_tmp60_ = _tmp59_;
#line 314 "enchant.vala"
							if (_tmp60_ == 1) {
#line 2155 "enchant.c"
								GError* _tmp61_;
								gboolean _tmp62_ = FALSE;
#line 315 "enchant.vala"
								_tmp61_ = g_error_new_literal (SPELLING, SPELLING_EMPTY_WORD, "Word missing");
#line 315 "enchant.vala"
								_inner_error0_ = _tmp61_;
#line 315 "enchant.vala"
								if (_inner_error0_->domain == SPELLING) {
#line 2164 "enchant.c"
									goto __catch0_spelling;
								}
#line 315 "enchant.vala"
								_g_free0 (str);
#line 315 "enchant.vala"
								_enchant_broker_free0 (broker);
#line 315 "enchant.vala"
								_g_free0 (lang);
#line 315 "enchant.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 315 "enchant.vala"
								g_clear_error (&_inner_error0_);
#line 315 "enchant.vala"
								return _tmp62_;
#line 2179 "enchant.c"
							}
#line 316 "enchant.vala"
							_tmp63_ = dict;
#line 316 "enchant.vala"
							_tmp64_ = str;
#line 316 "enchant.vala"
							_tmp65_ = string_substring (_tmp64_, (glong) 1, (glong) -1);
#line 316 "enchant.vala"
							_tmp66_ = _tmp65_;
#line 316 "enchant.vala"
							enchant_dict_add_to_session (_tmp63_, _tmp66_, (glong) -1);
#line 316 "enchant.vala"
							_g_free0 (_tmp66_);
#line 317 "enchant.vala"
							break;
#line 2195 "enchant.c"
						}
#line 295 "enchant.vala"
						case '/':
#line 2199 "enchant.c"
						{
							const gchar* _tmp67_;
							gint _tmp68_;
							gint _tmp69_;
							EnchantDict* _tmp72_;
							const gchar* _tmp73_;
							gchar* _tmp74_;
							gchar* _tmp75_;
#line 319 "enchant.vala"
							_tmp67_ = str;
#line 319 "enchant.vala"
							_tmp68_ = strlen (_tmp67_);
#line 319 "enchant.vala"
							_tmp69_ = _tmp68_;
#line 319 "enchant.vala"
							if (_tmp69_ == 1) {
#line 2216 "enchant.c"
								GError* _tmp70_;
								gboolean _tmp71_ = FALSE;
#line 320 "enchant.vala"
								_tmp70_ = g_error_new_literal (SPELLING, SPELLING_EMPTY_WORD, "Word missing");
#line 320 "enchant.vala"
								_inner_error0_ = _tmp70_;
#line 320 "enchant.vala"
								if (_inner_error0_->domain == SPELLING) {
#line 2225 "enchant.c"
									goto __catch0_spelling;
								}
#line 320 "enchant.vala"
								_g_free0 (str);
#line 320 "enchant.vala"
								_enchant_broker_free0 (broker);
#line 320 "enchant.vala"
								_g_free0 (lang);
#line 320 "enchant.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 320 "enchant.vala"
								g_clear_error (&_inner_error0_);
#line 320 "enchant.vala"
								return _tmp71_;
#line 2240 "enchant.c"
							}
#line 321 "enchant.vala"
							_tmp72_ = dict;
#line 321 "enchant.vala"
							_tmp73_ = str;
#line 321 "enchant.vala"
							_tmp74_ = string_substring (_tmp73_, (glong) 1, (glong) -1);
#line 321 "enchant.vala"
							_tmp75_ = _tmp74_;
#line 321 "enchant.vala"
							enchant_dict_remove (_tmp72_, _tmp75_, (glong) -1);
#line 321 "enchant.vala"
							_g_free0 (_tmp75_);
#line 322 "enchant.vala"
							break;
#line 2256 "enchant.c"
						}
#line 295 "enchant.vala"
						case '_':
#line 2260 "enchant.c"
						{
							const gchar* _tmp76_;
							gint _tmp77_;
							gint _tmp78_;
							EnchantDict* _tmp81_;
							const gchar* _tmp82_;
							gchar* _tmp83_;
							gchar* _tmp84_;
#line 324 "enchant.vala"
							_tmp76_ = str;
#line 324 "enchant.vala"
							_tmp77_ = strlen (_tmp76_);
#line 324 "enchant.vala"
							_tmp78_ = _tmp77_;
#line 324 "enchant.vala"
							if (_tmp78_ == 1) {
#line 2277 "enchant.c"
								GError* _tmp79_;
								gboolean _tmp80_ = FALSE;
#line 325 "enchant.vala"
								_tmp79_ = g_error_new_literal (SPELLING, SPELLING_EMPTY_WORD, "Word missing");
#line 325 "enchant.vala"
								_inner_error0_ = _tmp79_;
#line 325 "enchant.vala"
								if (_inner_error0_->domain == SPELLING) {
#line 2286 "enchant.c"
									goto __catch0_spelling;
								}
#line 325 "enchant.vala"
								_g_free0 (str);
#line 325 "enchant.vala"
								_enchant_broker_free0 (broker);
#line 325 "enchant.vala"
								_g_free0 (lang);
#line 325 "enchant.vala"
								g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 325 "enchant.vala"
								g_clear_error (&_inner_error0_);
#line 325 "enchant.vala"
								return _tmp80_;
#line 2301 "enchant.c"
							}
#line 326 "enchant.vala"
							_tmp81_ = dict;
#line 326 "enchant.vala"
							_tmp82_ = str;
#line 326 "enchant.vala"
							_tmp83_ = string_substring (_tmp82_, (glong) 1, (glong) -1);
#line 326 "enchant.vala"
							_tmp84_ = _tmp83_;
#line 326 "enchant.vala"
							enchant_dict_remove_from_session (_tmp81_, _tmp84_, (glong) -1);
#line 326 "enchant.vala"
							_g_free0 (_tmp84_);
#line 327 "enchant.vala"
							break;
#line 2317 "enchant.c"
						}
#line 295 "enchant.vala"
						case '%':
#line 2321 "enchant.c"
						{
#line 330 "enchant.vala"
							terse_mode = FALSE;
#line 331 "enchant.vala"
							break;
#line 2327 "enchant.c"
						}
#line 295 "enchant.vala"
						case '!':
#line 2331 "enchant.c"
						{
#line 333 "enchant.vala"
							terse_mode = TRUE;
#line 334 "enchant.vala"
							break;
#line 2337 "enchant.c"
						}
#line 295 "enchant.vala"
						case '#':
#line 295 "enchant.vala"
						case '+':
#line 295 "enchant.vala"
						case '-':
#line 295 "enchant.vala"
						case '~':
#line 295 "enchant.vala"
						case '`':
#line 2349 "enchant.c"
						{
#line 342 "enchant.vala"
							break;
#line 2353 "enchant.c"
						}
#line 295 "enchant.vala"
						case '$':
#line 2357 "enchant.c"
						{
							{
								const gchar* _tmp85_;
#line 347 "enchant.vala"
								_tmp85_ = str;
#line 347 "enchant.vala"
								if (g_str_has_prefix (_tmp85_, "$$ra ")) {
#line 2365 "enchant.c"
								} else {
									const gchar* _tmp86_;
#line 349 "enchant.vala"
									_tmp86_ = str;
#line 349 "enchant.vala"
									if (g_str_has_prefix (_tmp86_, "$$wc")) {
#line 2372 "enchant.c"
										EnchantDict* _tmp87_;
										const gchar* _tmp88_;
#line 351 "enchant.vala"
										_tmp87_ = dict;
#line 351 "enchant.vala"
										_tmp88_ = enchant_dict_get_extra_word_characters (_tmp87_);
#line 351 "enchant.vala"
										g_print ("%s\n", _tmp88_);
#line 2381 "enchant.c"
									}
								}
							}
#line 353 "enchant.vala"
							break;
#line 2387 "enchant.c"
						}
						default:
#line 295 "enchant.vala"
						case '^':
#line 2392 "enchant.c"
						{
#line 359 "enchant.vala"
							mode_A_no_command = TRUE;
#line 360 "enchant.vala"
							break;
#line 2398 "enchant.c"
						}
					}
				}
				goto __finally0;
				__catch0_spelling:
				{
#line 294 "enchant.vala"
					g_clear_error (&_inner_error0_);
#line 363 "enchant.vala"
					g_print ("Error: The word \"\" is invalid. Empty string.\n");
#line 2409 "enchant.c"
				}
				__finally0:
#line 294 "enchant.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2414 "enchant.c"
					gboolean _tmp89_ = FALSE;
#line 294 "enchant.vala"
					_g_free0 (str);
#line 294 "enchant.vala"
					_enchant_broker_free0 (broker);
#line 294 "enchant.vala"
					_g_free0 (lang);
#line 294 "enchant.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 294 "enchant.vala"
					g_clear_error (&_inner_error0_);
#line 294 "enchant.vala"
					return _tmp89_;
#line 2428 "enchant.c"
				}
			}
#line 367 "enchant.vala"
			if (main_mode != MODE_A) {
#line 367 "enchant.vala"
				_tmp90_ = TRUE;
#line 2435 "enchant.c"
			} else {
#line 367 "enchant.vala"
				_tmp90_ = mode_A_no_command;
#line 2439 "enchant.c"
			}
#line 367 "enchant.vala"
			if (_tmp90_) {
#line 2443 "enchant.c"
				GSList* tokens = NULL;
				EnchantDict* _tmp91_;
				const gchar* _tmp92_;
				GSList* _tmp93_;
				GSList* _tmp94_;
#line 368 "enchant.vala"
				_tmp91_ = dict;
#line 368 "enchant.vala"
				_tmp92_ = str;
#line 368 "enchant.vala"
				_tmp93_ = tokenize_line (_tmp91_, _tmp92_);
#line 368 "enchant.vala"
				tokens = _tmp93_;
#line 369 "enchant.vala"
				_tmp94_ = tokens;
#line 369 "enchant.vala"
				if (_tmp94_ == NULL) {
#line 2461 "enchant.c"
					FILE* _tmp95_;
#line 370 "enchant.vala"
					_tmp95_ = stdout;
#line 370 "enchant.vala"
					fputc ('\n', _tmp95_);
#line 2467 "enchant.c"
				}
				{
					GSList* tok_ptr = NULL;
					GSList* _tmp96_;
#line 371 "enchant.vala"
					_tmp96_ = tokens;
#line 371 "enchant.vala"
					tok_ptr = _tmp96_;
#line 2476 "enchant.c"
					{
						gboolean _tmp97_ = FALSE;
#line 371 "enchant.vala"
						_tmp97_ = TRUE;
#line 371 "enchant.vala"
						while (TRUE) {
#line 2483 "enchant.c"
							GSList* _tmp100_;
							Token* token = NULL;
							GSList* _tmp101_;
							gconstpointer _tmp102_;
							Token* _tmp103_;
							gchar* word = NULL;
							Token* _tmp104_;
							const gchar* _tmp105_;
							gchar* _tmp106_;
							gsize pos = 0UL;
							Token* _tmp107_;
#line 371 "enchant.vala"
							if (!_tmp97_) {
#line 2497 "enchant.c"
								GSList* _tmp98_;
								GSList* _tmp99_;
#line 371 "enchant.vala"
								_tmp98_ = tok_ptr;
#line 371 "enchant.vala"
								_tmp99_ = _tmp98_->next;
#line 371 "enchant.vala"
								tok_ptr = _tmp99_;
#line 2506 "enchant.c"
							}
#line 371 "enchant.vala"
							_tmp97_ = FALSE;
#line 371 "enchant.vala"
							_tmp100_ = tok_ptr;
#line 371 "enchant.vala"
							if (!(_tmp100_ != NULL)) {
#line 371 "enchant.vala"
								break;
#line 2516 "enchant.c"
							}
#line 372 "enchant.vala"
							corrected_something = TRUE;
#line 374 "enchant.vala"
							_tmp101_ = tok_ptr;
#line 374 "enchant.vala"
							_tmp102_ = _tmp101_->data;
#line 374 "enchant.vala"
							_tmp103_ = _token_ref0 ((Token*) _tmp102_);
#line 374 "enchant.vala"
							token = _tmp103_;
#line 375 "enchant.vala"
							_tmp104_ = token;
#line 375 "enchant.vala"
							_tmp105_ = _tmp104_->word;
#line 375 "enchant.vala"
							_tmp106_ = g_strdup (_tmp105_);
#line 375 "enchant.vala"
							word = _tmp106_;
#line 376 "enchant.vala"
							_tmp107_ = token;
#line 376 "enchant.vala"
							pos = (gsize) _tmp107_->pos;
#line 378 "enchant.vala"
							if (main_mode == MODE_A) {
#line 2542 "enchant.c"
								EnchantDict* _tmp108_;
								const gchar* _tmp109_;
#line 379 "enchant.vala"
								_tmp108_ = dict;
#line 379 "enchant.vala"
								_tmp109_ = word;
#line 379 "enchant.vala"
								do_mode_a (_tmp108_, _tmp109_, pos, line_count, terse_mode);
#line 2551 "enchant.c"
							} else {
#line 380 "enchant.vala"
								if (main_mode == MODE_L) {
#line 2555 "enchant.c"
									EnchantDict* _tmp110_;
									const gchar* _tmp111_;
#line 381 "enchant.vala"
									_tmp110_ = dict;
#line 381 "enchant.vala"
									_tmp111_ = word;
#line 381 "enchant.vala"
									do_mode_l (_tmp110_, _tmp111_, line_count);
#line 2564 "enchant.c"
								}
							}
#line 371 "enchant.vala"
							_g_free0 (word);
#line 371 "enchant.vala"
							_token_unref0 (token);
#line 2571 "enchant.c"
						}
					}
				}
#line 367 "enchant.vala"
				(tokens == NULL) ? NULL : (tokens = (_g_slist_free__token_unref0_ (tokens), NULL));
#line 2577 "enchant.c"
			}
		}
#line 386 "enchant.vala"
		if (main_mode == MODE_A) {
#line 386 "enchant.vala"
			_tmp112_ = corrected_something;
#line 2584 "enchant.c"
		} else {
#line 386 "enchant.vala"
			_tmp112_ = FALSE;
#line 2588 "enchant.c"
		}
#line 386 "enchant.vala"
		if (_tmp112_) {
#line 2592 "enchant.c"
			FILE* _tmp113_;
#line 387 "enchant.vala"
			_tmp113_ = stdout;
#line 387 "enchant.vala"
			fputc ('\n', _tmp113_);
#line 2598 "enchant.c"
		}
#line 388 "enchant.vala"
		_tmp114_ = stdout;
#line 388 "enchant.vala"
		fflush (_tmp114_);
#line 2604 "enchant.c"
	}
#line 391 "enchant.vala"
	result = TRUE;
#line 391 "enchant.vala"
	_g_free0 (str);
#line 391 "enchant.vala"
	_enchant_broker_free0 (broker);
#line 391 "enchant.vala"
	_g_free0 (lang);
#line 391 "enchant.vala"
	return result;
#line 2616 "enchant.c"
}

static gint
main_main (gchar** args,
           gint args_length1)
{
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GOptionContext* ctx = NULL;
	GOptionContext* _tmp2_;
	FILE* fp = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp11_;
	gint _tmp11__length1;
	GError* _inner_error0_ = NULL;
	gint result;
#line 396 "enchant.vala"
	setlocale (LC_ALL, "");
#line 397 "enchant.vala"
	g_get_charset (&_tmp0_);
#line 397 "enchant.vala"
	_g_free0 (charset);
#line 397 "enchant.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 397 "enchant.vala"
	charset = _tmp1_;
#line 399 "enchant.vala"
	_tmp2_ = g_option_context_new ("\n\nCheck spelling non-interactively.");
#line 399 "enchant.vala"
	ctx = _tmp2_;
#line 400 "enchant.vala"
	g_option_context_set_help_enabled (ctx, TRUE);
#line 401 "enchant.vala"
	g_option_context_add_main_entries (ctx, MAIN_main_options, NULL);
#line 2652 "enchant.c"
	{
#line 403 "enchant.vala"
		g_option_context_parse (ctx, (gint*) (&args_length1), &args, &_inner_error0_);
#line 403 "enchant.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2658 "enchant.c"
			gint _tmp3_ = -1;
#line 403 "enchant.vala"
			if (_inner_error0_->domain == G_OPTION_ERROR) {
#line 2662 "enchant.c"
				goto __catch0_g_option_error;
			}
#line 403 "enchant.vala"
			_g_option_context_free0 (ctx);
#line 403 "enchant.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 403 "enchant.vala"
			g_clear_error (&_inner_error0_);
#line 403 "enchant.vala"
			return _tmp3_;
#line 2673 "enchant.c"
		}
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
#line 402 "enchant.vala"
		e = _inner_error0_;
#line 402 "enchant.vala"
		_inner_error0_ = NULL;
#line 405 "enchant.vala"
		_tmp4_ = e;
#line 405 "enchant.vala"
		_tmp5_ = _tmp4_->message;
#line 405 "enchant.vala"
		g_printerr ("%s-%s: %s\n", PACKAGE, ENCHANT_MAJOR_VERSION, _tmp5_);
#line 406 "enchant.vala"
		usage (ctx);
#line 402 "enchant.vala"
		_g_error_free0 (e);
#line 2696 "enchant.c"
	}
	__finally0:
#line 402 "enchant.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2701 "enchant.c"
		gint _tmp6_ = -1;
#line 402 "enchant.vala"
		_g_option_context_free0 (ctx);
#line 402 "enchant.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 402 "enchant.vala"
		g_clear_error (&_inner_error0_);
#line 402 "enchant.vala"
		return _tmp6_;
#line 2711 "enchant.c"
	}
#line 409 "enchant.vala"
	if (main_version) {
#line 2715 "enchant.c"
		FILE* _tmp7_;
#line 410 "enchant.vala"
		_tmp7_ = stdout;
#line 410 "enchant.vala"
		print_version (_tmp7_);
#line 411 "enchant.vala"
		exit (0);
#line 2723 "enchant.c"
	}
#line 415 "enchant.vala"
	if (main_mode == MODE_NONE) {
#line 416 "enchant.vala"
		usage (ctx);
#line 2729 "enchant.c"
	}
#line 419 "enchant.vala"
	fp = NULL;
#line 420 "enchant.vala"
	_tmp8_ = main_files;
#line 420 "enchant.vala"
	_tmp8__length1 = _vala_array_length (main_files);
#line 420 "enchant.vala"
	if (_tmp8_ == NULL) {
#line 2739 "enchant.c"
		gint _tmp9_ = 0;
		FILE* _tmp10_;
#line 421 "enchant.vala"
		_tmp10_ = stdin;
#line 421 "enchant.vala"
		if (main_parse_file (_tmp10_)) {
#line 421 "enchant.vala"
			_tmp9_ = 0;
#line 2748 "enchant.c"
		} else {
#line 421 "enchant.vala"
			_tmp9_ = 1;
#line 2752 "enchant.c"
		}
#line 421 "enchant.vala"
		result = _tmp9_;
#line 421 "enchant.vala"
		_fclose0 (fp);
#line 421 "enchant.vala"
		_g_option_context_free0 (ctx);
#line 421 "enchant.vala"
		return result;
#line 2762 "enchant.c"
	}
#line 423 "enchant.vala"
	_tmp11_ = main_files;
#line 423 "enchant.vala"
	_tmp11__length1 = _vala_array_length (main_files);
#line 2768 "enchant.c"
	{
		gchar** f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 423 "enchant.vala"
		f_collection = _tmp11_;
#line 423 "enchant.vala"
		f_collection_length1 = _tmp11__length1;
#line 423 "enchant.vala"
		for (f_it = 0; f_it < f_collection_length1; f_it = f_it + 1) {
#line 2780 "enchant.c"
			gchar* _tmp12_;
			gchar* f = NULL;
#line 423 "enchant.vala"
			_tmp12_ = g_strdup (f_collection[f_it]);
#line 423 "enchant.vala"
			f = _tmp12_;
#line 2787 "enchant.c"
			{
				const gchar* _tmp13_;
				FILE* _tmp14_;
				FILE* _tmp15_;
				FILE* _tmp18_;
#line 424 "enchant.vala"
				_tmp13_ = f;
#line 424 "enchant.vala"
				_tmp14_ = g_fopen (_tmp13_, "rb");
#line 424 "enchant.vala"
				_fclose0 (fp);
#line 424 "enchant.vala"
				fp = _tmp14_;
#line 425 "enchant.vala"
				_tmp15_ = fp;
#line 425 "enchant.vala"
				if (_tmp15_ == NULL) {
#line 2805 "enchant.c"
					FILE* _tmp16_;
					const gchar* _tmp17_;
#line 426 "enchant.vala"
					_tmp16_ = stderr;
#line 426 "enchant.vala"
					_tmp17_ = f;
#line 426 "enchant.vala"
					fprintf (_tmp16_, "Error: Could not open the file \"%s\" for reading.\n", _tmp17_);
#line 427 "enchant.vala"
					exit (1);
#line 2816 "enchant.c"
				}
#line 429 "enchant.vala"
				_tmp18_ = fp;
#line 429 "enchant.vala"
				if (!main_parse_file (_tmp18_)) {
#line 430 "enchant.vala"
					exit (1);
#line 2824 "enchant.c"
				}
#line 423 "enchant.vala"
				_g_free0 (f);
#line 2828 "enchant.c"
			}
		}
	}
#line 432 "enchant.vala"
	result = 0;
#line 432 "enchant.vala"
	_fclose0 (fp);
#line 432 "enchant.vala"
	_g_option_context_free0 (ctx);
#line 432 "enchant.vala"
	return result;
#line 2840 "enchant.c"
}

int
main (int argc,
      char ** argv)
{
#line 394 "enchant.vala"
	return main_main (argv, argc);
#line 2849 "enchant.c"
}

Main*
main_construct (GType object_type)
{
	Main * self = NULL;
#line 213 "enchant.vala"
	self = (Main*) g_object_new (object_type, NULL);
#line 213 "enchant.vala"
	return self;
#line 2860 "enchant.c"
}

Main*
main_new (void)
{
#line 213 "enchant.vala"
	return main_construct (TYPE_MAIN);
#line 2868 "enchant.c"
}

static void
main_class_init (MainClass * klass,
                 gpointer klass_data)
{
#line 213 "enchant.vala"
	main_parent_class = g_type_class_peek_parent (klass);
#line 213 "enchant.vala"
	G_OBJECT_CLASS (klass)->finalize = main_finalize;
#line 2879 "enchant.c"
}

static void
main_instance_init (Main * self,
                    gpointer klass)
{
}

static void
main_finalize (GObject * obj)
{
	Main * self;
#line 213 "enchant.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN, Main);
#line 213 "enchant.vala"
	G_OBJECT_CLASS (main_parent_class)->finalize (obj);
#line 2896 "enchant.c"
}

static GType
main_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, NULL };
	GType main_type_id;
	main_type_id = g_type_register_static (G_TYPE_OBJECT, "Main", &g_define_type_info, 0);
	return main_type_id;
}

GType
main_get_type (void)
{
	static volatile gsize main_type_id__once = 0;
	if (g_once_init_enter (&main_type_id__once)) {
		GType main_type_id;
		main_type_id = main_get_type_once ();
		g_once_init_leave (&main_type_id__once, main_type_id);
	}
	return main_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

