/* SPDX-License-Identifier: GPL-2.0+ */
/*
 * DA9121 Single-channel dual-phase 10A buck converter
 * DA9130 Single-channel dual-phase 10A buck converter (Automotive)
 * DA9217 Single-channel dual-phase  6A buck converter
 * DA9122 Dual-channel single-phase  5A buck converter
 * DA9131 Dual-channel single-phase  5A buck converter (Automotive)
 * DA9220 Dual-channel single-phase  3A buck converter
 * DA9132 Dual-channel single-phase  3A buck converter (Automotive)
 *
 * Copyright (C) 2020  Dialog Semiconductor
 *
 * Authors: Steve Twiss, Dialog Semiconductor
 *          Adam Ward, Dialog Semiconductor
 */

#ifndef __DA9121_REGISTERS_H__
#define __DA9121_REGISTERS_H__

/* Values for: DA9121_REG_BUCK_BUCKx_4 registers, fields CHx_y_MODE
 *             DA9121_REG_BUCK_BUCKx_7 registers, fields CHx_RIPPLE_CANCEL
 */
#include <dt-bindings/regulator/dlg,da9121-regulator.h>

enum da9121_variant {
	DA9121_TYPE_DA9121_DA9130,
	DA9121_TYPE_DA9220_DA9132,
	DA9121_TYPE_DA9122_DA9131,
	DA9121_TYPE_DA9217,
	DA9121_TYPE_DA9141,
	DA9121_TYPE_DA9142
};

enum da9121_subvariant {
	DA9121_SUBTYPE_DA9121,
	DA9121_SUBTYPE_DA9130,
	DA9121_SUBTYPE_DA9220,
	DA9121_SUBTYPE_DA9132,
	DA9121_SUBTYPE_DA9122,
	DA9121_SUBTYPE_DA9131,
	DA9121_SUBTYPE_DA9217,
	DA9121_SUBTYPE_DA9141,
	DA9121_SUBTYPE_DA9142
};

/* Minimum, maximum and default polling millisecond periods are provided
 * here as an example. It is expected that any final implementation will
 * include a modification of these settings to match the required
 * application.
 */
#define DA9121_DEFAULT_POLLING_PERIOD_MS	3000
#define DA9121_MAX_POLLING_PERIOD_MS		10000
#define DA9121_MIN_POLLING_PERIOD_MS		1000

/* Registers */

#define DA9121_REG_SYS_STATUS_0		0x01
#define DA9121_REG_SYS_STATUS_1		0x02
#define DA9121_REG_SYS_STATUS_2		0x03
#define DA9121_REG_SYS_EVENT_0		0x04
#define DA9121_REG_SYS_EVENT_1		0x05
#define DA9121_REG_SYS_EVENT_2		0x06
#define DA9121_REG_SYS_MASK_0		0x07
#define DA9121_REG_SYS_MASK_1		0x08
#define DA9121_REG_SYS_MASK_2		0x09
#define DA9121_REG_SYS_MASK_3		0x0A
#define DA9121_REG_SYS_CONFIG_0		0x0B
#define DA9121_REG_SYS_CONFIG_1		0x0C
#define DA9121_REG_SYS_CONFIG_2		0x0D
#define DA9121_REG_SYS_CONFIG_3		0x0E
#define DA9121_REG_SYS_GPIO0_0		0x10
#define DA9121_REG_SYS_GPIO0_1		0x11
#define DA9121_REG_SYS_GPIO1_0		0x12
#define DA9121_REG_SYS_GPIO1_1		0x13
#define DA9121_REG_SYS_GPIO2_0		0x14
#define DA9121_REG_SYS_GPIO2_1		0x15
#define DA914x_REG_SYS_GPIO3_0		0x16
#define DA914x_REG_SYS_GPIO3_1		0x17
#define DA914x_REG_SYS_GPIO4_0		0x18
#define DA914x_REG_SYS_GPIO4_1		0x19
#define DA914x_REG_SYS_ADMUX1_0		0x1A
#define DA914x_REG_SYS_ADMUX1_1		0x1B
#define DA914x_REG_SYS_ADMUX2_0		0x1C
#define DA914x_REG_SYS_ADMUX2_1		0x1D
#define DA9121_REG_BUCK_BUCK1_0		0x20
#define DA9121_REG_BUCK_BUCK1_1		0x21
#define DA9121_REG_BUCK_BUCK1_2		0x22
#define DA9121_REG_BUCK_BUCK1_3		0x23
#define DA9121_REG_BUCK_BUCK1_4		0x24
#define DA9121_REG_BUCK_BUCK1_5		0x25
#define DA9121_REG_BUCK_BUCK1_6		0x26
#define DA9121_REG_BUCK_BUCK1_7		0x27
#define DA9xxx_REG_BUCK_BUCK2_0		0x28
#define DA9xxx_REG_BUCK_BUCK2_1		0x29
#define DA9xxx_REG_BUCK_BUCK2_2		0x2A
#define DA9xxx_REG_BUCK_BUCK2_3		0x2B
#define DA9xxx_REG_BUCK_BUCK2_4		0x2C
#define DA9xxx_REG_BUCK_BUCK2_5		0x2D
#define DA9xxx_REG_BUCK_BUCK2_6		0x2E
#define DA9xxx_REG_BUCK_BUCK2_7		0x2F
#define DA9121_REG_OTP_DEVICE_ID	0x48
#define DA9121_REG_OTP_VARIANT_ID	0x49
#define DA9121_REG_OTP_CUSTOMER_ID	0x4A
#define DA9121_REG_OTP_CONFIG_ID	0x4B

/* Register bits */

/* DA9121_REG_SYS_STATUS_0 */

#define DA9xxx_MASK_SYS_STATUS_0_SG			BIT(2)
#define DA9121_MASK_SYS_STATUS_0_TEMP_CRIT		BIT(1)
#define DA9121_MASK_SYS_STATUS_0_TEMP_WARN		BIT(0)

/* DA9121_REG_SYS_STATUS_1 */

#define DA9xxx_MASK_SYS_STATUS_1_PG2			BIT(7)
#define DA9xxx_MASK_SYS_STATUS_1_OV2			BIT(6)
#define DA9xxx_MASK_SYS_STATUS_1_UV2			BIT(5)
#define DA9xxx_MASK_SYS_STATUS_1_OC2			BIT(4)
#define DA9121_MASK_SYS_STATUS_1_PG1			BIT(3)
#define DA9121_MASK_SYS_STATUS_1_OV1			BIT(2)
#define DA9121_MASK_SYS_STATUS_1_UV1			BIT(1)
#define DA9121_MASK_SYS_STATUS_1_OC1			BIT(0)

/* DA9121_REG_SYS_STATUS_2 */

#define DA9121_MASK_SYS_STATUS_2_GPIO2			BIT(2)
#define DA9121_MASK_SYS_STATUS_2_GPIO1			BIT(1)
#define DA9121_MASK_SYS_STATUS_2_GPIO0			BIT(0)

/* DA9121_REG_SYS_EVENT_0 */

#define DA9xxx_MASK_SYS_EVENT_0_E_SG			BIT(2)
#define DA9121_MASK_SYS_EVENT_0_E_TEMP_CRIT		BIT(1)
#define DA9121_MASK_SYS_EVENT_0_E_TEMP_WARN		BIT(0)

/* DA9121_REG_SYS_EVENT_1 */

#define DA9xxx_MASK_SYS_EVENT_1_E_PG2			BIT(7)
#define DA9xxx_MASK_SYS_EVENT_1_E_OV2			BIT(6)
#define DA9xxx_MASK_SYS_EVENT_1_E_UV2			BIT(5)
#define DA9xxx_MASK_SYS_EVENT_1_E_OC2			BIT(4)
#define DA9121_MASK_SYS_EVENT_1_E_PG1			BIT(3)
#define DA9121_MASK_SYS_EVENT_1_E_OV1			BIT(2)
#define DA9121_MASK_SYS_EVENT_1_E_UV1			BIT(1)
#define DA9121_MASK_SYS_EVENT_1_E_OC1			BIT(0)

/* DA9121_REG_SYS_EVENT_2 */

#define DA9121_MASK_SYS_EVENT_2_E_GPIO2			BIT(2)
#define DA9121_MASK_SYS_EVENT_2_E_GPIO1			BIT(1)
#define DA9121_MASK_SYS_EVENT_2_E_GPIO0			BIT(0)

/* DA9121_REG_SYS_MASK_0 */

#define DA9xxx_MASK_SYS_MASK_0_M_SG			BIT(2)
#define DA9121_MASK_SYS_MASK_0_M_TEMP_CRIT		BIT(1)
#define DA9121_MASK_SYS_MASK_0_M_TEMP_WARN		BIT(0)

/* DA9121_REG_SYS_MASK_1 */

#define DA9xxx_MASK_SYS_MASK_1_M_PG2			BIT(7)
#define DA9xxx_MASK_SYS_MASK_1_M_OV2			BIT(6)
#define DA9xxx_MASK_SYS_MASK_1_M_UV2			BIT(5)
#define DA9xxx_MASK_SYS_MASK_1_M_OC2			BIT(4)
#define DA9121_MASK_SYS_MASK_1_M_PG1			BIT(3)
#define DA9121_MASK_SYS_MASK_1_M_OV1			BIT(2)
#define DA9121_MASK_SYS_MASK_1_M_UV1			BIT(1)
#define DA9121_MASK_SYS_MASK_1_M_OC1			BIT(0)

/* DA9121_REG_SYS_MASK_2 */

#define DA9121_MASK_SYS_MASK_2_M_GPIO2			BIT(2)
#define DA9121_MASK_SYS_MASK_2_M_GPIO1			BIT(1)
#define DA9121_MASK_SYS_MASK_2_M_GPIO0			BIT(0)

/* DA9122_REG_SYS_MASK_3 */

#define DA9121_MASK_SYS_MASK_3_M_VR_HOT			BIT(3)
#define DA9xxx_MASK_SYS_MASK_3_M_SG_STAT		BIT(2)
#define DA9xxx_MASK_SYS_MASK_3_M_PG2_STAT		BIT(1)
#define DA9121_MASK_SYS_MASK_3_M_PG1_STAT		BIT(0)

/* DA9121_REG_SYS_CONFIG_0 */

#define DA9121_MASK_SYS_CONFIG_0_CH1_DIS_DLY		0xF0
#define DA9121_MASK_SYS_CONFIG_0_CH1_EN_DLY		0x0F

/* DA9xxx_REG_SYS_CONFIG_1 */

#define DA9xxx_MASK_SYS_CONFIG_1_CH2_DIS_DLY		0xF0
#define DA9xxx_MASK_SYS_CONFIG_1_CH2_EN_DLY		0x0F

/* DA9121_REG_SYS_CONFIG_2 */

#define DA9121_MASK_SYS_CONFIG_2_OC_LATCHOFF		0x60
#define DA9121_MASK_SYS_CONFIG_2_OC_DVC_MASK		BIT(4)
#define DA9121_MASK_SYS_CONFIG_2_PG_DVC_MASK		0x0C

/* DA9121_REG_SYS_CONFIG_3 */

#define DA9121_MASK_SYS_CONFIG_3_OSC_TUNE		0X70
#define DA9121_MASK_SYS_CONFIG_3_I2C_TIMEOUT		BIT(1)

/* DA9121_REG_SYS_GPIO0_0 */

#define DA9121_MASK_SYS_GPIO0_0_GPIO0_MODE		0X1E
#define DA9121_MASK_SYS_GPIO0_0_GPIO0_OBUF		BIT(0)

/* DA9121_REG_SYS_GPIO0_1 */

#define DA9121_MASK_SYS_GPIO0_1_GPIO0_DEB_FALL		BIT(7)
#define DA9121_MASK_SYS_GPIO0_1_GPIO0_DEB_RISE		BIT(6)
#define DA9121_MASK_SYS_GPIO0_1_GPIO0_DEB		0x30
#define DA9121_MASK_SYS_GPIO0_1_GPIO0_PUPD		BIT(3)
#define DA9121_MASK_SYS_GPIO0_1_GPIO0_POL		BIT(2)
#define DA9121_MASK_SYS_GPIO0_1_GPIO0_TRIG		0x03

/* DA9121_REG_SYS_GPIO1_0 */

#define DA9121_MASK_SYS_GPIO1_0_GPIO1_MODE		0x1E
#define DA9121_MASK_SYS_GPIO1_0_GPIO1_OBUF		BIT(0)

/* DA9121_REG_SYS_GPIO1_1 */

#define DA9121_MASK_SYS_GPIO1_1_GPIO1_DEB_FALL		BIT(7)
#define DA9121_MASK_SYS_GPIO1_1_GPIO1_DEB_RISE		BIT(6)
#define DA9121_MASK_SYS_GPIO1_1_GPIO1_DEB		0x30
#define DA9121_MASK_SYS_GPIO1_1_GPIO1_PUPD		BIT(3)
#define DA9121_MASK_SYS_GPIO1_1_GPIO1_POL		BIT(2)
#define DA9121_MASK_SYS_GPIO1_1_GPIO1_TRIG		0x03

/* DA9121_REG_SYS_GPIO2_0 */

#define DA9121_MASK_SYS_GPIO2_0_GPIO2_MODE		0x1E
#define DA9121_MASK_SYS_GPIO2_0_GPIO2_OBUF		BIT(0)

/* DA9121_REG_SYS_GPIO2_1 */

#define DA9121_MASK_SYS_GPIO2_1_GPIO2_DEB_FALL		BIT(7)
#define DA9121_MASK_SYS_GPIO2_1_GPIO2_DEB_RISE		BIT(6)
#define DA9121_MASK_SYS_GPIO2_1_GPIO2_DEB		0x30
#define DA9121_MASK_SYS_GPIO2_1_GPIO2_PUPD		BIT(3)
#define DA9121_MASK_SYS_GPIO2_1_GPIO2_POL		BIT(2)
#define DA9121_MASK_SYS_GPIO2_1_GPIO2_TRIG		0x03

/* DA9121_REG_BUCK_BUCK1_0 / DA9xxx_REG_BUCK_BUCK2_0 */

#define DA9121_MASK_BUCK_BUCKx_0_CHx_SR_DVC_DWN		0x70
#define DA9121_MASK_BUCK_BUCKx_0_CHx_SR_DVC_UP		0x0E
#define DA9121_MASK_BUCK_BUCKx_0_CHx_EN			BIT(0)

/* DA9121_REG_BUCK_BUCK1_1 / DA9xxx_REG_BUCK_BUCK2_1 */

#define DA9121_MASK_BUCK_BUCKx_1_CHx_SR_SHDN		0x70
#define DA9121_MASK_BUCK_BUCKx_1_CHx_SR_STARTUP		0x0E
#define DA9121_MASK_BUCK_BUCKx_1_CHx_PD_DIS		BIT(0)

/* DA9121_REG_BUCK_BUCK1_2 / DA9xxx_REG_BUCK_BUCK2_2 */

#define DA9121_MASK_BUCK_BUCKx_2_CHx_ILIM		0x0F

/* DA9121_REG_BUCK_BUCK1_3 / DA9xxx_REG_BUCK_BUCK2_3 */

#define DA9121_MASK_BUCK_BUCKx_3_CHx_VMAX		0xFF

/* DA9121_REG_BUCK_BUCK1_4 / DA9xxx_REG_BUCK_BUCK2_4 */

#define DA9121_MASK_BUCK_BUCKx_4_CHx_VSEL		BIT(4)
#define DA9121_MASK_BUCK_BUCKx_4_CHx_B_MODE		0x0C
#define DA9121_MASK_BUCK_BUCKx_4_CHx_A_MODE		0x03

/* DA9121_REG_BUCK_BUCK1_5 / DA9xxx_REG_BUCK_BUCK2_5 */

#define DA9121_MASK_BUCK_BUCKx_5_CHx_A_VOUT		0xFF

/* DA9121_REG_BUCK_BUCK1_6 / DA9xxx_REG_BUCK_BUCK2_6 */

#define DA9121_MASK_BUCK_BUCKx_6_CHx_B_VOUT		0xFF

/* DA9121_REG_BUCK_BUCK1_7 / DA9xxx_REG_BUCK_BUCK2_7 */

#define DA9xxx_MASK_BUCK_BUCKx_7_CHx_RIPPLE_CANCEL	0x03


/* DA9121_REG_OTP_DEVICE_ID */

#define DA9121_MASK_OTP_DEVICE_ID_DEV_ID		0xFF

#define DA9121_DEVICE_ID	0x05
#define DA914x_DEVICE_ID	0x26

/* DA9121_REG_OTP_VARIANT_ID */

#define DA9121_SHIFT_OTP_VARIANT_ID_MRC			4
#define DA9121_MASK_OTP_VARIANT_ID_MRC			0xF0
#define DA9121_SHIFT_OTP_VARIANT_ID_VRC			0
#define DA9121_MASK_OTP_VARIANT_ID_VRC			0x0F

#define DA9121_VARIANT_MRC_BASE	0x2
#define DA9121_VARIANT_VRC	0x1
#define DA9220_VARIANT_VRC	0x0
#define DA9122_VARIANT_VRC	0x2
#define DA9217_VARIANT_VRC	0x7
#define DA9130_VARIANT_VRC	0x0
#define DA9131_VARIANT_VRC	0x1
#define DA9132_VARIANT_VRC	0x2

#define DA914x_VARIANT_MRC_BASE	0x0
#define DA9141_VARIANT_VRC	0x1
#define DA9142_VARIANT_VRC	0x2

/* DA9121_REG_OTP_CUSTOMER_ID */

#define DA9121_MASK_OTP_CUSTOMER_ID_CUST_ID		0xFF

/* DA9121_REG_OTP_CONFIG_ID */

#define DA9121_MASK_OTP_CONFIG_ID_CONFIG_REV		0xFF

#endif /* __DA9121_REGISTERS_H__ */
