# Parse version information from version.h:
unset(_THRUST_VERSION_INCLUDE_DIR CACHE) # Clear old result to force search
find_path(_THRUST_VERSION_INCLUDE_DIR thrust/version.h
  NO_DEFAULT_PATH # Only search explicit paths below:
  PATHS
    ${CMAKE_CURRENT_LIST_DIR}/../..            # Source tree
    ${CMAKE_CURRENT_LIST_DIR}/../../../include # Install tree
)
file(READ "${_THRUST_VERSION_INCLUDE_DIR}/thrust/version.h" THRUST_VERSION_HEADER)
string(REGEX MATCH "#define[ \t]+THRUST_VERSION[ \t]+([0-9]+)" DUMMY "${THRUST_VERSION_HEADER}")
set(THRUST_VERSION_FLAT ${CMAKE_MATCH_1})
# Note that Thrust calls this the PATCH number, CMake calls it the TWEAK number:
string(REGEX MATCH "#define[ \t]+THRUST_PATCH_NUMBER[ \t]+([0-9]+)" DUMMY "${THRUST_VERSION_HEADER}")
set(THRUST_VERSION_TWEAK ${CMAKE_MATCH_1})

math(EXPR THRUST_VERSION_MAJOR "${THRUST_VERSION_FLAT} / 100000")
math(EXPR THRUST_VERSION_MINOR "(${THRUST_VERSION_FLAT} / 100) % 1000")
math(EXPR THRUST_VERSION_PATCH "${THRUST_VERSION_FLAT} % 100") # Thrust: "subminor" CMake: "patch"

set(THRUST_VERSION "${THRUST_VERSION_MAJOR}.${THRUST_VERSION_MINOR}.${THRUST_VERSION_PATCH}.${THRUST_VERSION_TWEAK}")

set(PACKAGE_VERSION ${THRUST_VERSION})
set(PACKAGE_VERSION_COMPATIBLE FALSE)
set(PACKAGE_VERSION_EXACT FALSE)
set(PACKAGE_VERSION_UNSUITABLE FALSE)

if(PACKAGE_VERSION VERSION_GREATER_EQUAL PACKAGE_FIND_VERSION)
  if(PACKAGE_FIND_VERSION_MAJOR STREQUAL THRUST_VERSION_MAJOR)
    set(PACKAGE_VERSION_COMPATIBLE TRUE)
  endif()

  if(PACKAGE_FIND_VERSION STREQUAL PACKAGE_VERSION)
    set(PACKAGE_VERSION_EXACT TRUE)
  endif()
endif()
