##  rone's unified control.ctl
##  $Id: control.ctl,v 1.20.2.19 2002/04/18 21:08:59 rra Exp $
##
##  control.ctl - Access control for control messages.
##
##  Please copy usenet-config@isc.org on any updates to this file so that
##  it can be updated in the INN CVS repository and on ftp.isc.org.  For
##  changes to a public hierarchy, please also post the changes to
##  news.admin.hierarchies.
##
##  The canonical version of this file can be found in the latest INN
##  release and at <ftp://ftp.isc.org/pub/usenet/CONFIG/control.ctl>; these
##  two files will be kept in sync.  Please refer to the latest version of
##  this file for the most up-to-date hierarchy control information and
##  please use the latest version if you intend to carry all hierarchies.
##  You may wish to change the policy for alt.*.
##
##  Format:
##     <message>:<from>:<newsgroups>:<action>
##
##     <message>      Control message or "all" if it applies to all control
##                    messages.
##     <from>         Pattern that must match the From line.
##     <newsgroups>   Pattern that must match the newsgroup being newgroup'd
##                    or rmgroup'd (ignored for other messages).
##     <action>       What to do:
##                          doit        Perform action
##                          drop        Ignore message
##                          log         One line to error log
##                          mail        Send mail to admin
##                          verify-pgp_userid   Do PGP verification on user.
##                    All actions except drop and mail can be given a log
##                    location by following the action with an = and the
##                    log ("mail" says to mail the admin, an empty location
##                    tosses the log information, and a relative path xxx
##                    logs to $LOG/xxx.log.
##
##  The *last* matching entry is used.  See the expire.ctl(5) man page for
##  complete information.
##
##  This file follows the following policies:
##
##   * Most unknown or invalid control messages no longer result in mail.
##     This is due to the proliferation of forged control messages filling
##     up mailboxes.  Some news servers even get overwhelmed with trying to
##     log failure, so unsigned control messages for hierarchies that use
##     PGP are simply dropped.
##
##   * The assumption is that you now have PGP on your system.  If you
##     don't, you should get it to help protect yourself against all the
##     control message forgeries.  See <ftp://ftp.isc.org/pub/pgpcontrol/>.
##     PGP control message verification comes with all versions of INN since
##     1.5, but you will need to install either PGP or GnuPG; see the
##     installation instructions for your news server.
##
##     If for some reason you can't use PGP, search for the *PGP* comments
##     and modify the control lines to change "verify-..." in the action
##     field to "mail" or "doit=mail" or "doit=<log file>" or whatever you
##     prefer (replacing <log file> with the name of an appropriate log
##     file).
## 
##   * A number of hierarchies are for local use only but have leaked out
##     into the general stream.  In this config file, they are set so that
##     the groups will be easy to remove, and are marked with a comment of
##     *LOCAL* (for use by that organization only, not generally
##     distributed), *DEFUNCT* (a hierarchy that's no longer used), or
##     *PRIVATE* (should only be carried after making arrangements with the
##     given contact address).  Please delete all groups in those
##     hierarchies from your server if you carry them, unless you've
##     contacted the listed contact address and arranged a feed.
##
##     If you have permission to carry any of the hierachies so listed in
##     this file, you should change the entries for those hierarchies below.
##
##  The comments of this file aren't in any formal or well-defined syntax,
##  but they are meant to use a consistent syntax to allow eventual parsing
##  by scripts into a better database format.  Please follow the syntax of
##  existing entries when providing new ones.  The recognized "fields" are
##  Contact (contact e-mail address), URL, Key URL (URL for PGP key), Key
##  fingerprint, Key mail (address to mail for PGP key), and Syncable server
##  (for actsync or a similar tool).

## -------------------------------------------------------------------------
##	DEFAULT
## -------------------------------------------------------------------------

# Default to dropping control messages that aren't recognized to allow
# people to experiment without inadvertently mailbombing news admins.
all:*:*:drop

## -------------------------------------------------------------------------
##	CHECKGROUPS MESSAGES
## -------------------------------------------------------------------------

# Default to mailing all checkgroups messages to the administrator.
checkgroups:*:*:mail

## -------------------------------------------------------------------------
##	MISCELLANEOUS CONTROL MESSAGES
## -------------------------------------------------------------------------

# Mostly only used for UUCP feeds, very rarely used these days.
ihave:*:*:drop
sendme:*:*:drop

# Request to send a copy of the newsfeeds file, intended for mapping
# projects.  Almost never used for anything other than mailbombing now.
sendsys:*:*:log=sendsys

# Request to send the server's path entry.  Not particularly useful.
senduuname:*:*:log=senduuname

# Request to send the server's version number.
version:*:*:log=version

## -------------------------------------------------------------------------
##	NEWGROUP/RMGROUP MESSAGES
## -------------------------------------------------------------------------

## Default (for any group)
newgroup:*:*:mail
rmgroup:*:*:mail

## COMP, HUMANITIES, MISC, NEWS, REC, SCI, SOC, TALK (The Big 8)
# Contact: group-admin@isc.org
# Key fingerprint = F5 35 58 D3 55 64 10 14  07 C6 95 53 13 6F D4 07
# *PGP*   See comment at top of file.
newgroup:*:comp.*|humanities.*|misc.*|news.*|rec.*|sci.*|soc.*|talk.*:drop
rmgroup:*:comp.*|humanities.*|misc.*|news.*|rec.*|sci.*|soc.*|talk.*:drop
newgroup:group-admin@isc.org:*:drop
newgroup:tale@*uu.net:*:drop
rmgroup:group-admin@isc.org:*:drop
rmgroup:tale@*uu.net:*:drop
checkgroups:group-admin@isc.org:*:verify-news.announce.newgroups
newgroup:group-admin@isc.org:comp.*|misc.*:verify-news.announce.newgroups
newgroup:group-admin@isc.org:humanities.*:verify-news.announce.newgroups
newgroup:group-admin@isc.org:news.*|rec.*|sci.*:verify-news.announce.newgroups
newgroup:group-admin@isc.org:soc.*|talk.*:verify-news.announce.newgroups
rmgroup:group-admin@isc.org:comp.*|misc.*:verify-news.announce.newgroups
rmgroup:group-admin@isc.org:humanities.*:verify-news.announce.newgroups
rmgroup:group-admin@isc.org:news.*|rec.*|sci.*:verify-news.announce.newgroups
rmgroup:group-admin@isc.org:soc.*|talk.*:verify-news.announce.newgroups

## ACS & OSU (*LOCAL* -- Ohio State University, USA)
# Contact: Albert J. School <school.1@osu.edu>
# Secondary contact: Harpal Chohan <chohan+@osu.edu>
# For local use only, contact the above addresses for information.
newgroup:*@*:acs.*|osu.*:mail
rmgroup:*@*:acs.*|osu.*:doit

## AHN (Athens-Clarke County, Georgia, USA)
newgroup:greg@*.ucns.uga.edu:ahn.*:doit
rmgroup:greg@*.ucns.uga.edu:ahn.*:doit

## AIR (*DEFUNCT* -- Stanford University, USA)
# Contact: news@news.stanford.edu
# Defunct hierarchy, please remove any groups that you carry.
newgroup:*@*:air.*:mail
rmgroup:*@*:air.*:doit

## AKR (Akron, Ohio, USA)
newgroup:red@redpoll.mrfs.oh.us:akr.*:doit
rmgroup:red@redpoll.mrfs.oh.us:akr.*:doit

## ALABAMA & HSV (Huntsville, Alabama, USA)
# Contact: jpc@suespammers.org
# *PGP*   See comment at top of file.
newgroup:*:alabama.*|hsv.*:drop
rmgroup:*:alabama.*|hsv.*:drop
checkgroups:jpc@suespammers.org:alabama.*|hsv.*:verify-alabama-group-admin
newgroup:jpc@suespammers.org:alabama.*|hsv.*:verify-alabama-group-admin
rmgroup:jpc@suespammers.org:alabama.*|hsv.*:verify-alabama-group-admin

## ALIVE (*DEFUNCT*)
# Contact: thijs@kink.xs4all.nl
# Defunct hierarchy, please remove any groups that you carry.
newgroup:*@*:alive.*:mail
rmgroup:*@*:alive.*:doit

## ALT
#
# Accept all newgroups (except ones forged from Big 8 newgroup issuers,
# who never issue alt.* control messages) and silently ignore all
# rmgroups.  This file used to attempt to track and recommend trusted
# rmgroup issuers; it no longer does because they change too frequently.
# What policy to use for alt.* groups varies widely from site to site.
# For a small site, it is strongly recommended that this policy be changed
# to drop all newgroups for alt.* as well as rmgroups and that the news
# admin only add new alt.* groups on request, as tons of alt.* newgroups
# are sent out regularly with the intent more to create nonsense entries
# in active files than to actually create a useable newsgroup.
#
# Other options and comments on alt.* groups can be found at
# <http://www.alt-config.org/>, one of the many alt.* FAQ sites.  Be aware
# that there is no official, generally accepted alt.* policy and all
# information about alt.* groups available is essentially someone's
# opinion, including these comments.  There are nearly as many different
# policies with regard to alt.* groups as there are Usenet sites.
#
newgroup:*:alt.*:doit
newgroup:group-admin@isc.org:alt.*:drop
newgroup:tale@*uu.net:alt.*:drop
rmgroup:*:alt.*:drop

## AR (Argentina)
newgroup:jorge_f@nodens.fisica.unlp.edu.ar:ar.*:doit
rmgroup:jorge_f@nodens.fisica.unlp.edu.ar:ar.*:doit

## ARC (*LOCAL* -- NASA Ames Research Center, USA)
# Contact: news@arc.nasa.gov
# For internal use only, contact above address for questions
newgroup:*@*:arc.*:mail
rmgroup:*@*:arc.*:doit

## ARKANE (Arkane Systems, UK)
# Contact: newsbastard@arkane.demon.co.uk
# URL: http://www.arkane.demon.co.uk/Newsgroups.html
checkgroups:newsbastard@arkane.demon.co.uk:arkane.*:mail
newgroup:newsbastard@arkane.demon.co.uk:arkane.*:doit
rmgroup:newsbastard@arkane.demon.co.uk:arkane.*:doit

## AT (Austria)
checkgroups:control@usenet.backbone.at:at.*:mail
newgroup:control@usenet.backbone.at:at.*:doit
rmgroup:control@usenet.backbone.at:at.*:doit

## AUS (Australia)
# Contact: ausadmin@aus.news-admin.org
# URL: http://aus.news-admin.org/
# Key URL: http://aus.news-admin.org/ausadmin.asc
# *PGP*   See comment at top of file.
newgroup:*:aus.*:drop
rmgroup:*:aus.*:drop
checkgroups:ausadmin@aus.news-admin.org:aus.*:verify-ausadmin@aus.news-admin.org
newgroup:ausadmin@aus.news-admin.org:aus.*:verify-ausadmin@aus.news-admin.org
rmgroup:ausadmin@aus.news-admin.org:aus.*:verify-ausadmin@aus.news-admin.org

## AUSTIN (Texas, USA)
checkgroups:fletcher@cs.utexas.edu:austin.*:doit
checkgroups:chip@unicom.com:austin.*:doit
checkgroups:pug@pug.net:austin.*:doit
newgroup:fletcher@cs.utexas.edu:austin.*:doit
newgroup:chip@unicom.com:austin.*:doit
newgroup:pug@pug.net:austin.*:doit
rmgroup:fletcher@cs.utexas.edu:austin.*:doit
rmgroup:chip@unicom.com:austin.*:doit
rmgroup:pug@pug.net:austin.*:doit

## AZ (Arizona, USA)
newgroup:system@asuvax.eas.asu.edu:az.*:doit
rmgroup:system@asuvax.eas.asu.edu:az.*:doit

## BA (San Francisco Bay Area, USA)
# Contact: ba-mod@nas.nasa.gov
# URL: http://ennui.org/ba/
# Key URL: http://ennui.org/ba/ba-mod.asc
# *PGP*   See comment at top of file.
newgroup:*:ba.*:drop
rmgroup:*:ba.*:drop
checkgroups:ba-mod@nas.nasa.gov:ba.*:verify-ba.news.config
newgroup:ba-mod@nas.nasa.gov:ba.*:verify-ba.news.config
rmgroup:ba-mod@nas.nasa.gov:ba.*:verify-ba.news.config

## BACKBONE (*LOCAL* -- ruhr.de/ruhrgebiet.individual.net in Germany)
# Contact: admin@ruhr.de
# For internal use only, contact above address for questions
newgroup:*@*:backbone.*:mail
rmgroup:*@*:backbone.*:doit

## BAYNET (Bayerische Buergernetze, Deutschland)
# Contact: news@mayn.de
# URL: http://www.mayn.de/users/news/
# Key URL: http://home.mayn.de/news/pubkey-news.mayn.de
# Key fingerprint = F7 AD 96 D8 7A 3F 7E 84  02 0C 83 9A DB 8F EB B8
# Syncable server: news.mayn.de (contact news@mayn.de if permission denied)
# *PGP*   See comment at top of file.
newgroup:*:baynet.*:drop
rmgroup:*:baynet.*:drop
checkgroups:news@mayn.de:baynet.*:verify-news.mayn.de
newgroup:news@mayn.de:baynet.*:verify-news.mayn.de
rmgroup:news@mayn.de:baynet.*:verify-news.mayn.de

## BC (British Columbia, Canada)
checkgroups:bc_van_usenet@fastmail.ca:bc.*:mail
newgroup:bc_van_usenet@fastmail.ca:bc.*:doit
rmgroup:bc_van_usenet@fastmail.ca:bc.*:doit

## BDA (German groups?)
newgroup:news@*netuse.de:bda.*:doit
rmgroup:news@*netuse.de:bda.*:doit

## BE (Belgique/Belgie/Belgien/Belgium)
# Contact: be-hierarchy-admin@usenet.be
# URL: http://usenet.be/
# Key URL: http://usenet.be/be.announce.newgroups.asc
# Key fingerprint = 30 2A 45 94 70 DE 1F D5  81 8C 58 64 D2 F7 08 71
# *PGP*   See comment at top of file.
newgroup:*:be.*:drop
rmgroup:*:be.*:drop
checkgroups:group-admin@usenet.be:be.*:verify-be.announce.newgroups
newgroup:group-admin@usenet.be:be.*:verify-be.announce.newgroups
rmgroup:group-admin@usenet.be:be.*:verify-be.announce.newgroups

## BERMUDA
newgroup:news@*ibl.bm:bermuda.*:doit
rmgroup:news@*ibl.bm:bermuda.*:doit

## BES (*PRIVATE* -- Bejing Electron Spectrometer)
# Contact: news@news.stanford.edu
# Limited distribution hierarchy, contact the above address for information.
newgroup:news@news.stanford.edu:bes.*:mail
rmgroup:news@news.stanford.edu:bes.*:doit

## BEST (*LOCAL* -- Best Internet Communications, Inc.)
# Contact: news@best.net
# For local use only, contact the above address for information.
newgroup:*@*:best.*:mail
rmgroup:*@*:best.*:doit

## BIONET (Biology Network)
# URL: http://www.bio.net/
# Key fingerprint = EB C0 F1 BA 26 0B C6 D6  FB 8D ED C4 AE 5D 10 54
# *PGP*   See comment at top of file.
newgroup:*:bionet.*:drop
rmgroup:*:bionet.*:drop
checkgroups:Biosci-control-key@net.bio.net:bionet.*:verify-Biosci-control-key@net.bio.net
newgroup:Biosci-control-key@net.bio.net:bionet.*:verify-Biosci-control-key@net.bio.net=newgroup
rmgroup:Biosci-control-key@net.bio.net:bionet.*:verify-Biosci-control-key@net.bio.net=rmgroup

## BIRK (*LOCAL* -- University of Oslo, Norway)
# Contact: birk-admin@ping.uio.no
# For private use only, contact the above address for information.
newgroup:*@*:birk.*:drop
rmgroup:*@*:birk.*:doit

## BIT (Gatewayed Mailing lists)
# URL: http://www.newsadmin.com/bit/bit.htm
# *PGP*   See comment at top of file.
newgroup:*:bit.*:drop
rmgroup:*:bit.*:drop
checkgroups:bit@newsadmin.com:bit.*:verify-bit@newsadmin.com
newgroup:bit@newsadmin.com:bit.*:verify-bit@newsadmin.com
rmgroup:bit@newsadmin.com:bit.*:verify-bit@newsadmin.com

## BIZ (Business Groups)
newgroup:edhew@xenitec.on.ca:biz.*:doit
rmgroup:edhew@xenitec.on.ca:biz.*:doit

## BLGTN (Bloomington, In, USA)
newgroup:control@news.bloomington.in.us:blgtn.*:doit
rmgroup:control@news.bloomington.in.us:blgtn.*:doit

## BLN (Berlin, Germany)
checkgroups:news@*fu-berlin.de:bln.*:mail
newgroup:news@*fu-berlin.de:bln.*:doit
rmgroup:news@*fu-berlin.de:bln.*:doit

## BOFH (*PRIVATE* -- Bastard Operator From Hell)
# Contact: myname@myhost.mydomain.com
# For private use only, contact the above address for information.
newgroup:*@*:bofh.*:mail
rmgroup:*@*:bofh.*:doit

## CA (California, USA)
# Contact: ikluft@thunder.sbay.org
# URL: http://www.sbay.org/ca/
newgroup:ikluft@thunder.sbay.org:ca.*:doit
rmgroup:ikluft@thunder.sbay.org:ca.*:doit

## CAIS (*LOCAL* -- Capital Area Internet Services)
# Contact: news@cais.com
# For local use only, contact the above address for information.
newgroup:*@*:cais.*:mail
rmgroup:*@*:cais.*:doit

## CALSTATE (California State University)
newgroup:*@*calstate.edu:calstate.*:doit
rmgroup:*@*calstate.edu:calstate.*:doit

## CAPDIST (Albany, The Capital District, New York, USA)
newgroup:danorton@albany.net:capdist.*:doit
rmgroup:danorton@albany.net:capdist.*:doit

## CARLETON (Carleton University, Canada)
newgroup:news@cunews.carleton.ca:carleton.*:doit
newgroup:news@cunews.carleton.ca:carleton*class.*:mail
rmgroup:news@cunews.carleton.ca:carleton.*:doit

## CD-ONLINE (*LOCAL*)
# Contact: newsmaster@worldonline.nl
# For local use only, contact the above address for information.
newgroup:*@*:cd-online.*:mail
rmgroup:*@*:cd-online.*:doit

## CENTRAL (*LOCAL* -- The Internet Company of New Zealand, Wellington, NZ)
# Contact: usenet@iconz.co.nz
# For local use only, contact the above address for information.
newgroup:*@*:central.*:mail
rmgroup:*@*:central.*:doit

## CERN (*PRIVATE* -- CERN European Laboratory for Particle Physics)
# Contact: Dietrich Wiegandt <News.Support@cern.ch>
# For private use only, contact the above address for information.
newgroup:News.Support@cern.ch:cern.*:doit
rmgroup:News.Support@cern.ch:cern.*:doit

## CH (Switzerland)
# Contact: ch-news-admin@use-net.ch
# URL: http://www.use-net.ch/Usenet/
# Key URL: http://www.use-net.ch/Usenet/adminkey.html
# Key fingerprint = 71 80 D6 8C A7 DE 2C 70  62 4A 48 6E D9 96 02 DF
# *PGP*   See comment at top of file.
newgroup:*:ch.*:drop
rmgroup:*:ch.*:drop
checkgroups:felix.rauch@nice.ch:ch.*:verify-ch-news-admin@use-net.ch
newgroup:felix.rauch@nice.ch:ch.*:verify-ch-news-admin@use-net.ch
rmgroup:felix.rauch@nice.ch:ch.*:verify-ch-news-admin@use-net.ch

## CHAVEN (*LOCAL* -- Celestian Haven ISP, Midwest, USA)
# Contact: news@chaven.com
# For internal use only, contact above address for questions
newgroup:*@*:chaven.*:drop
rmgroup:*@*:chaven.*:doit

## CHRISTNET (Christian Discussion)
checkgroups:news@fdma.com:christnet.*:mail
newgroup:news@fdma.com:christnet.*:doit
rmgroup:news@fdma.com:christnet.*:doit

## CHI (Chicago, USA)
newgroup:lisbon@*interaccess.com:chi.*:doit
newgroup:lisbon@*chi.il.us:chi.*:doit
rmgroup:lisbon@*interaccess.com:chi.*:doit
rmgroup:lisbon@*chi.il.us:chi.*:doit

## CHILE (Chile and Chilean affairs)
# Contact: mod-cga@webhost.cl
# URL: http://www.webhost.cl/~mod-cga
checkgroups:mod-cga@*webhost.cl:chile.*:mail
newgroup:mod-cga@*webhost.cl:chile.*:doit
rmgroup:mod-cga@*webhost.cl:chile.*:doit

## CHINESE (China and Chinese language groups)
newgroup:pinghua@stat.berkeley.edu:chinese.*:doit
rmgroup:pinghua@stat.berkeley.edu:chinese.*:doit

## CITYSCAPE & DEMON (Cityscape Internet Services & Demon Internet, UK)
# Contact: Dave Williams <newsmaster@demon.net>
# URL: ftp://ftp.demon.co.uk/pub/news/doc/demon.news.txt
# *PGP*   See comment at top of file.
newgroup:*:cityscp.*:drop
rmgroup:*:cityscp.*:drop
checkgroups:newsmaster@demon.net:cityscp.*:verify-demon.news
newgroup:newsmaster@demon.net:cityscp.*:verify-demon.news
rmgroup:newsmaster@demon.net:cityscp.*:verify-demon.news

## CL (*PRIVATE* -- CL-Netz, German)
# Contact: koordination@cl-netz.de
# URL: http://www.cl-netz.de/
# Key URL: http://www.cl-netz.de/control.txt
# For internal use only, contact above address for questions.
# *PGP*   See comment at top of file.
newgroup:*@*:cl.*:drop
rmgroup:*@*:cl.*:doit
# The following three lines are only for authorized cl.* sites.
#checkgroups:koordination@cl-netz.de:cl.*:verify-cl.netz.infos
#newgroup:koordination@cl-netz.de:cl.*:verify-cl.netz.infos
#rmgroup:koordination@cl-netz.de:cl.*:verify-cl.netz.infos

## CLARINET (Features and News, available on a commercial basis)
# Contact: support@clari.net
# *PGP*   See comment at top of file.
newgroup:*:clari.*:drop
rmgroup:*:clari.*:drop
checkgroups:cl*@clarinet.com:clari.*:verify-ClariNet.Group
newgroup:cl*@clarinet.com:clari.*:verify-ClariNet.Group
rmgroup:cl*@clarinet.com:clari.*:verify-ClariNet.Group

## CMI (*LOCAL* -- Champaign County, IL, USA)
# Contact: news@uiuc.edu
# For internal use only, contact above address for questions.
newgroup:*:cmi.*:drop
rmgroup:*:cmi.*:doit

## CMU (*LOCAL* -- Carnegie-Mellon University, Pennsylvania, USA)
# Contact: Daniel Edward Lovinger <del+@CMU.EDU>
# For internal use only, contact above address for questions.
newgroup:*:cmu.*:drop
rmgroup:*:cmu.*:doit

## CN (China)
# *PGP*   See comment at top of file.
newgroup:*:cn.*:drop
rmgroup:*:cn.*:drop
checkgroups:control@bentium.com:cn.*:verify-cn.admin.news.announce
newgroup:control@bentium.com:cn.*:verify-cn.admin.news.announce
rmgroup:control@bentium.com:cn.*:verify-cn.admin.news.announce

## CN.BBS (China)
# Key URL: http://news.zixia.net/pubkey-cn.bbs.admin.announce
# *PGP*   See comment at top of file.
newgroup:news@zixia.net:cn.bbs.*:verify-cn.bbs.admin.announce
rmgroup:news@zixia.net:cn.bbs.*:verify-cn.bbs.admin.announce

## CUHK (*LOCAL* -- Chinese University of Hong Kong)
# Contact: shlam@ie.cuhk.edu.hk (Alan S H Lam)
# For internal use only, contact above address for questions.
newgroup:*:cuhk.*:drop
rmgroup:*:cuhk.*:doit

## CO (Colorado, USA)
# Contact: coadmin@boyznoyz.com (Bill of Denver)
checkgroups:coadmin@boyznoyz.com:co.*:doit
newgroup:coadmin@boyznoyz.com:co.*:doit
rmgroup:coadmin@boyznoyz.com:co.*:doit

## CODEWARRIOR (CodeWarrior discussion)
checkgroups:news@supernews.net:codewarrior.*:doit
newgroup:news@supernews.net:codewarrior.*:doit
rmgroup:news@supernews.net:codewarrior.*:doit

## COMPUTER42 (Computer 42, Germany)
# Contact: Dirk Schmitt <news@computer42.org>
newgroup:news@computer42.org:computer42.*:doit
rmgroup:news@computer42.org:computer42.*:doit

## CONCORDIA (Concordia University, Montreal, Canada)
# URL: General University info at http://www.concordia.ca/
# Contact: newsmaster@concordia.ca
newgroup:news@newsflash.concordia.ca:concordia.*:doit
rmgroup:news@newsflash.concordia.ca:concordia.*:doit

## COURTS (*DEFUNCT*)
# Contact: trier@ins.cwru.edu
# Defunct hierarchy as of mid-1998, please remove any groups that you carry.
newgroup:*@*:courts.*:mail
rmgroup:*@*:courts.*:doit

## CPCUIIA (American Institute for Chartered Property Casulty
## Underwriter/Insurance Institute of America, USA)
# Contact: miller@cpcuiia.org
# URL: http://www.aicpcu.org/
checkgroups:miller@cpcuiia.org:cpcuiia.*:mail
newgroup:miller@cpcuiia.org:cpcuiia.*:doit
rmgroup:miller@cpcuiia.org:cpcuiia.*:doit

## CU (*LOCAL* -- University of Colorado)
# Contact: Doreen Petersen <news@colorado.edu>
# For local use only, contact the above address for information.
newgroup:*@*:cu.*:mail
rmgroup:*@*:cu.*:doit

## CZ (Czech Republic)
# URL: ftp://ftp.vslib.cz/pub/news/config/cz/newsgroups (text)
# URL: http://www.ces.net/cgi-bin/newsgroups.p?cz (HTML)
checkgroups:petr.kolar@vslib.cz:cz.*:mail
newgroup:petr.kolar@vslib.cz:cz.*:doit
rmgroup:petr.kolar@vslib.cz:cz.*:doit

## DC (Washington, D.C., USA)
checkgroups:news@mattress.atww.org:dc.*:mail
newgroup:news@mattress.atww.org:dc.*:doit
rmgroup:news@mattress.atww.org:dc.*:doit

## DE (German language)
# *PGP*   See comment at top of file.
newgroup:*:de.*:drop
rmgroup:*:de.*:drop
checkgroups:moderator@dana.de:de.*:verify-de.admin.news.announce
newgroup:moderator@dana.de:de.*:verify-de.admin.news.announce
newgroup:*@*:de.alt.*:doit
rmgroup:moderator@dana.de:de.*:verify-de.admin.news.announce

## DFW (Dallas/Fort Worth, Texas, USA)
newgroup:eric@*cirr.com:dfw.*:doit
rmgroup:eric@*cirr.com:dfw.*:doit

## DK (Denmark)
# URL: http://www.usenet.dk/dk-admin/
# Key URL: http://www.usenet.dk/grupper/control_pubkey.html
# Key fingerprint = 7C B2 C7 50 F3 7D 5D 73  8C EE 2E 3F 55 80 72 FF
# *PGP*   See comment at top of file.
newgroup:*:dk.*:drop
rmgroup:*:dk.*:drop
checkgroups:news@news.dknet.dk:dk.*:verify-news@news.dknet.dk
newgroup:news@news.dknet.dk:dk.*:verify-news@news.dknet.dk
rmgroup:news@news.dknet.dk:dk.*:verify-news@news.dknet.dk

## DUKE (*LOCAL* -- Duke University, USA)
# Contact: news@newsgate.duke.edu
# For local use only, contact the above address for information.
newgroup:*@*:duke.*:mail
rmgroup:*@*:duke.*:doit

## EASYNET (Easynet PLC, UK)
# Contact: Christiaan Keet <newsmaster@easynet.net>
# URL: ftp://ftp.easynet.net/pub/usenet/easynet.control.txt
# *PGP*   See comment at top of file.
newgroup:*:easynet.*:drop
rmgroup:*:easynet.*:drop
checkgroups:newsmaster@easynet.net:easynet.*:verify-easynet.news
newgroup:newsmaster@easynet.net:easynet.*:verify-easynet.news
rmgroup:newsmaster@easynet.net:easynet.*:verify-easynet.news

## EE (Estonia)
# Contact: usenet@news.ut.ee
# URL: http://news.ut.ee/
# Key URL: http://news.ut.ee/pubkey.asc
# *PGP*   See comment at top of file.
newgroup:*:ee.*:drop
rmgroup:*:ee.*:drop
checkgroups:news@news.ut.ee:ee.*:verify-ee.news
newgroup:news@news.ut.ee:ee.*:verify-ee.news
rmgroup:news@news.ut.ee:ee.*:verify-ee.news

## EFN & EUG (Eugene Free Computer Network, Eugene/Springfield, Oregon, USA)
# *PGP*   See comment at top of file.
newgroup:*:eug.*:drop
rmgroup:*:eug.*:drop
checkgroups:newsadmin@efn.org:efn.*|eug.*:verify-eug.config
newgroup:newsadmin@efn.org:efn.*|eug.*:verify-eug.config
rmgroup:newsadmin@efn.org:efn.*|eug.*:verify-eug.config

## EHIME-U (? University, Japan ?)
newgroup:news@cc.nias.ac.jp:ehime-u.*:doit
newgroup:news@doc.dpc.ehime-u.ac.jp:ehime-u.*:doit
rmgroup:news@cc.nias.ac.jp:ehime-u.*:doit
rmgroup:news@doc.dpc.ehime-u.ac.jp:ehime-u.*:doit

## ENGLAND
# Contact: admin@england.news-admin.org
# URL: http://www.england.news-admin.org/newsadminsfaq.html
# Key fingerprint = DA 3E C2 01 46 E5 61 CB  A2 43 09 CA 13 6D 31 1F
# *PGP*   See comment at top of file.
newgroup:admin@england.news-admin.org:england.*:verify-england-usenet
rmgroup:admin@england.news-admin.org:england.*:verify-england-usenet
checkgroups:admin@england.news-admin.org:england.*:verify-england-usenet

## ES (Spain)
# Contact: david.martinez@rediris.es
# URL: http://www.rediris.es/netnews/infonews/config.es.html
# URL: http://news.rediris.es/~moderador/grupos/newsgroups.es
# *PGP*   See comment at top of file.
newgroup:*:es.*:drop
rmgroup:*:es.*:drop
checkgroups:moderador@news.rediris.es:es.*:verify-es.news
newgroup:moderador@news.rediris.es:es.*:verify-es.news
rmgroup:moderador@news.rediris.es:es.*:verify-es.news

## ESP (Spanish-language newsgroups)
# Contact: <mod-ena@ennui.org>
# URL: http://ennui.org/esp/
# *PGP*   See comment at top of file.
newgroup:*:esp.*:drop
rmgroup:*:esp.*:drop
checkgroups:mod-ena@ennui.org:esp.*:verify-esp.news.administracion
newgroup:mod-ena@ennui.org:esp.*:verify-esp.news.administracion
rmgroup:mod-ena@ennui.org:esp.*:verify-esp.news.administracion

## EUNET (Europe)
newgroup:news@noc.eu.net:eunet.*:doit
rmgroup:news@noc.eu.net:eunet.*:doit

## EUROPA (Europe)
# URL: http://www.europa.usenet.eu.org/
# Key fingerprint = 3A 05 A8 49 FB 16 29 25  75 E3 DE BB 69 E0 1D B4
# *PGP*   See comment at top of file.
newgroup:group-admin@usenet.eu.org:europa.*:verify-group-admin@usenet.eu.org
rmgroup:group-admin@usenet.eu.org:europa.*:verify-group-admin@usenet.eu.org
checkgroups:group-admin@usenet.eu.org:europa.*:verify-group-admin@usenet.eu.org

## EXAMPLE (Bogus hierarchy reserved for standards documents)
newgroup:*@*:example.*:mail
rmgroup:*@*:example.*:doit

## FA (*DEFUNCT* -- "From ARPA" gatewayed mailing lists)
# Removed in the "Great Renaming" of 1988.
#
# Note that a site in Finland is currently (as of 2001) gatewaying various
# mailing lists into fa.* newsgroups, but that site does not appear to be
# issuing any control messages for those groups.
#
newgroup:*@*:fa.*:mail
rmgroup:*@*:fa.*:doit

## FIDO (FidoNet)
newgroup:root@mbh.org:fido.*:doit
rmgroup:root@mbh.org:fido.*:doit

## FIDO.BELG.* (FidoNet)
# URL: http://www.z2.fidonet.org/news/fido.belg.news/
# *PGP*   See comment at top of file.
newgroup:*:fido.belg.*:drop
rmgroup:*:fido.belg.*:drop
checkgroups:fidobelg@mail.z2.fidonet.org:fido.belg.*:verify-fido.belg.news
newgroup:fidobelg@mail.z2.fidonet.org:fido.belg.*:verify-fido.belg.news
rmgroup:fidobelg@mail.z2.fidonet.org:fido.belg.*:verify-fido.belg.news

## FIDO7
# *PGP*   See comment at top of file.
newgroup:*:fido7.*:drop
rmgroup:*:fido7.*:drop
checkgroups:newgroups-request@fido7.ru:fido7.*:verify-fido7.announce.newgroups
newgroup:newgroups-request@fido7.ru:fido7.*:verify-fido7.announce.newgroups
rmgroup:newgroups-request@fido7.ru:fido7.*:verify-fido7.announce.newgroups

## FINET (Finland and Finnish language alternative newsgroups)
# The alt.* of Finland.
newgroup:*@*.fi:finet.*:doit
rmgroup:*@*.fi:finet.*:doit

## FJ (Japan and Japanese language)
# Contact: committee@fj-news.org
# URL: http://www.is.tsukuba.ac.jp/~yas/fj/
# Key URL: http://www.is.tsukuba.ac.jp/~yas/fj/fj.asc
newgroup:*:fj.*:drop
rmgroup:*:fj.*:drop
checkgroups:committee@fj-news.org:fj.*:verify-fj.news.announce
newgroup:committee@fj-news.org:fj.*:verify-fj.news.announce
rmgroup:committee@fj-news.org:fj.*:verify-fj.news.announce

## FL (Florida, USA)
newgroup:hgoldste@news1.mpcs.com:fl.*:doit
newgroup:scheidell@fdma.fdma.com:fl.*:doit
rmgroup:hgoldste@news1.mpcs.com:fl.*:doit
rmgroup:scheidell@fdma.fdma.com:fl.*:doit

## FLORA (FLORA Community WEB, Canada)
# Contact: russell@flora.org
# URL: http://news.flora.org/
# Key URL: http://www.flora.org/russell/
# *PGP*   See comment at top of file.
newgroup:*:flora.*:drop
rmgroup:*:flora.*:drop
checkgroups:news@flora.ottawa.on.ca:flora.*:verify-flora-news
newgroup:news@news.rediris.es:flora.*:verify-flora-news
rmgroup:news@news.rediris.es:flora.*:verify-flora-news

## FR (French Language)
# *PGP*   See comment at top of file.
newgroup:*:fr.*:drop
rmgroup:*:fr.*:drop
checkgroups:control@usenet-fr.news.eu.org:fr.*:verify-control@usenet-fr.news.eu.org
newgroup:control@usenet-fr.news.eu.org:fr.*:verify-control@usenet-fr.news.eu.org
rmgroup:control@usenet-fr.news.eu.org:fr.*:verify-control@usenet-fr.news.eu.org

## FREE (Open Hierarchy where anyone can create a group)
newgroup:*:free.*:doit
newgroup:group-admin@isc.org:free.*:drop
newgroup:tale@*uu.net:free.*:drop
rmgroup:*:free.*:drop

## FUDAI (Japanese ?)
newgroup:news@picard.cs.osakafu-u.ac.jp:fudai.*:doit
rmgroup:news@picard.cs.osakafu-u.ac.jp:fudai.*:doit

## FUR (*PRIVATE* -- furrynet)
# Contact: fur-config@news.furry.net
# Please contact the above address before adding these groups.
newgroup:*@*:fur.*:mail
rmgroup:*@*:fur.*:doit

## GER & HANNET & HANNOVER & HILDESHEIM & HISS (Hannover, Germany)
newgroup:fifi@hiss.han.de:ger.*|hannover.*|hannet.*|hildesheim.*|hiss.*:doit
rmgroup:fifi@hiss.han.de:ger.*|hannover.*|hannet.*|hildesheim.*|hiss.*:doit

## GIT (Georgia Institute of Technology, USA)
newgroup:news@news.gatech.edu:git.*:doit
newgroup:news@news.gatech.edu:git*class.*:mail
rmgroup:news@news.gatech.edu:git.*:doit

## GNU (Free Software Foundation)
newgroup:gnu@prep.ai.mit.edu:gnu.*:doit
newgroup:news@*ai.mit.edu:gnu.*:doit
rmgroup:gnu@prep.ai.mit.edu:gnu.*:doit
rmgroup:news@*ai.mit.edu:gnu.*:doit

## GOV (Government Information)
# URL: http://www.govnews.org/govnews/
# Key URL: http://www.govnews.org/govnews/site-setup/gov.pgpkeys
# *PGP*   See comment at top of file.
newgroup:*:gov.*:drop
rmgroup:*:gov.*:drop
checkgroups:gov-usenet-announce-moderator@govnews.org:gov.*:verify-gov.usenet.announce
newgroup:gov-usenet-announce-moderator@govnews.org:gov.*:verify-gov.usenet.announce
rmgroup:gov-usenet-announce-moderator@govnews.org:gov.*:verify-gov.usenet.announce

## GWU (George Washington University, Washington, DC)
# Contact: Sweth Chandramouli <news@nit.gwu.edu>
newgroup:news@nit.gwu.edu:gwu.*:doit
rmgroup:news@nit.gwu.edu:gwu.*:doit

## HAMILTON (Canadian)
newgroup:news@*dcss.mcmaster.ca:hamilton.*:doit
rmgroup:news@*dcss.mcmaster.ca:hamilton.*:doit

## HAMSTER (Hamster, a Win32 news and mail proxy server)
# Contact: hamster-contact@snafu.de
# URL: http://www.nethamster.org
# Key URL: http://www.nethamster.org/control/hamster.asc
# Key fingerprint = 12 75 A9 42 8A D6 1F 77 6A CF B4 0C 79 15 5F 93
# *PGP*   See comment at top of file.
checkgroups:hamster-control@snafu.de:hamster.*:verify-hamster-control@snafu.de
newgroup:hamster-control@snafu.de:hamster.*:verify-hamster-control@snafu.de
rmgroup:hamster-control@snafu.de:hamster.*:verify-hamster-control@snafu.de

## HAN (Korean Hangul)
# Contact: newgroups-request@usenet.or.kr
# Key URL: ftp://ftp.usenet.or.kr/pub/korea/usenet/pgp/PGPKEY.han
# *PGP*   See comment at top of file.
newgroup:*:han.*:drop
rmgroup:*:han.*:drop
checkgroups:newgroups-request@usenet.or.kr:han.*:verify-han.news.admin
newgroup:newgroups-request@usenet.or.kr:han.*:verify-han.news.admin
rmgroup:newgroups-request@usenet.or.kr:han.*:verify-han.news.admin

## HARVARD (Harvard University, Cambridge, MA)
newgroup:*@*.harvard.edu:harvard.*:doit
rmgroup:*@*.harvard.edu:harvard.*:doit

## HAWAII
newgroup:news@lava.net:hawaii.*:doit
rmgroup:news@lava.net:hawaii.*:doit

## HIVNET (HIVNET Foundation, for HIV+/AIDS information)
# Contact: news@hivnet.org
# Key URL: ftp://ftp.hivnet.org/pub/usenet/pgpkey.hivnet
# Key fingerprint = 5D D6 0E DC 1E 2D EA 0B  B0 56 4D D6 52 53 D7 A4
# Syncable server: news.hivnet.org
# *PGP*   See comment at top of file.
newgroup:*:hiv.*:drop
rmgroup:*:hiv.*:drop
checkgroups:news@hivnet.org:hiv.*:verify-news@hivnet.org
newgroup:news@hivnet.org:hiv.*:verify-news@hivnet.org
rmgroup:news@hivnet.org:hiv.*:verify-news@hivnet.org

## HK (Hong Kong)
newgroup:hknews@comp.hkbu.edu.hk:hk.*:doit
rmgroup:hknews@comp.hkbu.edu.hk:hk.*:doit

## HOUSTON (Houston, Texas, USA)
# *PGP*   See comment at top of file.
newgroup:*:houston.*:drop
rmgroup:*:houston.*:drop
checkgroups:news@academ.com:houston.*:verify-houston.usenet.config
newgroup:news@academ.com:houston.*:verify-houston.usenet.config
rmgroup:news@academ.com:houston.*:verify-houston.usenet.config

## HUMANITYQUEST
# Contact: news-admin@humanityquest.com
# URL: http://www.humanityquest.com/projects/newsgroups/
# Key URL: http://www.humanityquest.com/projects/newsgroups/PGP.htm
# Key fingerprint = BA3D B306 B6F5 52AA BA8F 32F0 8C4F 5040 16F9 C046
# *PGP*  See comment at top of file.
newgroup:*:humanityquest.*:drop
rmgroup:*:humanityquest.*:drop
checkgroups:news-admin@humanityquest.com:humanityquest.*:verify-humanityquest.admin.config
newgroup:news-admin@humanityquest.com:humanityquest.*:verify-humanityquest.admin.config
rmgroup:news-admin@humanityquest.com:humanityquest.*:verify-humanityquest.admin.config

## HUN (Hungary)
newgroup:*:hun.*:drop
rmgroup:*:hun.*:drop
checkgroups:hun-mnt@news.sztaki.hu:hun.*:verify-hun.admin.news
newgroup:hun-mnt@news.sztaki.hu:hun.*:verify-hun.admin.news
rmgroup:hun-mnt@news.sztaki.hu:hun.*:verify-hun.admin.news

## IA (Iowa, USA)
newgroup:skunz@iastate.edu:ia.*:doit
rmgroup:skunz@iastate.edu:ia.*:doit

## IBMNET (*LOCAL*)
# Contact: news@ibm.net
# For local use only, contact the above address for information.
newgroup:*@*:ibmnet.*:mail
rmgroup:*@*:ibmnet.*:doit

## ICONZ (*LOCAL* -- The Internet Company of New Zealand, New Zealand)
# Contact: usenet@iconz.co.nz
# For local use only, contact the above address for information.
newgroup:*@*:iconz.*:mail
rmgroup:*@*:iconz.*:doit

## IDOCTRA (Idoctra Translation Software, Translation Discussion)
# Contact: support@idoctra.com
newgroup:support@idoctra.com:idoctra.*:doit
rmgroup:support@idoctra.com:idoctra.*:doit

## IE (Ireland)
# Contact: control@usenet.ie
# *PGP*   See comment at top of file.
newgroup:*:ie.*:drop
rmgroup:*:ie.*:drop
checkgroups:control@usenet.ie:ie.*:verify-control@usenet.ie
newgroup:control@usenet.ie:ie.*:verify-control@usenet.ie
rmgroup:control@usenet.ie:ie.*:verify-control@usenet.ie

## IEEE (*DEFUNCT* -- Institute of Electrical and Electronic Engineers)
# Contact: <postoffice@ieee.org>
# Defunct hierarchy, please remove any groups that you carry.
newgroup:*@*:ieee.*:mail
rmgroup:*@*:ieee.*:doit

## INFO newsgroups
newgroup:rjoyner@uiuc.edu:info.*:doit
rmgroup:rjoyner@uiuc.edu:info.*:doit

## IS (Iceland)
# Contact: Marius Olafsson <news@isnet.is>
# *PGP*   See comment at top of file.
newgroup:*:is.*:drop
rmgroup:*:is.*:drop
checkgroups:news@isnet.is:is.*:verify-is.isnet
newgroup:news@isnet.is:is.*:verify-is.isnet
rmgroup:news@isnet.is:is.*:verify-is.isnet

## ISC (Japanese ?)
newgroup:news@sally.isc.chubu.ac.jp:isc.*:doit
rmgroup:news@sally.isc.chubu.ac.jp:isc.*:doit

## ISRAEL & IL (Israel)
newgroup:news@news.biu.ac.il:israel.*:doit
rmgroup:news@news.biu.ac.il:israel.*|il.*:doit

## IT (Italian)
# Contact: gcn@news.nic.it
# URL: http://www.news.nic.it/
# Key URL: http://www.news.nic.it/pgp.txt
# Key fingerprint = 94 A4 F7 B5 46 96 D6 C7  A6 73 F2 98 C4 8C D0 E0
# *PGP*   See comment at top of file.
newgroup:*:it.*:drop
rmgroup:*:it.*:drop
checkgroups:gcn@news.nic.it:it.*:verify-gcn@news.nic.it
newgroup:gcn@news.nic.it:it.*:verify-gcn@news.nic.it
rmgroup:gcn@news.nic.it:it.*:verify-gcn@news.nic.it

## ITALIA (Italy)
# Contact: news@news.cineca.it
# URL: http://news.cineca.it/italia/
# Key URL: http://news.cineca.it/italia/italia-pgp.txt
# Key fingerprint = 0F BB 71 62 DA 5D 5D B8  D5 86 FC 28 02 67 1A 6B
# *PGP*   See comment at top of file.
newgroup:*:italia.*:drop
rmgroup:*:italia.*:drop
checkgroups:news@news.cineca.it:italia.*:verify-italia.announce.newgroups
newgroup:news@news.cineca.it:italia.*:verify-italia.announce.newgroups
rmgroup:news@news.cineca.it:italia.*:verify-italia.announce.newgroups

## IU (Indiana University)
newgroup:news@usenet.ucs.indiana.edu:iu.*:doit
newgroup:root@usenet.ucs.indiana.edu:iu.*:doit
newgroup:*@usenet.ucs.indiana.edu:iu*class.*:mail
rmgroup:news@usenet.ucs.indiana.edu:iu.*:doit
rmgroup:root@usenet.ucs.indiana.edu:iu.*:doit

## JAPAN (Japan)
# Contact: Tsuneo Tanaka <tt+null@efnet.com>
# URL: http://www.asahi-net.or.jp/~AE5T-KSN/japan-e.html
# Key URL: http://grex.cyberspace.org/~tt/japan.admin.announce.asc
# Key URL: http://www.asahi-net.or.jp/~AE5T-KSN/japan/japan.admin.announce.asc
# Key fingerprint = 6A FA 19 47 69 1B 10 74  38 53 4B 1B D8 BA 3E 85
# *PGP*   See comment at top of file.
newgroup:*:japan.*:drop
rmgroup:*:japan.*:drop
checkgroups:japan.admin.announce@news.efnet.com:japan.*:verify-japan.admin.announce@news.efnet.com
newgroup:japan.admin.announce@news.efnet.com:japan.*:verify-japan.admin.announce@news.efnet.com
rmgroup:japan.admin.announce@news.efnet.com:japan.*:verify-japan.admin.announce@news.efnet.com

## K12 (US Educational Network)
newgroup:braultr@*csmanoirs.qc.ca:k12.*:doit
rmgroup:braultr@*csmanoirs.qc.ca:k12.*:doit

## KA (*PRIVATE* -- Karlsruhe, Germany)
# Contact: usenet@karlsruhe.org
# URL: http://www.karlsruhe.org/             (German only)
# URL: http://www.karlsruhe.org/newsgroups   (newsgroup list)
# Key fingerprint =  DE 19 BB 25 76 19 81 17  F0 67 D2 23 E8 C8 7C 90
# For private use only, contact the above address for information.
# *PGP*   See comment at top of file.
newgroup:*:ka.*:drop
rmgroup:*:ka.*:drop
checkgroups:usenet@karlsruhe.org:ka.*:verify-usenet@karlsruhe.org
newgroup:usenet@karlsruhe.org:ka.*:verify-usenet@karlsruhe.org
rmgroup:usenet@karlsruhe.org:ka.*:verify-usenet@karlsruhe.org

## KANTO
# *PGP*   See comment at top of file.
rmgroup:*:kanto.*:drop
checkgroups:ty@kamoi.imasy.or.jp:kanto.*:verify-kanto.news.network
# NOTE: newgroups aren't verified...
newgroup:*@*.jp:kanto.*:doit
rmgroup:ty@kamoi.imasy.or.jp:kanto.*:verify-kanto.news.network

## KASSEL (Kassel, Germany)
# Key mail: pgp-public-keys@keys.de.pgp.net Subject: GET 0xC4D30EE5
# *PGP*   See comment at top of file.
newgroup:*:kassel.*:drop
rmgroup:*:kassel.*:drop
checkgroups:dirk.meyer@dinoex.sub.org:kassel.*:verify-kassel-admin
newgroup:dirk.meyer@dinoex.sub.org:kassel.*:verify-kassel-admin
rmgroup:dirk.meyer@dinoex.sub.org:kassel.*:verify-kassel-admin

## KC (Kansas City, Kansas/Missouri, USA)
newgroup:dan@sky.net:kc.*:doit
rmgroup:dan@sky.net:kc.*:doit

## KIEL (Kiel, Germany)
checkgroups:kris@white.schulung.netuse.de:kiel.*:mail
newgroup:kris@white.schulung.netuse.de:kiel.*:doit
rmgroup:kris@white.schulung.netuse.de:kiel.*:doit

## KRST (*LOCAL* -- University of Oslo, Norway)
# Contact: jani@ifi.uio.no
# For private use only, contact the above address for information.
newgroup:*@*:krst.*:drop
rmgroup:*@*:krst.*:doit

## KWNET (*LOCAL* -- Kitchener-Waterloo?)
# Contact: Ed Hew <edhew@xenitec.on.ca>
# For private use only, contact the above address for information.
newgroup:*@*:kwnet.*:mail
rmgroup:*@*:kwnet.*:doit

## LAW (?)
# Contact: Jim Burke <jburke@kentlaw.edu>
newgroup:*@*.kentlaw.edu:law.*:doit
newgroup:*@*.law.vill.edu:law.*:doit
rmgroup:*@*.kentlaw.edu:law.*:doit
rmgroup:*@*.law.vill.edu:law.*:doit

## LINUX (Gated Linux mailing lists)
# Contact: Marco d'Itri <md@toglimi.linux.it>
# Key fingerprint = 81 B3 27 99 4F CE 32 D1  1B C9 01 0D BB B3 2E 41
# *PGP*  See comment at top of file.
newgroup:*:linux.*:drop
rmgroup:*:linux.*:drop
checkgroups:linux-admin@bofh.it:linux.*:verify-linux-admin@bofh.it
newgroup:linux-admin@bofh.it:linux.*:verify-linux-admin@bofh.it
rmgroup:linux-admin@bofh.it:linux.*:verify-linux-admin@bofh.it

## LOCAL (Local-only groups)
# It is not really a good idea for sites to use these since they may occur
# on many unconnected sites.
newgroup:*@*:local.*:mail
rmgroup:*@*:local.*:drop

## MALTA (Nation of Malta)
# Contact: cmeli@cis.um.edu.mt
# URL: http://www.malta.news-admin.org/
# Key fingerprint = 20 17 01 5C F0 D0 1A 42  E4 13 30 58 0B 14 48 A6
# *PGP*   See comment at top of file.
newgroup:*:malta.*:drop
rmgroup:*:malta.*:drop
checkgroups:cmeli@cis.um.edu.mt:malta.*:verify-malta.config
newgroup:cmeli@cis.um.edu.mt:malta.*:verify-malta.config
rmgroup:cmeli@cis.um.edu.mt:malta.*:verify-malta.config

## MANAWATU (*LOCAL* -- Manawatu district, New Zealand)
# Contact: alan@manawatu.gen.nz or news@manawatu.gen.nz
# For local use only, contact the above address for information.
newgroup:*@*:manawatu.*:mail
rmgroup:*@*:manawatu.*:doit

## MAUS (MausNet, Germany)
# Key fingerprint: 82 52 C7 70 26 B9 72 A1  37 98 55 98 3F 26 62 3E
# *PGP*   See comment at top of file.
newgroup:*:maus.*:drop
rmgroup:*:maus.*:drop
checkgroups:guenter@gst0hb.north.de:maus.*:verify-maus-info
checkgroups:guenter@gst0hb.hb.provi.de:maus.*:verify-maus-info
newgroup:guenter@gst0hb.north.de:maus.*:verify-maus-info
newgroup:guenter@gst0hb.hb.provi.de:maus.*:verify-maus-info
rmgroup:guenter@gst0hb.north.de:maus.*:verify-maus-info
rmgroup:guenter@gst0hb.hb.provi.de:maus.*:verify-maus-info

## MCMASTER (*LOCAL* -- McMaster University, Ontario)
# Contact: Brian Beckberger <news@informer1.cis.mcmaster.ca>
# For local use only, contact the above address for information.
newgroup:*@*:mcmaster.*:mail
rmgroup:*@*:mcmaster.*:doit

## MCOM (Netscape Inc, USA)
newgroup:*@*:mcom.*:mail
rmgroup:*@*:mcom.*:doit

## ME (Maine, USA)
newgroup:kerry@maine.maine.edu:me.*:doit
rmgroup:kerry@maine.maine.edu:me.*:doit

## MEDLUX (All-Russia medical teleconferences)
# URL: ftp://ftp.medlux.ru/pub/news/medlux.grp
checkgroups:neil@new*.medlux.ru:medlux.*:mail
newgroup:neil@new*.medlux.ru:medlux.*:doit
rmgroup:neil@new*.medlux.ru:medlux.*:doit

## MELB (Melbourne, Australia)
newgroup:kre@*mu*au:melb.*:doit
newgroup:revdoc@*uow.edu.au:melb.*:doit
rmgroup:kre@*mu*au:melb.*:doit
rmgroup:revdoc@*uow.edu.au:melb.*:doit

## MENSA (The Mensa Organisation)
# Contact: usenet@newsgate.mensa.org
# Key fingerprint = A7 57 24 49 C0 D4 47 33  84 A0 52 6E F1 A4 00 5B
# *PGP*   See comment at top of file.
newgroup:*:mensa.*:drop
rmgroup:*:mensa.*:drop
checkgroups:usenet@newsgate.mensa.org:mensa.*:verify-mensa.config
newgroup:usenet@newsgate.mensa.org:mensa.*:verify-mensa.config
rmgroup:usenet@newsgate.mensa.org:mensa.*:verify-mensa.config

## METOCEAN (ISP in Japan)
newgroup:fwataru@*.metocean.co.jp:metocean.*:doit
rmgroup:fwataru@*.metocean.co.jp:metocean.*:doit

## METROPOLIS (*LOCAL*)
# Contact: newsmaster@worldonline.nl
# For local use only, contact the above address for information.
newgroup:*@*:metropolis.*:mail
rmgroup:*@*:metropolis.*:doit

## MI (Michigan, USA)
# Contact: Steve Simmons <scs@lokkur.dexter.mi.us>
# URL: http://www.inland-sea.com/mi-news.html
checkgroups:scs@lokkur.dexter.mi.us:mi.*:mail
newgroup:scs@lokkur.dexter.mi.us:mi.*:doit
rmgroup:scs@lokkur.dexter.mi.us:mi.*:doit

## MICROSOFT (Microsoft, Inc.)
#
# Broken control messages for the Microsoft groups are sent from the
# address pssolops@microsoft.com, but they aren't signed and don't contain
# valid newsgroup file entries.  It is therefore recommended to use
# actsync rather than control message processing to maintain one's local
# list of microsoft.* groups if you carry this hierarchy.
#
# newgroup:pssolops@microsoft.com:microsoft.*:doit
# rmgroup:pssolops@microsoft.com:microsoft.*:doit
newgroup:*:microsoft.*:drop
rmgroup:*:microsoft.*:drop

## MILW (Milwaukee, Wisconsin, USA)
# Contact: milw@usenet.mil.wi.us
# URL: http://usenet.mil.wi.us
# Key fingerprint = 6E 9B 9F 70 98 AB 9C E5  C3 C0 05 82 21 5B F4 9E
# Key URL: http://usenet.mil.wi.us/pgpkey
# *PGP*   See comment at top of file.
checkgroups:milw@usenet.mil.wi.us:milw.*:verify-milw.config
newgroup:milw@usenet.mil.wi.us:milw.*:verify-milw.config
rmgroup:milw@usenet.mil.wi.us:milw.*:verify-milw.config

## MOD (*DEFUNCT* -- Original top level moderated hierarchy)
# Removed in the "Great Renaming" of 1988.
# Possible revival attempt in mid-97, so watch this space..
newgroup:*@*:mod.*:mail
rmgroup:*@*:mod.*:doit

## MUC (Munchen (Munich), Germany)
# Key fingerprint = 43 C7 0E 7C 45 C7 06 E0  BD 6F 76 CE 07 39 5E 66
# *PGP*   See comment at top of file.
newgroup:*:muc.*:drop
rmgroup:*:muc.*:drop
checkgroups:muc-cmsg@muenchen.pro-bahn.org:muc.*:verify-muc.admin
newgroup:muc-cmsg@muenchen.pro-bahn.org:muc.*:verify-muc.admin
rmgroup:muc-cmsg@muenchen.pro-bahn.org:muc.*:verify-muc.admin

## NAGASAKI-U (Nagasaki University, Japan ?)
newgroup:root@*nagasaki-u.ac.jp:nagasaki-u.*:doit
rmgroup:root@*nagasaki-u.ac.jp:nagasaki-u.*:doit

## NAS (*LOCAL* -- Numerican Aerodynamic Simulation Facility,
## NASA Ames Research Center, USA)
# Contact: news@nas.nasa.gov
# For internal use only, contact above address for questions.
newgroup:*@*:nas.*:mail
rmgroup:*@*:nas.*:doit

## NASA (*LOCAL* -- National Aeronautics and Space Administration, USA)
# Contact: news@nas.nasa.gov
# For internal use only, contact above address for questions.
newgroup:*@*:nasa.*:mail
rmgroup:*@*:nasa.*:doit

## NC (North Carolina, USA)
#
# Tim Seaver <tas@bellsouth.net> says he hasn't had any dealings with nc.*
# for over two years and the hierarchy is basically "open to anyone who
# wants it."
#
# newgroup:tas@ncren.net:nc.*:doit
# rmgroup:tas@ncren.net:nc.*:doit

## NCF (*LOCAL* -- National Capital Freenet, Ottawa, Ontario, Canada)
# Contact: news@freenet.carleton.ca
# For local use only, contact the above address for information.
newgroup:*@*:ncf.*:mail
rmgroup:*@*:ncf.*:doit

## NCTU newsgroups (Taiwan)
newgroup:chen@cc.nctu.edu.tw:nctu.*:doit
rmgroup:chen@cc.nctu.edu.tw:nctu.*:doit

## NCU (*LOCAL* -- National Central University, Taiwan)
# Contact: Ying-Hao Chang <aqlott@db.csie.ncu.edu.tw>
# Contact: <runn@news.ncu.edu.tw>
# For local use only, contact the above addresses for information.
newgroup:*@*:ncu.*:mail
rmgroup:*@*:ncu.*:doit

## NERSC (National Energy Research Scientific Computing Center)
# Contact: <usenet@nersc.gov>
# newgroup:*@*:nersc.*:mail
# rmgroup:*@*:nersc.*:doit

## NET newsgroups (Usenet 2)
# URL: http://www.usenet2.org
# Key fingerprint = D7 D3 5C DB 18 6A 29 79  BF 74 D4 58 A3 78 9D 22
# *PGP*   See comment at top of file.
newgroup:*:net.*:drop
rmgroup:*:net.*:drop
checkgroups:control@usenet2.org:net.*:verify-control@usenet2.org
newgroup:control@usenet2.org:net.*:verify-control@usenet2.org
rmgroup:control@usenet2.org:net.*:verify-control@usenet2.org

## NETSCAPE (Netscape Communications Corp)
# Contact: news@netscape.com
# URL: http://www.mozilla.org/community.html
# URL: http://www.mozilla.org/newsfeeds.html
# Key fingerprint = B7 80 55 12 1F 9C 17 0B  86 66 AD 3B DB 68 35 EC
# *PGP*   See comment at top of file.
newgroup:*:netscape.*:drop
rmgroup:*:netscape.*:drop
checkgroups:news@netscape.com:netscape.*:verify-netscape.public.admin
newgroup:news@netscape.com:netscape.*:verify-netscape.public.admin
rmgroup:news@netscape.com:netscape.*:verify-netscape.public.admin

## NETINS (*LOCAL* -- netINS, Inc)
# Contact: news@netins.net
# For local use only, contact the above address for information.
newgroup:*@*:netins.*:mail
rmgroup:*@*:netins.*:doit

## NIAGARA (Niagara Peninsula, USA/Canada)
newgroup:news@niagara.com:niagara.*:doit
rmgroup:news@niagara.com:niagara.*:doit

## NIAS (Japanese ?)
newgroup:news@cc.nias.ac.jp:nias.*:doit
rmgroup:news@cc.nias.ac.jp:nias.*:doit

## NIGERIA (Nigeria)
newgroup:news@easnet.net:nigeria.*:doit
rmgroup:news@easnet.net:nigeria.*:doit

## NIHON (Japan)
newgroup:ktomita@jade.dti.ne.jp:nihon.*:doit
rmgroup:ktomita@jade.dti.ne.jp:nihon.*:doit

## NL (Netherlands)
# Contact: nl-admin@nic.surfnet.nl
# URL: http://www.xs4all.nl/~egavic/NL/ (Dutch)
# URL: http://www.kinkhorst.com/usenet/nladmin.en.html (English)
# Key fingerprint = 45 20 0B D5 A1 21 EA 7C  EF B2 95 6C 25 75 4D 27
# *PGP*   See comment at top of file.
newgroup:*:nl.*:drop
rmgroup:*:nl.*:drop
checkgroups:nl-admin@nic.surfnet.nl:nl.*:verify-nl.newsgroups
newgroup:nl-admin@nic.surfnet.nl:nl.*:verify-nl.newsgroups
rmgroup:nl-admin@nic.surfnet.nl:nl.*:verify-nl.newsgroups

## NL-ALT (Alternative Netherlands groups)
# URL: http://www.xs4all.nl/~onno/nl-alt/
# Several options are given in the FAQ for creating and removing groups.
# Key fingerprint = 6B 62 EB 53 4D 5D 2F 96  35 D9 C8 9C B0 65 0E 4C
# *PGP*   See comment at top of file.
rmgroup:*:nl-alt.*:drop
checkgroups:nl-alt-janitor@surfer.xs4all.nl:nl-alt.*:verify-nl-alt.config.admin
newgroup:*@*:nl-alt.*:doit
rmgroup:nl-alt-janitor@surfer.xs4all.nl:nl-alt.*:verify-nl-alt.config.admin
rmgroup:news@kink.xs4all.nl:nl-alt.*:verify-nl-alt.config.admin

## NLNET (Netherlands ISP)
newgroup:beheer@nl.net:nlnet.*:doit
rmgroup:beheer@nl.net:nlnet.*:doit

## NLO (Open Source / Free Software, hosted by nl.linux.org)
# URL: http://news.nl.linux.org/doc/nlo.html
# Key fingerprint = 63 DC B2 51 0A F3 DD 72  C2 BD C6 FD C1 C5 44 CF
# *PGP*  See comment at top of file.
newgroup:*:nlo.*:drop
rmgroup:*:nlo.*:drop
checkgroups:news@nl.linux.org:nlo.*:verify-nlo.newsgroups
newgroup:news@nl.linux.org:nlo.*:verify-nlo.newsgroups
rmgroup:news@nl.linux.org:nlo.*:verify-nlo.newsgroups

## NM (New Mexico, USA)
newgroup:news@tesuque.cs.sandia.gov:nm.*:doit
rmgroup:news@tesuque.cs.sandia.gov:nm.*:doit

## NO (Norway)
# URL: http://www.usenet.no/
# *PGP*   See comment at top of file.
newgroup:*:no.*:drop
rmgroup:*:no.*:drop
checkgroups:control@usenet.no:no.*:verify-no-hir-control
newgroup:control@usenet.no:no.*:verify-no-hir-control
newgroup:*@*.no:no.alt.*:doit
rmgroup:control@usenet.no:no.*:verify-no-hir-control

## NORD (Northern Germany)
# thilo@own.deceiver.org no longer a valid address
# newgroup:thilo@own.deceiver.org:nord.*:doit
# rmgroup:thilo@own.deceiver.org:nord.*:doit

## NV (Nevada)
newgroup:doctor@netcom.com:nv.*:doit
newgroup:cshapiro@netcom.com:nv.*:doit
rmgroup:doctor@netcom.com:nv.*:doit
rmgroup:cshapiro@netcom.com:nv.*:doit

## NY (New York State, USA)
newgroup:root@ny.psca.com:ny.*:mail
rmgroup:root@ny.psca.com:ny.*:mail

## NYC (New York City)
# Contact: Perry E. Metzger <perry@piermont.com>
newgroup:perry@piermont.com:nyc.*:doit
rmgroup:perry@piermont.com:nyc.*:doit

## NZ (New Zealand)
# Contact: root@usenet.net.nz
# URL: http://usenet.net.nz
# URL: http://www.faqs.org/faqs/usenet/nz-news-hierarchy
# Key fingerprint = 07 DF 48 AA D0 ED AA 88  16 70 C5 91 65 3D 1A 28
# *PGP*   See comment at top of file.
newgroup:*:nz.*:drop
rmgroup:*:nz.*:drop
checkgroups:root@usenet.net.nz:nz.*:verify-nz-hir-control
newgroup:root@usenet.net.nz:nz.*:verify-nz-hir-control
rmgroup:root@usenet.net.nz:nz.*:verify-nz-hir-control

## OC (Orange County, California, USA)
newgroup:bob@tsunami.sugarland.unocal.com:oc.*:doit
rmgroup:bob@tsunami.sugarland.unocal.com:oc.*:doit

## OH (Ohio, USA)
newgroup:trier@ins.cwru.edu:oh.*:doit
rmgroup:trier@ins.cwru.edu:oh.*:doit

## OK (Oklahoma, USA)
newgroup:quentin@*qns.com:ok.*:doit
rmgroup:quentin@*qns.com:ok.*:doit

## OKINAWA (Okinawa, Japan)
newgroup:news@opus.or.jp:okinawa.*:doit
rmgroup:news@opus.or.jp:okinawa.*:doit

## ONT (Ontario, Canada)
newgroup:pkern@gpu.utcc.utoronto.ca:ont.*:doit
rmgroup:pkern@gpu.utcc.utoronto.ca:ont.*:doit

## OPERA (Opera Software, Oslo, Norway)
# Contact: usenet@opera.com
# URL: http://news.opera.com/
# Key URL: http://news.opera.com/pgpkey-opera-group-admin
# *PGP*   See comment at top of file.
newgroup:*@opera.com:opera.*:verify-opera-group-admin
rmgroup:*@opera.com:opera.*:verify-opera-group-admin
checkgroups:*@opera.com:opera.*:verify-opera-group-admin

## OTT (Ottawa, Ontario, Canada)
# Contact: onag@pinetree.org
# URL: http://www.pinetree.org/ONAG/
newgroup:news@bnr.ca:ott.*:doit
newgroup:news@nortel.ca:ott.*:doit
newgroup:clewis@ferret.ocunix.on.ca:ott.*:doit
newgroup:news@ferret.ocunix.on.ca:ott.*:doit
newgroup:news@*pinetree.org:ott.*:doit
newgroup:gordon@*pinetree.org:ott.*:doit
newgroup:dave@revcan.ca:ott.*:doit
rmgroup:news@bnr.ca:ott.*:doit
rmgroup:news@nortel.ca:ott.*:doit
rmgroup:clewis@ferret.ocunix.on.ca:ott.*:doit
rmgroup:news@ferret.ocunix.on.ca:ott.*:doit
rmgroup:news@*pinetree.org:ott.*:doit
rmgroup:gordon@*pinetree.org:ott.*:doit
rmgroup:dave@revcan.ca:ott.*:doit

## PA (Pennsylvania, USA)
# URL: http://www.netcom.com/~rb1000/pa_hierarchy/
newgroup:fxp@epix.net:pa.*:doit
rmgroup:fxp@epix.net:pa.*:doit

## PGH (Pittsburgh, Pennsylvania, USA)
# *PGP*   See comment at top of file.
newgroup:*:pgh.*:drop
rmgroup:*:pgh.*:drop
checkgroups:pgh-config@psc.edu:pgh.*:verify-pgh.config
newgroup:pgh-config@psc.edu:pgh.*:verify-pgh.config
rmgroup:pgh-config@psc.edu:pgh.*:verify-pgh.config

## PHL (Philadelphia, Pennsylvania, USA)
newgroup:news@vfl.paramax.com:phl.*:doit
rmgroup:news@vfl.paramax.com:phl.*:doit

## PIN (Personal Internauts' NetNews)
newgroup:pin-admin@forus.or.jp:pin.*:doit
rmgroup:pin-admin@forus.or.jp:pin.*:doit

## PIPEX (UUNET WorldCom UK)
# Contact: Russell Vincent <news-control@ops.pipex.net>
newgroup:news-control@ops.pipex.net:pipex.*:doit
rmgroup:news-control@ops.pipex.net:pipex.*:doit

## PITT (University of Pittsburgh, PA)
newgroup:news+@pitt.edu:pitt.*:doit
newgroup:news@toads.pgh.pa.us:pitt.*:doit
rmgroup:news+@pitt.edu:pitt.*:doit
rmgroup:news@toads.pgh.pa.us:pitt.*:doit

## PL (Poland and Polish language)
# URL: http://www.ict.pwr.wroc.pl/doc/news-pl-new-site-faq.html
# *PGP*   See comment at top of file.
newgroup:*:pl.*:drop
rmgroup:*:pl.*:drop
checkgroups:michalj@*fuw.edu.pl:pl.*:verify-pl.announce.newgroups
checkgroups:newgroup@usenet.pl:pl.*:verify-pl.announce.newgroups
newgroup:michalj@*fuw.edu.pl:pl.*:verify-pl.announce.newgroups
newgroup:newgroup@usenet.pl:pl.*:verify-pl.announce.newgroups
rmgroup:michalj@*fuw.edu.pl:pl.*:verify-pl.announce.newgroups
rmgroup:newgroup@usenet.pl:pl.*:verify-pl.announce.newgroups

## PLANET (*LOCAL* -- PlaNet FreeNZ co-operative, New Zealand)
# Contact: office@pl.net
# For local use only, contact the above address for information.
newgroup:*@*:planet.*:mail
rmgroup:*@*:planet.*:doit

## PRIMA (*LOCAL* -- prima.ruhr.de/Prima e.V. in Germany)
# Contact: admin@prima.ruhr.de
# For internal use only, contact above address for questions
newgroup:*@*:prima.*:mail
rmgroup:*@*:prima.*:doit

## PSU (*LOCAL* -- Penn State University, USA)
# Contact: Dave Barr (barr@math.psu.edu)
# For internal use only, contact above address for questions
newgroup:*@*:psu.*:mail
rmgroup:*@*:psu.*:doit

## PT (Portugal and Portuguese language)
newgroup:*:pt.*:drop
rmgroup:*:pt.*:drop
checkgroups:pmelo@*.inescc.pt:pt.*:verify-control@usenet-pt.org
newgroup:pmelo@*.inescc.pt:pt.*:verify-control@usenet-pt.org
rmgroup:pmelo@*.inescc.pt:pt.*:verify-control@usenet-pt.org

## PUBNET (*DEFUNCT*)
# URL: ftp://ftp.isc.org/pub/usenet/control/pubnet/pubnet.config.Z
# Defunct hierarchy, please remove any groups that you carry.
newgroup:*@*:pubnet.*:mail
rmgroup:*@*:pubnet.*:doit

## RELCOM (Commonwealth of Independent States)
# The official list of relcom groups is supposed to be available from
# URL: ftp://kiarchive.relcom.ru/pub/relcom/netinfo/
# *PGP*   See comment at top of file.
newgroup:*:relcom.*:drop
rmgroup:*:relcom.*:drop
checkgroups:coord@new*.relcom.ru:relcom.*:verify-relcom.newsgroups
newgroup:coord@new*.relcom.ru:relcom.*:verify-relcom.newsgroups
rmgroup:coord@new*.relcom.ru:relcom.*:verify-relcom.newsgroups

## RPI (*LOCAL* -- Rensselaer Polytechnic Institute, Troy, NY, USA)
# Contact: sofkam@rpi.edu
# For local use only, contact the above address for information.
newgroup:*@*:rpi.*:mail
rmgroup:*@*:rpi.*:doit

## SAAR (Saarland Region, Germany)
# URL: http://www.saar-admin-news.de/
# Key URL: http://www.saar-admin-news.de/saar-control.asc
# *PGP*   See comment at top of file.
newgroup:control@saar-admin-news.de:saar.*:verify-saar-control
rmgroup:control@saar-admin-news.de:saar.*:verify-saar-control
checkgroups:control@saar-admin-news.de:saar.*:verify-saar-control

## SACHSNET (German)
newgroup:root@lusatia.de:sachsnet.*:doit
rmgroup:root@lusatia.de:sachsnet.*:doit

## SAT (San Antonio, Texas, USA)
# Contact: satgroup@endicor.com
# URL: http://www.endicor.com/~satgroup/
# *PGP*   See comment at top of file.
newgroup:*:sat.*:drop
rmgroup:*:sat.*:drop
checkgroups:satgroup@endicor.com:sat.*:verify-satgroup@endicor.com
newgroup:satgroup@endicor.com:sat.*:verify-satgroup@endicor.com
rmgroup:satgroup@endicor.com:sat.*:verify-satgroup@endicor.com

## SBAY (South Bay/Silicon Valley, California)
newgroup:steveh@grafex.sbay.org:sbay.*:doit
newgroup:ikluft@thunder.sbay.org:sbay.*:doit
rmgroup:steveh@grafex.sbay.org:sbay.*:mail
rmgroup:ikluft@thunder.sbay.org:sbay.*:mail

## SCHULE
# Contact: schule-admin@roxel.ms.sub.org
# URL: http://home.pages.de/~schule-admin/
# Key URL: http://home.pages.de/~schule-admin/schule.asc
# Key fingerprint = 64 06 F0 AE E1 46 85 0C  BD CA 0E 53 8B 1E 73 D2
# *PGP*   See comment at top of file.
newgroup:*:schule.*:drop
rmgroup:*:schule.*:drop
checkgroups:newsctrl@schule.de:schule.*:verify-schule.konfig
newgroup:newsctrl@schule.de:schule.*:verify-schule.konfig
rmgroup:newsctrl@schule.de:schule.*:verify-schule.konfig

## SDNET (Greater San Diego Area, California, USA)
# URL: http://www-rohan.sdsu.edu/staff/wk/w/sdnet.html
# URL: http://www-rohan.sdsu.edu/staff/wk/w/config.html
# URL: ftp://ftp.csu.net/pub/news/active
newgroup:wkronert@sunstroke.sdsu.edu:sdnet.*:doit
rmgroup:wkronert@sunstroke.sdsu.edu:sdnet.*:doit

## SDSU (*LOCAL* -- San Diego State University, CA)
# Contact: Craig R. Sadler <usenet@sdsu.edu>
# For local use only, contact the above address for information.
newgroup:*@*:sdsu.*:mail
rmgroup:*@*:sdsu.*:doit

## SE (Sweden)
# Contact: usenet@usenet-se.net
# URL: http://www.usenet-se.net/
# URL: http://www.usenet-se.net/index_eng.html  (English version)
# Key URL: http://www.usenet-se.net/pgp-key.txt
# Key fingerprint = 68 03 F0 FD 0C C3 4E 69  6F 0D 0C 60 3C 58 63 96
# *PGP*   See comment at top of file.
newgroup:*:se.*:drop
rmgroup:*:se.*:drop
checkgroups:usenet@usenet-se.net:se.*:verify-usenet-se
newgroup:usenet@usenet-se.net:se.*:verify-usenet-se
rmgroup:usenet@usenet-se.net:se.*:verify-usenet-se

## SEATTLE (Seattle, Washington, USA)
newgroup:billmcc@akita.com:seattle.*:doit
newgroup:graham@ee.washington.edu:seattle.*:doit
rmgroup:billmcc@akita.com:seattle.*:doit
rmgroup:graham@ee.washington.edu:seattle.*:doit

## SFNET (Finland)
newgroup:sfnet@*.cs.tut.fi:sfnet.*:doit
rmgroup:sfnet@*.cs.tut.fi:sfnet.*:doit

## SHAMASH (Jewish)
newgroup:archives@israel.nysernet.org:shamash.*:doit
rmgroup:archives@israel.nysernet.org:shamash.*:doit

## SI (The Republic of Slovenia)
# *PGP*   See comment at top of file.
newgroup:*:si.*:drop
rmgroup:*:si.*:drop
checkgroups:news-admin@arnes.si:si.*:verify-si.news.announce.newsgroups
newgroup:news-admin@arnes.si:si.*:verify-si.news.announce.newsgroups
rmgroup:news-admin@arnes.si:si.*:verify-si.news.announce.newsgroups

## SK (Slovakia)
checkgroups:uhlar@ccnews.ke.sanet.sk:sk.*:mail
newgroup:uhlar@ccnews.ke.sanet.sk:sk.*:doit
rmgroup:uhlar@ccnews.ke.sanet.sk:sk.*:doit

## SLAC (*PRIVATE* -- Stanford Linear Accelerator Center, Stanford, USA)
# Contact: news@news.stanford.edu
# Limited distribution hierarchy, contact the above address for information.
newgroup:news@news.stanford.edu:slac.*:mail
rmgroup:news@news.stanford.edu:slac.*:doit

## SLO (San Luis Obispo, CA)
newgroup:news@punk.net:slo.*:doit
rmgroup:news@punk.net:slo.*:doit

## SOLENT (Solent region, England)
newgroup:news@tcp.co.uk:solent.*:doit
rmgroup:news@tcp.co.uk:solent.*:doit

## SPOKANE (Spokane, Washington, USA)
newgroup:usenet@news.spokane.wa.us:spokane.*:doit
rmgroup:usenet@news.spokane.wa.us:spokane.*:doit

## STAROFFICE (StarOffice business suite, Sun Microsystems, Inc.)
# Contact: news@stardivision.de
# URL: http://www.sun.com/products/staroffice/newsgroups.html
# Key fingerprint = F6 6A 5C 57 77 1F 63 26  F2 43 02 41 75 2A 04 1C
# Syncable server: starnews.sun.com
# *PGP*   See comment at top of file.
newgroup:*:staroffice.*:drop
rmgroup:*:staroffice.*:drop
checkgroups:news@stardivision.de:staroffice.*:verify-staroffice.admin
newgroup:news@stardivision.de:staroffice.*:verify-staroffice.admin
rmgroup:news@stardivision.de:staroffice.*:verify-staroffice.admin

## STGT (Stuttgart, Germany)
# URL: http://news.uni-stuttgart.de/hierarchie/stgt/stgt-control.txt
# *PGP*   See comment at start of file.
newgroup:*:stgt.*:drop
rmgroup:*:stgt.*:drop
checkgroups:stgt-control@news.uni-stuttgart.de:stgt.*:verify-stgt-control
newgroup:stgt-control@news.uni-stuttgart.de:stgt.*:verify-stgt-control
rmgroup:stgt-control@news.uni-stuttgart.de:stgt.*:verify-stgt-control

## STL (Saint Louis, Missouri, USA)
newgroup:news@icon-stl.net:stl.*:doit
rmgroup:news@icon-stl.net:stl.*:doit

## SU (*LOCAL* -- Stanford University, USA)
# Contact: news@news.stanford.edu
# For local use only, contact the above address for information.
newgroup:*@*:su.*:mail
rmgroup:*@*:su.*:doit

## SUNET (Swedish University Network)
newgroup:ber@*.sunet.se:sunet.*:doit
rmgroup:ber@*.sunet.se:sunet.*:doit

## SURFNET (Dutch Universities network)
newgroup:news@info.nic.surfnet.nl:surfnet.*:doit
rmgroup:news@info.nic.surfnet.nl:surfnet.*:doit

## SWNET (Sverige, Sweden)
newgroup:ber@sunic.sunet.se:swnet.*:doit
rmgroup:ber@sunic.sunet.se:swnet.*:doit

## TAMU (Texas A&M University)
# Contact: Philip Kizer <news@tamu.edu>
newgroup:news@tamsun.tamu.edu:tamu.*:doit
rmgroup:news@tamsun.tamu.edu:tamu.*:doit

## TAOS (Taos, New Mexico, USA)
# Contact: Chris Gunn <cgunn@laplaza.org>
newgroup:cgunn@laplaza.org:taos.*:doit
rmgroup:cgunn@laplaza.org:taos.*:doit

## TCFN (Toronto Free Community Network, Canada)
newgroup:news@t-fcn.net:tcfn.*:doit
rmgroup:news@t-fcn.net:tcfn.*:doit

## T-NETZ (*DEFUNCT* -- Germany)
# Defunct, use z-netz.*.
newgroup:*@*:t-netz.*:mail
rmgroup:*@*:t-netz.*:doit

## TELE (*LOCAL* -- Tele Danmark Internet)
# Contact: usenet@tdk.net
# For internal use only, contact above address for questions.
newgroup:*@*:tele.*:mail
rmgroup:*@*:tele.*:doit

## TERMVAKT (*LOCAL* -- University of Oslo, Norway)
# Contact: jani@ifi.uio.no
# For private use only, contact the above address for information.
newgroup:*@*:termvakt.*:drop
rmgroup:*@*:termvakt.*:doit

## TEST (Local test hierarchy)
# It is not really a good idea for sites to use these since they may occur
# on many unconnected sites.
newgroup:*@*:test.*:mail
rmgroup:*@*:test.*:mail

## THUR (Thuringia, Germany)
# Key Fingerprint: 7E 3D 73 13 93 D4 CA 78  39 DE 3C E7 37 EE 22 F1
# *PGP*   See comment at top of file.
newgroup:*:thur.*:drop
rmgroup:*:thur.*:drop
checkgroups:usenet@thur.de:thur.*:verify-thur.net.news.groups
newgroup:usenet@thur.de:thur.*:verify-thur.net.news.groups
rmgroup:usenet@thur.de:thur.*:verify-thur.net.news.groups

## TNN (The Network News, Japan)
newgroup:tnn@iij-mc.co.jp:tnn.*:doit
newgroup:netnews@news.iij.ad.jp:tnn.*:doit
rmgroup:tnn@iij-mc.co.jp:tnn.*:doit
rmgroup:netnews@news.iij.ad.jp:tnn.*:doit

## TRIANGLE (Research Triangle, Central North Carolina, USA)
newgroup:jfurr@acpub.duke.edu:triangle.*:doit
newgroup:tas@concert.net:triangle.*:doit
newgroup:news@news.duke.edu:triangle.*:doit
rmgroup:jfurr@acpub.duke.edu:triangle.*:doit
rmgroup:tas@concert.net:triangle.*:doit
rmgroup:news@news.duke.edu:triangle.*:doit

## TUM (Technische Universitaet Muenchen)
newgroup:news@informatik.tu-muenchen.de:tum.*:doit
rmgroup:news@informatik.tu-muenchen.de:tum.*:doit

## TW (Taiwan)
newgroup:ltc@news.cc.nctu.edu.tw:tw.*:doit
newgroup:k-12@news.nchu.edu.tw:tw.k-12.*:doit
rmgroup:ltc@news.cc.nctu.edu.tw:tw.*:doit
rmgroup:k-12@news.nchu.edu.tw:tw.k-12*:doit

## TX (Texas, USA)
newgroup:eric@cirr.com:tx.*:doit
newgroup:fletcher@cs.utexas.edu:tx.*:doit
newgroup:usenet@academ.com:tx.*:doit
rmgroup:eric@cirr.com:tx.*:doit
rmgroup:fletcher@cs.utexas.edu:tx.*:doit
rmgroup:usenet@academ.com:tx.*:doit

## UCB (University of California Berkeley, USA)
# Contact: Chris van den Berg <usenet@agate.berkeley.edu>
newgroup:*:ucb.*:drop
rmgroup:*:ucb.*:drop
checkgroups:usenet@agate.berkeley.edu:ucb.*:verify-ucb.news
newgroup:usenet@agate.berkeley.edu:ucb.*:verify-ucb.news
rmgroup:usenet@agate.berkeley.edu:ucb.*:verify-ucb.news

## UCD (University of California Davis, USA)
newgroup:usenet@rocky.ucdavis.edu:ucd.*:doit
newgroup:usenet@mark.ucdavis.edu:ucd.*:doit
rmgroup:usenet@rocky.ucdavis.edu:ucd.*:doit
rmgroup:usenet@mark.ucdavis.edu:ucd.*:doit

## UFRA (Unterfranken, Deutschland)
# Contact: news@mayn.de
# URL: http://www.mayn.de/users/news/
# Key fingerprint = F7 AD 96 D8 7A 3F 7E 84  02 0C 83 9A DB 8F EB B8
# Syncable server: news.mayn.de (contact news@mayn.de if permission denied)
# *PGP*   See comment at top of file.
newgroup:*:ufra.*:drop
rmgroup:*:ufra.*:drop
checkgroups:news@mayn.de:ufra.*:verify-news.mayn.de
newgroup:news@mayn.de:ufra.*:verify-news.mayn.de
rmgroup:news@mayn.de:ufra.*:verify-news.mayn.de

## UIUC (*LOCAL* -- University of Illinois at Urbana-Champaign, USA)
# Contact: usenet@uiuc.edu
# For internal use only, contact above address for questions.
newgroup:*@*:uiuc.*:mail
rmgroup:*@*:uiuc.*:doit

## UK (United Kingdom of Great Britain and Northern Ireland)
# *PGP*   See comment at top of file.
newgroup:*:uk.*:drop
rmgroup:*:uk.*:drop
checkgroups:control@usenet.org.uk:uk.*:verify-uk.net.news.announce
newgroup:control@usenet.org.uk:uk.*:verify-uk.net.news.announce
rmgroup:control@usenet.org.uk:uk.*:verify-uk.net.news.announce

## UKR (Ukraine)
newgroup:ay@sita.kiev.ua:ukr.*:doit
rmgroup:ay@sita.kiev.ua:ukr.*:doit

## UMICH (University of Michigan, USA)
newgroup:*@*.umich.edu:umich.*:doit
rmgroup:*@*.umich.edu:umich.*:doit

## UMN (University of Minnesota, USA)
newgroup:edh@*.tc.umn.edu:umn.*:doit
newgroup:news@*.tc.umn.edu:umn.*:doit
newgroup:Michael.E.Hedman-1@umn.edu:umn.*:doit
newgroup:edh@*.tc.umn.edu:umn*class.*:mail
newgroup:news@*.tc.umn.edu:umn*class.*:mail
newgroup:Michael.E.Hedman-1@umn.edu:umn*class.*:mail
rmgroup:news@*.tc.umn.edu:umn.*:doit
rmgroup:edh@*.tc.umn.edu:umn.*:doit
rmgroup:Michael.E.Hedman-1@umn.edu:umn.*:doit

## UN (The United Nations)
# URL: http://www.itu.int/Conferences/un/
# *PGP*   See comment at top of file.
newgroup:*:un.*:drop
rmgroup:*:un.*:drop
checkgroups:news@news.itu.int:un.*:verify-ungroups@news.itu.int
newgroup:news@news.itu.int:un.*:verify-ungroups@news.itu.int
rmgroup:news@news.itu.int:un.*:verify-ungroups@news.itu.int

## UO (University of Oregon, Eugene, Oregon, USA)
newgroup:newsadmin@news.uoregon.edu:uo.*:doit
rmgroup:newsadmin@news.uoregon.edu:uo.*:doit

## US (United States of America)
checkgroups:uscontrol@earthlink.net:us.*:mail
newgroup:uscontrol@earthlink.net:us.*:doit
rmgroup:uscontrol@earthlink.net:us.*:doit

## UT (University of Toronto, Canada)
# newgroup:news@ecf.toronto.edu:ut.*:doit
# newgroup:news@ecf.toronto.edu:ut.class.*:mail
# rmgroup:news@ecf.toronto.edu:ut.*:doit

## UTA (Finnish)
newgroup:news@news.cc.tut.fi:uta.*:doit
rmgroup:news@news.cc.tut.fi:uta.*:doit

## UTEXAS (University of Texas, USA)
newgroup:fletcher@cs.utexas.edu:utexas.*:doit
newgroup:news@geraldo.cc.utexas.edu:utexas.*:doit
newgroup:fletcher@cs.utexas.edu:utexas*class.*:mail
newgroup:news@geraldo.cc.utexas.edu:utexas*class.*:mail
rmgroup:fletcher@cs.utexas.edu:utexas.*:doit
rmgroup:news@geraldo.cc.utexas.edu:utexas.*:doit

## UTWENTE (*LOCAL* -- University of Twente, Netherlands)
# Contact: newsmaster@utwente.nl
# For internal use only, contact above address for questions
newgroup:*@*:utwente.*:mail
rmgroup:*@*:utwente.*:doit

## UVA (*LOCAL* -- University of Virginia, USA)
# Contact: usenet@virginia.edu
# For internal use only, contact above address for questions.
newgroup:*@*:uva.*:mail
rmgroup:*@*:uva.*:doit

## UW (University of Waterloo, Canada)
newgroup:bcameron@math.uwaterloo.ca:uw.*:doit
rmgroup:bcameron@math.uwaterloo.ca:uw.*:doit

## UWARWICK (*LOCAL* -- University of Warwick, UK)
# Contact: Jon Harley <news@csv.warwick.ac.uk>
# For internal use only, contact above address for questions.
newgroup:*@*:uwarwick.*:mail
rmgroup:*@*:uwarwick.*:doit

## UWO (University of Western Ontario, London, Canada)
newgroup:reggers@julian.uwo.ca:uwo.*:doit
rmgroup:reggers@julian.uwo.ca:uwo.*:doit

## VAN (Vancouver, British Columbia, Canada)
checkgroups:bc_van_usenet@fastmail.ca:van.*:mail
newgroup:bc_van_usenet@fastmail.ca:van.*:doit
rmgroup:bc_van_usenet@fastmail.ca:van.*:doit

## VEGAS (Las Vegas, Nevada, USA)
newgroup:cshapiro@netcom.com:vegas.*:doit
newgroup:doctor@netcom.com:vegas.*:doit
rmgroup:cshapiro@netcom.com:vegas.*:doit
rmgroup:doctor@netcom.com:vegas.*:doit

## VGC (Japan groups?)
newgroup:news@isl.melco.co.jp:vgc.*:doit
rmgroup:news@isl.melco.co.jp:vgc.*:doit

## VMSNET (VMS Operating System)
newgroup:cts@dragon.com:vmsnet.*:doit
rmgroup:cts@dragon.com:vmsnet.*:doit

## WADAI (Japanese ?)
newgroup:kohe-t@*wakayama-u.ac.jp:wadai.*:doit
rmgroup:kohe-t@*wakayama-u.ac.jp:wadai.*:doit

## WALES (Wales)
# Contact: committee@wales-usenet.org
# URL: http://www.wales-usenet.org/
# Key fingerprint = 2D 9E DE DF 12 DA 34 5C  49 E1 EE 28 E3 AB 0D AD
# *PGP*   See comment at top of file.
newgroup:*:wales.*:drop
rmgroup:*:wales.*:drop
newgroup:control@wales-usenet.org:wales.*:verify-wales-usenet
rmgroup:control@wales-usenet.org:wales.*:verify-wales-usenet
checkgroups:control@wales-usenet.org:wales.*:verify-wales-usenet

## WASH (Washington State, USA)
newgroup:graham@ee.washington.edu:wash.*:doit
rmgroup:graham@ee.washington.edu:wash.*:doit

## WEST-VIRGINIA (West Virginia, USA)
# Note: checkgroups only by bryan27, not mark.
checkgroups:bryan27@hgo.net:west-virginia.*:doit
newgroup:mark@bluefield.net:west-virginia.*:doit
newgroup:bryan27@hgo.net:west-virginia.*:doit
rmgroup:mark@bluefield.net:west-virginia.*:doit
rmgroup:bryan27@hgo.net:west-virginia.*:doit

## WORLDONLINE (*LOCAL*)
# Contact: newsmaster@worldonline.nl
# For local use only, contact the above address for information.
newgroup:*@*:worldonline.*:mail
rmgroup:*@*:worldonline.*:doit

## WPG (Winnipeg, Manitoba, Canada)
# Contact: Gary Mills <mills@cc.umanitoba.ca>
newgroup:mills@cc.umanitoba.ca:wpg.*:doit
rmgroup:mills@cc.umanitoba.ca:wpg.*:doit

## WPI (Worcester Polytechnic Institute, Worcester, MA)
newgroup:aej@*.wpi.edu:wpi.*:doit
rmgroup:aej@*.wpi.edu:wpi.*:doit

## WU (Washington University at St. Louis, MO)
newgroup:*@*.wustl.edu:wu.*:doit
rmgroup:*@*.wustl.edu:wu.*:doit

## XS4ALL (XS4ALL, Netherlands)
# Contact: Cor Bosman <news@xs4all.nl>
newgroup:news@*xs4all.nl:xs4all.*:doit
rmgroup:news@*xs4all.nl:xs4all.*:doit

## YORK (*LOCAL* -- York University, Toronto, ON)
# Contact: Peter Marques <news@yorku.ca>
# For local use only, contact the above address for information.
newgroup:*@*:york.*:mail
rmgroup:*@*:york.*:doit

## Z-NETZ (German non-Internet based network)
# Contact: teko@dinoex.sub.org
# Key URL: ftp://ftp.dinoex.de/pub/keys/z-netz.koordination.user+sysops.asc
# *PGP*   See comment at top of file.
newgroup:*:z-netz.*:drop
rmgroup:*:z-netz.*:drop
checkgroups:teko@dinoex.sub.org:z-netz.*:verify-z-netz.koordination.user+sysops
newgroup:teko@dinoex.sub.org:z-netz.*:verify-z-netz.koordination.user+sysops
rmgroup:teko@dinoex.sub.org:z-netz.*:verify-z-netz.koordination.user+sysops

## ZA (South Africa)
newgroup:root@duvi.eskom.co.za:za.*:doit
newgroup:ccfj@hippo.ru.ac.za:za.*:doit
rmgroup:root@duvi.eskom.co.za:za.*:doit
rmgroup:ccfj@hippo.ru.ac.za:za.*:doit

## ZER (*DEFUNCT* -- Germany)
# Defunct, use z-netz.*.
newgroup:*@*:zer.*:mail
rmgroup:*@*:zer.*:doit
