#!/bin/sh
# Copyright (C) 1993-1995 Ian Jackson.

# This file is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# It is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with GNU Emacs; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.

# (Note: I do not consider works produced using these BFNN processing
# tools to be derivative works of the tools, so they are NOT covered
# by the GPL.  However, I would appreciate it if you credited me if
# appropriate in any documents you format using BFNN.)

set -e

echo "this time: $1   last time: $2"

echo converting 1 ...
./bfnnconv.pl linux-faq.bfnn
echo converting 2 ...
./bfnnconv.pl linux-faq.bfnn
echo formatting 1 ...
lout linux-faq.lout >/dev/null
echo formatting 2 ...
lout linux-faq.lout >linux-faq.ps
echo changes ...
./changes.text "$2"
echo tarring ...
./mktar.sh

if [ x != "x$1" ]
then
	echo archiving to $1 ...
	mkdir $1
	cp linux-faq.ascii linux-faq.source.tar.gz $1/.
	echo exporting ...
	cp linux-faq.tar.gz linux-faq.html.tar.gz $HOME/out/.
	echo posting ...
	sh ./linux-faq.post
	sleep 20
	echo posting changes ...
	sh ./changes.post
fi

echo done.
exit 0
