.TH XLANDER 6 "27 April 1992" "X Version 11"
.SH NAME
xlander \- A lunar landing simulation with a twist
.SH SYNOPSIS
.B xlander 
[
.I -controls
controls
]
[
.I -fn
font
]
[
.I -gravity
planet
]
[
.I -lateral
value
]
[
.I -repeat
]
[
.I -retro
value
]

.SH DESCRIPTION
.LP
XLander is a lunar landing simulation for X.  It features an
"out-the-window" scrolling 3-d display.

.SH GAME PLAY
.LP
As you play the game, you will see the landing craft on the screen.
The 3-d view follows the craft around, lagging behind slightly, which
gives a good illusion of motion.

The lander is equipped with five thrusters; four directional thrusters
which control lateral motion, and one retroactive thruster which fires
downwards to produce upward momentum.
Each thruster is activated by pressing and holding a particular
key.  By default, the space bar fires the retroactive thruster, and
the 8, 2, 4 and 6 keypad keys fire the front, rear, left and right
directional thrusters, respectively.  The control keys can be re-mapped
using the
.B -control
option described below.  You can also use the keyboard arrow keys to
fire directional thrusters if you like.

Each thruster uses up a particular amount of fuel.  The retro thruster
consumes more fuel than the directional thrusters, since it produces
more thrust to combat the force of gravity.  Fuel is indicated on
the control panel.  Once it's gone, you can no longer thrust.

At the start of the game, your landing craft will be free-falling
toward the surface.  The goal is to land the craft on the landing pad
with as little vertical and lateral motion as possible.  The landing
pad is visible as a square on the ground with a flag planted at one
corner.  The shadow of the craft is projected on the ground, allowing you to
see how high it is and where it will land.

In order to land, you must be going slowly enough in both the vertical
and lateral directions.
Although you can land anywhere on the surface, you must land on the
landing pad to get points.
After each successful landing, the program gives
you a score based on your vertical and lateral speeds, refills your
fuel tank, and restarts the simulation at a higher difficulty level
(by increasing the force of gravity).  After you crash, the game
shows your final score and then allows you to either start over or
quit.

.SH GAUGES AND INDICATORS
.LP
The lunar lander is equipped with a number of gauges and indicators
which tell you its status.  At the left of the gauge panel is a
circular heading indicator which tells you the lateral direction of
the craft.  Next to this is a vertical velocity gauge, which tells you
your rate of ascent or descent; after this comes a fuel gauge,
followed by a radar screen which tells you your position relative to
the landing pad.

.SH OPTIONS
.TP
.B -controls controls
Configure the keyboard controls used by xlander.  You should pass a
string of 5 characters.  The first character is the key used to thrust
forward, followed in order by the keys used to thrust backward, left,
and right.  After this comes the retro thrust key.  The default
control string is "8246 ".
.IP
If you are used to the
.B vi
editor, you might want to try using the control string "kjhl ".
.TP
.B -fn font
Select the font used to display the text used by the program.
.TP
.B -gravity planet
Simulate gravity of a particular planet or other heavenly body.
Valid planets are:  moon (default), earth, mercury, venus, mars, jupiter,
saturn, uranus, neptune, and pluto.  This option also automatically
adjusts the amount of retro thrust to suit the gravity of the planet
(unless you override it using the
.B -retro
option).
.TP
.B -lateral value
Specify the amount of thrust, in ft/sec^2, provided by the four lateral
thrusters on the craft.
.TP
.B -repeat
Do not turn off key repeat for the duration of the game.
.IP
Since thrust is activated by holding down keys, xlander turns off auto
key repeat during the game.  This prevents keypress events from getting
backed up in the queue.  When the game exits, the original key repeat
mode is restored.  This option disables this behavior.
.TP
.B -retro value
Specify the amount of thrust, in ft/sec^2, provided by the retroactive
thruster.

.SH BUGS
.LP
Collision detection needs (a lot of) work.  Suggestions, anyone?
.LP
Since we're not physicists or mathematicians, we don't claim that this
is a completely accurate simulation.  So, have fun with it but don't
take it too seriously!

.SH AUTHORS
.LP
Paul Riddle (paulr@umbc3.umbc.edu)
.br
Mike Friedman (mikef@umbc3.umbc.edu)

.SH SEE ALSO
.LP
xwave(1)
