/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.solaris_x86;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.JVMDebugger;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.x86.X86ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.JavaThreadPDAccess;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.x86.X86CurrentFrameGuess;
import sun.jvm.hotspot.runtime.x86.X86Frame;
import sun.jvm.hotspot.runtime.x86.X86RegisterMap;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class SolarisX86JavaThreadPDAccess
implements JavaThreadPDAccess {
    private static AddressField lastJavaFPField;
    private static AddressField osThreadField;
    private static AddressField baseOfStackPointerField;
    private static CIntegerField osThreadThreadIDField;
    private static final long GUESS_SCAN_RANGE = 131072L;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("JavaThread");
        Type anchorType = db.lookupType("JavaFrameAnchor");
        lastJavaFPField = anchorType.getAddressField("_last_Java_fp");
        osThreadField = type.getAddressField("_osthread");
        type = db.lookupType("OSThread");
        osThreadThreadIDField = type.getCIntegerField("_thread_id");
    }

    public Address getLastJavaFP(Address addr) {
        return lastJavaFPField.getValue(addr.addOffsetTo(JavaThread.getAnchorField().getOffset()));
    }

    public Address getLastJavaPC(Address addr) {
        return null;
    }

    public Address getBaseOfStackPointer(Address addr) {
        return null;
    }

    public Frame getLastFramePD(JavaThread thread, Address addr) {
        Address fp = thread.getLastJavaFP();
        if (fp == null) {
            return null;
        }
        Address pc = thread.getLastJavaPC();
        if (pc != null) {
            return new X86Frame(thread.getLastJavaSP(), fp, pc);
        }
        return new X86Frame(thread.getLastJavaSP(), fp);
    }

    public RegisterMap newRegisterMap(JavaThread thread, boolean updateMap) {
        return new X86RegisterMap(thread, updateMap);
    }

    public Frame getCurrentFrameGuess(JavaThread thread, Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        X86ThreadContext context = (X86ThreadContext)t.getContext();
        X86CurrentFrameGuess guesser = new X86CurrentFrameGuess(context, thread);
        if (!guesser.run(131072L)) {
            return null;
        }
        if (guesser.getPC() == null) {
            return new X86Frame(guesser.getSP(), guesser.getFP());
        }
        return new X86Frame(guesser.getSP(), guesser.getFP(), guesser.getPC());
    }

    public void printThreadIDOn(Address addr, PrintStream tty) {
        tty.print(this.getThreadProxy(addr));
    }

    public void printInfoOn(Address threadAddr, PrintStream tty) {
    }

    public Address getLastSP(Address addr) {
        ThreadProxy t = this.getThreadProxy(addr);
        X86ThreadContext context = (X86ThreadContext)t.getContext();
        return context.getRegisterAsAddress(7);
    }

    public ThreadProxy getThreadProxy(Address addr) {
        Address osThreadAddr = osThreadField.getValue(addr);
        Address tidAddr = osThreadAddr.addOffsetTo(osThreadThreadIDField.getOffset());
        JVMDebugger debugger = VM.getVM().getDebugger();
        return debugger.getThreadForIdentifierAddress(tidAddr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                SolarisX86JavaThreadPDAccess.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

