/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.oops.Array;
import sun.jvm.hotspot.oops.IndexableFieldIdentifier;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class ObjArray
extends Array {
    private static long elementSize;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("objArrayOopDesc");
        elementSize = db.getOopSize();
    }

    ObjArray(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    public boolean isObjArray() {
        return true;
    }

    public Oop getObjAt(long index) {
        long offset = ObjArray.baseOffsetInBytes(BasicType.T_OBJECT) + index * elementSize;
        return this.getHeap().newOop(this.getHandle().getOopHandleAt(offset));
    }

    public void printValueOn(PrintStream tty) {
        tty.print("ObjArray");
    }

    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        int length = (int)this.getLength();
        long baseOffset = ObjArray.baseOffsetInBytes(BasicType.T_OBJECT);
        for (int index = 0; index < length; ++index) {
            long offset = baseOffset + (long)index * elementSize;
            visitor.doOop(new OopField(new IndexableFieldIdentifier(index), offset, false), false);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                ObjArray.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

