/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.windbg;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerBase;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.DebuggerUtilities;
import sun.jvm.hotspot.debugger.MachineDescription;
import sun.jvm.hotspot.debugger.NotInHeapException;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.debugger.PageCache;
import sun.jvm.hotspot.debugger.ReadResult;
import sun.jvm.hotspot.debugger.ThreadProxy;
import sun.jvm.hotspot.debugger.UnalignedAddressException;
import sun.jvm.hotspot.debugger.UnmappedAddressException;
import sun.jvm.hotspot.debugger.cdbg.CDebugger;
import sun.jvm.hotspot.debugger.cdbg.ClosestSymbol;
import sun.jvm.hotspot.debugger.windbg.DLL;
import sun.jvm.hotspot.debugger.windbg.WindbgAddress;
import sun.jvm.hotspot.debugger.windbg.WindbgCDebugger;
import sun.jvm.hotspot.debugger.windbg.WindbgDebugger;
import sun.jvm.hotspot.debugger.windbg.WindbgOopHandle;
import sun.jvm.hotspot.debugger.windbg.WindbgThreadFactory;
import sun.jvm.hotspot.debugger.windbg.amd64.WindbgAMD64ThreadFactory;
import sun.jvm.hotspot.debugger.windbg.ia64.WindbgIA64ThreadFactory;
import sun.jvm.hotspot.debugger.windbg.x86.WindbgX86ThreadFactory;
import sun.jvm.hotspot.utilities.PlatformInfo;

public class WindbgDebuggerLocal
extends DebuggerBase
implements WindbgDebugger {
    private PageCache cache;
    private boolean attached;
    private boolean isCore;
    private Map nameToDllMap;
    private List loadObjects;
    private CDebugger cdbg;
    private Map threadIntegerRegisterSet;
    private List threadList;
    private long ptrIDebugClient;
    private long ptrIDebugControl;
    private long ptrIDebugDataSpaces;
    private long ptrIDebugOutputCallbacks;
    private long ptrIDebugAdvanced;
    private long ptrIDebugSymbols;
    private long ptrIDebugSystemObjects;
    private WindbgThreadFactory threadFactory;
    private static String DTFWHome;
    private static String imagePath;
    private static String symbolPath;
    private static boolean useNativeLookup;

    public WindbgDebuggerLocal(MachineDescription machDesc, boolean useCache) throws DebuggerException {
        this.machDesc = machDesc;
        this.utils = new DebuggerUtilities(machDesc.getAddressSize(), machDesc.isBigEndian()){

            public void checkAlignment(long address, long alignment) {
                if (address % alignment != 0L && (alignment != 8L || address % 4L != 0L)) {
                    throw new UnalignedAddressException("Trying to read at address: " + this.addressValueToString(address) + " with alignment: " + alignment, address);
                }
            }
        };
        String cpu = PlatformInfo.getCPU();
        if (cpu.equals("x86")) {
            this.threadFactory = new WindbgX86ThreadFactory(this);
        } else if (cpu.equals("amd64")) {
            this.threadFactory = new WindbgAMD64ThreadFactory(this);
        } else if (cpu.equals("ia64")) {
            this.threadFactory = new WindbgIA64ThreadFactory(this);
        }
        if (useCache) {
            this.initCache(4096L, 4096L);
        }
    }

    public boolean hasProcessList() throws DebuggerException {
        return false;
    }

    public List getProcessList() throws DebuggerException {
        return null;
    }

    public synchronized void attach(int processID) throws DebuggerException {
        this.attachInit();
        this.attach0(processID);
        this.attached = true;
        this.isCore = false;
    }

    public synchronized void attach(String executableName, String coreFileName) throws DebuggerException {
        this.attachInit();
        this.attach0(executableName, coreFileName);
        this.attached = true;
        this.isCore = true;
    }

    public List getLoadObjectList() {
        this.requireAttach();
        return this.loadObjects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean detach() {
        if (!this.attached) {
            return false;
        }
        if (this.nameToDllMap != null) {
            Iterator iter = this.nameToDllMap.values().iterator();
            while (iter.hasNext()) {
                DLL dll = (DLL)iter.next();
                dll.close();
            }
            this.nameToDllMap = null;
            this.loadObjects = null;
        }
        this.cdbg = null;
        this.clearCache();
        this.threadIntegerRegisterSet = null;
        this.threadList = null;
        try {
            this.detach0();
        }
        finally {
            this.attached = false;
            this.resetNativePointers();
        }
        return true;
    }

    public Address parseAddress(String addressString) throws NumberFormatException {
        return this.newAddress(this.utils.scanAddress(addressString));
    }

    public String getOS() {
        return PlatformInfo.getOS();
    }

    public String getCPU() {
        return PlatformInfo.getCPU();
    }

    public boolean hasConsole() throws DebuggerException {
        return true;
    }

    public synchronized String consoleExecuteCommand(String cmd) throws DebuggerException {
        this.requireAttach();
        if (!this.attached) {
            throw new DebuggerException("debugger not yet attached to a Dr. Watson dump!");
        }
        return this.consoleExecuteCommand0(cmd);
    }

    public String getConsolePrompt() throws DebuggerException {
        return "(windbg)";
    }

    public CDebugger getCDebugger() throws DebuggerException {
        if (this.cdbg == null && !this.getCPU().equals("ia64")) {
            this.cdbg = new WindbgCDebugger(this);
        }
        return this.cdbg;
    }

    public synchronized Address lookup(String objectName, String symbol) {
        this.requireAttach();
        return this.newAddress(this.lookupByName(objectName, symbol));
    }

    public synchronized OopHandle lookupOop(String objectName, String symbol) {
        Address addr = this.lookup(objectName, symbol);
        if (addr == null) {
            return null;
        }
        return addr.addOffsetToAsOopHandle(0L);
    }

    public synchronized ClosestSymbol lookup(long address) {
        return this.lookupByAddress0(address);
    }

    public MachineDescription getMachineDescription() {
        return this.machDesc;
    }

    public ThreadProxy getThreadForIdentifierAddress(Address addr) {
        return this.threadFactory.createThreadWrapper(addr);
    }

    public ThreadProxy getThreadForThreadId(long handle) {
        throw new DebuggerException("Unimplemented!");
    }

    public long getThreadIdFromSysId(long sysId) throws DebuggerException {
        this.requireAttach();
        return this.getThreadIdFromSysId0(sysId);
    }

    public long readJLong(long address) throws UnmappedAddressException, UnalignedAddressException {
        this.checkJavaConfigured();
        this.utils.checkAlignment(address, this.jintSize);
        byte[] data = this.readBytes(address, this.jlongSize);
        return this.utils.dataToJLong(data, this.jlongSize);
    }

    public String addressValueToString(long address) {
        return this.utils.addressValueToString(address);
    }

    public WindbgAddress readAddress(long address) throws UnmappedAddressException, UnalignedAddressException {
        return (WindbgAddress)this.newAddress(this.readAddressValue(address));
    }

    public WindbgOopHandle readOopHandle(long address) throws UnmappedAddressException, UnalignedAddressException, NotInHeapException {
        long value = this.readAddressValue(address);
        return value == 0L ? null : new WindbgOopHandle(this, value);
    }

    public int getAddressSize() {
        return (int)this.machDesc.getAddressSize();
    }

    private synchronized void setThreadIntegerRegisterSet(long threadId, long[] regs) {
        this.threadIntegerRegisterSet.put(new Long(threadId), regs);
    }

    private synchronized void addThread(long sysId) {
        this.threadList.add(this.threadFactory.createThreadWrapper(sysId));
    }

    public synchronized long[] getThreadIntegerRegisterSet(long threadId) throws DebuggerException {
        this.requireAttach();
        return (long[])this.threadIntegerRegisterSet.get(new Long(threadId));
    }

    public synchronized List getThreadList() throws DebuggerException {
        this.requireAttach();
        return this.threadList;
    }

    private String findFullPath(String file) {
        File f = new File(file);
        if (f.exists()) {
            return file;
        }
        file = f.getName();
        StringTokenizer st = new StringTokenizer(imagePath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            f = new File(st.nextToken(), file);
            if (!f.exists()) continue;
            return f.getPath();
        }
        return null;
    }

    private synchronized void addLoadObject(String file, long size, long base) {
        String path = this.findFullPath(file);
        if (path != null) {
            DLL dll = null;
            dll = useNativeLookup ? new DLL(this, path, size, this.newAddress(base)){

                public ClosestSymbol closestSymbolToPC(Address pcAsAddr) {
                    long pc = WindbgDebuggerLocal.this.getAddressValue(pcAsAddr);
                    ClosestSymbol sym = WindbgDebuggerLocal.this.lookupByAddress0(pc);
                    if (sym == null) {
                        return super.closestSymbolToPC(pcAsAddr);
                    }
                    return sym;
                }
            } : new DLL(this, path, size, this.newAddress(base));
            this.loadObjects.add(dll);
            this.nameToDllMap.put(new File(file).getName(), dll);
        }
    }

    public long getAddressValue(Address addr) {
        if (addr == null) {
            return 0L;
        }
        return ((WindbgAddress)addr).getValue();
    }

    public Address newAddress(long value) {
        if (value == 0L) {
            return null;
        }
        return new WindbgAddress(this, value);
    }

    private void checkAttached() {
        if (this.attached) {
            String msg = this.isCore ? "already attached to a Dr. Watson dump!" : "already attached to a process!";
            throw new DebuggerException(msg);
        }
    }

    private void requireAttach() {
        if (!this.attached) {
            throw new RuntimeException("not attached to a process or Dr Watson dump");
        }
    }

    private void attachInit() {
        this.checkAttached();
        this.loadObjects = new ArrayList();
        this.nameToDllMap = new HashMap();
        this.threadIntegerRegisterSet = new HashMap();
        this.threadList = new ArrayList();
    }

    private void resetNativePointers() {
        this.ptrIDebugClient = 0L;
        this.ptrIDebugControl = 0L;
        this.ptrIDebugDataSpaces = 0L;
        this.ptrIDebugOutputCallbacks = 0L;
        this.ptrIDebugAdvanced = 0L;
        this.ptrIDebugSymbols = 0L;
        this.ptrIDebugSystemObjects = 0L;
    }

    synchronized long lookupByName(String objectName, String symbol) {
        WindbgAddress addr;
        long res = 0L;
        if (useNativeLookup && (res = this.lookupByName0(objectName, symbol)) != 0L) {
            return res;
        }
        DLL dll = (DLL)this.nameToDllMap.get(objectName);
        if (dll != null && (addr = (WindbgAddress)dll.lookupSymbol(symbol)) != null) {
            return addr.getValue();
        }
        return 0L;
    }

    public synchronized ReadResult readBytesFromProcess(long address, long numBytes) throws UnmappedAddressException, DebuggerException {
        this.requireAttach();
        byte[] res = this.readBytesFromProcess0(address, numBytes);
        if (res != null) {
            return new ReadResult(res);
        }
        return new ReadResult(address);
    }

    private DLL findDLLByName(String fullPathName) {
        Iterator iter = this.loadObjects.iterator();
        while (iter.hasNext()) {
            DLL dll = (DLL)iter.next();
            if (!dll.getName().equals(fullPathName)) continue;
            return dll;
        }
        return null;
    }

    public void writeBytesToProcess(long address, long numBytes, byte[] data) throws UnmappedAddressException, DebuggerException {
        throw new DebuggerException("Unimplemented");
    }

    private static native void initIDs();

    private native void attach0(String var1, String var2);

    private native void attach0(int var1);

    private native void detach0();

    private native byte[] readBytesFromProcess0(long var1, long var3) throws UnmappedAddressException, DebuggerException;

    private native long getThreadIdFromSysId0(long var1);

    private native String consoleExecuteCommand0(String var1);

    private native long lookupByName0(String var1, String var2);

    private native ClosestSymbol lookupByAddress0(long var1);

    private ClosestSymbol createClosestSymbol(String symbol, long diff) {
        return new ClosestSymbol(symbol, diff);
    }

    static {
        String sysDir;
        File feng;
        Object dirName = null;
        DTFWHome = System.getenv("DEBUGGINGTOOLSFORWINDOWS");
        if (DTFWHome == null) {
            String sysRoot = System.getenv("SYSTEMROOT");
            DTFWHome = sysRoot + File.separator + ".." + File.separator + "Program Files" + File.separator + "Debugging Tools For Windows";
        }
        String dbghelp = DTFWHome + File.separator + "dbghelp.dll";
        String dbgeng = DTFWHome + File.separator + "dbgeng.dll";
        File fhelp = new File(dbghelp);
        File feng2 = new File(dbgeng);
        if (fhelp.exists() && feng2.exists()) {
            System.load(dbghelp);
            System.load(dbgeng);
        } else if (!fhelp.exists() && !feng2.exists()) {
            DTFWHome = null;
        } else {
            throw new UnsatisfiedLinkError("Both files dbghelp.dll and dbgeng.dll must exist in directory " + DTFWHome);
        }
        if (DTFWHome == null && !(feng = new File((sysDir = System.getenv("SYSTEMROOT") + File.separator + "system32") + File.separator + "dbgeng.dll")).exists()) {
            throw new UnsatisfiedLinkError("File dbgeng.dll does not exist in " + sysDir + ".  Please search microsoft.com " + "for Debugging Tools For Windows, and " + "either download it to the default " + "location, or download it to a custom " + "location and set environment variable " + "   DEBUGGINGTOOLSFORWINDOWS  " + "to the pathname of that location.");
        }
        System.loadLibrary("sawindbg");
        imagePath = System.getProperty("sun.jvm.hotspot.debugger.windbg.imagePath");
        if (imagePath == null) {
            imagePath = System.getenv("PATH");
        }
        if ((symbolPath = System.getProperty("sun.jvm.hotspot.debugger.windbg.symbolPath")) == null) {
            symbolPath = imagePath;
        }
        useNativeLookup = true;
        String str = System.getProperty("sun.jvm.hotspot.debugger.windbg.disableNativeLookup");
        if (str != null) {
            useNativeLookup = false;
        }
        WindbgDebuggerLocal.initIDs();
    }
}

