/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.code;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.compiler.OopMap;
import sun.jvm.hotspot.compiler.OopMapSet;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.utilities.Assert;
import sun.jvm.hotspot.utilities.CStringUtilities;

public class CodeBlob
extends VMObject {
    private static AddressField nameField;
    private static CIntegerField sizeField;
    private static CIntegerField headerSizeField;
    private static CIntegerField relocationSizeField;
    private static CIntegerField instructionsOffsetField;
    private static CIntegerField frameCompleteOffsetField;
    private static CIntegerField dataOffsetField;
    private static CIntegerField oopsOffsetField;
    private static CIntegerField oopsLengthField;
    private static CIntegerField frameSizeField;
    private static AddressField oopMapsField;
    private static final int NOT_YET_COMPUTED = -2;
    private static final int UNDEFINED = -1;
    private int linkOffset = -2;
    private static int matcherInterpreterFramePointerReg;

    private static void initialize(TypeDataBase db) {
        Type type = db.lookupType("CodeBlob");
        nameField = type.getAddressField("_name");
        sizeField = type.getCIntegerField("_size");
        headerSizeField = type.getCIntegerField("_header_size");
        relocationSizeField = type.getCIntegerField("_relocation_size");
        frameCompleteOffsetField = type.getCIntegerField("_frame_complete_offset");
        instructionsOffsetField = type.getCIntegerField("_instructions_offset");
        dataOffsetField = type.getCIntegerField("_data_offset");
        oopsOffsetField = type.getCIntegerField("_oops_offset");
        oopsLengthField = type.getCIntegerField("_oops_length");
        frameSizeField = type.getCIntegerField("_frame_size");
        oopMapsField = type.getAddressField("_oop_maps");
        if (VM.getVM().isServerCompiler()) {
            matcherInterpreterFramePointerReg = db.lookupIntConstant("Matcher::interpreter_frame_pointer_reg");
        }
    }

    public CodeBlob(Address addr) {
        super(addr);
    }

    public boolean isBufferBlob() {
        return false;
    }

    public boolean isNMethod() {
        return false;
    }

    public boolean isRuntimeStub() {
        return false;
    }

    public boolean isDeoptimizationStub() {
        return false;
    }

    public boolean isUncommonTrapStub() {
        return false;
    }

    public boolean isExceptionStub() {
        return false;
    }

    public boolean isSafepointStub() {
        return false;
    }

    public boolean isJavaMethod() {
        return false;
    }

    public boolean isNativeMethod() {
        return false;
    }

    public boolean isOSRMethod() {
        return false;
    }

    public Address headerBegin() {
        return this.addr;
    }

    public Address headerEnd() {
        return this.addr.addOffsetTo(headerSizeField.getValue(this.addr));
    }

    public Address instructionsBegin() {
        return this.headerBegin().addOffsetTo(instructionsOffsetField.getValue(this.addr));
    }

    public Address instructionsEnd() {
        return this.headerBegin().addOffsetTo(dataOffsetField.getValue(this.addr));
    }

    public Address dataBegin() {
        return this.headerBegin().addOffsetTo(dataOffsetField.getValue(this.addr));
    }

    public Address dataEnd() {
        return this.headerBegin().addOffsetTo(sizeField.getValue(this.addr));
    }

    public Address oopsBegin() {
        return this.headerBegin().addOffsetTo(oopsOffsetField.getValue(this.addr));
    }

    public Address oopsEnd() {
        return this.oopsBegin().addOffsetTo(this.getOopsLength());
    }

    public int getRelocationOffset() {
        return (int)headerSizeField.getValue(this.addr);
    }

    public int getInstructionsOffset() {
        return (int)instructionsOffsetField.getValue(this.addr);
    }

    public int getDataOffset() {
        return (int)dataOffsetField.getValue(this.addr);
    }

    public int getOopsOffset() {
        return (int)oopsOffsetField.getValue(this.addr);
    }

    public int getSize() {
        return (int)sizeField.getValue(this.addr);
    }

    public int getHeaderSize() {
        return (int)headerSizeField.getValue(this.addr);
    }

    public int getInstructionsSize() {
        return (int)this.instructionsEnd().minus(this.instructionsBegin());
    }

    public int getDataSize() {
        return (int)this.dataEnd().minus(this.dataBegin());
    }

    public boolean blobContains(Address addr) {
        return this.headerBegin().lessThanOrEqual(addr) && this.dataEnd().greaterThan(addr);
    }

    public boolean instructionsContains(Address addr) {
        return this.instructionsBegin().lessThanOrEqual(addr) && this.instructionsEnd().greaterThan(addr);
    }

    public boolean dataContains(Address addr) {
        return this.dataBegin().lessThanOrEqual(addr) && this.dataEnd().greaterThan(addr);
    }

    public boolean oopsContains(Address addr) {
        return this.oopsBegin().lessThanOrEqual(addr) && this.oopsEnd().greaterThan(addr);
    }

    public boolean contains(Address addr) {
        return this.instructionsContains(addr);
    }

    public boolean isFrameCompleteAt(Address a) {
        return this.instructionsContains(a) && a.minus(this.instructionsBegin()) >= frameCompleteOffsetField.getValue(this.addr);
    }

    public OopHandle getOopAt(int index) {
        if (index == 0) {
            return null;
        }
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(index > 0 && index <= this.getOopsLength(), "must be a valid non-zero index");
        }
        return this.oopsBegin().getOopHandleAt((long)(index - 1) * VM.getVM().getOopSize());
    }

    public boolean isZombie() {
        return false;
    }

    public boolean isLockedByVM() {
        return false;
    }

    public OopMapSet getOopMaps() {
        Address oopMapsAddr = oopMapsField.getValue(this.addr);
        if (oopMapsAddr == null) {
            return null;
        }
        return new OopMapSet(oopMapsAddr);
    }

    public OopMap getOopMapForReturnAddress(Address returnAddress, boolean debugging) {
        Address pc = returnAddress;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getOopMaps() != null, "nope");
        }
        return this.getOopMaps().findMapAtOffset(pc.minus(this.instructionsBegin()), debugging);
    }

    public long getFrameSize() {
        return VM.getVM().getAddressSize() * frameSizeField.getValue(this.addr);
    }

    public boolean callerMustGCArguments(JavaThread thread) {
        return false;
    }

    public String getName() {
        return CStringUtilities.getString(nameField.getValue(this.addr));
    }

    public void print() {
        this.printOn(System.out);
    }

    public void printOn(PrintStream tty) {
        tty.print(this.getName());
        this.printComponentsOn(tty);
    }

    protected void printComponentsOn(PrintStream tty) {
        tty.println(" instructions: [" + this.instructionsBegin() + ", " + this.instructionsEnd() + "), " + " data: [" + this.dataBegin() + ", " + this.dataEnd() + "), " + " oops: [" + this.oopsBegin() + ", " + this.oopsEnd() + "), " + " frame size: " + this.getFrameSize());
    }

    private int getOopsLength() {
        return (int)oopsLengthField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            public void update(Observable o, Object data) {
                CodeBlob.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

