/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;

public abstract class Sqlca {
    protected transient Connection connection_;
    SqlException exceptionThrownOnStoredProcInvocation_;
    boolean messageTextRetrievedContainsTokensOnly_ = true;
    protected int sqlCode_;
    private String sqlErrmc_;
    protected String[] sqlErrmcMessages_;
    private String[] sqlStates_;
    protected String sqlErrp_;
    protected int[] sqlErrd_;
    protected char[] sqlWarn_;
    protected String sqlState_;
    protected byte[] sqlErrmcBytes_;
    protected byte[] sqlErrpBytes_;
    protected byte[] sqlWarnBytes_;
    protected int sqlErrmcCcsid_;
    protected boolean containsSqlcax_ = true;
    protected long rowsetRowCount_;
    private static final String sqlErrmcDelimiter__ = "\u0014\u0014\u0014";
    private boolean returnTokensOnlyInMessageText_ = false;
    private final transient Agent agent_;
    private String[] cachedMessages;

    protected Sqlca(Connection connection) {
        this.connection_ = connection;
        this.agent_ = this.connection_ != null ? this.connection_.agent_ : null;
    }

    void returnTokensOnlyInMessageText(boolean bl) {
        this.returnTokensOnlyInMessageText_ = bl;
    }

    synchronized int numberOfMessages() {
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ != null) {
            return this.sqlErrmcMessages_.length;
        }
        return 1;
    }

    public synchronized int getSqlCode() {
        return this.sqlCode_;
    }

    public synchronized String getSqlErrmc() {
        int n;
        if (this.sqlErrmc_ != null) {
            return this.sqlErrmc_;
        }
        this.initSqlErrmcMessages();
        if (this.sqlErrmcMessages_ == null) {
            return null;
        }
        if (this.sqlErrmcMessages_.length == 0) {
            this.sqlErrmc_ = "";
            return this.sqlErrmc_;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < this.sqlErrmcMessages_.length - 1; ++n) {
            stringBuffer.append(this.sqlErrmcMessages_[n]);
            stringBuffer.append(sqlErrmcDelimiter__);
            stringBuffer.append(this.sqlStates_[n + 1]);
            stringBuffer.append(":");
        }
        stringBuffer.append(this.sqlErrmcMessages_[n]);
        this.sqlErrmc_ = stringBuffer.toString();
        return this.sqlErrmc_;
    }

    private void initSqlErrmcMessages() {
        if (this.sqlErrmcMessages_ == null || this.sqlStates_ == null) {
            this.processSqlErrmcTokens(this.sqlErrmcBytes_);
        }
    }

    public synchronized String getSqlErrp() {
        if (this.sqlErrp_ != null) {
            return this.sqlErrp_;
        }
        if (this.sqlErrpBytes_ == null) {
            return null;
        }
        try {
            this.sqlErrp_ = this.bytes2String(this.sqlErrpBytes_, 0, this.sqlErrpBytes_.length);
            return this.sqlErrp_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int[] getSqlErrd() {
        if (this.sqlErrd_ != null) {
            return this.sqlErrd_;
        }
        this.sqlErrd_ = new int[6];
        return this.sqlErrd_;
    }

    public synchronized char[] getSqlWarn() {
        if (this.sqlWarn_ != null) {
            return this.sqlWarn_;
        }
        try {
            this.sqlWarn_ = this.sqlWarnBytes_ == null ? new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '} : this.bytes2String(this.sqlWarnBytes_, 0, this.sqlWarnBytes_.length).toCharArray();
            return this.sqlWarn_;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.sqlWarn_ = new char[]{' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' '};
            return this.sqlWarn_;
        }
    }

    public synchronized String getSqlState() {
        return this.sqlState_;
    }

    synchronized String getSqlState(int n) {
        this.initSqlErrmcMessages();
        if (this.sqlStates_ != null) {
            return this.sqlStates_[n];
        }
        return this.getSqlState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getMessage(int var1_1) throws SqlException {
        if (this.cachedMessages != null && this.cachedMessages[var1_1] != null) {
            return this.cachedMessages[var1_1];
        }
        if (this.connection_ == null) return this.getUnformattedMessage(var1_1);
        if (this.connection_.isClosedX() != false) return this.getUnformattedMessage(var1_1);
        if (this.returnTokensOnlyInMessageText_) {
            return this.getUnformattedMessage(var1_1);
        }
        var2_2 = null;
        var3_3 = this.connection_;
        synchronized (var3_3) {
            block16: {
                block14: {
                    block15: {
                        block13: {
                            try {
                                var2_2 = this.connection_.prepareMessageProc("call SYSIBM.SQLCAMESSAGE(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
                                var4_4 = null;
                                var5_5 = null;
                                if (this.sqlErrmcMessages_ != null) {
                                    var4_4 = this.sqlErrmcMessages_[var1_1];
                                    var5_5 = this.sqlStates_[var1_1];
                                }
                                var2_2.setIntX(1, var1_1 == 0 ? this.getSqlCode() : 0);
                                var2_2.setShortX(2, (short)(var4_4 == null ? 0 : var4_4.length()));
                                var2_2.setStringX(3, var4_4);
                                var2_2.setStringX(4, this.getSqlErrp());
                                var2_2.setIntX(5, this.getSqlErrd()[0]);
                                var2_2.setIntX(6, this.getSqlErrd()[1]);
                                var2_2.setIntX(7, this.getSqlErrd()[2]);
                                var2_2.setIntX(8, this.getSqlErrd()[3]);
                                var2_2.setIntX(9, this.getSqlErrd()[4]);
                                var2_2.setIntX(10, this.getSqlErrd()[5]);
                                var2_2.setStringX(11, new String(this.getSqlWarn()));
                                var2_2.setStringX(12, var5_5);
                                var2_2.setStringX(13, null);
                                var2_2.setStringX(14, Locale.getDefault().toString());
                                var2_2.registerOutParameterX(14, 12);
                                var2_2.registerOutParameterX(15, -1);
                                var2_2.registerOutParameterX(16, 4);
                                var2_2.executeX();
                                if (var2_2.getIntX(16) == 0) {
                                    this.messageTextRetrievedContainsTokensOnly_ = false;
                                    var6_6 = var2_2.getStringX(15);
                                    if (this.cachedMessages == null) {
                                        this.cachedMessages = new String[this.numberOfMessages()];
                                    }
                                    this.cachedMessages[var1_1] = var6_6;
                                    var7_8 = var6_6;
                                    var9_9 = null;
                                    if (var2_2 == null) return var7_8;
                                    break block13;
                                }
                                var6_7 = this.getUnformattedMessage(var1_1);
                                break block14;
                            }
                            catch (Throwable var8_15) {
                                var9_11 = null;
                                if (var2_2 == null) throw var8_15;
                                try {
                                    var2_2.closeX();
                                    throw var8_15;
                                }
                                catch (SqlException var10_14) {
                                    throw var8_15;
                                }
                            }
                        }
                        ** try [egrp 2[TRYBLOCK] [3 : 385->392)] { 
lbl61:
                        // 1 sources

                        var2_2.closeX();
                        break block15;
lbl63:
                        // 1 sources

                        catch (SqlException var10_12) {
                            // empty catch block
                        }
                    }
                    return var7_8;
                }
                var9_10 = null;
                if (var2_2 == null) return var6_7;
                ** try [egrp 2[TRYBLOCK] [3 : 385->392)] { 
lbl71:
                // 1 sources

                var2_2.closeX();
                break block16;
lbl73:
                // 1 sources

                catch (SqlException var10_13) {
                    // empty catch block
                }
            }
            return var6_7;
        }
    }

    synchronized String getJDBCMessage(int n) {
        if (this.connection_ != null && this.connection_.retrieveMessageText_) {
            try {
                return this.getMessage(n);
            }
            catch (SqlException sqlException) {
                this.exceptionThrownOnStoredProcInvocation_ = sqlException;
                this.chainDeferredExceptionsToAgentOrAsConnectionWarnings(sqlException);
                return this.getUnformattedMessage(n);
            }
        }
        return this.getUnformattedMessage(n);
    }

    private String getUnformattedMessage(int n) {
        String string;
        String string2;
        int n2;
        if (n == 0) {
            n2 = this.getSqlCode();
            string2 = this.getSqlState();
            string = this.getSqlErrmc();
        } else {
            n2 = 0;
            string2 = this.sqlStates_[n];
            string = this.sqlErrmcMessages_[n];
        }
        return "DERBY SQL error: SQLCODE: " + n2 + ", SQLSTATE: " + string2 + ", SQLERRMC: " + string;
    }

    private void chainDeferredExceptionsToAgentOrAsConnectionWarnings(SqlException sqlException) {
        SqlException sqlException2 = sqlException;
        while (sqlException2 != null) {
            SqlWarning sqlWarning;
            SqlException sqlException3 = sqlException2.getNextException();
            if ((sqlException2 = sqlException2.copyAsUnchainedSQLException(this.agent_.logWriter_)).getErrorCode() == -440) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"));
                sqlWarning.setNextException(sqlException2.getSQLException());
                this.connection_.accumulate440WarningForMessageProcFailure(sqlWarning);
            } else if (sqlException2.getErrorCode() == -444) {
                sqlWarning = new SqlWarning(this.agent_.logWriter_, new ClientMessageId("01J12"));
                sqlWarning.setNextException(sqlException2.getSQLException());
                this.connection_.accumulate444WarningForMessageProcFailure(sqlWarning);
            } else {
                this.agent_.accumulateDeferredException(sqlException2);
            }
            sqlException2 = sqlException3;
        }
    }

    public boolean includesSqlCode(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this.getSqlCode()) continue;
            return true;
        }
        return false;
    }

    private void processSqlErrmcTokens(byte[] byArray) {
        if (byArray == null) {
            return;
        }
        int n = byArray.length;
        if (n == 0) {
            this.sqlErrmcMessages_ = new String[0];
            this.sqlStates_ = this.sqlErrmcMessages_;
            return;
        }
        try {
            String string = this.bytes2String(byArray, 0, n);
            String[] stringArray = string.split("\\u0014{3}");
            String[] stringArray2 = new String[stringArray.length];
            stringArray2[0] = this.getSqlState();
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i] = stringArray[i].substring(0, 5);
                stringArray[i] = stringArray[i].substring(6);
            }
            this.sqlStates_ = stringArray2;
            this.sqlErrmcMessages_ = stringArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    protected String bytes2String(byte[] byArray, int n, int n2) throws UnsupportedEncodingException {
        return new String(byArray, n, n2, "UTF8");
    }

    public int getUpdateCount() {
        if (this.sqlErrd_ == null) {
            return 0;
        }
        return this.sqlErrd_[2];
    }

    public long getRowCount() throws DisconnectException {
        return ((long)this.sqlErrd_[0] << 32) + (long)this.sqlErrd_[1];
    }

    public void setContainsSqlcax(boolean bl) {
        this.containsSqlcax_ = bl;
    }

    public boolean containsSqlcax() {
        return this.containsSqlcax_;
    }

    public void resetRowsetSqlca(Connection connection, int n, String string, byte[] byArray) {
        this.connection_ = connection;
        this.sqlCode_ = n;
        this.sqlState_ = string;
        this.sqlErrpBytes_ = byArray;
    }

    public void setRowsetRowCount(long l) {
        this.rowsetRowCount_ = l;
    }

    public long getRowsetRowCount() {
        return this.rowsetRowCount_;
    }
}

