/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class BinaryRelationalOperatorNode
extends BinaryComparisonOperatorNode
implements RelationalOperator {
    private int operatorType;
    private BaseTableNumbersVisitor btnVis;
    JBitSet optBaseTables;
    JBitSet valNodeBaseTables;
    InListOperatorNode inListProbeSource = null;
    protected static final int LEFT = -1;
    protected static final int NEITHER = 0;
    protected static final int RIGHT = 1;

    public void init(Object object, Object object2) {
        String string = "";
        String string2 = "";
        switch (this.getNodeType()) {
            case 41: {
                string = "equals";
                string2 = "=";
                this.operatorType = 1;
                break;
            }
            case 42: {
                string = "greaterOrEquals";
                string2 = ">=";
                this.operatorType = 4;
                break;
            }
            case 43: {
                string = "greaterThan";
                string2 = ">";
                this.operatorType = 3;
                break;
            }
            case 44: {
                string = "lessOrEquals";
                string2 = "<=";
                this.operatorType = 6;
                break;
            }
            case 45: {
                string = "lessThan";
                string2 = "<";
                this.operatorType = 5;
                break;
            }
            case 47: {
                string = "notEquals";
                string2 = "<>";
                this.operatorType = 2;
                break;
            }
        }
        super.init(object, object2, string2, string);
        this.btnVis = null;
    }

    public void init(Object object, Object object2, Object object3) {
        this.init(object, object2);
        this.inListProbeSource = (InListOperatorNode)object3;
    }

    protected InListOperatorNode getInListOp() {
        return this.inListProbeSource;
    }

    public ColumnReference getColumnOperand(Optimizable optimizable, int n) {
        ColumnReference columnReference;
        FromTable fromTable = (FromTable)optimizable;
        boolean bl = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, fromTable, false, bl) && columnReference.getSource().getColumnPosition() == n) {
                return columnReference;
            }
            bl = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, fromTable, false, bl) && columnReference.getSource().getColumnPosition() == n) {
            return columnReference;
        }
        return null;
    }

    public ColumnReference getColumnOperand(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, (FromTable)optimizable, false, bl)) {
                return columnReference;
            }
            bl = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, (FromTable)optimizable, false, bl)) {
            return columnReference;
        }
        return null;
    }

    public ValueNode getExpressionOperand(int n, int n2, FromTable fromTable) {
        ColumnReference columnReference;
        boolean bl = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, fromTable, false, bl) && columnReference.getSource().getColumnPosition() == n2) {
                return this.rightOperand;
            }
            bl = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, fromTable, false, bl) && columnReference.getSource().getColumnPosition() == n2) {
            return this.leftOperand;
        }
        return null;
    }

    public ValueNode getOperand(ColumnReference columnReference, int n, boolean bl) {
        this.initBaseTableVisitor(n, true);
        try {
            ColumnReference columnReference2;
            this.btnVis.setTableMap(this.optBaseTables);
            columnReference.accept(this.btnVis);
            this.btnVis.setTableMap(this.valNodeBaseTables);
            if (this.leftOperand instanceof ColumnReference) {
                columnReference2 = (ColumnReference)this.leftOperand;
                columnReference2.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && columnReference2.getSource().getColumnPosition() == columnReference.getColumnNumber()) {
                    if (bl) {
                        return this.rightOperand;
                    }
                    return this.leftOperand;
                }
            }
            if (this.rightOperand instanceof ColumnReference) {
                this.valNodeBaseTables.clearAll();
                columnReference2 = (ColumnReference)this.rightOperand;
                columnReference2.accept(this.btnVis);
                this.valNodeBaseTables.and(this.optBaseTables);
                if (this.valNodeBaseTables.getFirstSetBit() != -1 && columnReference2.getSource().getColumnPosition() == columnReference.getColumnNumber()) {
                    if (bl) {
                        return this.leftOperand;
                    }
                    return this.rightOperand;
                }
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return null;
    }

    public void generateExpressionOperand(Optimizable optimizable, int n, ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        FromBaseTable fromBaseTable = (FromBaseTable)optimizable;
        ValueNode valueNode = this.getExpressionOperand(fromBaseTable.getTableNumber(), n, fromBaseTable);
        valueNode.generateExpression(expressionClassBuilder, methodBuilder);
    }

    public boolean selfComparison(ColumnReference columnReference) throws StandardException {
        ValueNode valueNode = this.leftOperand == columnReference ? this.rightOperand : (this.rightOperand == columnReference ? this.leftOperand : null);
        JBitSet jBitSet = valueNode.getTablesReferenced();
        return jBitSet.get(columnReference.getTableNumber());
    }

    public boolean usefulStartKey(Optimizable optimizable) {
        int n = this.columnOnOneSide(optimizable);
        if (n == 0) {
            return false;
        }
        return this.usefulStartKey(n == -1);
    }

    protected boolean keyColumnOnLeft(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl = false;
        if (this.leftOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.leftOperand, (FromTable)optimizable, false, true)) {
            bl = true;
        }
        return bl;
    }

    protected int columnOnOneSide(Optimizable optimizable) {
        ColumnReference columnReference;
        boolean bl = false;
        boolean bl2 = true;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, (FromTable)optimizable, false, bl2)) {
                return -1;
            }
            bl2 = false;
        }
        if (this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, (FromTable)optimizable, false, bl2)) {
            return 1;
        }
        return 0;
    }

    public boolean usefulStopKey(Optimizable optimizable) {
        int n = this.columnOnOneSide(optimizable);
        if (n == 0) {
            return false;
        }
        return this.usefulStopKey(n == -1);
    }

    public void generateAbsoluteColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n = this.getAbsoluteColumnPosition(optimizable);
        methodBuilder.push(n);
    }

    public void generateRelativeColumnId(MethodBuilder methodBuilder, Optimizable optimizable) {
        int n = this.getAbsoluteColumnPosition(optimizable);
        n = optimizable.convertAbsoluteToRelativeColumnPosition(n);
        methodBuilder.push(n);
    }

    private int getAbsoluteColumnPosition(Optimizable optimizable) {
        ColumnReference columnReference = this.keyColumnOnLeft(optimizable) ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        ConglomerateDescriptor conglomerateDescriptor = optimizable.getTrulyTheBestAccessPath().getConglomerateDescriptor();
        int n = columnReference.getSource().getColumnPosition();
        if (conglomerateDescriptor != null && conglomerateDescriptor.isIndex()) {
            n = conglomerateDescriptor.getIndexDescriptor().getKeyColumnPosition(n);
        }
        return n - 1;
    }

    public void generateQualMethod(ExpressionClassBuilder expressionClassBuilder, MethodBuilder methodBuilder, Optimizable optimizable) throws StandardException {
        MethodBuilder methodBuilder2 = expressionClassBuilder.newUserExprFun();
        if (this.keyColumnOnLeft(optimizable)) {
            this.rightOperand.generateExpression(expressionClassBuilder, methodBuilder2);
        } else {
            this.leftOperand.generateExpression(expressionClassBuilder, methodBuilder2);
        }
        methodBuilder2.methodReturn();
        methodBuilder2.complete();
        expressionClassBuilder.pushMethodReference(methodBuilder, methodBuilder2);
    }

    public void generateOrderedNulls(MethodBuilder methodBuilder) {
        methodBuilder.push(false);
    }

    public boolean orderedNulls() {
        return false;
    }

    public boolean isQualifier(Optimizable optimizable, boolean bl) throws StandardException {
        if (this.inListProbeSource != null) {
            return false;
        }
        ValueNode valueNode = null;
        ColumnReference columnReference = null;
        boolean bl2 = false;
        boolean bl3 = true;
        FromTable fromTable = (FromTable)optimizable;
        if (this.leftOperand instanceof ColumnReference) {
            columnReference = (ColumnReference)this.leftOperand;
            if (this.valNodeReferencesOptTable(columnReference, fromTable, bl, bl3)) {
                valueNode = this.rightOperand;
                bl2 = true;
            }
            bl3 = false;
        }
        if (!bl2 && this.rightOperand instanceof ColumnReference && this.valNodeReferencesOptTable(columnReference = (ColumnReference)this.rightOperand, fromTable, bl, bl3)) {
            valueNode = this.leftOperand;
            bl2 = true;
        }
        if (!bl2) {
            return false;
        }
        return !this.valNodeReferencesOptTable(valueNode, fromTable, bl, true);
    }

    public int getOrderableVariantType(Optimizable optimizable) throws StandardException {
        if (this.keyColumnOnLeft(optimizable)) {
            return this.rightOperand.getOrderableVariantType();
        }
        return this.leftOperand.getOrderableVariantType();
    }

    public boolean compareWithKnownConstant(Optimizable optimizable, boolean bl) {
        ValueNode valueNode = null;
        ValueNode valueNode2 = valueNode = this.keyColumnOnLeft(optimizable) ? this.rightOperand : this.leftOperand;
        if (bl) {
            return valueNode instanceof ConstantNode || valueNode.requiresTypeFromContext() && ((ParameterNode)valueNode).getDefaultValue() != null;
        }
        return valueNode instanceof ConstantNode;
    }

    public DataValueDescriptor getCompareValue(Optimizable optimizable) throws StandardException {
        ValueNode valueNode = null;
        ValueNode valueNode2 = valueNode = this.keyColumnOnLeft(optimizable) ? this.rightOperand : this.leftOperand;
        if (valueNode instanceof ConstantNode) {
            return ((ConstantNode)valueNode).getValue();
        }
        if (valueNode.requiresTypeFromContext()) {
            ParameterNode parameterNode = valueNode instanceof UnaryOperatorNode ? ((UnaryOperatorNode)valueNode).getParameterOperand() : (ParameterNode)valueNode;
            return parameterNode.getDefaultValue();
        }
        return null;
    }

    protected double booleanSelectivity(Optimizable optimizable) throws StandardException {
        TypeId typeId = null;
        double d = -1.0;
        int n = this.columnOnOneSide(optimizable);
        if (n == -1) {
            typeId = this.leftOperand.getTypeId();
        } else if (n == 1) {
            typeId = this.rightOperand.getTypeId();
        }
        if (typeId != null && (typeId.getJDBCTypeId() == -7 || typeId.getJDBCTypeId() == 16)) {
            d = 0.5;
        }
        return d;
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.DataValueDescriptor";
    }

    BinaryOperatorNode getNegation(ValueNode valueNode, ValueNode valueNode2) throws StandardException {
        BinaryOperatorNode binaryOperatorNode = (BinaryOperatorNode)this.getNodeFactory().getNode(this.getNegationNode(), valueNode, valueNode2, this.getContextManager());
        binaryOperatorNode.setType(this.getTypeServices());
        return binaryOperatorNode;
    }

    private int getNegationNode() {
        switch (this.getNodeType()) {
            case 41: {
                return 47;
            }
            case 42: {
                return 45;
            }
            case 43: {
                return 44;
            }
            case 45: {
                return 42;
            }
            case 44: {
                return 43;
            }
            case 47: {
                return 41;
            }
        }
        return -1;
    }

    protected boolean usefulStartKey(boolean bl) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return bl;
            }
            case 5: 
            case 6: {
                return !bl;
            }
        }
        return false;
    }

    protected boolean usefulStopKey(boolean bl) {
        switch (this.operatorType) {
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: 
            case 4: {
                return !bl;
            }
            case 5: 
            case 6: {
                return bl;
            }
        }
        return false;
    }

    public int getStartOperator(Optimizable optimizable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return 1;
            }
            case 3: 
            case 5: {
                return -1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public int getStopOperator(Optimizable optimizable) {
        switch (this.operatorType) {
            case 1: 
            case 4: 
            case 6: {
                return -1;
            }
            case 3: 
            case 5: {
                return 1;
            }
            case 2: {
                return 0;
            }
        }
        return 0;
    }

    public void generateOperator(MethodBuilder methodBuilder, Optimizable optimizable) {
        switch (this.operatorType) {
            case 1: {
                methodBuilder.push(2);
                break;
            }
            case 2: {
                methodBuilder.push(2);
                break;
            }
            case 4: 
            case 5: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable) ? 1 : 3);
                break;
            }
            case 3: 
            case 6: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable) ? 3 : 1);
            }
        }
    }

    public void generateNegate(MethodBuilder methodBuilder, Optimizable optimizable) {
        switch (this.operatorType) {
            case 1: {
                methodBuilder.push(false);
                break;
            }
            case 2: {
                methodBuilder.push(true);
                break;
            }
            case 5: 
            case 6: {
                methodBuilder.push(!this.keyColumnOnLeft(optimizable));
                break;
            }
            case 3: 
            case 4: {
                methodBuilder.push(this.keyColumnOnLeft(optimizable));
            }
        }
    }

    public int getOperator() {
        return this.operatorType;
    }

    public double selectivity(Optimizable optimizable) throws StandardException {
        double d = this.booleanSelectivity(optimizable);
        if (d >= 0.0) {
            return d;
        }
        switch (this.operatorType) {
            case 1: {
                return 0.1;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                if (this.getBetweenSelectivity()) {
                    return 0.5;
                }
            }
            case 3: {
                return 0.33;
            }
        }
        return 0.0;
    }

    public RelationalOperator getTransitiveSearchClause(ColumnReference columnReference) throws StandardException {
        return (RelationalOperator)((Object)this.getNodeFactory().getNode(this.getNodeType(), columnReference, this.rightOperand, this.getContextManager()));
    }

    public boolean equalsComparisonWithConstantExpression(Optimizable optimizable) {
        if (this.operatorType != 1) {
            return false;
        }
        boolean bl = false;
        Object var3_3 = null;
        int n = this.columnOnOneSide(optimizable);
        if (n == -1) {
            bl = this.rightOperand.isConstantExpression();
        } else if (n == 1) {
            bl = this.leftOperand.isConstantExpression();
        }
        return bl;
    }

    public boolean isRelationalOperator() {
        return this.inListProbeSource == null;
    }

    public boolean isBinaryEqualsOperatorNode() {
        return this.inListProbeSource == null && this.operatorType == 1;
    }

    public boolean isInListProbeNode() {
        return this.inListProbeSource != null;
    }

    public boolean optimizableEqualityNode(Optimizable optimizable, int n, boolean bl) throws StandardException {
        if (this.operatorType != 1) {
            return false;
        }
        if (this.inListProbeSource != null) {
            return false;
        }
        ColumnReference columnReference = this.getColumnOperand(optimizable, n);
        if (columnReference == null) {
            return false;
        }
        if (this.selfComparison(columnReference)) {
            return false;
        }
        return !this.implicitVarcharComparison();
    }

    private boolean implicitVarcharComparison() throws StandardException {
        TypeId typeId = this.leftOperand.getTypeId();
        TypeId typeId2 = this.rightOperand.getTypeId();
        if (typeId.isStringTypeId() && !typeId2.isStringTypeId()) {
            return true;
        }
        return typeId2.isStringTypeId() && !typeId.isStringTypeId();
    }

    public ValueNode genSQLJavaSQLTree() throws StandardException {
        if (this.operatorType == 1) {
            return this;
        }
        return super.genSQLJavaSQLTree();
    }

    public ValueNode getScopedOperand(int n, JBitSet jBitSet, ResultSetNode resultSetNode, int[] nArray) throws StandardException {
        Object object;
        ResultColumn resultColumn = null;
        ColumnReference columnReference = n == -1 ? (ColumnReference)this.leftOperand : (ColumnReference)this.rightOperand;
        JBitSet jBitSet2 = new JBitSet(jBitSet.size());
        BaseTableNumbersVisitor baseTableNumbersVisitor = new BaseTableNumbersVisitor(jBitSet2);
        columnReference.accept(baseTableNumbersVisitor);
        if (!jBitSet.contains(jBitSet2)) {
            return (ColumnReference)columnReference.getClone();
        }
        if (nArray[0] == -1) {
            object = new int[]{-1};
            ResultSetNode resultSetNode2 = columnReference.getSourceResultSet((int[])object);
            resultColumn = resultSetNode.getResultColumns().getResultColumn(object[0], resultSetNode2, nArray);
        } else {
            resultColumn = resultSetNode.getResultColumns().getResultColumn(nArray[0]);
        }
        if (resultColumn.getExpression() instanceof ColumnReference) {
            object = (ColumnReference)((ColumnReference)resultColumn.getExpression()).getClone();
            ((ColumnReference)object).markAsScoped();
            return object;
        }
        return resultColumn.getExpression();
    }

    private boolean valNodeReferencesOptTable(ValueNode valueNode, FromTable fromTable, boolean bl, boolean bl2) {
        this.initBaseTableVisitor(fromTable.getReferencedTableMap().size(), bl2);
        boolean bl3 = false;
        try {
            if (bl2) {
                this.buildTableNumList(fromTable, bl);
            }
            this.btnVis.setTableMap(this.valNodeBaseTables);
            valueNode.accept(this.btnVis);
            this.valNodeBaseTables.and(this.optBaseTables);
            bl3 = this.valNodeBaseTables.getFirstSetBit() != -1;
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return bl3;
    }

    private void initBaseTableVisitor(int n, boolean bl) {
        if (this.valNodeBaseTables == null) {
            this.valNodeBaseTables = new JBitSet(n);
        } else {
            this.valNodeBaseTables.clearAll();
        }
        if (bl) {
            if (this.optBaseTables == null) {
                this.optBaseTables = new JBitSet(n);
            } else {
                this.optBaseTables.clearAll();
            }
        }
        if (this.btnVis == null) {
            this.btnVis = new BaseTableNumbersVisitor(this.valNodeBaseTables);
        }
    }

    private void buildTableNumList(FromTable fromTable, boolean bl) throws StandardException {
        if (fromTable.getTableNumber() >= 0) {
            this.optBaseTables.set(fromTable.getTableNumber());
        }
        if (bl) {
            return;
        }
        this.optBaseTables.or(fromTable.getReferencedTableMap());
        this.btnVis.setTableMap(this.optBaseTables);
        fromTable.accept(this.btnVis);
    }
}

