#ifndef _FELD_H
#define _FELD_H

#include <gnome.h>

#include "cmplx.h"
#include "trx.h"

#define	SampleRate	11025
#define	NumColumns	7
#define NumPixel	7
#define	PixelLen	90
#define ColumnLen	((PixelLen)*(NumPixel))
#define	DownSample	21
#define	PixBufLen	((ColumnLen)/(DownSample))
#define BandWidth	245.0
#define	CenterFreq	1000.0
#define FilterLen	22

struct feld {
        /*
         * Common stuff
         */
        double bw;

	/*
	 * RX related stuff
	 */
	double rxphacc;

	struct filter *hilbert;
	struct fftfilt *fftfilt;

	double sndbuf[ColumnLen];
	int sndptr;

	double agc;

	/*
	 * TX related stuff
	 */
	double txphacc;

	struct filter *txfilt;

	GdkPixmap *pixmap;
	GdkGC *gc_black;
	GdkGC *gc_white;

	int preamble;
	int postamble;
};

/* in feld.c */
extern void feld_init(struct trx *trx);

/* in feldrx.c */
extern int feld_rxprocess(struct trx *trx, float *buf, int len);

/* in feldtx.c */
extern int feld_txprocess(struct trx *trx);

#endif
