#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include "main.h"
#include "conf.h"
#include "confdialog.h"
#include "trx.h"
#include "macro.h"
#include "log.h"
#include "qsodata.h"

/* ---------------------------------------------------------------------- */

gboolean
on_appwindow_delete_event              (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	trx_set_state(TRX_STATE_ABORT);
	gtk_main_quit();

	return TRUE;
}

/* ---------------------------------------------------------------------- */

void
on_send_file1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	widget = g_object_get_data(G_OBJECT(appwindow), "txfileselectdialog");

	if (widget) {
		gtk_window_present(GTK_WINDOW(widget));
		return;
	}

	widget = create_txfileselection();
	gtk_widget_show(widget);

	g_object_set_data(G_OBJECT(appwindow), "txfileselectdialog", widget);
}


void
on_log_to_file1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	if (log_to_file_activate(GTK_CHECK_MENU_ITEM(menuitem)->active) == FALSE)
		errmsg("Unable to open log file");
}


void
on_clear_tx_window1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkTextView *view;
	GtkTextBuffer *buffer;

	view = GTK_TEXT_VIEW(lookup_widget(appwindow, "txtext"));
	buffer = gtk_text_view_get_buffer(view);
	gtk_text_buffer_set_text(buffer, "", -1);

	/* clear tx typeahead buffer */
	while (trx_get_tx_char() != -1);
}


void
on_clear_rx_window1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkTextView *view;
	GtkTextBuffer *buffer;

	view = GTK_TEXT_VIEW(lookup_widget(appwindow, "rxtext"));
	buffer = gtk_text_view_get_buffer(view);
	gtk_text_buffer_set_text(buffer, "", -1);
}


void
on_exit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	trx_set_state(TRX_STATE_ABORT);
	gtk_main_quit();
}

/* ---------------------------------------------------------------------- */

static void set_sens(gboolean afc, gboolean sql, gboolean rev, gboolean frq)
{
	GtkWidget *w;

	w = lookup_widget(appwindow, "afcbutton");
	gtk_widget_set_sensitive(w, afc);
	w = lookup_widget(appwindow, "squelchbutton");
	gtk_widget_set_sensitive(w, sql);
	w = lookup_widget(appwindow, "reversebutton");
	gtk_widget_set_sensitive(w, rev);
	w = lookup_widget(appwindow, "freqspinbutton");
	gtk_widget_set_sensitive(w, frq);
}

static void set_scope_mode(miniscope_mode_t mode)
{
	GtkWidget *widget;

	widget = lookup_widget(appwindow, "miniscope");
	miniscope_set_mode(MINISCOPE(widget), mode);
}

void
on_mfsk1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_MFSK16) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_MFSK16);
		trx_set_state_wait(state);

		set_sens(TRUE, TRUE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_mfsk2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_MFSK8) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_MFSK8);
		trx_set_state_wait(state);

		set_sens(TRUE, TRUE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_rtty1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_RTTY) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_RTTY);
		trx_set_state_wait(state);

		set_sens(TRUE, FALSE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_throb1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_THROB1) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_THROB1);
		trx_set_state_wait(state);

		set_sens(TRUE, FALSE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, TRUE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_throb2_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_THROB2) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_THROB2);
		trx_set_state_wait(state);

		set_sens(TRUE, FALSE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, TRUE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_throb4_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_THROB4) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_THROB4);
		trx_set_state_wait(state);

		set_sens(TRUE, FALSE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_SCOPE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, TRUE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_bpsk31_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_BPSK31) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_BPSK31);
		trx_set_state_wait(state);

		set_sens(TRUE, TRUE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_PHASE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}


void
on_qpsk31_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_QPSK31) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_QPSK31);
		trx_set_state_wait(state);

		set_sens(TRUE, TRUE, TRUE, TRUE);
		set_scope_mode(MINISCOPE_MODE_PHASE);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}

void
on_mt63_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_MT63) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_MT63);
		trx_set_state_wait(state);

		set_sens(FALSE, TRUE, FALSE, FALSE);
		set_scope_mode(MINISCOPE_MODE_BLANK);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, FALSE);
		waterfall_set_fixed(waterfall, TRUE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 0);

		statusbar_set_mode(trx_get_mode());
	}
}

void
on_feldhell1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);
	GtkWidget *w;

	if (item->active && trx_get_mode() != MODE_FELD) {
		gint state = trx_get_state();

		trx_set_state_wait(TRX_STATE_ABORT);
		trx_set_mode(MODE_FELD);
		trx_set_state_wait(state);

		set_sens(FALSE, FALSE, FALSE, TRUE);
		set_scope_mode(MINISCOPE_MODE_BLANK);

		waterfall_set_samplerate(waterfall, trx_get_samplerate());
		waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
		waterfall_set_frequency(waterfall, trx_get_freq());
		waterfall_set_centerline(waterfall, TRUE);
		waterfall_set_fixed(waterfall, FALSE);

		w = lookup_widget(appwindow, "trxnotebook");
		gtk_notebook_set_current_page(GTK_NOTEBOOK(w), 1);

		statusbar_set_mode(trx_get_mode());
	}
}

/* ---------------------------------------------------------------------- */

void
on_preferences1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *widget;

	widget = g_object_get_data(G_OBJECT(appwindow), "configdialog");

	if (widget) {
		gtk_window_present(GTK_WINDOW(widget));
		return;
	}

	widget = confdialog_init();

	if (widget) {
		gtk_widget_show(widget);
		g_object_set_data(G_OBJECT(appwindow), "configdialog", widget);
	}
}


void
on_macroconfig1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(1);
}


void
on_macroconfig2_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(2);
}


void
on_macroconfig3_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(3);
}


void
on_macroconfig4_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(4);
}


void
on_macroconfig5_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(5);
}


void
on_macroconfig6_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(6);
}


void
on_macroconfig7_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(7);
}


void
on_macroconfig8_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(8);
}


void
on_macroconfig9_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(9);
}


void
on_macroconfig10_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(10);
}


void
on_macroconfig11_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(11);
}


void
on_macroconfig12_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	macroconfig(12);
}

/* ---------------------------------------------------------------------- */

void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkWidget *aboutwindow;

	aboutwindow = create_aboutwindow();
	gtk_widget_show(aboutwindow);
}

/* ---------------------------------------------------------------------- */

void
on_pausebutton_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gboolean b = gtk_toggle_button_get_active(togglebutton);

	if (b && trx_get_state() != TRX_STATE_ABORT) {
		trx_set_state(TRX_STATE_PAUSE);
	}
}


void
on_rxbutton_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gboolean b = gtk_toggle_button_get_active(togglebutton);

	if (b)  trx_set_state(TRX_STATE_RX);
}


void
on_txbutton_toggled                    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	GtkWidget *widget;
	gboolean b = gtk_toggle_button_get_active(togglebutton);

	if (b) {
		trx_set_state(TRX_STATE_TX);

		/* set focus to the tx text widget */
		widget = lookup_widget(appwindow, "txtext");
		gtk_widget_grab_focus(widget);
	}
}


void
on_abortbutton_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
	gint state = trx_get_state();

	if (state != TRX_STATE_ABORT && state != TRX_STATE_PAUSE) {
		trx_set_state_wait(TRX_STATE_ABORT);
		/* clear tx typeahead buffer */
		while (trx_get_tx_char() != -1);
		/* switch to rx */
		trx_set_state_wait(TRX_STATE_RX);
		push_button("rxbutton");
	}
}


static gint
tune_timeout_cb                        (gpointer unused)
{
	gdk_threads_enter();
	if (trx_get_state() == TRX_STATE_TUNE)
		push_button("rxbutton");
	gdk_threads_leave();

	return FALSE;
}

void
on_tunebutton_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	gboolean b = gtk_toggle_button_get_active(togglebutton);

	if (b) {
		trx_set_state(TRX_STATE_TUNE);
		gtk_timeout_add(30000, tune_timeout_cb, NULL);
	}
}

/* ---------------------------------------------------------------------- */

void
on_qsoentry_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
	set_qsotime();
}


void
on_logbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	log_qsodata();
}


void
on_newbutton_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	clear_qsodata();
}

/* ---------------------------------------------------------------------- */

gboolean
on_txtext_key_press_event              (GtkWidget       *widget,
                                        GdkEventKey     *event,
                                        gpointer         user_data)
{
	GtkTextBuffer *buffer;

	/* ignore if CTRL or ALT is pressed (reserved for accelerators) */
	if (event->state & (GDK_CONTROL_MASK | GDK_MOD1_MASK))
		return FALSE;

	switch (event->keyval) {
	case GDK_Return:
		send_char('\n');
		break;

	case GDK_BackSpace:
		trx_put_tx_char(8);
		buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
		textbuffer_delete_end(buffer, 1);
		break;

	default:
		if (event->keyval < 256)
			send_char(event->keyval);
		break;
	}

	return FALSE;
}


gboolean
on_txtext_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	return FALSE;
}


void
on_txtext_selection_received           (GtkWidget       *widget,
                                        GtkSelectionData *data,
                                        guint            time,
                                        gpointer         user_data)
{
	return;
}

/* ---------------------------------------------------------------------- */

void
on_macrobutton1_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(1);
}


gboolean
on_macrobutton1_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(1);
	return FALSE;
}


void
on_macrobutton2_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(2);
}


gboolean
on_macrobutton2_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(2);
	return FALSE;
}


void
on_macrobutton3_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(3);
}


gboolean
on_macrobutton3_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(3);
	return FALSE;
}


void
on_macrobutton4_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(4);
}


gboolean
on_macrobutton4_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(4);
	return FALSE;
}


void
on_macrobutton5_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(5);
}


gboolean
on_macrobutton5_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(5);
	return FALSE;
}


void
on_macrobutton6_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(6);
}


gboolean
on_macrobutton6_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(6);
	return FALSE;
}


void
on_macrobutton7_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(7);
}


gboolean
on_macrobutton7_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(7);
	return FALSE;
}


void
on_macrobutton8_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(8);
}


gboolean
on_macrobutton8_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(8);
	return FALSE;
}


void
on_macrobutton9_clicked                (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(9);
}


gboolean
on_macrobutton9_button_press_event     (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(9);
	return FALSE;
}


void
on_macrobutton10_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(10);
}


gboolean
on_macrobutton10_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(10);
	return FALSE;
}


void
on_macrobutton11_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(11);
}


gboolean
on_macrobutton11_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(11);
	return FALSE;
}


void
on_macrobutton12_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	send_macro(12);
}


gboolean
on_macrobutton12_button_press_event    (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	if (event->button == 3)
		macroconfig(12);
	return FALSE;
}

/* ---------------------------------------------------------------------- */

gboolean
on_waterfall_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	/* we are interested in button three */
	if (event->button != 3)
		return FALSE;

	gtk_menu_popup(GTK_MENU(WFPopupMenu), NULL, NULL, NULL, NULL,
		       event->button, event->time);

	return FALSE;
}


void
on_freqspinbutton_changed              (GtkEditable     *editable,
                                        gpointer         user_data)
{
	GtkSpinButton *spin;
	gfloat freq;

	spin = GTK_SPIN_BUTTON(editable);
	freq = gtk_spin_button_get_value_as_float(spin);
	waterfall_set_frequency(waterfall, freq);
}


void
on_afcbutton_toggled                   (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	trx_set_afc(gtk_toggle_button_get_active(togglebutton));
}


void
on_squelchbutton_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	trx_set_squelch(gtk_toggle_button_get_active(togglebutton));
}


void
on_reversebutton_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
	trx_set_reverse(gtk_toggle_button_get_active(togglebutton));
}

/* ---------------------------------------------------------------------- */

static void
destroy_txfileselection(void)
{
	GtkWidget *w;

	w = g_object_get_data(G_OBJECT(appwindow), "txfileselectdialog");

	if (w != NULL)
		gtk_widget_destroy(w);

	g_object_set_data(G_OBJECT(appwindow), "txfileselectdialog", NULL);
}

gboolean
on_txfileselection_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	destroy_txfileselection();
	return FALSE;
}


void
on_txfileselect_ok_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkFileSelection *f;
	GtkWidget *w;
	gchar *fname, line[1024];
	FILE *fp;

	w = g_object_get_data(G_OBJECT(appwindow), "txfileselectdialog");
	f = GTK_FILE_SELECTION(w);
	fname = g_strdup(gtk_file_selection_get_filename(f));

	destroy_txfileselection();

	if ((fp = fopen(fname, "r")) == NULL) {
		errmsg("fopen: %s: %s", fname, strerror(errno));
		g_free(fname);
		return;
	}

	while (fgets(line, sizeof(line) - 1, fp) > 0) {
		line[sizeof(line) - 1] = 0;
		send_string(line);
	}

	g_free(fname);
}


void
on_txfileselect_cancel_button_clicked  (GtkButton       *button,
                                        gpointer         user_data)
{
	destroy_txfileselection();
}

/* ---------------------------------------------------------------------- */

void
on_wfpause_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	waterfall_set_pause(waterfall, item->active);
}


void
on_wfmode_normal_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_mode(waterfall, WATERFALL_MODE_NORMAL);
}


void
on_wfmode_spectrum_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_mode(waterfall, WATERFALL_MODE_SPECTRUM);
}


void
on_wfmode_scope_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_mode(waterfall, WATERFALL_MODE_SCOPE);
}


void
on_wfmag_1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_magnification(waterfall, WATERFALL_MAG_1);
}


void
on_wfmag_2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_magnification(waterfall, WATERFALL_MAG_2);
}


void
on_wfmag_4_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_magnification(waterfall, WATERFALL_MAG_4);
}


void
on_wfspeed_half_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_speed(waterfall, WATERFALL_SPEED_HALF);
}


void
on_wfspeed_normal_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_speed(waterfall, WATERFALL_SPEED_NORMAL);
}


void
on_wfspeed_double_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_speed(waterfall, WATERFALL_SPEED_DOUBLE);
}


void
on_wfwindow_rect_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_window(waterfall, WATERFALL_WINDOW_RECT);
}


void
on_wfwindow_tria_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_window(waterfall, WATERFALL_WINDOW_TRIA);
}


void
on_wfwindow_hamm_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	GtkCheckMenuItem *item = GTK_CHECK_MENU_ITEM(menuitem);

	if (item->active)
		waterfall_set_window(waterfall, WATERFALL_WINDOW_HAMM);
}

/* ---------------------------------------------------------------------- */

static gchar *qsodatatext = NULL;

static void word_start(GtkTextIter *iter)
{
	while (gtk_text_iter_backward_char(iter))
		if (g_unichar_isspace(gtk_text_iter_get_char(iter)))
			break;

	if (g_unichar_isspace(gtk_text_iter_get_char(iter)))
		gtk_text_iter_forward_char(iter);
}

static void word_end(GtkTextIter *iter)
{
	while (gtk_text_iter_forward_char(iter))
		if (g_unichar_isspace(gtk_text_iter_get_char(iter)))
			break;
}

gboolean
on_rxtext_button_press_event           (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
	GtkTextIter iter, start, end;
	GtkTextBuffer *buffer;
	gint x, y;

	g_free(qsodatatext);
	qsodatatext = NULL;

	if (event->button != 3)
		return FALSE;

	gtk_text_view_window_to_buffer_coords(GTK_TEXT_VIEW(widget),
					      GTK_TEXT_WINDOW_WIDGET,
					      event->x, event->y,
					      &x, &y);

	gtk_text_view_get_iter_at_location(GTK_TEXT_VIEW(widget), &iter, x, y);

	if (!gtk_text_iter_inside_word(&iter))
		return FALSE;

	start = iter;
	end = iter;

	word_start(&start);
	word_end(&end);

	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widget));
	gtk_text_buffer_apply_tag_by_name(buffer, "qsodatatag", &start, &end);
	qsodatatext = gtk_text_buffer_get_text(buffer, &start, &end, FALSE);

	return FALSE;
}

static void on_rxtext_qsodata_activated(GtkMenuItem *menuitem, gpointer data)
{
	void (*func) (char *str) = data;
	(*func) (qsodatatext);
}

static void on_rxtext_menu_selection_done(GtkMenuShell *menushell,
					  gpointer user_data)
{
	GtkTextIter start, end;
	GtkTextView *view;
	GtkTextBuffer *buffer;

	view = GTK_TEXT_VIEW(lookup_widget(appwindow, "rxtext"));
	buffer = gtk_text_view_get_buffer(view);

	gtk_text_buffer_get_start_iter(buffer, &start);
	gtk_text_buffer_get_end_iter(buffer, &end);
	gtk_text_buffer_remove_tag_by_name(buffer, "qsodatatag", &start, &end);
}

void
on_rxtext_populate_popup               (GtkTextView     *textview,
                                        GtkMenu         *menu,
                                        gpointer         user_data)
{
	GtkWidget *menu_item;
	gboolean flag = FALSE;

	if (qsodatatext != NULL)
		flag = TRUE;

	g_signal_connect(G_OBJECT(menu), "selection-done",
			 G_CALLBACK(on_rxtext_menu_selection_done), NULL);

	/* Prepend separator */
	menu_item = gtk_separator_menu_item_new();
	gtk_widget_show(menu_item);
	gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), menu_item);

	/* Prepend clear button */
	menu_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_CLEAR, NULL);
	// gtk_widget_set_sensitive(menu_item, TRUE);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_clear_rx_window1_activate), NULL);
	gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), menu_item);

	/* Append separator */
	menu_item = gtk_separator_menu_item_new();
	gtk_widget_show(menu_item);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	/* Append qsodata buttons */
	menu_item = gtk_menu_item_new_with_label("Callsign");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsocall);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	menu_item = gtk_menu_item_new_with_label("Name");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsoname);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	menu_item = gtk_menu_item_new_with_label("QTH");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsoqth);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	menu_item = gtk_menu_item_new_with_label("Sent RST");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsotxrst);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	menu_item = gtk_menu_item_new_with_label("Received RST");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsorxrst);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);

	menu_item = gtk_menu_item_new_with_label("Notes");
	gtk_widget_set_sensitive(menu_item, flag);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_rxtext_qsodata_activated),
			 (gpointer) set_qsonotes);
	gtk_menu_shell_append(GTK_MENU_SHELL(menu), menu_item);
}


void
on_txtext_populate_popup               (GtkTextView     *textview,
                                        GtkMenu         *menu,
                                        gpointer         user_data)
{
	GtkWidget *menu_item;

	/* Add the separator */
	menu_item = gtk_separator_menu_item_new();
	gtk_widget_show(menu_item);
	gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), menu_item);

	/* Add clear button */
	menu_item = gtk_image_menu_item_new_from_stock(GTK_STOCK_CLEAR, NULL);
	// gtk_widget_set_sensitive(menu_item, TRUE);
	gtk_widget_show(menu_item);
	g_signal_connect(G_OBJECT(menu_item), "activate",
			 G_CALLBACK(on_clear_tx_window1_activate), NULL);
	gtk_menu_shell_prepend(GTK_MENU_SHELL(menu), menu_item);
}

/* ---------------------------------------------------------------------- */

void
on_confrestartbutton_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	gint state = trx_get_state();

	trx_set_state_wait(TRX_STATE_ABORT);
	trx_set_state_wait(state);

	waterfall_set_bandwidth(waterfall, trx_get_bandwidth());
	waterfall_set_frequency(waterfall, trx_get_freq());
}

/* ---------------------------------------------------------------------- */

