# Notes:
# 1) this is an INCLUDE file for common settings
#    for demonstration configs
# 2) INCLUDING file must supply the sections for:
#    [EMC],[KINS],[HAL]

[APPLICATIONS]
APP = halshow --fformat "%.3f" corexy.halshow

[DISPLAY]
DISPLAY = axis
POSITION_OFFSET = RELATIVE
POSITION_FEEDBACK = ACTUAL
MAX_FEED_OVERRIDE = 1.2
DEFAULT_LINEAR_VELOCITY = 1.0
MIN_LINEAR_VELOCITY = 0
MAX_LINEAR_VELOCITY = 1.0
INTRO_GRAPHIC = linuxcnc.gif
INTRO_TIME = 5
PROGRAM_PREFIX = ../../nc_files/
INCREMENTS = .1in .01in .001in

[TASK]
TASK = milltask
CYCLE_TIME = 0.010

[RS274NGC]
PARAMETER_FILE = linuxcnc.var

[EMCMOT]
EMCMOT = motmod
BASE_PERIOD =   250000
SERVO_PERIOD = 1000000

[TRAJ]
COORDINATES =  XYZ
LINEAR_UNITS = inch
ANGULAR_UNITS = degree
DEFAULT_LINEAR_VELOCITY = 1.0
MAX_LINEAR_VELOCITY = 1.0

[EMCIO]
EMCIO = io
CYCLE_TIME = 0.10
TOOL_TABLE = tool.tbl

[AXIS_X]
MAX_VELOCITY =      2.0
MAX_ACCELERATION = 20.0
MIN_LIMIT =        -0.1
MAX_LIMIT =        10.0

[AXIS_Y]
MAX_VELOCITY =      2.0
MAX_ACCELERATION = 20.0
MIN_LIMIT =        -0.1
MAX_LIMIT =        10.0

[AXIS_Z]
MAX_VELOCITY =      2.0
MAX_ACCELERATION = 20.0
MIN_LIMIT =        -5.0
MAX_LIMIT =         0.5

[JOINT_0]
TYPE = LINEAR
MAX_VELOCITY =        2.0
MAX_ACCELERATION =   20.0
STEPGEN_MAXACCEL =   25.0
SCALE =            8000.0
HOME_SEARCH_VEL = 1
HOME_LATCH_VEL  = 1
HOME_SEQUENCE   = 0

[JOINT_1]
TYPE = LINEAR
MAX_VELOCITY =        2.0
MAX_ACCELERATION =   20.0
STEPGEN_MAXACCEL =   25.0
SCALE =            8000.0
HOME_SEARCH_VEL = 1
HOME_LATCH_VEL  = 1
HOME_SEQUENCE   = 1

[JOINT_2]
TYPE = LINEAR
MAX_VELOCITY =        2.0
MAX_ACCELERATION =   20.0
STEPGEN_MAXACCEL =   25.0
SCALE =            8000.0
HOME_SEARCH_VEL = 1
HOME_LATCH_VEL  = 1
HOME_SEQUENCE   = 2
