#! /bin/sh
#
################################################################################
# Primitive line tests - 2.2.2
################################################################################
#
OBJS=10000
SIZE=10
echo "/Test 2.2.2 : Aggregate primitive and attribute changes"
#
# XDrawSegment tests
#
for AGGREGATE in `echo 1 10 100`
do
    xx="$XEXT $WINDOW -size $SIZE -objects $OBJS -aggregate $AGGREGATE"
    TESTNAME="$OBJS $SIZE-pixel line segments, $AGGREGATE/prim (drawsegments)"
    $xx -l "$TESTNAME" -segments -primlines
done
#
AGGREGATE=$OBJS
TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim (XDrawLines)"
xx="$XEXT $WINDOW -size $SIZE -objects $OBJS -aggregate $AGGREGATE"
$xx -l "$TESTNAME" -primlines
#
for AGGREGATE in `echo 0 10 100`
do
    if [ $AGGREGATE = "0" ]
    then
	FUNC="(drawline)"
    else
	FUNC="(drawlines)"
    fi
    TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim $FUNC"
    xx="$XEXT $WINDOW -size $SIZE -objects $OBJS -aggregate $AGGREGATE"
    $xx -l "$TESTNAME" -primlines
#
    for NCHG in `echo 1 10`
    do
	TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim, chgfg=$NCHG $FUNC"
	$xx -l "$TESTNAME" -chgfg $NCHG -primlines

	TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim, chgfggc=$NCHG $FUNC"
	$xx -l "$TESTNAME" -chgfggc $NCHG -primlines

	TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim, chgfunc=$NCHG $FUNC"
	$xx -l "$TESTNAME" -chgfunction $NCHG -primlines

	TESTNAME="$OBJS $SIZE-pixel lines, $AGGREGATE/prim, chgstipple=$NCHG $FUNC"
	$xx -l "$TESTNAME" -chgstipple $NCHG -primlines
    done
done
#
