/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 extension test 2.2.2 -  primitive diagonal line tests
*/

#include "x11perf.h"

static XPoint   *points,*endpoints;
static XSegment *segs,*endsegs;
static GC       gc;
static Pixmap	stipple;

static unsigned long Pixel[4];
static int Function[2] = { GXcopy, GXxor };
static int Fillstyle[2] = { FillSolid, FillOpaqueStippled };
static GC gcs[4];

#define	NGCS	    (sizeof(gcs)/sizeof(GC))
#define GCMASK      (NGCS - 1)
#define PIXELMASK   ((sizeof(Pixel)/sizeof(unsigned long)) - 1)
#define FUNCMASK    ((sizeof(Function)/sizeof(int)) - 1)
#define STIPPLEMASK ((sizeof(Fillstyle)/sizeof(int)) - 1)

extern Bool doSegments,chgForeground,chgFunction,chgStipple,chgfgGC;
extern int chgAttributes,nAggregate;

/*
 generate connected sequence of diagonal lines
*/
int InitPrimLines(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i,size,nlines,n;
    int x,y,dx,dy,xl,xr,yb,yt;

    n = (nAggregate < p->objects) ? nAggregate : p->objects;
    if (n != 0) p->objects = (p->objects / n) * n; /* make multiple of 'n' */

    gc = xp->fggc;
    size = p->special;
    nlines = p->objects;
    if (doSegments) {
	segs = (XSegment *)malloc(nlines * sizeof(XSegment));
	endsegs = segs + nlines;
    }
    else {
	points = (XPoint *)malloc((nlines+1) * sizeof(XPoint));
	endpoints = points + nlines;
    }

    x = Width/2. + size;
    y = Height/2. - size;
    dx = dy = size;
    xl = dx;
    xr = Width - dx;
    yt = 2 * dy;
    yb = Height - 2 * dy;

    if (doSegments) {	/* generate segments */
	XSegment *seg;
	for (seg = segs; seg < endsegs; ++seg) {
	    seg->x1 = x;
	    seg->y1 = y;
	    if (x <= xl || x >= xr) dx = -dx;
	    if (y <= yt || y >= yb) dy = -dy;
	    x += dx;
	    y += dy;
	    seg->x2 = x;
	    seg->y2 = y;
	}
    }
    else {		/* generate lines */
	XPoint *pt;
	for (pt = points; pt <= endpoints; ++pt) {
	    pt->x = x;
	    pt->y = y;
	    if (x <= xl || x >= xr) dx = -dx;
	    if (y <= yt || y >= yb) dy = -dy;
	    x += dx;
	    y += dy;
	}
    }

/*
 create foreground color GCs
*/
    Pixel[0] = AllocateColor(xp->d,"red",xp->foreground);
    Pixel[1] = AllocateColor(xp->d,"green",xp->background);
    Pixel[2] = AllocateColor(xp->d,"blue",xp->foreground);
    Pixel[3] = AllocateColor(xp->d,"black",xp->background);

    if (chgfgGC) {
	for (i = 0; i < NGCS; i++) {	/* create GCs */
	    XGCValues gcv;
	    gcv.graphics_exposures = False;
	    gcv.background = xp->background;
	    gcv.foreground = Pixel[i];
	    gcs[i] = XCreateGC(xp->d, xp->w,
		GCForeground | GCBackground | GCGraphicsExposures, &gcv);
	}
	gc = gcs[0];
    }
    else if (chgStipple) {		/* create stipple */
	XGCValues gcv;
	static unsigned char bitmap10x10[] = {
	    0x12, 0x34, 0x56, 0x78, 0x12, 0x34, 0x56, 0x78,
	    0x12, 0x34, 0x56, 0x78, 0x12, 0x34, 0x56, 0x78
	};
	gcv.stipple = XCreateBitmapFromData(xp->d, xp->w, bitmap10x10, 10, 10);
	XChangeGC(xp->d,gc,GCStipple,&gcv);
    	XFreePixmap(xp->d, gcv.stipple);
    }

    return reps;

}

#define CHANGE_FG	gcv.foreground = Pixel[++count & PIXELMASK];\
			XChangeGC(d,gc,GCForeground,&gcv)

#define CHANGE_FGGC	gc = gcs[++count & GCMASK]

#define CHANGE_FUNC	gcv.function = Function[++count & FUNCMASK];\
			XChangeGC(d,gc,GCFunction,&gcv)

#define CHANGE_STIPPLE	gcv.fill_style = Fillstyle[++count & STIPPLEMASK];\
			XChangeGC(d,gc,GCFillStyle,&gcv)

void DoPrimLines(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i,n,count;
    XGCValues gcv;
    Display *d = xp->d;
    Window w = xp->w;

    n = (nAggregate < p->objects) ? nAggregate : p->objects;

    if (doSegments) {			/* draw as segments */
	XSegment *seg;
	if (n == 1) {
	    for (i = 0; i != reps; i++) {
		for (seg = segs; seg < endsegs; seg++)
		    XDrawSegments(d, w, gc, seg, 1);
		gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
	    }
	}
	else {
	    for (i = 0; i != reps; i++) {
		for (seg = segs; seg < endsegs; seg += n)
		    XDrawSegments(d, w, gc, seg, n);
		gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
	    }
	}
    }
    else if (nAggregate > 0) {	/* aggregate into groups of lines (XDrawLines)*/
	XPoint *pt;
	int n1 = n + 1;
	if (chgAttributes == 0) {
	    for (i = 0; i != reps; i++) {
		for (pt = points; pt < endpoints; pt += n)
		    XDrawLines(d, w, gc, pt, n1,CoordModeOrigin);
		gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
	    }
	}
	else if (chgAttributes == 1) {	/* change every group of lines */
	    for (i = 0; i != reps; i++) {
		count = i;
		if (chgForeground) {	/* change foreground via XChangeGC */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			CHANGE_FG;
		    }
		}
		else if (chgfgGC) {	/* change foreground via gc */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			CHANGE_FGGC;
		    }
		}
		else if (chgFunction) {	/* change function */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			CHANGE_FUNC;
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
		else if (chgStipple) {	/* change stipple */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			CHANGE_STIPPLE;
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
	    }
	}
	else {				/* change every 'n' group of lines */
	    for (i = 0; i != reps; i++) {
		int nchg = chgAttributes;
		count = i;
		if (chgForeground) {	/* change foreground via XChangeGC */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			if (--nchg == 0) {
			    CHANGE_FG;
			    nchg = chgAttributes;
			}
		    }
		}
		else if (chgfgGC) {	/* change foreground via gc */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			if (--nchg == 0) {
			    CHANGE_FGGC;
			    nchg = chgAttributes;
			}
		    }
		}
		else if (chgFunction) {	/* change function */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			if (--nchg == 0) {
			    CHANGE_FUNC;
			    nchg = chgAttributes;
			}
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
		else if (chgStipple) {	/* change stipple */
		    for (pt = points; pt < endpoints; pt += n) {
			XDrawLines(d, w, gc, pt, n1, CoordModeOrigin);
			if (--nchg == 0) {
			    CHANGE_STIPPLE;
			    nchg = chgAttributes;
			}
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
	    }
	}
    }
    else {			/* draw as individual lines (XDrawLine) */
	XPoint *pt;

	if (chgAttributes == 0) {		/* don't change attributes */
	    for (i = 0; i != reps; i++) {
		for (pt = points; pt < endpoints; ++pt)
		    XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
		gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
	    }
	}
	else if (chgAttributes == 1) {		/* change every primitive */
	    for (i = 0; i != reps; i++) {
		count = i;
		if (chgForeground) {		/* change fg via XChangeGC */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			CHANGE_FG;
		    }
		}
		else if (chgfgGC) {		/* change fg via gc */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			CHANGE_FGGC;
		    }
		}
		else if (chgFunction) {		/* change function */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			CHANGE_FUNC;
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
		else if (chgStipple) {		/* change stipple */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			CHANGE_STIPPLE;
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
	    }
	}
	else {				/* change every 'n' lines */
	    for (i = 0; i != reps; i++) {
		int nchg = chgAttributes;
		count = i;
		if (chgForeground) {	/* change fg via XChangeGC */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			if (--nchg == 0) {
			    CHANGE_FG;
			    nchg = chgAttributes;
			}
		    }
		}
		else if (chgfgGC) {	/* change fg via gc */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			if (--nchg == 0) {
			    CHANGE_FGGC;
			    nchg = chgAttributes;
			}
		    }
		}
		else if (chgFunction) {	/* change function */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			if (--nchg == 0) {
			    CHANGE_FUNC;
			    nchg = chgAttributes;
			}
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
		else if (chgStipple) {	/* change stipple */
		    for (pt = points; pt < endpoints; ++pt) {
			XDrawLine(d,w,gc,pt->x,pt->y,pt[1].x,pt[1].y);
			if (--nchg == 0) {
			    CHANGE_STIPPLE;
			    nchg = chgAttributes;
			}
		    }
		    gc = (gc == xp->bggc) ? xp->fggc : xp->bggc;
		}
	    }
	}
    }
}

void EndPrimLines(xp, p)
    XParms  xp;
    Parms   p;
{
    int i;

    if (doSegments) free(segs);
    else free(points);

    if (chgfgGC) {
	for (i = 0; i < NGCS; i++) XFreeGC(xp->d,gcs[i]);
    }
}
