/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

#include <math.h>
#include "x11perf.h"

/*
 horizontal, vertical, and diagonal line extension tests - 2.2.10.1
*/

typedef struct ptlist {
	struct ptlist *next;
	XPoint *points;
	int npts;
} Ptlist;

static Ptlist	*ptlroot;
static GC       pgc;
static void	setcapstyle();

extern int xOrg,yOrg,xStep,yStep;

/*
 initialize horizontal lines
 (generate groups of horizontal polylines)
*/
int InitHorizLines(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int size,x,y,x0,y0,nlines,npts;
    Ptlist *ptl,**ptlpp;
    XPoint *pt;

    pgc = xp->fggc;
    size = p->special;

    x0 = xOrg;
    y = y0 = yOrg;

    ptlpp = &ptlroot;

    for (nlines = p->objects + 1; nlines > 0; ) {
	ptl = (Ptlist *)malloc(sizeof(Ptlist));
	*ptlpp = ptl;
	ptlpp = &ptl->next;
	for (x = x0, npts = 0; x < Width; x += size) npts++;
	if (npts == 1) npts = 2;
	if (nlines < npts) npts = nlines + 1;
	nlines -= (npts - 1);
	ptl->npts = npts;
	pt = ptl->points = (XPoint *)malloc(sizeof(XPoint) * npts);
	for (x = x0; --npts >= 0; x += size) {
	    pt->x = x;
	    pt->y = y;
	    pt++;
	    
	}
	if ((y += yStep) >= Height) y = y0;
    }
    *ptlpp = NULL;

    setcapstyle(xp);
    
    return reps;
}
   
/*
 initialize vertical lines
 (generate groups of vertical polylines)
*/
int InitVertLines(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int size,x,y,x0,y0,nlines,npts;
    Ptlist *ptl,**ptlpp;
    XPoint *pt;

    pgc = xp->fggc;
    size = p->special;

    x = x0 = xOrg;
    y0 = yOrg;

    ptlpp = &ptlroot;

    for (nlines = p->objects + 1; nlines > 0; ) {
	ptl = (Ptlist *)malloc(sizeof(Ptlist));
	*ptlpp = ptl;
	ptlpp = &ptl->next;
	for (y = y0, npts = 0; y < Width; y += size) npts++;
	if (npts == 1) npts = 2;
	if (nlines < npts) npts = nlines + 1;
	nlines -= (npts - 1);
	ptl->npts = npts;
	pt = ptl->points = (XPoint *)malloc(sizeof(XPoint) * npts);
	for (y = y0; --npts >= 0; y += size) {
	    pt->x = x;
	    pt->y = y;
	    pt++;
	    
	}
	if ((x += xStep) >= Width) x = x0;
    }
    *ptlpp = NULL;

    setcapstyle(xp);
    
    return reps;
}

static void setcapstyle(xp)
    XParms  xp;
{

    XGCValues   gcv;

    gcv.cap_style = CapNotLast;	/* don't draw endpoint */
    XChangeGC(xp->d, xp->fggc, GCCapStyle, &gcv);
    XChangeGC(xp->d, xp->bggc, GCCapStyle, &gcv);
}
   
void DoHVLines(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i;
    Ptlist *ptl;

    for (i = 0; i != reps; i++) {
	for (ptl = ptlroot; ptl != NULL; ptl = ptl->next) {
	    XDrawLines(xp->d, xp->w, pgc, ptl->points, ptl->npts,
			CoordModeOrigin);
	}
	pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
    }
}

void EndHVLines(xp, p)
    XParms  xp;
    Parms p;
{
    Ptlist *ptl,*ptlnext;

    for (ptl = ptlroot; ptl != NULL; ptl = ptlnext) {
   	ptlnext = ptl->next;
	free(ptl->points);
	free(ptl);
    }
}
