/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 multi buffering tests 2.2.9
*/

#include <stdio.h>
#include "x11perf.h"
#include "multibuf.h"

static Pixmap	Pix;
static Multibuffer *Buffers;
static int nBuffers,code;

#define dprintf printf

int InitDoubleBuf(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    nBuffers = p->objects;
    code = p->special;

    switch (code) {
	case 1:			/* draw directly to window */
	    break;

	case 2:			/* draw to background pixmap, copy to window */
	    Pix = XCreatePixmap(xp->d,xp->w,Width,Height,
			DefaultDepth(xp->d,DefaultScreen(xp->d)));
	    XFillRectangle(xp->d,Pix,xp->bggc,0,0,Width,Height);
	    break;

	default: {		/* multibuffer */
#ifdef _3MAX
	    int major_opcode, first_event, first_error;
	    char *extension = MULTIBUF_PROTOCOL_NAME;

	    Buffers = (Multibuffer *)malloc(nBuffers * sizeof(Multibuffer));
	    if (XQueryExtension(xp->d, extension, &major_opcode, &first_event,
		&first_error) == False) {
		fprintf(stderr, "%s extension not supported by server\n", extension);
		return 0;
	    }
	    else if (XmbufCreateBuffers(xp->d,xp->w, nBuffers,
		    MultibufferActionBackground,MultibufferHintFrequent,
		    Buffers) != nBuffers) {
		fprintf(stderr, "can't create %d image buffers\n",nBuffers);
		return 0;
	    }
#endif
	    break;
	}
    }

    return reps;

}

void DoDoubleBuf(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i,bufnum,x,xleft,xright,y,ytop,ybottom;
    GC gc = xp->fggc;

    x = xleft = 1;
    y = ytop = 1;
    xright = Width - 10;
    ybottom = Height - 10;
    
    switch (code) {
	case 1:
	    for (i = 0; i <= reps; i++) {	/* draw directly to window */
		XClearWindow(xp->d,xp->w);
		XDrawLine(xp->d, xp->w, gc,
		       x,y,x + 10,y + 10, CoordModeOrigin);
		if (++x >= xright) x = xleft;
		if (++y >= ybottom) y = ytop;
	    }
	    break;

	case 2:
	    for (i = 0; i <= reps; i++) { /* draw to pixmap, copy to window */
		XFillRectangle(xp->d,Pix,xp->bggc,0,0,Width,Height);
		XDrawLine(xp->d, Pix, gc,
		       x,y,x + 10,y + 10, CoordModeOrigin);
		XCopyArea(xp->d,Pix,xp->w,gc,0,0,Width,Height,0,0);
		if (++x >= xright) x = xleft;
		if (++y >= ybottom) y = ytop;
	    }
	    break;

	default:
#ifdef _3MAX
	    for (i = 0; i <= reps; i++) {
		bufnum = i % nBuffers;
		XDrawLine(xp->d, Buffers[bufnum], gc,
		       x,y,x + 10,y + 10, CoordModeOrigin);
		XmbufDisplayBuffers(xp->d, 1, &Buffers[bufnum],0,0);
		if (++x >= xright) x = xleft;
		if (++y >= ybottom) y = ytop;
	    }
#endif
	    break;
    }
}

void EndDoubleBuf(xp, p)
    XParms  xp;
    Parms   p;
{
    if (code == 1) ;
    else if (code == 2) XFreePixmap(xp->d,Pix);
#ifdef _3MAX
    else {
	XmbufDestroyBuffers(xp->d,xp->w);
	free(Buffers);
    }
#endif
}
