/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 colormap extension tests - 2.2.4
*/

#include <stdio.h>
#include "x11perf.h"
#include <X11/Xutil.h>

static Colormap *cmap;
static XColor *colorcell_defs,*endcolorcell_defs;
static int ncolors,nmaps;

extern Bool cycleMaps;
extern int xStep,yStep,cycleDelay;
extern XRectangle Rect_;

static void generate_entries();

int InitColors(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i,j,nmatch,depth;
    Visual *visual;
    XVisualInfo vv,*visuallist;
    XColor *cp;

    ncolors = p->objects;
    nmaps = p->special;

#ifdef XXX
    vv.screen = DefaultScreen(xp->d);
    for (i = ncolors - 1, depth = 0; i != 0; i >>= 1) depth++;
    vv.colormap_size = 256;
    vv.depth = depth;
    vv.class = PseudoColor;
    vv.bits_per_rgb = 8;
    visuallist = XGetVisualInfo(xp->d,VisualScreenMask | VisualDepthMask
			| VisualColormapSizeMask | VisualClassMask
			| VisualBitsPerRGBMask,
		        &vv,&nmatch);
    if (nmatch == 0) {
	fprintf(stderr,"InitColors: no matching visuals found!\n");
	return 0;
    }
    visual = visuallist[0].visual;
    if (visual->map_entries < ncolors) {
	fprintf(stderr,"InitColors: matching visual colormap size (%d) too small!\n",visual->map_entries);
	return 0;
    }
#endif XXX

    if (XMatchVisualInfo(xp->d,DefaultScreen(xp->d),
		DefaultDepth(xp->d,DefaultScreen(xp->d)),
		PseudoColor,&vv) == 0) {
	fprintf(stderr,"InitColors: no matching visuals found!\n");
	return 0;
    }
    if (vv.colormap_size < ncolors) {
	fprintf(stderr,"InitColors: matching visual colormap size (%d) too small!\n",vv.colormap_size);
	return 0;
    }
    visual = vv.visual;

/*
 create separate static color maps to cycle
*/
    if (cycleMaps) {
/*
 create static color maps (set the color cells for the maps once)
*/
	cmap = (Colormap *)malloc(nmaps * sizeof(Colormap));
	colorcell_defs = (XColor *)malloc(ncolors * sizeof(XColor));

	for (i = 0; i < nmaps; i++) {
	    cmap[i] = XCreateColormap(xp->d,xp->w,visual,AllocAll);
	    generate_entries(colorcell_defs,ncolors,i);
	    XStoreColors(xp->d,cmap[i],colorcell_defs,ncolors);
	    XSetWindowColormap(xp->d,xp->w,cmap[i]);
	    XInstallColormap(xp->d,cmap[i]);
	}
    }
/*
 create single colormap, which will be dynamically changed
*/
    else {
	cmap = (Colormap *)malloc(sizeof(Colormap));
	cmap[0] = XCreateColormap(xp->d,xp->w,visual,AllocAll);
	colorcell_defs = (XColor *)malloc(nmaps * ncolors * sizeof(XColor));
	endcolorcell_defs = colorcell_defs + nmaps * ncolors;
	cp = colorcell_defs;
	for (i = 0; i < nmaps; i++) {
	    generate_entries(cp,ncolors,i);
	    cp += ncolors;
	}
	XStoreColors(xp->d,cmap[0],colorcell_defs,ncolors);
	XSetWindowColormap(xp->d,xp->w,cmap[0]);
	XInstallColormap(xp->d,cmap[0]);
    }

/*
 draw fllled rectangle for each color entry
*/
    {
	int x,y,dx,dy,width,height;
	XGCValues gcv;
	GC gc = xp->fggc;

	x = Rect_.x;
	y = Rect_.y;
	width = Rect_.width;
	height = Rect_.height;
	dx = width + xStep;
	dy = height + yStep;

	for (i = 0; i < ncolors; i++) {
	    gcv.foreground = i;
	    XChangeGC(xp->d,gc,GCForeground,&gcv);
	    XFillRectangle(xp->d,xp->w,gc,x,y,width,height);
	    if ((x += dx) >= Width) {
		x = Rect_.x;
		y += dy;
	    }
	}
    }
    return reps;
}

/*
 generate colormap entries
*/
static void generate_entries(cp,ncolors,mapnum)
XColor *cp;
int ncolors,mapnum;
{
    int i;

#define LOW_INTENSITY	(64 << 8)
#define MED_INTENSITY	(128 << 8)

    for (i = 0; i < ncolors; i++) {
	cp->pixel = i;
	cp->flags = DoRed | DoGreen | DoBlue;
	switch(mapnum % 3) {
	    case 0:
		cp->red = i << 8;
		cp->blue = LOW_INTENSITY;
		cp->green = MED_INTENSITY;
		break;
	    case 1:
		cp->red = MED_INTENSITY;
		cp->blue = i << 8;
		cp->green = LOW_INTENSITY;
		break;
	    case 2:
		cp->red = LOW_INTENSITY;
		cp->blue = MED_INTENSITY;
		cp->green = i << 8;
		break;
	}
	cp++;
    }
}

void DoColors(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int i,j;

    if (cycleMaps) {
	for (i = 0; i < reps; i++) {	/* cycle between color maps */
	    XInstallColormap(xp->d,cmap[i % nmaps]);
	    for (j = cycleDelay; j > 0; --j) ;
	}
    }
    else {				/* change colormap entries */
	XColor *cp = colorcell_defs;
	for (i = 0; i < reps; i++) {
	    XStoreColors(xp->d,cmap[0],cp,ncolors);
	    if ((cp += ncolors) == endcolorcell_defs) cp = colorcell_defs;
	    for (j = cycleDelay; j > 0; --j) ;
	}
    }
}

void EndColors(xp, p)
    XParms  xp;
    Parms   p;
{
    if (cycleMaps) {
	int i;
	for (i = 0; i < nmaps; i++)
	    XFreeColormap(xp->d,cmap[i]);
    }
    else {
	XFreeColormap(xp->d,cmap[0]);
    }
    free(cmap);
    free(colorcell_defs);
}
