/*****************************************************************************
Copyright 1988, 1989 by Digital Equipment Corporation, Maynard, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of Digital not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************************/

/*
 pixel alignment tests - 2.2.10.5-6
*/

#include "x11perf.h"

static XPoint	    *points,*endpoints;
static XRectangle   *rects;
static GC	    pgc;

extern XRectangle Rect_;
extern Bool doFill,doTriangles,doXscan;
extern int xStep,yStep;

/*
 initialize pixel alignment
*/
int InitAlign(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    int x,y,x0,y0,dx,dy;

    if (doTriangles) {		/* use right-aligned triangles */
	int npts,h,h1,w,w1;
	XPoint *pt;

	npts = p->objects * (doFill ? 3 : 4);
	points = (XPoint *)malloc(npts * sizeof(XPoint));
	endpoints = points + npts;

	x = x0 = Rect_.x;
	y = y0 = Rect_.y;
	w = Rect_.width;
	w1 = Rect_.width - 1;
	h = Rect_.height;
	h1 = Rect_.height - 1;
	dx = w + xStep;
	dy = h + yStep;

	for (pt = points; pt < endpoints; ) {
	    pt->x = x + w1;
	    pt->y = y;
	    ++pt;
	    pt->x = x + w1;
	    pt->y = y + h1;
	    ++pt;
	    pt->x = x;
	    pt->y = y + h1;
	    ++pt;
	    if (!doFill) {		/* draw to starting point */
		pt->x = x + w1;
		pt->y = y;
		++pt;
	    }
	    if (doXscan) {
		x += dx;
		if (x + w >= Width) {
		    x = x0;
		    y += dy;
		    if (y + h >= Height) y = y0;
		}
	     }
	    else {
		y += dy;
		if (y + h >= Height) {
		    y = y0;
		    x += dx;
		    if (x + w >= Width) x = x0;
		}
	    }
	}
    }
    else {			/* use rectangles */
	int h,w;
	XRectangle *r,*endr;

	rects = (XRectangle *)malloc(p->objects * sizeof(XRectangle));
	endr = rects + p->objects;

	x = x0 = Rect_.x;
	y = y0 = Rect_.y;
	w = Rect_.width;
	h = Rect_.height;
	dx = w + xStep;
	dy = h + yStep;

	for (r = rects; r < endr; r++) {
	    r->x = x;
	    r->y = y;
	    r->width = w;
	    r->height = h;
	    if (doXscan) {
		x += dx;
		if (x + w >= Width) {
		    x = x0;
		    y += dy;
		    if (y + h >= Height) y = y0;
		}
	     }
	    else {
		y += dy;
		if (y + h >= Height) {
		    y = y0;
		    x += dx;
		    if (x + w >= Width) x = x0;
		}
	    }
	}
    }

    pgc = xp->fggc;

    return reps;
}

void DoAlign(xp, p, reps)
    XParms  xp;
    Parms   p;
    int     reps;
{
    if (doTriangles) {		/* triangles */
	int     i;
	XPoint  *pt;
	for (i = 0; i != reps; i++) {
	    if (doFill) {	/* fill */
		for (pt = points; pt < endpoints; pt += 3) {
		    XFillPolygon(xp->d, xp->w, pgc, pt, 3,
				    Convex, CoordModeOrigin);
		}
	    }
	    else {		/* draw as lines */
		for (pt = points; pt < endpoints; pt += 4) {
		    XDrawLines(xp->d, xp->w, pgc, pt, 4, CoordModeOrigin);
		}
	    }
	    pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
	}
    }
    else {			/* rectangles */
	int i;
	for (i = 0; i != reps; i++) {
	    if (doFill)
		XFillRectangles(xp->d, xp->w, pgc, rects, p->objects);
	    else
		XDrawRectangles(xp->d, xp->w, pgc, rects, p->objects);
	    pgc = (pgc == xp->bggc) ? xp->fggc : xp->bggc;
	}
    }
}

void EndAlign(xp, p)
    XParms  xp;
    Parms p;
{
    if (doTriangles) free(points);
    else free(rects);
}
