/*
 * Try out the SVID message passing stuff
 *
 * Generates lots of error messages and stuff (i.e. not much of a test program).
 */

#include <stdio.h>

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/msg.h>

main()
{
    int msgkey = 0x132451;
    int trial;
    int i, rval, msqid[50];

    for ( trial = 0; trial < 50; trial += 1 ) {
	printf("trial = %d\n",trial);
	printf("getting key %08x\n",msgkey+trial);
	msqid[trial] = msgget(msgkey+trial, 0777);
	if ( msqid[trial] < 0 ) {
	    perror("msgget #1 failed");
	} else {
	printf("msqid[%d] #1 = %d\n",trial,msqid[trial]);
	}
	msqid[trial] = msgget(msgkey+trial, IPC_CREAT | 0777);
	if ( msqid[trial] < 0 ) {
	    perror("msgget #2 failed");
	}
	printf("msqid #2 = %d\n",msqid[trial]);
    }

    /*
     * Try to get rid of the critters (twice)
     */

    for ( trial = 0; trial < 50; trial += 1 ) {
	printf("trial = %d\n",trial);
	for ( i = 0; i < 2; i += 1 ) {
	    if ( (rval = msgctl(msqid[trial], IPC_RMID, NULL)) < 0 ) {
		perror("msgctl(IPC_RMID) failed");
	    }
	    printf("rval = %d from msgctl(IPC_RMID)\n",rval);
	}
    }
    exit(0);
}
