#@package: directory_stack pushd popd dirs

global TCLENV(dirPushList)

set TCLENV(dirPushList) ""

proc pushd {args} {
    global TCLENV

    if {[llength $args] > 1} {
        error "bad # args: pushd [dir_to_cd_to]"
    }
    set TCLENV(dirPushList) [linsert $TCLENV(dirPushList) 0 [pwd]]

    if {[llength $args] != 0} {
        cd [glob $args]
    }
}

proc popd {} {
    global TCLENV

    if [llength $TCLENV(dirPushList)] {
        cd [lvarpop TCLENV(dirPushList)]
        pwd
    } else {
        error "directory stack empty"
    }
}

proc dirs {} { 
    global TCLENV
    echo [pwd] $TCLENV(dirPushList)
}
