.TH "TclX" TCL "" "Tcl"
.ad b
'@index: tclx ExtendedTcl
.SH NAME
TclX - Extended Tcl - Extended command set for Tcl 6.1.
'
.SH "INTRODUCTION"
.PP
This man page contains the documentation for all of the extensions that are
added to Tcl 6.1 by Extended Tcl.  These extensions provide their
capabilities by adding new commands to Tcl whitout changing the syntax of
standard Tcl.  Extended Tcl is a superset of standard Tcl and is built with
the standard Tcl sources.
.TP
The command descriptions are separated into several sections:
.TP
o General Commands
.TP
o Unix Access Commands
.TP
o File I/O Commands
.TP
o File Scanning Commands
.TP
o Math Commands
.TP
o List Manipulation Commands
.TP
o Keyed Lists
.TP
o String and Character Manipulation Commands
'
.SH "GENERAL COMMANDS"
.PP
A set of general useful Tcl commands.  Includes interactive inputting of
commands, a facility for tracing execution and a looping command.
'
'@help: extended/commandloop
'@brief: Create an interactive command loop.
.TP
.B commandloop [\fIprompt\fR] [\fIprompt2\fR]
.br
Create an interactive command loop for the current TCL interpreter.  This
command receives commands from stdin and executes them.  This command is
useful for non-interactive TCL scripts that want to enter an interactive mode.
\fIPrompt\fR is a command string to set the top level prompt hook to
 to, the contents of which is executed to generate the main prompt.
\fIPrompt2\fR is a command string to set the down level prompt to, which is
generates the prompt command for continuation input.  When the command
terminates, the variables for the prompt hooks will be set to their old value.
If these arguments are not specified, the prompt hooks use their current
value.  Prompt hooks are TCL code that return as their result the prompt to
output.  The result of the last command executed in the command string (which
may be a \fBreturn\fR) will be outputted as the prompt.
'@endhelp
'@help: extended/cmdtrace
'@brief: Trace Tcl execution.
.TP
.B cmdtrace \fIlevel\fR|\fBon\fR [\fBnoeval\fR] [\fBnotruncate\fR] [\fBflush\fR] [\fIfilehandle\fR]
.br
Print a trace statement for all commands executed at depth of \fIlevel\fR or
below (1 is the top level).  If \fBon\fR is specified, all commands at any
level are traced.
If \fBnoeval\fR is specified, arguments are
printed unevaluated -- if it is not specified, the arguments are printed after
evaluation. If the command line is longer than 60 characters, it is truncated
to 60 and a "..." is postpended to indicate that there was more.  If
\fBnoeval\fR wasn't specified, the arguments are printed after evaluation.  In
this case, each argument is truncated to 40 characters (with "..." postpended 
if the argument was longer than 40 characters) and printed. If an evaluated 
argument contains a space, the entire argument will be enclosed inside of
braces (`{}') to allow the reader to visually separate the arguments from
each other. If \fBnotruncate\fR is specified, then the truncation of commands
and evaluated arguments will be disabled. If \fBflush\fR is specified, then
the output buffer will be flushed after each line is printed.  This is useful
when tracing code that cause an application to abort, making it easy to narrow
the problem down to the command that caused the abort. If \fIfilehandle\fR is
specified, then the trace output will be written to the file.
.TP
.B cmdtrace off
Turn off all tracing.
.TP
.B cmdtrace depth
.br
Returns the current maximum trace level, or zero if trace is disabled.
'@endhelp
'@help: extended/echo
'@brief: Echo one or more strings to stdout, followed by a newline.
.TP
.B echo \fIstr1\fR [\fIstr2..\fR]
.br
Print the strings to stdout followed by a newline.
'@endhelp
'@help: extended/infox
'@brief: Return information about extended Tcl or the current application.
.TP
.B infox \fIoption\fR
.br
Return information about extended Tcl or the current application.  
The following \fBinfox\fR command options are available.
.RS 5
.TP
.B version
Return the version number of Extended Tcl.  The version number for
extended Tcl is generated by combining the base version of the standard Tcl
code with a letter indicating the version of Extended Tcl being used.  This is
the documentation for version \fBtcl6.1a\fR.
.TP
.B patchlevel
Return the patchlevel for Extended Tcl.
.TP
.B appname
Return the symbolic application name of the current application linked with
the Extended Tcl library.  The C variable \fBtclAppName\fR must be set by the
application to return an application specific value for this variable.
.TP
.B applongname
Return a natural language name for the current application. The C variable
\fBtclLongAppName\fR must be set by the application to return an application
specific value for this variable.
.TP
.B appversion
Return the version number for the current application.  The C variable
\fBtclAppVersion\fR must be set by the application to return an application
specific value for this variable.
.RE
'@endhelp
'@help: extended/loop
'@brief: Higher-performance for-style loop.
.TP
.B loop \fIvar first last [increment] body\fR
.br
\fBLoop\fR is a looping command, similar in behavior to the Tcl \fBfor\fR
statement, except that the \fBloop\fR statement achieves substantially higher
performance and is easier to code when the beginning and ending values of a
loop are known and the loop variable is to be incremented by a known, fixed
amount every time through.
.sp
 The \fIvar\fR argument is the name of a Tcl variable that will contain the
loop index.  The loop index is first set to the value specified by
\fIfirst\fR.  The Tcl interpreter is invoked upon \fIbody\fR zero or more
times, where \fIvar\fR is incremented by \fIincrement\fR every time through
the loop, or by one if \fIincrement\fR is not specified.  \fIIncrement\fR can
be negative in which case the loop will count downwards.
.sp
When \fIvar\fR reaches \fIlast\fR, the loop terminates without a subsequent
execution of \fIbody\fR.  For instance, if the original \fBloop\fR parameters
would cause \fBloop\fR to terminate, say \fIfirst\fR was one, \fIlast\fR was
zero and \fIincrement\fR was not specified or was non-negative, \fIbody\fR is
not executed at all and \fBloop\fR returns.
.sp
If a \fBcontinue\fR command is invoked within \fIbody\fR then
any remaining commands in the current execution of \fIbody\fR are skipped,
as in the \fBfor\fR command.
If a \fBbreak\fR command is invoked
within \fIbody\fR
then the \fBloop\fR command will
return immediately.
\fBLoop\fR returns an empty string.
'@endhelp
'
.SH "UNIX ACCESS COMMANDS
.PP
These commands provide access to many basic Unix facilities, including process
handling, data and time, signal handling, linking and unlinking files,
changing file attributes, process and user attributes and the executing
commands via the shell.
'
'@help: extended/alarm
'@brief: Set a process alarm clock.
.TP
.B alarm \fIseconds\fR
.br
Instructs the system to send a SIGALRM signal in the specified number of
seconds.  If \fIseconds\fR is 0, any previous alarm request is canceled.
Only one alarm at a time may be active, the command returns the number of
seconds left in the previous alarm.
'@endhelp
'
'@help: extended/chgrp
'@brief: Change file group.
.TP
.B chgrp \fIgroup\fR \fIfilelist\fR
.br
Set group of each file in the list \fIfilelist\fR to \fIgroup\fR, which is a
group name or numeric group id.
'@endhelp
'@help: extended/chmod
'@brief: Set file permissions.
.TP
.B chmod [\fB-i\fR] \fImode\fR \fIfilelist\fR
.br
Set permissions of each of the files in the list \fIfilelist\fR to \fImode\fR,
which is an absolute numeric mode or symbolic permissions as in the
\fBchmod(C)\fR UNIX command.  Normally absolute modes are assumed to be
specified in octal.  However Tcl stores numbers internally as integers.  The
\fB-i\fR option causes an absolute mode to be treated as a standard Tcl
integer (decimal unless prefixed by "0" of "0x").
'@endhelp
'@help: extended/chown
'@brief: Change file owner and/or group.
.TP
.B chown \fIowner\fR|{\fIowner group\fR} \fIfilelist\fR
.br
Set owner of each file in the list \fIfilelist\fR to \fIowner\fR, which is a
owner name or numeric owner id.  If the first parameter is a list, then the
owner is set to the first element of the list and the group is set to the
second element of the list. \fIGroup\fR is a group name or numeric group id.
If \fIgroup\fR is {}, then the file group will be set to the group for the
associated the specified user.
'@endhelp
'@help: extended/execvp
'@brief: Perform a process exec, executing a file.
.TP
.B execvp \fIprog\fR [\fIarg1...argN\fR]
.br
Do an execvp, replacing the current program with \fIprog\fR and passing the
arguments \fIarg1...argN\fR. 
'@endhelp
'@help: extended/fmtclock
'@brief: Convert integer time to human-readable format.
.TP
.B fmtclock \fIclockval\fR [\fIformat\fR] [\fBGMT|{}\fR]
.br
Convert a value returned by \fBgetclock\fR or \fBfile\fR to human readable
form.  The \fIformat\fR argument is a string that describes how to format the
date and time.  Field descriptors consist of a ``%'' followed by a field
descriptor. All other characters are copied into the result.  The available
field descriptors are:
.sp
.nf
.ft CW
    %% - Insert a %.
    %a - Abbreviated weekday name.
    %A - Full weekday name
    %b - Abbreviated month name.
    %B - Full month name.
    %d - Day of month (01 - 31).
    %D - Date as %m/%d/%y.
    %e - Day of month (1-31), no leading zeros.
    %h - Abbreviated month name.
    %H - Hour (00 - 23).
    %I - Hour (00 - 12).
    %j - Day number of year (001 - 366).
    %m - Month number (01 - 12).
    %M - Minute (00 - 59).
    %n - Insert a new line.
    %p - AM or PM.
    %r - Time as %I:%M:%S %p.
    %R - Time as %H:%M.
    %S - Seconds (00 - 59).
    %t - Insert a tab.
    %T - Time as %H:%M:%S.
    %U - Week number of year (01 - 52), Sunday is the first 
         day of the week.
    %w - Weekday number (Sunday = 0).
    %W - Week number of year (01 - 52), Monday is the first 
         day of the week.
    %x - Local specific date format.
    %X - Local specific time format.
    %y - Year within century (00 - 99).
    %Y - Year as ccyy (e.g. 1990)
    %Z - Time zone name.
.fi
.ft R
.sp
If format is not specified, "%a %b %d %H:%M:%S %Z %Y" is used.  If \fBGMT\fR
is specified, the time will be formated as Greenwich Mean Time. If the
argument is not specified or is empty, then the local timezone will be used as
defined by the timezone environment variable.
'@endhelp
'@help: extended/fork
'@brief: Fork the current Tcl process.
.TP
.B fork
.br
Fork the current TCL process.  Fork returns zero to the child process and the
process number of the child to the parent process.  If an \fBexecvp\fR is not
going to be performed before the forked process does output, then a
\fBflush\fR should be issued against \fBstdout\fR, \fBstderr\fR and any other
open output file before doing the \fBfork\fR.  Otherwise, output from the
parent process pending in the buffers will also be outputted by the child
process.
'@endhelp
'@help: extended/getclock
'@brief: Return current date and time as an integer value.
.TP
.B getclock
.br
Return the current date and time as a system dependent integer value.  The
unit of the value is seconds, allowing it to be used for relative time
calculations and so forth.
'@endhelp
'@help: extended/id
'@brief: Access, set or convert process, user and group information.
.TP
.B id options
.br
This command provides a means of getting, setting and converting user, group
and process ids.  The following versions of the \fBid\fR command are available:
'
.RS 5
.TP
.B id user \fR[\fIname\fR]
.TP
.B id userid \fR[\fIuid\fR]
Set the real and effective user ID to \fIname\fR or \fIuid\fR, if the
name (or uid) is valid and permissions allow it.  If the name (or uid)
is not specified, the current name (or uid) is returned.
.TP
.B id convert userid \fIuid\fR
.TP
.B id convert user \fIname\fR
Convert a user ID number to a user name, or vice versa.
.TP
.B id group \fR[\fIname\fR]
.TP
.B id groupid \fR[\fIgid\fR]
Set the real and effective group ID to \fIname\fR or \fIgid\fR, if the
name (or gid) is valid and permissions allow it.  If the group name
(or gid) is not specified, the current group name (or gid) is returned.
.TP
.B id convert groupid \fIgid\fR
.TP
.B id convert group \fIname\fR
Convert a group ID number to a group name, or vice versa.
.TP
.B id effective user
.TP
.B id effective userid
Return the effective user name, or effective user ID number, respectively.
.TP
.B id effective group
.TP
.B id effective groupid
Return the effective group name, or effective group ID number, respectively.
.TP
.B id process
.br
Return the process ID of the current process.
.TP
.B id process parent
.br
Return the process ID of the parent of the current process.
.TP
.B id process group
.br
Return the process group ID of the current process.
.TP
.B id process group set
.br
Set the process group ID of the current process to its process ID.
.RE
'@endhelp
'
'@help: extended/kill
'@brief: Send a signal to the specified process.
.TP
.B kill [\fIsignal\fR] \fIprocesslist\fR
.br
Send a signal to the each process in the list \fIprocesslist\fR, if permitted.
\fISignal\fR, if present, is the signal number or the symbolic name of the
signal, see the signal system call manual page.  The leading "SIG" is optional
when the signal is specified by its symbolic name.
.PP
The default for \fIsigno\fR is 15, SIGTERM.
'@endhelp
'@help: extended/link
'@brief: Make a link to a file.
.TP
.B link \fIsrcpath destpath\fR
.br
Create a directory entry, \fIdestpath\fR, linking it to the existing file,
\fIsrcpath\fR.
'@endhelp
'@help: extended/mkdir
'@brief: Create a new directory
.TP
.B mkdir [-path] \fIdirList\fR
.br
Create each of the directories in the list \fIdirList\fR.  The mode on the
new directories is 777, modified by the umask.  If \fB-path\fR is specified,
then any non-existent parent directories in the specified path are also
created.
'@endhelp
'@help: extended/rmdir
'@brief: Remove directories
.TP
.B rmdir \fIdirList\fR
.br
Remove each of the directories in the list \fIdirList\fR.
'@endhelp
'@help: extended/signal
'@brief: Specify action to take when a signal is received.
.TP
.B signal \fIaction\fR \fIsiglist\fR [\fIcommand\fR]
.br
Specify the action to take when a Unix signal occurs. \fISiglist\fR is a list
of either the symbolic or numeric Unix signal (the SIG prefix is optional).
\fIAction\fR is one of the following actions to be performed on receipt of the
signal.
.IP
\fBdefault\fR - Terminate the process
.IP
\fBignore\fR - Ignore the signal.
.IP
\fBerror\fR - Generate a catchable Tcl error.  It will be as if the command
that was running returned an error.  The error code will be in the form:
.br
    {\fBUNIX SIG\fR \fIsigname\fR}
.br
For the death of child signal, \fIsigname\fR will always be SIGCHLD, rather
than SIGCLD, to allow writting protable code.
.IP
\fBtrap\fR - When the signal occures, execute \fIcommand\fR and continue
execution if an error is not returned by \fIcommand\fR.  If will be executed
in the global context and the symbolic signal name (e.g. SIGINT) will be
supplied in a global variable \fBsignalRecieved\fR.  If an error is returned,
then follow the standard Tcl error mechanism.  Often \fIcommand\fR will just
do an \fBexit\fR.
.IP
\fBget\fR - Retrieve the current settings of the specified signals.  A list
will be returned with each element containing one of `\fBdefault\fR',
`\fBignore\fR', `\fBerror\fR' or `\fBtrap\fR' corresponding to each signal in
\fIsiglist\fR.
.sp
For all signals except \fBSIGCLD\fR, the signal action will remain enabled
after the specified signal has occured.  For \fBSIGCLD\fR (also known as
\fBSIGCHLD\fR), the signal will not be automatically reenable. A wait must be
performed before issuing another \fBsignal\fR command.  Signals are not
processed until after the completion of the Tcl command that is executing when
the signal is recieved.
'@endhelp
'@help: extended/sleep
'@brief: Sleep Tcl for the specified number of seconds.
.TP
.B sleep \fIseconds\fR
.br
Sleep the TCL process for \fIseconds\fR.
'@endhelp
'@help: extended/system
'@brief: Execute command via `system' call.
.TP
.B system \fIcommand\fR
.br
Executes \fIcommand\fR via the system(3) call.  Differs from \fBexec\fR
because \fBsystem\fR doesn't return stdout as the result or the command and
\fBsystem\fR goes through the shell to provide wildcard
expansion, redirection, etc,
as is normal from a \fBsh\fR command line.  Returns the exit code of
the command.
'@endhelp
'@help: extended/times
'@brief: Get process and child execution times.
.TP
.B times
Return a list containing the process and child execution times in the form:
.br
    \fIutime stime cutime cstime\fR
.br
See times system call manual page.  The values are in milliseconds.
'@endhelp
'@help: extended/umask
'@brief: Get or set the file-creation mode mask.
.TP
.B umask [\fIoctalmask\fR]
.br
Sets file-creation mode mask to the octal value of \fIoctalmask\fR.
If \fIoctalmask\fR is omitted, the current mask is returned.
'@endhelp
'@help: extended/unlink
'@brief: Delete (unlink) files.
.TP
.B unlink \fIfilelist\fR
.br
Delete (unlink) the files whose names are in the list \fIfilelist\fR.
'@endhelp
'@help: extended/wait
'@brief: Wait for a child process to terminate.
.TP
.B wait \fIproclist\fR
.br
Waits for an any of the immediate child processes specified in the list
\fIproclist\fR to terminate or a signal to be received.  \fBWait\fR returns a
list of three elements: The first element is process id of the terminating
process. If the process exited normally, the second element is `EXIT',
followed by the error code.  If the process terminated because of a signal,
the second element is `SIG', followed by the signal name.  If the process is
currently stopped, the second element is `STOP', followed by the signal name.
'@endhelp
'
.SH "FILE I/O COMMANDS"
.PP      
The commands extend the stdio-style file I/O capabilities present in Tcl 6.1.
These extensions include searching ASCII-sorted data files, copying files,
duplicating file descriptors, control of file access options, retrieving open
file status, and creating pipes with the \fBpipe\fR system call. A interface
to the \fBselect\fR system call is also available on Unix systems that support
it.
.PP
It should be noted that Tcl file I/O is implemented on top of the stdio 
library.  By default, the file is buffered, when communicating to a process
through a pipe, a \fBflush\fR command should be issued to force the data
out.  Alternatively, the \fBfcntl\fR command may be used to set the buffering
mode to line buffered or unbuffered.
'@help: extended/bsearch
.TP
.B bsearch \fIfilehandle key\fR [\fIretvar\fR] [\fIcompare_proc\fR]
.br
Search an opened sorted data file, \fIfilehandle\fR, for a line
matching \fIkey\fR. If \fIretvar\fR is specified, then the line from the
file is returned in \fIretvar\fR and the command returns \fB1\fR if \fIkey\fR
was found, and \fB0\fR if it was not found.  If \fIretvar\fR is not specified
or is a null name, then the command returns the line that was found, or an
empty string if \fIkey\fR is not found.
.sp
By default, the key is matched against the first white-space seperated field
in each line.  The field is treated as an ASCII string.  If \fIcompare_proc\fR
is specified, then it is the name of a Tcl procedure to evaluate against each
line read from the file.  This \fIcompare_proc\fR takes two arguments, the key
and a line extracted from the file.  The compare routine should return a
number less than zero if the key is less than the line, zero if the key
matches the line or greater than zero if the key is greater than the line.
The file must be sorted in assending order by whatever criteria
\fIcompare_proc\fR uses to compare the key with the line.
'@endhelp
'@help: extended/copyfile
'@brief: Copy remainder of one open file into another.
.TP
.B copyfile \fIhandle1 handle2\fR
.br
Copies the rest of file specified by \fIhandle1\fR from its current position
to the file specified by \fIhandle2\fR.
'@endhelp
'@help: extended/dup
'@brief: Duplicate an open filehandle.
.TP
.B dup \fIfilehandle\fR [\fIstdhandle\fR]
.br
Duplicate an open file.  A file handle is created that addresses the
same file as \fIfilehandle\fR.
.sp
A special case is allowed for dup-ing files to stdin, stdout or stderr.
If \fIstdhandle\fR is specified, then it must be one of the
standard handles to dup \fIfilehandle\fR to.  
.sp
.nf
.ftCW
    proc ChildProcess {cmd inPipe outPipe} {
        if {[set childPid [fork]] == 0} {
            close stdin
            dup $inPipe stdin
            close $inPipe

            close stdout
            dup $outPipe stdout
            close $outPipe

            execvp $cmd
            # will never make it here...
        }
        return $childPid
    }
.ftR
.fi
'@endhelp
'@help: extended/fcntl
'@brief: Get or set open file access options.
.TP
.B fcntl \fIhandle\fR [\fIattribute value\fR] 
.br
This command either returns a list of various boolean attributes controlling
access to a file or set or clears one of the boolean attributes.  If
\fIattribute\fR and \fIvalue\fR are not specified, then the list of the 
attributes that are set are return. If an attribute is not set, then it will
not be included in the list.  The following attributes maybe returned:
.IP
\fBRDONLY\fR - The file is opened for reading only.
.sp
\fBWRONLY\fR - The file is opened for writing only.
.sp
\fBRDWR\fR - The file is opened for reading and writing.
.sp
\fBAPPEND\fR - The file is opened for append only writes.  All writes will
be forced to the end of the file.
.sp
\fBNDELAY\fR - The file is to be accessed with non-blocking I/O.  See the
\fBread\fR system call for a description of how it affects the behaviour of
file reads
.sp
\fBCLEXEC\fR - Close the file on an process exec.  If the \fBexecvp\fR
command or some other mechanism causes the process to exec, the file will
be closed.
.sp
\fBNOBUF\fR - The file is not buffered. If set, then there no stdio buffering
for the file.
.sp
\fBLINEBUF\fR - Output the file will be line buffered. The buffer will
be flushed when a newline is written, when the buffer is full,
or when input is requested.
.sp
The \fBAPPEND\fR, \fBNDELAY\fR, and \fBCLEXEC\fR attributes may be set or
cleared by specifying the attribute name and a value \fB1\fR to set the
attribute and \fB0\fR to clear it.
.sp
The \fBNOBUF\fR and \fBLINEBUF\fR attributes may only be set (a value of
\fB1\fR) and only one of the options may be set.  Once set, they may not be
cleared. Thees option should be set before any I/O operations have been done
on the file.
'@endhelp
'
'@help: extended/fstat
'@brief: Obtain status information about a open file.
.TP
.B fstat \fIhandle\fR [\fIarrayvar\fR]
.br
Obtain the status of an open file.  This differs from the \fBfile stat\fR
command in that it takes a file handle rather than a file name.
If \fIarrayvar\fR is
specified, the status information is returned in the following elements of
this array variable: \fBatime\fR, \fBctime\fR, \fBdev\fR, \fBgid\fR, 
\fBino\fR, \fBmode\fR, \fBmtime\fR, \fBnlink\fR, \fBsize\fR, \fBuid\fR.
Each element is a decimal string with the value of the corresponding
field from the \fBstat\fR return structure; see the manual entry
for \fBstat\fR for details on the meanings of the values.  If \fIarrayvar\fR
is not specified, then the information is returned as a keyed list.  Each
element of the list is itself a list with the status value name paired with its
value, in alphabetical order.  For example:
.sp 1
.IP
{atime\ 683617279} {ctime\ 683617310} {dev\ 298} {gid\ 50} {ino\ 6317}
{mode\ 33152} {mtime\ 683617310} {nlink\ 1} {size\ 924} {uid\ 200}
'@endhelp
'
'@help: extended/pipe
'@brief: Create a pipe.
.TP
.B pipe [\fIhandle_var_r handle_var_w\fR]
.br
Create a pipe (see the pipe system call manual page).  If \fIhandle_var_r\fR
and \fIhandle_var_r\fR are specified, then variable \fIhandle_var_r\fR will
contain the handle opened for reading and \fIhandle_var_w\fR will contain the
handle opened for writing.  If the handle variables are not specified, then a
list containing the read followed by the write handle is returned as the
result of the command.
'@endhelp
'@help: extended/select
'@brief: Synchronous I/O multiplexing.
.TP
.B select \fIreadhandles\fR [\fIwritehandles\fR] [\fIexcepthandles\fR] [\fItimeout\fR]
.br
This command allows polling or blocking on multiple files being ready for
for reading, are ready for writing, or have an exceptional condition pending.
\fIreadhandles\fR, \fIwritehandles\fR, \fIexcepthandles\fR are each lists
of file handles (as returned from \fBopen\fR) to query.  An empty list ({}) may
be specified if a category is not used. 
.sp
The \fIreadhandles\fR files are checked to set if data is available for
reading. The \fIwritehandles\fR are checked if they are clear for writing The
\fIexcepthandles\fR are checked to see if an exceptional condition has
occured.  The write and exception checking is most useful on devices, however,
the read checking is also very valuable when communicating with multiple
processes through pipes.
.sp
\fITimeout\fR is a floating point timeout number of seconds.  If an empty
list is supplied (or the parameter is omitted), then no timeout is set.  If
the value is zero, then the \fBselect\fR command functions as a poll of the
files.
.sp
If the \fItimeout\fR period expires with none of the files becomming ready,
then the command returns an empty list.  Otherwise the command returns a 
list of three elements, each of those elements is a list of the file handles
that are ready in the read, write and exception classes.  If none are ready in
a class, then that element will be the null list.  For example:
.nf
    select {file3 file4 file5} {file6 file7} {} 10.5

could return
   {file3 file4} {file6} {}
or perhaps
   file3 {} {}
.fi
.sp
'@endhelp
'
.SH "FILE SCANNING COMMANDS"
.PP
These commands provide a facility to scan files, matching lines of the file
against regular expressions and executing Tcl code on a match.  With this
facility you can use Tcl to do the sort of file processing
that are traditionally done with \fBawk\fR.  And since Tcl's approach is more
declarative, some of the scripts that are really hard to write in awk are a
snap in Tcl.
.PP
File scanning in Tcl centers around the concept of a \fIscan context\fR.
A scan context contains one or more match statements, which associate
regular expressions to scan for with Tcl code to be executed when the
expressions are matched.
'
'@help: extended/scancontext
'@brief: Manage file scan contexts.
.TP
.B scancontext [\fIoption\fR]
.br
This command manages file scan contexts.  A scan context is a collection of
regular expressions and commands to execute when that regular expression
matches a line of the file.  A context may also have a single default match,
to be applied against lines that do not match any of the regular expressions.
Multiple scan contexts may be defined and the may be reused on multiple files.
A scan context is identified by a context handle.  The \fBscancontext\fR
command takes
the following forms:
.TP
.B scancontext create
Create a new scan context.  The \fBscanmatch\fR command is used to define
patterns in the context.
'
.TP
.B scancontext delete \fIcontexthandle\fR
.br
Delete the scan context identified by \fIcontexthandle\fR and free all the
match statements and compiled regular expressions associated with the
specified context.
'@endhelp
'@help: extended/scanfile
'@brief: Scan a file, executing match code when their patterns are matched.
.TP
.B scanfile \fIcontexthandle\fR \fIfilehandle\fR
.br
Scan the file specified by \fIfilehandle\fR, starting at the
current file position.  Check all patterns in the scan context specified by
\fIcontexthandle\fR against
it, executing the match commands corresponding to patterns matched.
'@endhelp
'@help: extended/scanmatch
'@brief: Specify tcl code to execute when scanfile pattern is matched.
.TP
.B scanmatch [\fB-nocase\fR] \fIcontexthandle\fR [\fIregexp\fR] \fIcommands\fR
.br
Specify Tcl \fIcommands\fR, to be evaluated when \fIregexp\fR is matched by a
\fBscanfile\fR command.  The match is added to the scan context specified by
\fIcontexthandle\fR.  Several match statements may be
specified for a give context.  \fIRegexp\fR is a regular expression (see the
\fBregexp\fR command).  If \fB-nocase\fR is specified as the first argument,
the pattern is matched regardless of
alphabetic case.
.sp
If \fIregexp\fR is not specified, then a default match is
specified for the scan context.  The default match will be executed when a
line of the file does not match any of the specified regular expressions.
.sp
The array, \fBmatchInfo\fR, is available when the Tcl code is executed and
contains information about the file being scanned.  It is local to the top
level of the match command unless declared global at that level.  If it is to
be used as a global it \fImust\fR be declared global before \fBscanfile\fR is
called (since \fBscanfile\fR sets the \fBmatchInfo\fR before the match code is
executed, a subsequent \fBglobal\fR will override the local variable).  The
text of the file line that was matched is in \fBmatchInfo(line)\fR.  The byte
offset into the file of the line that was matched is in
\fBmatchInfo(offset)\fR.  The line number of the line that was matched is in
\fBmatchInfo(linenum)\fR. This is relative to the first line scanned, not the
first line of the file.  The first line is line number one.  The file handle
of the file being scanned is in \fBmatchInfo(handle)\fR.
.PP
All \fBscanmatch\fR patterns that match a line will be processed in the order
that the specifications were added to the scan context.  The remainder of the
\fBscanmatch\fR pattern-command pairs may be skipped for a file line if a
\fBcontinue\fR is executed in the match command.  If a \fBreturn\fR is
executed in the body of the match command, the \fBscanfile\fR command in
progress returns with the value passed to \fBreturn\fR as it's value.
'@endhelp
'
.SH "MATH COMMANDS"
.PP
These commands make many additonal math functions available in Tcl, including
min, max, trig functions, exponent, logarithm, square root, and more.  An
integer random number generator is provided as well.
'@help: extended/acos
'@brief: Return the arccosine of a number.
.TP
.B acos \fInum\fR
.br
Returns the arccosine of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/asin
'@brief: Return the arcsin of a number.
.TP
.B asin \fInum\fR
.br
Returns the arcsin of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/atan
'@brief: Return the arctangent of a number..
.TP
.B atan \fInum\fR
.br
Returns the arctangent of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/ceil
'@brief: Return the smallest integer not less than a floating point number.
.TP
.B ceil \fInum\fR
.br
Returns the smallest integer not less than \fInum\fR (floating point).
'@endhelp
'@help: extended/cos
'@brief: Return the cosine of a number.
.TP
.B cos \fInum\fR
.br
Returns the cosine of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/cosh
'@brief: Return the hyperbolic cosine of a number.
.TP
.B cosh \fInum\fR
.br
Returns the hyperbolic cosine of \fInum\fR.
'@endhelp
'@help: extended/exp
'@brief: Return e to the power of a number.
.TP
.B exp \fInum\fR
.br
Returns \fIe\fR to the power of \fInum\fR.
'@endhelp
'@help: extended/fabs
'@brief: Return the absolute value of the floating point number.
.TP
.B fabs \fInum\fR
.br
Returns the absolute value of \fInum\fR (floating point).
'@endhelp
'@help: extended/floor
'@brief: Return the largest integer not greater than a floating point number.
.TP
.B floor \fInum\fR
.br
Returns the largest integer not greater than \fInum\fR (floating point).
'@endhelp
'@help: extended/fmod
'@brief: Perform a floating point modulus operation.
.TP
.B fmod \fInum1\fR \fInum2\fR
.br
Returns \fInum1\fR modulo \fInum2\fR.
'@endhelp
'@help: extended/max
'@brief: Return the argument that has the highest numeric value.
.TP
.B max \fInum1 num2\fR [..\fInumN\fR]
.br
Returns the argument that has the highest numeric value. The arguments,
\fInumN\fR may be any interger or floating point values.
'@endhelp
'@help: extended/min
'@brief: Return the argument that has the lowest numeric value.
.TP
.B min \fInum1 num2\fR [..\fInumN\fR]
.br
Returns the argument that has the lowest numeric value. The arguments,
\fInumN\fR may be any interger or floating point values.
'@endhelp
'@help: extended/log
'@brief: Return the natural logarithm of a number.
.TP
.B log \fInum\fR
.br
Returns the natural logarithm of \fInum\fR.
'@endhelp
'@help: extended/log10
'@brief: Return the logarithm base 10 of a number.
.TP
.B log10 \fInum\fR
.br
Returns the logarithm base 10 of \fInum\fR.
'@endhelp
'@help: extended/pow
'@brief: Return a number to the power of another number.
.TP
.B pow \fInum1\fR \fInum2\fR
.br
Returns \fInum1\fR to the power of \fInum2\fR.
'@endhelp
'@help: extended/random
'@brief: Return a pseudorandom integer or set the seed.
.TP
.B random \fBlimit\fR | \fBseed\fR [\fIseedval\fR]
.br
Generate a pseudorandom integer number greater than or equal to zero and
less than \fIlimit\fR.  If \fBseed\fR is specified, then the command
resets the random number generator to a starting point derived from 
the \fBseedval\fR. This allows one to reproduce a random number sequence
for testing purposes.
If \fIseedval\fR is omitted, then the seed is set to a value based on current
system state and the current time, providing a reasonably interesting and
ever-changing seed.
'@endhelp
'@help: extended/sin
'@brief: Return the sin of a number.
.TP
.B sin \fInum\fR
.br
Returns the sin of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/tan
'@brief: Return the tangent of a number.
.TP
.B tan \fInum\fR
.br
Returns the tangent of \fInum\fR.  \fInum\fR is in radians.
'@endhelp
'@help: extended/sinh
'@brief: Return the hyperbolic sin of a number.
.TP
.B sinh \fInum\fR
.br
Returns the hyperbolic sin of \fInum\fR.
'@endhelp
'@help: extended/sqrt
'@brief: Return the square root of a number.
.TP
.B sqrt \fInum\fR
.br
Returns the square root of \fInum\fR.
'@endhelp
'@help: extended/tanh
'@brief: Return the hyperbolic tangent of a number.
.TP
.B tanh \fInum\fR
.br
Returns the hyperbolic tangent of \fInum\fR.
'@endhelp
'
.SH "LIST MANINIPULATION COMMANDS"
.PP
Extended Tcl provides two additional list manipulation commands.
'@help: extended/lempty
'@brief: Determine if a list is empty. 
.TP
.B lempty \fIlist\fR
.br
Determine if the specified list is empty.
If empty, 1 is returned, otherwise, 0 is returned.  This command is an
alternative to comparing a list to an empty string.
'@endhelp
'
'@help: extended/lvarpop
'@brief: Pop or replace the specified element from a list.
.TP
.B lvarpop \fIvar\fR [\fIindex\fR \fR[\fIstring\fR]]
.br
The \fBlvarpop\fR command pops (deletes) the element indexed by
\fIindex\fR from the list in the variable \fIvar\fR.
If \fIindex\fR is omitted, then 0 is assumed.
If \fIstring\fR, is specified, then the deleted element is replaced by 
\fIstring\fR. The replaced or deleted element is returned.
Thus ``lvarpop argv 0'' returns the first element and sets argv to contain the
remainder of the string.
'@endhelp
'
'@help: extended/keyedlists
'@brief: Introduction to keyed lists
.SH "KEYED LISTS"
.PP
Extended Tcl defines a special type of list referred to as a \fIkeyed list\fR.
These lists provided a structured data type built upon standard Tcl lists.
This provides a functionality similar to \fBstruct\fRs in the C 
programming language.
A keyed list is a list in which each element consists of a key and value 
pair.
These element pairs are stored as lists themselves, where the key is the first
element of the list, and the value is the second.  The key-value pairs are
refered to as \fIfields\fR.
Here is an example of a keyed list:
.IP
    {{NAME {Frank Zappa}} {JOB {musician and composer}}
'
.PP
If the variable \fBperson\rR contained the above list, then
\fBkeylget person NAME\fR would return \fB{Frank Zappa}\fR.
Executing \fBkeylset person ID 106\fR would make \fBperson\fR
contain 
.IP
    {{ID 106} {NAME {Frank Zappa}} {JOB {musician and composer}}
.PP
By convention, `.' is a field name separator, allowing nesting of fields,
even though keyed list are only one level deep.  Currently none of the commands
explictly function on nested field names, but they may in a future release,
so `.' should not be used for other than a field separator in a name.  For
example:
.IP
    {{ID 106} {NAME.FIRST Frank} {NAME.LAST Zappa}}
.PP
All key list functions take the name of the variable containing the keyed list
as an argument (i.e. passed by reference) rather than the value.
'@endhelp
'@help: extended/keyldel
'@brief: Delete a field of a keyed list.
.TP
.B keyldel \fIlistvar\fR \fIkey\fR
.br
Delete the field specified by \fIkey\fR from the keyed list in the
variable \fIlistvar\fR.  This removes both the key and the value from
the keyed list.
'@endhelp
'@help: extended/keylget
'@brief: Get the value of a field of a keyed list.
.TP
.B keylget \fIlistvar\fR \fIkey\fR [\fIretvar\fR | {}]
.br
Return the value associated with the \fIkey\fR out of keyed list in the
variable \fIlistvar\fR.  If \fIretvar\fR is not specified, then the value will
be returned as the result of the command.  If \fIkey\fR is not found in the
list, an error will result.  If \fIretvar\fR is specified and \fIkey\fR is in
the list, then the value is returned in the variable \fIretvar\fR and the
command returns one. 
If \fIkey\fR is not in the list, the command will return \fB0\fR
and \fIretvar\fR will be unchanged.  If \fB{}\fR is specified for
\fIretvar\fR, the value is not returned, only the presence of the key is
determined.
'@endhelp
'
'@help: extended/keylset
'@brief: Set the value of a field of a keyed list.
.TP
.B keylset \fIlistvar\fR \fIkey\fR \fIvalue\fR
.br
Set the value associated with the \fIkey\fR in the keyed list in the
variable \fIlistvar\fR  to \fIvalue\fR.
If \fRlistvar\fR does not exists, it is created.  If \fIkey\fR
is not currently in the list, it will be added.  If it already exists, 
\fIvalue\fR overrides the existing value.
'@endhelp
'
.SH "STRING AND CHARACTER MANIPULATION COMMANDS"
.PP
The commands provide additional functionality to classify characters, convert
characters between character and numeric values, and index into a string,
determine the length of a string, extract a range of character from a string,
replicate a string a number of times, and transliterate a string (similar to
the \fItr\fR command).
'
'@help: extended/cindex
'@brief: Return indexed character from string.
.TP
.B cindex \fIstring index\fR
.br
Returns the character indexed by \fIindex\fR (zero based) from \fIstring\fR.
This command is a shortcut for:
.nf
.ft CW
    \fBstring index\fR \fIstring index\fR
.ft R
.fi
'@endhelp
'@help: extended/clength
'@brief: Return length of specified string.
.TP
.B clength \fIstring\fR
.br
Returns the length of \fIstring\fR in characters.  
This command is a shortcut for:
.nf
.ft CW
    \fBstring length\fR \fIstring\fR
.ft R
.fi
'@endhelp
'@help: extended/crange
'@brief: Return range of characters from string.
.TP
.B crange \fIstring first last\fR
.br
Returns a range of characters from \fIstring\fR starting at \fIfirst\fR
(zero-based) until \fIlast\fR.  The special keyword \fBend\fR may be specified
for \fIlast\fR to indicate that the remainder of the string is to be 
extracted.  This command is a short cut for:
.nf
.ft CW
    \fBstring range\fR \fIstring first last\fR
.ft R
.fi
'@endhelp
'@help: extended/csubstr
'@brief: Return a substring from within a string.
.TP
.B csubstr \fIstring first length\fR
.br
Returns a range of characters from \fIstring\fR starting at \fIfirst\fR 
(zero-based) for \fIlength\fR characters.
The special keyword \fBend\fR may be specified
for \fIlength\fR to indicate that the remainder of the string is to be 
extracted.  This command is a short cut for:
.nf
.ft CW
    \fBstring range\fR \fIstring first\fR [\fBexpr\fR \fIlength\fB-1\fR]
.ft R
.fi
'@endhelp
'@help: extended/ctype
'@brief: Determine if string has various characteristics.
.TP
.B ctype \fIclass string\fR 
.br
Determine if all characters in \fIstring\fR are in of the specified
\fIclass\fR.  Returns \fB1\fR if they are all of \fIclass\fR and \fB0\fR if
they are not or if the string is null. This command also provides another
method (besides \fBformat\fR and \fBscan\fR) of converting between an ASCII
character and its numeric value.  The following \fBctype\fR commands are
available.
.RS 5
.TP
.B ctype alnum \fIstring\fR
Tests that all characters are alphabetic or numeric characters as defined by
the character set.
.TP
.B ctype alpha \fIstring\fR
Tests that all characters are alphabetic characters as defined by the
character set.
.TP
.B ctype ascii \fIstring\fR
Tests that all characters are an ASCII character (a non-negative number less
than 0200).
.TP
.B ctype char \fInumber\fR
Converts the numeric value, \fIstring\fR, to an ASCII character.  Number must
be in the range 0 through 255.
.TP
.B ctype cntrl \fIstring\fR
Tests that all characters are ``control characters'' as defined by the
character set.
.TP
.B ctype digit \fIstring\fR
Tests that all characters are valid decimal digits, i.e. 0 through 9.
.TP
.B ctype graph \fIstring\fR
Tests that all characters within are any character for which \fIctype print\fR
is true, except for space characters.
.TP
.B ctype lower \fIstring\fR
Tests that all characters are lowercase letters as defined by the character
set.
.TP
.B ctype ord \fIcharacter\fR
Convert a character into its decimal numeric value.  The string must be one
character long.
.TP
.B ctype space \fIstring\fR
Tests that all characters are either a space, horizontal-tab, carriage
return, newline, vertical-tab, or form-feed.
.TP
.B ctype print \fIstring\fR
Tests that all characters are a space or any character for which \fIctype
alnum\fR or \fIctype punct\fR is true or other ``printing character'' as
defined by the character set.
.TP
.B ctype punct \fIstring\fR
Tests that all characters are made up of any of the characters
other than the ones for which
\fBalnum\fR, \fBcntrl\fR, or \fBspace\fR is true.
.TP
.B ctype upper \fIstring\fR
Tests that all characters are uppercase letters as defined by the character
set.
.TP
.B ctype xdigit \fIstring\fR
Tests that all characters are valid hexadecimal digits, that is \fI0\fR
through \fI9\fR, a through \fIf\fR or \fIA\fR through \fIF\fR.
.RE
'@endhelp
'@help: extended/replicate
'@brief: Replicate string a number of times.
.TP
.B replicate \fIstring count\fR
.br
Returns \fIstring\fR replicated \fIcount\fR times.
'@endhelp
'@help: extended/translit
'@brief: Translate characters in string according to patterns.
.TP
.B \fBtranslit \fIinrange outrange string\fR
.br
Translate characters in \fIstring\fR matching characters in \fIinrange\fR
to the corresponding character in \fIoutrange\fR. \fIInrange\fR and 
\fIoutrange\fR may be list of characters or a range in the form `A-M'.
.nf
.ft CW
    Example:
        translit a-z A-Z foobar
    returns 
        FOOBAR
.ft R
.if
'@endhelp
