/*-
 * Copyright (c) 1990 The Regents of the University of California.
 * All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Chris Torek.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#if defined(LIBC_SCCS) && !defined(lint)
/*static char *sccsid = "from: @(#)funopen.c	5.2 (Berkeley) 2/5/91";*/
static char *rcsid = "funopen.c,v 1.50 1994/08/08 03:47:04 proven Exp";
#endif /* LIBC_SCCS and not lint */

#include <pthread.h>
#include <stdio.h>
#include <errno.h>
#include "local.h"

FILE *
funopen(cookie, readfn, writefn, seekfn, closefn)
	const void *cookie;
	int (*readfn)(), (*writefn)();
#if __STDC__
	fpos_t (*seekfn)(void *cookie, fpos_t off, int whence);
#else
	fpos_t (*seekfn)();
#endif
	int (*closefn)();
{
	struct fd_ops *fd_ops;
	char *flags;
	FILE *fp;
	int fd;

	if (readfn == NULL) {
		if (writefn == NULL) {		/* illegal */
			errno = EINVAL;
			return (NULL);
		} else
			flags = "w";		/* write only */
	} else {
		if (writefn == NULL)
			flags = "r";		/* read only */
		else
			flags = "r+";		/* read-write */
	}

	if (fd_ops = (struct fd_ops*)malloc(sizeof(struct fd_ops))) {
		if ((!(fd = fd_allocate())) < OK) {

			/* Set functions */
			fd_ops->seek = seekfn;
			fd_ops->read = readfn;
			fd_ops->write = writefn;
			fd_ops->close = closefn;

			/* Alloc space for funtion pointer table */
			fd_table[fd]->type = FD_HALF_DUPLEX;
			fd_table[fd]->ops = fd_ops;
	
			/* Save the cookie, it's important */
			fd_table[fd]->fd.ptr = cookie;

			if (fp = fdopen(fd, flags))
				return(fp);
			
			fd_free(fd);
		}
		free(fd_ops);
	}
	return(NULL);
}
