/*
 * array of error messages for the malloc internal errors.
 *
 * Copyright 1993 by the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Antaire not be used in advertising or publicity pertaining to
 * distribution of the document or software without specific, written prior
 * permission.
 *
 * The Antaire Corporation makes no representations about the suitability of
 * the software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@antaire.com
 *
 * $Id: error_str.h,v 1.12 1993/09/07 04:50:33 gray Exp $
 */

#ifndef __ERROR_STR_H__
#define __ERROR_STR_H__

/* string error codes which apply to error codes in error_val.h */
LOCAL	char	*malloc_errlist[] = {
  "no error",
  
  /* administrative errors */
  "initialization and setup failed",
  "malloc library has gone recursive",
  "errno value passed in by user is out-of-bounds",
  
  /* pointer verification errors */
  "pointer is null",
  "pointer is not pointing into the heap data space",
  "cannot locate pointer in the heap",
  "found pointer the user was looking for",
  "possibly bad .c filename pointer",
  "possibly bad .c file line-number",
  "failed UNDER picket-fence magic-number checking",
  "failed OVER picket-fence magic-number checking",
  "use of pointer would exceed allocation",
  "pointer is on the free list",
  
  /* allocation errors */
  "invalid allocation size",
  "largest maximum allocation size exceeded",
  "user allocated space contiguous block error",
  "could not allocate more memory, heap extension failed",
  "heap extension failed to produce a linear address space",
  "bad size in information structure",
  
  /* free errors */
  "pointer is not on a block boundary",
  "tried to free pointer which is already freed",
  "pointer does not point to start of user-allocated space",
  "pointer does not point to user-allocated space",
  "inconsistency with free linked-list",
  "free space contiguous block error",
  "bad basic-block memory pointer in the free-list",
  "space that should be free has been overwritten",
  
  /* dblock errors */
  "bad divided-block chunk size",
  "bad divided-block pointer",
  "bad basic-block memory pointer in dblock struct",
  "bad divided-block admin pointer",
  "bad divided-block admin magic numbers",
  "bad divided-block chunk admin information structure",
  
  /* administrative errors */
  "admin structure pointer out of bounds",
  "bad admin structure list",
  "bad magic number in admin structure",
  "bad basic-block count value in admin structure",
  "bad basic-block administration pointer",
  "bad basic-block administration counter",
  
  /* heap check verification */
  "bad basic-block allocation order",
  "basic-block has bad flag value"
  };

#endif /* ! __ERROR_STR_H__ */
