#include <stdio.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xresource.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include    "Compat.h"
#include    "LayoutP.h"
#include    "laygram.h"

static char *LayYYsourcebase, *LayYYsource;

#define input()		(*LayYYsource++)
#define unput(c)	(--LayYYsource)

static unsigned char is_word_sep[256] = {0,};
static unsigned int  word_sep_inited = False;

static int word_sep(unsigned char c)
{
    return c < 256 && is_word_sep[c];
}

static void init_word_sep(void)
{
    word_sep_inited = True;

    is_word_sep['\0'] = True;
    is_word_sep['\t'] = True;
    is_word_sep['\n'] = True;
    is_word_sep[' ']  = True;
    is_word_sep['$']  = True;
    is_word_sep['%']  = True;
    is_word_sep['(']  = True;
    is_word_sep[')']  = True;
    is_word_sep['*']  = True;
    is_word_sep['+']  = True;
    is_word_sep['-']  = True;
    is_word_sep['/']  = True;
    is_word_sep['<']  = True;
    is_word_sep['=']  = True;
    is_word_sep['>']  = True;
    is_word_sep['[']  = True;
    is_word_sep['\\'] = True;
    is_word_sep[']']  = True;
    is_word_sep['{']  = True;
    is_word_sep['}']  = True;
}

int LayYYlex(void)
{
    char	buffer[256];
    char	c;
    char	*p;
    int		n;

    for (;;) { /* so that we can do continue to skip e.g. whitespace */
	c = input();

	switch (c) {
	case '\0':
	    return 0;
	case ' ':
	case '\t':
	case '\n':
	    continue;
	case '{':
	    return OC;
	case '}':
	    return CC;
	case '(':
	    return OP;
	case ')':
	    return CP;
	case '<':
	    return OA;
	case '>':
	    return CA;
	case '=':
	    return EQUAL;
	case '$':
	    return DOLLAR;
	case '+':	
	    LayYYlval.oval = Plus;
	    return PLUS;
	case '-':
	    LayYYlval.oval = Minus;
	    return MINUS;
	case '*':
	    LayYYlval.oval = Times;
	    return TIMES;
	case '/':
	    LayYYlval.oval = Divide;
	    return DIVIDE;
	case '%':
	    LayYYlval.oval = Percent;
	    while (*LayYYsource == ' ' ||
		   *LayYYsource == '\t' ||
		   *LayYYsource == '\n')
		LayYYsource++;

	    if (LayYYsource[0] == 'o' &&
		LayYYsource[1] == 'f' &&
		word_sep(LayYYsource[2])) {
		LayYYsource += 2;
		return PERCENTOF;
	    }
	    return PERCENT;
	case '_':
	case 'a':
	case 'b':
	case 'c':
	case 'd':
	case 'e':
	case 'f':
	case 'g':
	    break;
	case 'h':
	    if (strncmp(LayYYsource, "orizontal", 9) == 0 &&
		word_sep(LayYYsource[9])) {
		LayYYsource += 9;
		return HORIZONTAL;
	    }
	    if (strncmp(LayYYsource, "eight", 5) == 0 &&
		word_sep(LayYYsource[5])) {
		LayYYsource += 5;
		return HEIGHT;
	    }
	    break;
	case 'i':
	    if (LayYYsource[0] != 'n' ||
		LayYYsource[1] != 'f')
		break;
	    if (strncmp(LayYYsource, "nfinity", 7) == 0 &&
		word_sep(LayYYsource[7])) {
		LayYYsource += 7;
		LayYYlval.ival = 1;
		return INFINITY;
	    }
	    for (p = LayYYsource + 2 ; *p == 'f' ; p++);
	    if (word_sep(*p)) {
		LayYYlval.ival = p - LayYYsource - 1;
		LayYYsource = p;
		return INFINITY;
	    }
	    break;
	case 'j':
	case 'k':
	case 'l':
	case 'm':
	case 'n':
	case 'o':
	case 'p':
	case 'q':
	case 'r':
	case 's':
	case 't':
	case 'u':
	case 'v':
	    if (strncmp(LayYYsource, "ertical", 7) == 0 &&
		word_sep(LayYYsource[7])) {
		LayYYsource += 7;
		return VERTICAL;
	    }
	    break;
	case 'w':
	    if (strncmp(LayYYsource, "idth", 4) == 0 &&
		word_sep(LayYYsource[4])) {
		LayYYsource += 4;
		return WIDTH;
	    }
	    break;
	case 'x':
	case 'y':
	case 'z':
	    break;
	case 'A':
	case 'B':
	case 'C':
	case 'D':
	case 'E':
	case 'F':
	case 'G':
	case 'H':
	case 'I':
	case 'J':
	case 'K':
	case 'L':
	case 'M':
	case 'N':
	case 'O':
	case 'P':
	case 'Q':
	case 'R':
	case 'S':
	case 'T':
	case 'U':
	case 'V':
	case 'W':
	case 'X':
	case 'Y':
	case 'Z':
	    break;
	case '\\':
	    c = input();
	    break;
	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	    LayYYlval.ival = atoi(LayYYsource - 1);
	    while (*LayYYsource >= '0' && *LayYYsource <= '9')
		LayYYsource++;
	    return NUMBER;
	default:
	    fprintf(stderr, "ignoring %c\n", c);
	    continue;
	}

	buffer[0] = c;
	for (n = 1 ; n < sizeof(buffer) ; n++) {
	    c = input();
	    if ((c >= '0' && c <= '9') ||
		(c >= 'a' && c <= 'z') ||
		(c >= 'A' && c <= 'Z') ||
		c == '_')
		buffer[n] = c;
	    else
		break;
	}
	if (n >= sizeof(buffer))
	    return 0;
	if (!word_sep(c))
	    return 0;
	unput(c);
	buffer[n] = '\0';

	LayYYlval.qval = XrmStringToQuark(buffer);

	return NAME;
    }
}

int LayYYsetsource(char *s)
{
    LayYYsourcebase = LayYYsource = s;

    if (!word_sep_inited)
	init_word_sep();

    return 0;
}

int LayYYerror(char *s)
{
    char    *t;
    
    fprintf (stderr, "%s\n", s);
    t = LayYYsource - 50;
    if (t < LayYYsourcebase)
	t = LayYYsourcebase;
    while (*t && t < LayYYsource + 50) {
	if (t == LayYYsource)
	    fputc('@', stderr);
	fputc(*t++, stderr);
    }
    if (t == LayYYsource)
	fputc('@', stderr);
    if (!*t)
	fputs("<EOF>", stderr);
    fputc('\n', stderr);

    return 0;
}
