#! /usr/local/bin/perl -s
##  Sendbatches for INN.
##  $Revision: 1.1 $
##  Perl script to send general batches out.
##  By Christophe.Wolfhugel@grasp.insa-lyon.fr (bizness: wolf@hsc-sec.fr)

# =()<$newsbin="@<_PATH_NEWSBIN>@";>()=
$newsbin="/usr/local/news/bin";

$ENV{'PATH'} = "$newsbin/batch:$newsbin:/bin:/usr/bin:/usr/ucb";

# =()<$batch="@<_PATH_BATCHDIR>@";>()=
$batch="/var/spool/news/out.going";
# =()<$lib="@<_PATH_NEWSLIB>@";>()=
$lib="/usr/local/news";
# =()<$locks="@<_PATH_LOCKS>@";>()=
$locks="/usr/local/news";

$ctlfile="$lib/sendbatches.ctl";

## Go to the right dir
chdir($batch) || die("Can't change to batch dir.");

open(CTL, "$ctlfile") || die("Can't read $ctlfile");
while (<CTL>) {
   next if (/^#/);
   chop; split;
   $line{$_[0]} = "$_";
}
close(CTL);

if ($#ARGV == -1) { $ARGV[0] = "*"; }
foreach $i (@ARGV) {
   $i =~ s/\./\\./g if ($i =~ /\*/);
   $i =~ s/\*/.*/g;
   if ($i !~ /\*/) {
      push(@list, $i);
      next;
   }
   foreach $j (keys(line)) {
      next if ($j =~ /^\/default\/$/);
      push(@list, $j) if ($j =~ /^$i$/);
   }
}

sub handler {
   unlink($lock) if $lock;
   exit(1);
}
$SIG{'HUP'}   = 'handler';
$SIG{'INT'}   = 'handler';
$SIG{'QUIT'}  = 'handler';
$SIG{'TERM'}  = 'handler';

foreach $site (@list) {
   $l =  ($line{$site}) ? $line{$site} : $line{"/default/"};
   next unless $l;
   next if ($l !~ /^\S+\s+(\d+)\s+(\d+)\s+(\d+)\s+(\S+)\s+(.+)$/);
   $min = $1;
   $num = $2;
   $siz = $3;
   $mun = $4;
   $sen = $5;

   $lock = "$locks/LOCK.batches.$site";
   if (system("shlock -p $$ -f $lock") > 255) {
      print "$^W: $site [$$] already locked\n";
      next;
   }
   $batchfile = "$site.batch";
   if (-f "$site.work") {
      system("cat $site.work >> $batchfile");
      unlink("$site.work");
   }
   rename("$site", "$site.work");
   if (system("ctlinnd -s -t30 flush $site") > 255) {
      print "$^X: [$$] Can't flush $site.\n";
      unlink($lock);
      next;
   }
   system("cat $site.work >> $batchfile");
   unlink("$site.work");
   $size = (-s $batchfile);
   if ($size == 0 || ($size < $min && !$force)) {
      print "$^X: [$$] no articles for $site\n";
      unlink($lock);
      next;
   }
   $sen =~ s/^(\S+)\s*(.*)$/$1 $site $2/;
   print "$^X: [$$] begin $site\n";
   system("batcher -N$num -b$siz -p\"$mun | $sen\" $site $batchfile");
   print "$^X: [$$] end  $site\n";
   unlink($lock);
}
exit 0;
