.TH XNETLOAD 1 "Release 1" "X Version 11"
.SH NAME
xnetload - ethernet load average display for X
.SH SYNOPSIS
.ta 6n
\fBxnetload\fP	[-\fItoolkitoption\fP ...] [-scale \fIinteger\fP] 
.br
	[-update \fIseconds\fP] [-hl \fIcolor\fP] [-highlight \fIcolor\fP] 
.br
	[-jumpscroll \fIpixels\fP] [-label \fIstring\fP] [-nolabel] \fIhost\fP
.SH DESCRIPTION
The 
.I xnetload 
program displays a periodically updating histogram of the ethernet load average for
the specified \fIhost\fP. The resulting graph is scaled as 0% to 100%, where 0% 
corresponds to 0mbs and 100% corresponds to 10mbs.
NOTE: \fIThe specified host must be running rpc.etherd.
.SH OPTIONS
.PP
.I Xnetload
accepts all of the standard X Toolkit command line options (see \fIX(1)\fP).
The order of the options is unimportant.  \fIxnetload\fP also accepts the
following additional options:
.PP
.TP 8
.B \-hl \fIcolor\fP or \-highlight \fIcolor\fP
This option specifies the color of the scale lines.  
.TP 8
.B \-jumpscroll \FPnumber of pixels\fP
The number of pixels to shift the graph to the left when the graph
reaches the right edge of the window.  The default value is 1/2 the width
of the current window.  Smooth scrolling can be achieved by setting it to 1.
.TP 8
.B \-label \fIstring\fP
The string to put into the label above the load average.
.TP 8
.B \-nolabel
If this command line option is specified then no label will be
displayed above the load graph.
.TP 8
.B \-scale \fIinteger\fP
This option specifies the minimum number of tick marks in the histogram,
where one division represents one load average point.  If the load goes
above this number, \fIxnetload\fP will create more divisions, but it will never
use fewer than this number.  The default is 10 (as set by the resource file).
.PP
.TP 8
.B \-update \fIseconds\fP
This option specifies the frequency in seconds at which \fIxnetload\fP
updates its display.  The minimum amount of time allowed between updates
is 1 second. For ethernet load monitoring this should be set to 1.
.TP 8
.B  \fIhost\fP
The \fIhost\fP specification is required. It is the name of any host, reachable
from the initiating CPU, that is running rpc.etherd
.SH RESOURCES
In addition to the resources available to each of the widgets used by 
\fIxnetload\fP there is one resource defined by the application itself.
.TP 8
.B showLabel (\fPclass\fB Boolean)
If False then no label will be displayed.
.SH WIDGETS
In order to specify resources, it is useful to know the hierarchy of
the widgets which compose \fIxnetload\fR.  In the notation below,
indentation indicates hierarchical structure.  The widget class name
is given first, followed by the widget instance name.
.sp
.nf
.ta .5i 1.0i 1.5i 2.0i
Xnetload  xnetload
	Paned  paned
		Label  label
		StripChart  load
.fi
.sp
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH FILES
/usr/lib/X11/app-defaults/XNetload - specifies required resources.
.br
/usr/etc/rpc.etherd - Must be running on target system.
.SH SEE ALSO
X(1), xrdb(1), mem(4), Athena StripChart Widget.
.SH BUGS
This program requires the ability to talk to the rpd.etherd daemon, and to
set the ethernet interface into promiscuous mode. Therefore, the Makefile
installs the program in /usr/bin/X11/ with root as the owner and with the
setuid bit set. This may not be necessary on some (most) systems, depending 
on the ownership of rpc.etherd.
.PP
.SH COPYRIGHT
Taken from the original xload sources distributed with X11R4.
Original copyright is preserved below:
.PP
Copyright 1988, Massachusetts Institute of Technology.
.br
See \fIX(1)\fP for a full statement of rights and permissions.
.SH AUTHORS
Original xload authors: K. Shane Hartman (MIT-LCS) and Stuart A. Malone (MIT-LCS);
.br
with features added by Jim Gettys (MIT-Athena), Bob Scheifler (MIT-LCS),
Tony Della Fera (MIT-Athena), and Chris Peterson (MIT-LCS).
.PP
Modified to the current xnetload form by:
.br
Roger Smith, Sterling Software at
.br
NASA-Ames Research Center, Mountain View, Ca.
.PP 
Much thanks and appreciation to Martyn Hampson of the Imperial College Computer Centre
for his contribution of sunRPC for ULTRIX Systems.
.PP
For questions or reporting bugs:
.br
rsmith@proteus.arc.nasa.gov
