/*
 *	Copyright (c) 1993 The CAD lab of the
 *	Novosibirsk Institute of Broadcasting and Telecommunication
 *
 *	BPFT $Id: extract.h,v 1.1 1993/10/20 16:03:56 bob Exp $
 *
 *	$Log: extract.h,v $
 * Revision 1.1  1993/10/20  16:03:56  bob
 * Initial revision
 *
 *
 * Redistribution and use in source forms, with and without modification,
 * are permitted provided that this entire comment appears intact.
 * Redistribution in binary form may occur without any restrictions.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' WITHOUT ANY WARRANTIES OF ANY KIND.
 */

#if defined(sparc) || defined(mips) || defined(ibm032)
#define BPF_ALIGN
#endif

#ifdef BPF_ALIGN

#if BYTEORDER == LITTLE_ENDIAN
#define EXTRACT_SHORT(p)\
	((u_short)\
		((u_short)*((u_char *)p+1)<<8|\
		 (u_short)*((u_char *)p+0)<<0))
#define EXTRACT_LONG(p)\
		((u_long)*((u_char *)p+3)<<24|\
		 (u_long)*((u_char *)p+2)<<16|\
		 (u_long)*((u_char *)p+1)<<8|\
		 (u_long)*((u_char *)p+0)<<0)
#else
#define EXTRACT_SHORT(p)\
	((u_short)\
		((u_short)*((u_char *)p+0)<<8|\
		 (u_short)*((u_char *)p+1)<<0))
#define EXTRACT_LONG(p)\
		((u_long)*((u_char *)p+0)<<24|\
		 (u_long)*((u_char *)p+1)<<16|\
		 (u_long)*((u_char *)p+2)<<8|\
		 (u_long)*((u_char *)p+3)<<0)
#endif

#else

#define EXTRACT_SHORT(p)	((u_short)ntohs(*(u_short *)p))
#define EXTRACT_LONG(p)		(ntohl(*(u_long *)p))

#endif
